/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDI;
import org.forester.util.ForesterUtil;

public class GSDI
extends SDI {
    private final HashMap<PhylogenyNode, Integer> _transversal_counts;
    private final boolean _most_parsimonious_duplication_model;
    private int _speciation_or_duplication_events_sum = 0;
    private int _speciations_sum = 0;

    public GSDI(Phylogeny gene_tree, Phylogeny species_tree, boolean most_parsimonious_duplication_model) {
        super(gene_tree, species_tree);
        this._most_parsimonious_duplication_model = most_parsimonious_duplication_model;
        this._transversal_counts = new HashMap();
        this._duplications_sum = 0;
        this.getSpeciesTree().preOrderReId(0);
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    private Event createDuplicationEvent() {
        Event event = Event.createSingleDuplicationEvent();
        ++this._duplications_sum;
        return event;
    }

    private Event createSingleSpeciationOrDuplicationEvent() {
        Event event = Event.createSingleSpeciationOrDuplicationEvent();
        ++this._speciation_or_duplication_events_sum;
        return event;
    }

    private Event createSpeciationEvent() {
        Event event = Event.createSingleSpeciationEvent();
        ++this._speciations_sum;
        return event;
    }

    private void determineEvent(PhylogenyNode s, PhylogenyNode g) {
        Event event = null;
        int sum_g_childs_mapping_to_s = 0;
        PhylogenyNodeIterator iter = g.iterateChildNodesForward();
        while (iter.hasNext()) {
            if (iter.next().getLink() != s) continue;
            ++sum_g_childs_mapping_to_s;
        }
        int traversals_sum = 0;
        int max_traversals = 0;
        PhylogenyNode max_traversals_node = null;
        if (!s.isExternal()) {
            PhylogenyNodeIterator iter2 = s.iterateChildNodesForward();
            while (iter2.hasNext()) {
                PhylogenyNode current_node = iter2.next();
                int traversals = this.getTraversalCount(current_node);
                traversals_sum += traversals;
                if (traversals <= max_traversals) continue;
                max_traversals = traversals;
                max_traversals_node = current_node;
            }
        }
        if (sum_g_childs_mapping_to_s > 0) {
            if (traversals_sum == 2) {
                event = this.createDuplicationEvent();
            } else if (traversals_sum > 2) {
                if (max_traversals <= 1) {
                    event = this._most_parsimonious_duplication_model ? this.createSpeciationEvent() : this.createSingleSpeciationOrDuplicationEvent();
                } else {
                    event = this.createDuplicationEvent();
                    this._transversal_counts.put(max_traversals_node, 1);
                }
            } else {
                event = this.createDuplicationEvent();
            }
        } else {
            event = this.createSpeciationEvent();
        }
        g.getNodeData().setEvent(event);
    }

    void geneTreePostOrderTraversal(PhylogenyNode g) {
        if (!g.isExternal()) {
            PhylogenyNodeIterator iter = g.iterateChildNodesForward();
            while (iter.hasNext()) {
                this.geneTreePostOrderTraversal(iter.next());
            }
            PhylogenyNode[] linked_nodes = new PhylogenyNode[g.getNumberOfDescendants()];
            int i = 0;
            while (i < linked_nodes.length) {
                linked_nodes[i] = g.getChildNode(i).getLink();
                ++i;
            }
            int[] min_max = GSDI.obtainMinMaxIdIndices(linked_nodes);
            int min_i = min_max[0];
            int max_i = min_max[1];
            while (linked_nodes[min_i] != linked_nodes[max_i]) {
                this.increaseTraversalCount(linked_nodes[max_i]);
                linked_nodes[max_i] = linked_nodes[max_i].getParent();
                int[] min_max_ = GSDI.obtainMinMaxIdIndices(linked_nodes);
                min_i = min_max_[0];
                max_i = min_max_[1];
            }
            PhylogenyNode s = linked_nodes[max_i];
            g.setLink(s);
            this.determineEvent(s, g);
        }
    }

    public int getSpeciationOrDuplicationEventsSum() {
        return this._speciation_or_duplication_events_sum;
    }

    public int getSpeciationsSum() {
        return this._speciations_sum;
    }

    private int getTraversalCount(PhylogenyNode node) {
        if (this._transversal_counts.containsKey(node)) {
            return this._transversal_counts.get(node);
        }
        return 0;
    }

    private void increaseTraversalCount(PhylogenyNode node) {
        if (this._transversal_counts.containsKey(node)) {
            this._transversal_counts.put(node, this._transversal_counts.get(node) + 1);
        } else {
            this._transversal_counts.put(node, 1);
        }
    }

    @Override
    void linkNodesOfG() {
        HashMap<Taxonomy, PhylogenyNode> speciestree_ext_nodes = new HashMap<Taxonomy, PhylogenyNode>();
        PhylogenyNodeIterator iter = this._species_tree.iteratorLevelOrder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getNodeData().isHasTaxonomy()) continue;
            if (speciestree_ext_nodes.containsKey(n.getNodeData().getTaxonomy())) {
                throw new IllegalArgumentException("taxonomy [" + n.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            speciestree_ext_nodes.put(n.getNodeData().getTaxonomy(), n);
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            if (!g.getNodeData().isHasTaxonomy()) {
                throw new IllegalArgumentException("gene tree node " + g + " has no taxonomic data");
            }
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(g.getNodeData().getTaxonomy());
            if (s == null) {
                throw new IllegalArgumentException("species " + g.getNodeData().getTaxonomy() + " not present in species tree.");
            }
            g.setLink(s);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Most parsimonious duplication model: " + this._most_parsimonious_duplication_model);
        sb.append(ForesterUtil.getLineSeparator());
        sb.append("Speciations sum                    : " + this.getSpeciationsSum());
        sb.append(ForesterUtil.getLineSeparator());
        sb.append("Duplications sum                   : " + this.getDuplicationsSum());
        sb.append(ForesterUtil.getLineSeparator());
        if (!this._most_parsimonious_duplication_model) {
            sb.append("Speciation or duplications sum     : " + this.getSpeciationOrDuplicationEventsSum());
            sb.append(ForesterUtil.getLineSeparator());
        }
        sb.append("mapping cost L                     : " + this.computeMappingCostL());
        return sb.toString();
    }

    static int[] obtainMinMaxIdIndices(PhylogenyNode[] linked_nodes) {
        int max_i = 0;
        int min_i = 0;
        int max_i_id = -2147483647;
        int min_i_id = Integer.MAX_VALUE;
        int i = 0;
        while (i < linked_nodes.length) {
            int id_i = linked_nodes[i].getNodeId();
            if (id_i > max_i_id) {
                max_i = i;
                max_i_id = linked_nodes[max_i].getNodeId();
            }
            if (id_i < min_i_id) {
                min_i = i;
                min_i_id = linked_nodes[min_i].getNodeId();
            }
            ++i;
        }
        return new int[]{min_i, max_i};
    }
}

