/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.PrintableSpeciesSpecificDomainSimilariyData;
import org.forester.surfacing.Species;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.BasicDescriptiveStatistics;

public class BasicDomainSimilarityCalculator
implements DomainSimilarityCalculator {
    final DomainSimilarity.DomainSimilaritySortField _sort;
    private final boolean _sort_by_species_count_first;
    private final boolean _treat_as_binary_comparison;

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField sort, boolean sort_by_species_count_first, boolean treat_as_binary_comparison) {
        this._sort = sort;
        this._sort_by_species_count_first = sort_by_species_count_first;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
    }

    @Override
    public SortedSet<DomainSimilarity> calculateSimilarities(PairwiseDomainSimilarityCalculator pairwise_calculator, List<GenomeWideCombinableDomains> cdc_list, boolean ignore_domains_without_combinations_in_any_genome, boolean ignore_domains_specific_to_one_genome) {
        if (cdc_list.size() < 2) {
            throw new IllegalArgumentException("attempt to calculate multiple combinable domains similarity for less than two combinale domains collections");
        }
        TreeSet<DomainSimilarity> similarities = new TreeSet<DomainSimilarity>();
        TreeSet<DomainId> keys = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains cdc : cdc_list) {
            keys.addAll(cdc.getAllCombinableDomainsIds().keySet());
        }
        for (DomainId key : keys) {
            ArrayList<CombinableDomains> same_id_cd_list = new ArrayList<CombinableDomains>(cdc_list.size());
            ArrayList<Species> species_with_key_id_domain = new ArrayList<Species>();
            for (GenomeWideCombinableDomains cdc : cdc_list) {
                if (!cdc.contains(key)) continue;
                same_id_cd_list.add(cdc.get(key));
                species_with_key_id_domain.add(cdc.getSpecies());
            }
            if (ignore_domains_without_combinations_in_any_genome) {
                boolean without_combinations = true;
                for (CombinableDomains cd : same_id_cd_list) {
                    if (cd.getNumberOfCombinableDomains() <= 0) continue;
                    without_combinations = false;
                    break;
                }
                if (without_combinations) continue;
            }
            if (same_id_cd_list.size() > 0) {
                if (ignore_domains_specific_to_one_genome && same_id_cd_list.size() <= 1) continue;
                DomainSimilarity s = this.calculateSimilarity(pairwise_calculator, same_id_cd_list);
                if (s != null) {
                    similarities.add(s);
                    continue;
                }
                throw new IllegalStateException("similarity is null: this should not have happened");
            }
            throw new IllegalStateException("this should not have happened");
        }
        return similarities;
    }

    private DomainSimilarity calculateSimilarity(PairwiseDomainSimilarityCalculator pairwise_calculator, List<CombinableDomains> domains_list) {
        if (domains_list.size() == 1) {
            TreeMap<Species, SpeciesSpecificDomainSimilariyData> species_data = new TreeMap<Species, SpeciesSpecificDomainSimilariyData>();
            species_data.put(domains_list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(0)));
            return new PrintableDomainSimilarity(domains_list.get(0), 1.0, 1.0, 1.0, 1.0, 0.0, 0, 0, 0, species_data, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        }
        BasicDescriptiveStatistics stat = new BasicDescriptiveStatistics();
        TreeMap<Species, SpeciesSpecificDomainSimilariyData> species_data = new TreeMap<Species, SpeciesSpecificDomainSimilariyData>();
        species_data.put(domains_list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(0)));
        int max_difference_in_counts = 0;
        int max_difference = 0;
        boolean is_domain_combination_based = pairwise_calculator instanceof CombinationsBasedPairwiseDomainSimilarityCalculator;
        int i = 1;
        while (i < domains_list.size()) {
            species_data.put(domains_list.get(i).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(i)));
            CombinableDomains domains_i = domains_list.get(i);
            int j = 0;
            while (j < i) {
                PairwiseDomainSimilarity pairwise_similarity = pairwise_calculator.calculateSimilarity(domains_i, domains_list.get(j));
                int difference_in_counts = pairwise_similarity.getDifferenceInCounts();
                int difference = 0;
                difference = is_domain_combination_based ? ((CombinationsBasedPairwiseDomainSimilarity)pairwise_similarity).getNumberOfDifferentDomains() : difference_in_counts;
                if (Math.abs(difference_in_counts) > Math.abs(max_difference_in_counts)) {
                    max_difference_in_counts = difference_in_counts;
                }
                if (Math.abs(difference) > Math.abs(max_difference)) {
                    max_difference = difference;
                }
                stat.addValue(pairwise_similarity.getSimilarityScore());
                ++j;
            }
            ++i;
        }
        if (stat.getN() < 1) {
            throw new AssertionError((Object)"empty descriptive statistics: this should not have happened");
        }
        if (stat.getN() != 1 && this.isTreatAsBinaryComparison()) {
            throw new IllegalArgumentException("attmpt to treat similarity with N not equal to one as binary comparison");
        }
        if (!this.isTreatAsBinaryComparison() && max_difference_in_counts < 0) {
            max_difference_in_counts = Math.abs(max_difference_in_counts);
            if (!is_domain_combination_based) {
                max_difference = Math.abs(max_difference);
            }
        }
        PrintableDomainSimilarity similarity = null;
        similarity = stat.getN() == 1 ? new PrintableDomainSimilarity(domains_list.get(0), stat.getMin(), stat.getMax(), stat.arithmeticMean(), stat.median(), 0.0, stat.getN(), max_difference_in_counts, max_difference, species_data, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : new PrintableDomainSimilarity(domains_list.get(0), stat.getMin(), stat.getMax(), stat.arithmeticMean(), stat.median(), stat.sampleStandardDeviation(), stat.getN(), max_difference_in_counts, max_difference, species_data, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        return similarity;
    }

    private DomainSimilarity.DomainSimilaritySortField getSort() {
        return this._sort;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private static SpeciesSpecificDomainSimilariyData createSpeciesSpecificDomainSimilariyData(CombinableDomains cd) {
        PrintableSpeciesSpecificDomainSimilariyData sd = new PrintableSpeciesSpecificDomainSimilariyData(cd.getKeyDomainProteinsCount(), cd.getKeyDomainCount(), cd.getNumberOfCombinableDomains(), cd.getKeyDomainConfidenceDescriptiveStatistics());
        for (DomainId domain : cd.getCombinableDomains()) {
            sd.addProteinsExhibitingCombinationCount(domain, cd.getNumberOfProteinsExhibitingCombination(domain));
        }
        return sd;
    }
}

