/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.DescriptiveStatistics;

class PrintableSpeciesSpecificDomainSimilariyData
implements SpeciesSpecificDomainSimilariyData {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    final SortedMap<DomainId, Integer> _combinable_domain_id_to_count_map;
    private final int _key_domain_proteins_count;
    private final int _key_domain_domains_count;
    private final int _combinable_domains_count;
    private final DescriptiveStatistics _key_domain_confidence_descriptive_statistics;

    public PrintableSpeciesSpecificDomainSimilariyData(int key_domain_proteins_count, int key_domain_domains_count, int combinable_domains, DescriptiveStatistics key_domain_confidence_descriptive_statistics) {
        this._key_domain_proteins_count = key_domain_proteins_count;
        this._key_domain_domains_count = key_domain_domains_count;
        this._combinable_domains_count = combinable_domains;
        this._key_domain_confidence_descriptive_statistics = key_domain_confidence_descriptive_statistics;
        this._combinable_domain_id_to_count_map = new TreeMap<DomainId, Integer>();
    }

    @Override
    public void addProteinsExhibitingCombinationCount(DomainId domain_id, int count) {
        if (this.getCombinableDomainIdToCountsMap().containsKey(domain_id)) {
            throw new IllegalArgumentException("Domain with id " + domain_id + " already exists");
        }
        this.getCombinableDomainIdToCountsMap().put(domain_id, count);
    }

    @Override
    public SortedMap<DomainId, Integer> getCombinableDomainIdToCountsMap() {
        return this._combinable_domain_id_to_count_map;
    }

    private int getCombinableDomainsCount() {
        return this._combinable_domains_count;
    }

    private DescriptiveStatistics getKeyDomainConfidenceDescriptiveStatistics() {
        return this._key_domain_confidence_descriptive_statistics;
    }

    private int getKeyDomainDomainsCount() {
        return this._key_domain_domains_count;
    }

    private int getKeyDomainProteinsCount() {
        return this._key_domain_proteins_count;
    }

    @Override
    public int getNumberOfProteinsExhibitingCombinationWith(DomainId domain_id) {
        if (!this.getCombinableDomainIdToCountsMap().containsKey(domain_id)) {
            throw new IllegalArgumentException("Domain with id " + domain_id + " not found");
        }
        return (Integer)this.getCombinableDomainIdToCountsMap().get(domain_id);
    }

    public String toString() {
        return this.toStringBuffer(DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES, false).toString();
    }

    @Override
    public StringBuffer toStringBuffer(DomainSimilarityCalculator.Detailedness detailedness, boolean html) {
        StringBuffer sb = new StringBuffer();
        if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
            sb.append(" ");
            sb.append(this.getKeyDomainDomainsCount());
            sb.append(", ");
            sb.append(this.getKeyDomainProteinsCount());
            sb.append(", ");
            sb.append(this.getCombinableDomainsCount());
            sb.append(", ");
            if (html) {
                sb.append("<i>");
            }
            sb.append(FORMATTER.format(this.getKeyDomainConfidenceDescriptiveStatistics().arithmeticMean()));
            if (html) {
                sb.append("</i>");
            }
            if (!this.getCombinableDomainIdToCountsMap().isEmpty()) {
                sb.append(":");
            }
        }
        Set<DomainId> ids = this.getCombinableDomainIdToCountsMap().keySet();
        int i = 0;
        for (DomainId domain_id : ids) {
            ++i;
            sb.append(" ");
            if (html) {
                sb.append("<a href=\"http://pfam.sanger.ac.uk/family?id=" + domain_id.getId() + "\">" + domain_id.getId() + "</a>");
            } else {
                sb.append(domain_id.getId());
            }
            if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
                sb.append(":");
                sb.append(this.getCombinableDomainIdToCountsMap().get(domain_id));
            }
            if (i >= ids.size() - 1) continue;
            sb.append(",");
        }
        return sb;
    }
}

