/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment.routines;

import java.util.Arrays;
import java.util.List;
import org.biojava3.alignment.SimpleSequencePair;
import org.biojava3.alignment.template.AbstractPairwiseSequenceAligner;
import org.biojava3.alignment.template.AlignedSequence;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class AnchoredPairwiseSequenceAligner<S extends Sequence<C>, C extends Compound>
extends AbstractPairwiseSequenceAligner<S, C> {
    private static int defaultCutsPerSection = 10;

    public static void setDefaultCutsPerSection(int defaultCutsPerSection) {
        AnchoredPairwiseSequenceAligner.defaultCutsPerSection = Math.max(1, defaultCutsPerSection);
    }

    public AnchoredPairwiseSequenceAligner() {
        this.setCutsPerSection(defaultCutsPerSection);
    }

    public AnchoredPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        this(query, target, gapPenalty, subMatrix, defaultCutsPerSection, null);
    }

    public AnchoredPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, int cutsPerSection) {
        this(query, target, gapPenalty, subMatrix, cutsPerSection, null);
    }

    public AnchoredPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, int cutsPerSection, int[] anchors) {
        super(query, target, gapPenalty, subMatrix);
        this.setCutsPerSection(cutsPerSection);
        this.setAnchors(anchors);
    }

    public int[] getAnchors() {
        return Arrays.copyOf(this.anchors, this.anchors.length);
    }

    public int getCutsPerSection() {
        return this.cutsPerSection;
    }

    public void setAnchors(int[] anchors) {
        this.anchors = anchors == null ? null : Arrays.copyOf(anchors, anchors.length);
        this.reset();
    }

    public void setCutsPerSection(int cutsPerSection) {
        this.cutsPerSection = Math.max(1, cutsPerSection);
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.getQuery() != null && this.getTarget() != null) {
            this.resetAnchors();
        }
    }

    @Override
    protected void setProfile(List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        this.profile = this.pair = new SimpleSequencePair(this.getQuery(), this.getTarget(), sx, sy);
    }
}

