/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.convert;

import ch.systemsx.cisd.base.utilities.NativeLibraryUtilities;
import java.nio.ByteBuffer;

public class NativeData {
    private static final boolean useNativeLib = Boolean.getBoolean("nativedata.javamode") ? false : NativeLibraryUtilities.loadNativeLibrary("nativedata");
    public static final int SHORT_SIZE = 2;
    public static final int CHAR_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;

    private static native boolean isLittleEndian();

    private static native void copyIntToByte(int[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToInt(byte[] var0, int var1, int[] var2, int var3, int var4, int var5);

    private static native void copyLongToByte(long[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToLong(byte[] var0, int var1, long[] var2, int var3, int var4, int var5);

    private static native void copyShortToByte(short[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToShort(byte[] var0, int var1, short[] var2, int var3, int var4, int var5);

    private static native void copyCharToByte(char[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToChar(byte[] var0, int var1, char[] var2, int var3, int var4, int var5);

    private static native void copyFloatToByte(float[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToFloat(byte[] var0, int var1, float[] var2, int var3, int var4, int var5);

    private static native void copyDoubleToByte(double[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native void copyByteToDouble(byte[] var0, int var1, double[] var2, int var3, int var4, int var5);

    public static void ensureNativeLibIsLoaded() {
    }

    public static boolean isUseNativeLib() {
        return useNativeLib;
    }

    public static ByteOrder getNativeByteOrder() {
        return ByteOrder.getNativeByteOrder();
    }

    public static short changeByteOrder(short s) {
        return (short)(s << 8 | s >> 8 & 0xFF);
    }

    public static char changeByteOrder(char c) {
        return (char)(c << 8 | c >> 8 & 0xFF);
    }

    public static int changeByteOrder(int i) {
        return NativeData.changeByteOrder((short)i) << 16 | NativeData.changeByteOrder((short)(i >> 16)) & 0xFFFF;
    }

    public static float changeByteOrder(float f) {
        return Float.intBitsToFloat(NativeData.changeByteOrder(Float.floatToRawIntBits(f)));
    }

    public static long changeByteOrder(long l) {
        return (long)NativeData.changeByteOrder((int)l) << 32 | (long)NativeData.changeByteOrder((int)(l >> 32)) & 0xFFFFFFFFL;
    }

    public static double changeByteOrder(double d) {
        return Double.longBitsToDouble(NativeData.changeByteOrder(Double.doubleToRawLongBits(d)));
    }

    public static void copyIntToByte(int[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyIntToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 4);
            bb.order(byteOrder.getNioByteOrder());
            bb.asIntBuffer().put(inData, inStart, len);
        }
    }

    public static void copyByteToInt(byte[] inData, int inStart, int[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToInt(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 4);
            bb.order(byteOrder.getNioByteOrder());
            bb.asIntBuffer().get(outData, outStart, len);
        }
    }

    public static void copyLongToByte(long[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyLongToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 8);
            bb.order(byteOrder.getNioByteOrder());
            bb.asLongBuffer().put(inData, inStart, len);
        }
    }

    public static void copyByteToLong(byte[] inData, int inStart, long[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToLong(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 8);
            bb.order(byteOrder.getNioByteOrder());
            bb.asLongBuffer().get(outData, outStart, len);
        }
    }

    public static void copyShortToByte(short[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyShortToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 2);
            bb.order(byteOrder.getNioByteOrder());
            bb.asShortBuffer().put(inData, inStart, len);
        }
    }

    public static void copyCharToByte(char[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyCharToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 2);
            bb.order(byteOrder.getNioByteOrder());
            bb.asCharBuffer().put(inData, inStart, len);
        }
    }

    public static void copyByteToShort(byte[] inData, int inStart, short[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToShort(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 2);
            bb.order(byteOrder.getNioByteOrder());
            bb.asShortBuffer().get(outData, outStart, len);
        }
    }

    public static void copyByteToChar(byte[] inData, int inStart, char[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToChar(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 2);
            bb.order(byteOrder.getNioByteOrder());
            bb.asCharBuffer().get(outData, outStart, len);
        }
    }

    public static void copyFloatToByte(float[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyFloatToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 4);
            bb.order(byteOrder.getNioByteOrder());
            bb.asFloatBuffer().put(inData, inStart, len);
        }
    }

    public static void copyByteToFloat(byte[] inData, int inStart, float[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToFloat(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 4);
            bb.order(byteOrder.getNioByteOrder());
            bb.asFloatBuffer().get(outData, outStart, len);
        }
    }

    public static void copyDoubleToByte(double[] inData, int inStart, byte[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyDoubleToByte(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(outData, outStart, len * 8);
            bb.order(byteOrder.getNioByteOrder());
            bb.asDoubleBuffer().put(inData, inStart, len);
        }
    }

    public static void copyByteToDouble(byte[] inData, int inStart, double[] outData, int outStart, int len, ByteOrder byteOrder) {
        if (useNativeLib) {
            NativeData.copyByteToDouble(inData, inStart, outData, outStart, len, byteOrder.ordinal());
        } else {
            ByteBuffer bb = ByteBuffer.wrap(inData, inStart, len * 8);
            bb.order(byteOrder.getNioByteOrder());
            bb.asDoubleBuffer().get(outData, outStart, len);
        }
    }

    public static char[] byteToChar(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        char[] array = new char[len];
        NativeData.copyByteToChar(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static char[] byteToChar(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 2 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 2;
        char[] array = new char[len];
        NativeData.copyByteToChar(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static short[] byteToShort(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        short[] array = new short[len];
        NativeData.copyByteToShort(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static short[] byteToShort(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 2 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 2;
        short[] array = new short[len];
        NativeData.copyByteToShort(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static byte[] shortToByte(short[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[2 * len];
        NativeData.copyShortToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] shortToByte(short[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[2 * data.length];
        NativeData.copyShortToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] charToByte(char[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[2 * len];
        NativeData.copyCharToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] charToByte(char[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[2 * data.length];
        NativeData.copyCharToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    public static int[] byteToInt(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        int[] array = new int[len];
        NativeData.copyByteToInt(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static int[] byteToInt(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 4 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 4;
        int[] array = new int[len];
        NativeData.copyByteToInt(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static byte[] intToByte(int[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[4 * len];
        NativeData.copyIntToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] intToByte(int[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[4 * data.length];
        NativeData.copyIntToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    public static long[] byteToLong(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        long[] array = new long[len];
        NativeData.copyByteToLong(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static long[] byteToLong(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 8 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 8;
        long[] array = new long[len];
        NativeData.copyByteToLong(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static byte[] longToByte(long[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[8 * len];
        NativeData.copyLongToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] longToByte(long[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[8 * data.length];
        NativeData.copyLongToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    public static float[] byteToFloat(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        float[] array = new float[len];
        NativeData.copyByteToFloat(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static float[] byteToFloat(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 4 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 4;
        float[] array = new float[len];
        NativeData.copyByteToFloat(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static byte[] floatToByte(float[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[4 * len];
        NativeData.copyFloatToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] floatToByte(float[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[4 * data.length];
        NativeData.copyFloatToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    public static double[] byteToDouble(byte[] byteArr, ByteOrder byteOrder, int start, int len) {
        double[] array = new double[len];
        NativeData.copyByteToDouble(byteArr, start, array, 0, len, byteOrder);
        return array;
    }

    public static double[] byteToDouble(byte[] byteArr, ByteOrder byteOrder) {
        if (byteArr.length % 8 != 0) {
            throw new IllegalArgumentException("Length of byteArr does not match size of data type");
        }
        int len = byteArr.length / 8;
        double[] array = new double[len];
        NativeData.copyByteToDouble(byteArr, 0, array, 0, len, byteOrder);
        return array;
    }

    public static byte[] doubleToByte(double[] data, ByteOrder byteOrder, int start, int len) {
        byte[] byteArr = new byte[8 * len];
        NativeData.copyDoubleToByte(data, start, byteArr, 0, len, byteOrder);
        return byteArr;
    }

    public static byte[] doubleToByte(double[] data, ByteOrder byteOrder) {
        byte[] byteArr = new byte[8 * data.length];
        NativeData.copyDoubleToByte(data, 0, byteArr, 0, data.length, byteOrder);
        return byteArr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ByteOrder {
        NATIVE(java.nio.ByteOrder.nativeOrder()),
        LITTLE_ENDIAN(java.nio.ByteOrder.LITTLE_ENDIAN),
        BIG_ENDIAN(java.nio.ByteOrder.BIG_ENDIAN);

        private final java.nio.ByteOrder nioByteOrder;

        private ByteOrder(java.nio.ByteOrder nioByteOrder) {
            this.nioByteOrder = nioByteOrder;
        }

        java.nio.ByteOrder getNioByteOrder() {
            return this.nioByteOrder;
        }

        static ByteOrder getNativeByteOrder() {
            return ByteOrder.NATIVE.nioByteOrder.equals(ByteOrder.LITTLE_ENDIAN.nioByteOrder) ? LITTLE_ENDIAN : BIG_ENDIAN;
        }
    }
}

