/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.Date;

public class HDF5DateTimeWriter
implements IHDF5DateTimeWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5DateTimeWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setTimeStampAttribute(String objectPath, String name, long timeStamp) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, new long[]{timeStamp});
    }

    public void setDateAttribute(String objectPath, String name, Date date) {
        this.setTimeStampAttribute(objectPath, name, date.getTime());
    }

    public void setDateArrayAttribute(String objectPath, String name, Date[] dates) {
        this.setTimeStampArrayAttribute(objectPath, name, HDF5DateTimeWriter.datesToTimeStamps(dates));
    }

    public void setTimeStampArrayAttribute(final String objectPath, final String name, final long[] timeStamps) {
        assert (objectPath != null);
        assert (name != null);
        assert (timeStamps != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, timeStamps.length, registry);
                int storageTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, timeStamps.length, registry);
                HDF5DateTimeWriter.this.baseWriter.setAttribute(objectPath, name, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, storageTypeId, memoryTypeId, timeStamps);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void writeTimeStamp(final String objectPath, final long timeStamp) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, HDFNativeData.longToByte(timeStamp), true, true, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeScalarRunnable);
    }

    public void createTimeStampArray(String objectPath, int size) {
        this.createTimeStampArray(objectPath, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    public void createTimeStampArray(String objectPath, long size, int blockSize) {
        this.createTimeStampArray(objectPath, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    public void createTimeStampArray(final String objectPath, final int size, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = features.requiresChunking() ? HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[1], new long[]{size}, 8, registry) : HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, null, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createTimeStampArray(final String objectPath, final long length, final int blockSize, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (length >= 0L);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{length}, new long[]{blockSize}, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeStampArray(String objectPath, long[] timeStamps) {
        this.writeTimeStampArray(objectPath, timeStamps, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    public void writeTimeStampArray(final String objectPath, final long[] timeStamps, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (timeStamps != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_I64LE, new long[]{timeStamps.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, timeStamps);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeStampArrayBlock(final String objectPath, final long[] data, final long blockNumber) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{data.length};
                long[] slabStartOrNull = new long[]{(long)data.length * blockNumber};
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, new long[]{(long)data.length * (blockNumber + 1L)}, -1, registry);
                HDF5DateTimeWriter.this.baseWriter.checkIsTimeStamp(objectPath, dataSetId, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, dimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeStampArrayBlockWithOffset(final String objectPath, final long[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                HDF5DateTimeWriter.this.baseWriter.checkIsTimeStamp(objectPath, dataSetId, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeDate(String objectPath, Date date) {
        this.writeTimeStamp(objectPath, date.getTime());
    }

    public void writeDateArray(String objectPath, Date[] dates) {
        this.writeTimeStampArray(objectPath, HDF5DateTimeWriter.datesToTimeStamps(dates));
    }

    public void writeDateArray(String objectPath, Date[] dates, HDF5GenericStorageFeatures features) {
        this.writeTimeStampArray(objectPath, HDF5DateTimeWriter.datesToTimeStamps(dates), features);
    }

    private static long[] datesToTimeStamps(Date[] dates) {
        assert (dates != null);
        long[] timestamps = new long[dates.length];
        int i = 0;
        while (i < timestamps.length) {
            timestamps[i] = dates[i].getTime();
            ++i;
        }
        return timestamps;
    }

    public void setTimeDurationAttribute(String objectPath, String name, long timeDuration, HDF5TimeUnit timeUnit) {
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, timeUnit.getTypeVariant(), HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, new long[]{timeDuration});
    }

    public void setTimeDurationAttribute(String objectPath, String name, HDF5TimeDuration timeDuration) {
        this.setTimeDurationAttribute(objectPath, name, timeDuration.getValue(), timeDuration.getUnit());
    }

    public void setTimeDurationArrayAttribute(final String objectPath, final String name, final HDF5TimeDurationArray timeDurations) {
        assert (objectPath != null);
        assert (name != null);
        assert (timeDurations != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, timeDurations.timeDurations.length, registry);
                int storageTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, timeDurations.timeDurations.length, registry);
                HDF5DateTimeWriter.this.baseWriter.setAttribute(objectPath, name, timeDurations.timeUnit.getTypeVariant(), storageTypeId, memoryTypeId, timeDurations.timeDurations);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void writeTimeDuration(String objectPath, long timeDuration) {
        this.writeTimeDuration(objectPath, timeDuration, HDF5TimeUnit.SECONDS);
    }

    public void writeTimeDuration(final String objectPath, final long timeDuration, final HDF5TimeUnit timeUnit) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, HDFNativeData.longToByte(timeDuration), true, true, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeScalarRunnable);
    }

    public void writeTimeDuration(String objectPath, HDF5TimeDuration timeDuration) {
        this.writeTimeDuration(objectPath, timeDuration.getValue(), timeDuration.getUnit());
    }

    public void createTimeDurationArray(String objectPath, int size, HDF5TimeUnit timeUnit) {
        this.createTimeDurationArray(objectPath, size, timeUnit, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    public void createTimeDurationArray(String objectPath, long size, int blockSize, HDF5TimeUnit timeUnit) {
        this.createTimeDurationArray(objectPath, size, blockSize, timeUnit, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    public void createTimeDurationArray(final String objectPath, final int size, final HDF5TimeUnit timeUnit, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = features.requiresChunking() ? HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[1], new long[]{size}, 8, registry) : HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, null, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createTimeDurationArray(final String objectPath, final long size, final int blockSize, final HDF5TimeUnit timeUnit, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations) {
        this.writeTimeDurationArray(objectPath, timeDurations, HDF5TimeUnit.SECONDS, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(String objectPath, HDF5TimeDurationArray timeDurations) {
        this.writeTimeDurationArray(objectPath, timeDurations, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(final String objectPath, final HDF5TimeDurationArray timeDurations, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (timeDurations != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_I64LE, new long[]{timeDurations.timeDurations.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, timeDurations.timeDurations);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, timeDurations.timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit) {
        this.writeTimeDurationArray(objectPath, timeDurations, timeUnit, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit, HDF5IntStorageFeatures features) {
        this.writeTimeDurationArray(objectPath, new HDF5TimeDurationArray(timeDurations, timeUnit));
    }

    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations) {
        this.writeTimeDurationArray(objectPath, timeDurations, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (timeDurations != null);
        if (timeDurations.length == 0) {
            return;
        }
        HDF5TimeDurationArray durations = HDF5TimeDurationArray.create(timeDurations);
        this.writeTimeDurationArray(objectPath, durations);
    }

    public void writeTimeDurationArrayBlock(String objectPath, HDF5TimeDurationArray data, long blockNumber) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, data, data.getLength(), (long)data.getLength() * blockNumber);
    }

    public void writeTimeDurationArrayBlockWithOffset(final String objectPath, final HDF5TimeDurationArray data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                HDF5TimeUnit storedUnit = HDF5DateTimeWriter.this.baseWriter.checkIsTimeDuration(objectPath, dataSetId, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, storedUnit.convert(data));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArrayBlock(String objectPath, long[] data, long blockNumber, HDF5TimeUnit timeUnit) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber, timeUnit);
    }

    public void writeTimeDurationArrayBlockWithOffset(String objectPath, long[] data, int dataSize, long offset, HDF5TimeUnit timeUnit) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, new HDF5TimeDurationArray(data, timeUnit), dataSize, offset);
    }

    public void writeTimeDurationArrayBlock(String objectPath, HDF5TimeDuration[] data, long blockNumber) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeTimeDurationArrayBlockWithOffset(String objectPath, HDF5TimeDuration[] data, int dataSize, long offset) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, HDF5TimeDurationArray.create(data), dataSize, offset);
    }
}

