/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5DoubleWriter
implements IHDF5DoubleWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5DoubleWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setDoubleAttribute(String objectPath, String name, double value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, new double[]{value});
    }

    public void setDoubleArrayAttribute(final String objectPath, final String name, final double[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, value.length, registry);
                int storageTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F64LE, value.length, registry);
                HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setDoubleMDArrayAttribute(final String objectPath, final String name, final MDDoubleArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, value.dimensions(), registry);
                int storageTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F64LE, value.dimensions(), registry);
                HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setDoubleMatrixAttribute(String objectPath, String name, double[][] value) {
        this.setDoubleMDArrayAttribute(objectPath, name, new MDDoubleArray(value));
    }

    public void writeDouble(String objectPath, double value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, value);
    }

    public void writeDoubleArray(String objectPath, double[] data) {
        this.writeDoubleArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeDoubleArray(final String objectPath, final double[] data, final HDF5FloatStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DoubleWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F64LE, new long[]{data.length}, 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createDoubleArray(String objectPath, int size) {
        this.createDoubleArray(objectPath, size, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleArray(String objectPath, long size, int blockSize) {
        this.createDoubleArray(objectPath, size, blockSize, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleArray(final String objectPath, final int size, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createDoubleArray(final String objectPath, final long size, final int blockSize, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeDoubleArrayBlock(String objectPath, double[] data, long blockNumber) {
        this.writeDoubleArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeDoubleArrayBlockWithOffset(final String objectPath, final double[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeDoubleMatrix(String objectPath, double[][] data) {
        this.writeDoubleMatrix(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeDoubleMatrix(String objectPath, double[][] data, HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeDoubleMDArray(objectPath, new MDDoubleArray(data), features);
    }

    public void createDoubleMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createDoubleMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createDoubleMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, dimensions, blockDimensions, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeDoubleMatrixBlock(String objectPath, double[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeDoubleMDArrayBlock(objectPath, new MDDoubleArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeDoubleMatrixBlockWithOffset(String objectPath, double[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeDoubleMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeDoubleMatrixBlockWithOffset(String objectPath, double[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeDoubleMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeDoubleMDArray(String objectPath, MDDoubleArray data) {
        this.writeDoubleMDArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeDoubleMDArray(final String objectPath, final MDDoubleArray data, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DoubleWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F64LE, data.longDimensions(), 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createDoubleMDArray(String objectPath, int[] dimensions) {
        this.createDoubleMDArray(objectPath, dimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createDoubleMDArray(objectPath, dimensions, blockDimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createDoubleMDArray(final String objectPath, final int[] dimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, nullDimensions, MDArray.toLong(dimensions), 8, registry);
                } else {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, MDArray.toLong(dimensions), null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createDoubleMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, dimensions, MDArray.toLong(blockDimensions), 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeDoubleMDArrayBlock(String objectPath, MDDoubleArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeDoubleMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeDoubleMDArrayBlockWithOffset(final String objectPath, final MDDoubleArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeDoubleMDArrayBlockWithOffset(final String objectPath, final MDDoubleArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

