/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5T;
import java.lang.reflect.Field;

abstract class HDF5MemberByteifyer {
    private final Field fieldOrNull;
    private final String memberName;
    protected final int size;
    protected final int sizeInBytes;
    protected final int offset;
    protected final CharacterEncoding encoding;
    private final HDF5DataTypeVariant typeVariant;

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, HDF5DataTypeVariant typeVariantOrNull) {
        this(fieldOrNull, memberName, size, size, offset, CharacterEncoding.ASCII, typeVariantOrNull);
    }

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int sizeInBytes, int offset, CharacterEncoding encoding) {
        this(fieldOrNull, memberName, size, sizeInBytes, offset, encoding, HDF5DataTypeVariant.NONE);
    }

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int sizeInBytes, int offset, CharacterEncoding encoding, HDF5DataTypeVariant typeVariantOrNull) {
        this.fieldOrNull = fieldOrNull;
        this.memberName = memberName;
        this.size = size;
        this.sizeInBytes = sizeInBytes;
        this.offset = offset;
        this.encoding = encoding;
        this.typeVariant = HDF5DataTypeVariant.maskNull(typeVariantOrNull);
    }

    public abstract byte[] byteify(int var1, Object var2) throws IllegalAccessException;

    public abstract void setFromByteArray(int var1, Object var2, byte[] var3, int var4) throws IllegalAccessException;

    protected abstract int getMemberStorageTypeId();

    protected abstract int getMemberNativeTypeId();

    public void insertType(int dataTypeId) {
        H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, this.getMemberStorageTypeId());
    }

    public void insertNativeType(int dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
        if (this.getMemberNativeTypeId() < 0) {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, h5.getNativeDataTypeCheckForBitField(this.getMemberStorageTypeId(), registry));
        } else {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, this.getMemberNativeTypeId());
        }
    }

    public String getMemberName() {
        return this.memberName;
    }

    Field tryGetField() {
        return this.fieldOrNull;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalSize() {
        return this.offset + this.sizeInBytes;
    }

    public HDF5DataTypeVariant getTypeVariant() {
        return this.typeVariant;
    }

    public String describe() {
        if (this.fieldOrNull != null) {
            return "field '" + this.fieldOrNull.getName() + "' of class '" + this.fieldOrNull.getDeclaringClass().getCanonicalName() + "'";
        }
        return "member '" + this.memberName + "'";
    }

    public boolean isDummy() {
        return false;
    }

    public String toString() {
        return this.describe();
    }
}

