/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ShortWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5ShortWriter
implements IHDF5ShortWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5ShortWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setShortAttribute(String objectPath, String name, short value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_I16LE, HDF5Constants.H5T_NATIVE_INT16, new short[]{value});
    }

    public void setShortArrayAttribute(final String objectPath, final String name, final short[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT16, value.length, registry);
                int storageTypeId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I16LE, value.length, registry);
                HDF5ShortWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setShortMDArrayAttribute(final String objectPath, final String name, final MDShortArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT16, value.dimensions(), registry);
                int storageTypeId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I16LE, value.dimensions(), registry);
                HDF5ShortWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setShortMatrixAttribute(String objectPath, String name, short[][] value) {
        this.setShortMDArrayAttribute(objectPath, name, new MDShortArray(value));
    }

    public void writeShort(String objectPath, short value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I16LE, HDF5Constants.H5T_NATIVE_INT16, value);
    }

    public void writeShortArray(String objectPath, short[] data) {
        this.writeShortArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeShortArray(final String objectPath, final short[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5ShortWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, new long[]{data.length}, 2, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT16, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createShortArray(String objectPath, int size) {
        this.createShortArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortArray(String objectPath, long size, int blockSize) {
        this.createShortArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, new long[1], new long[]{size}, 2, registry);
                } else {
                    HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, new long[]{size}, null, 2, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createShortArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, new long[]{size}, new long[]{blockSize}, 2, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeShortArrayBlock(String objectPath, short[] data, long blockNumber) {
        this.writeShortArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeShortArrayBlockWithOffset(final String objectPath, final short[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileId, objectPath, ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeShortMatrix(String objectPath, short[][] data) {
        this.writeShortMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeShortMatrix(String objectPath, short[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeShortMDArray(objectPath, new MDShortArray(data), features);
    }

    public void createShortMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createShortMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createShortMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, dimensions, blockDimensions, 2, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeShortMatrixBlock(String objectPath, short[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeShortMDArrayBlock(objectPath, new MDShortArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeShortMatrixBlockWithOffset(String objectPath, short[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeShortMDArrayBlockWithOffset(objectPath, new MDShortArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeShortMatrixBlockWithOffset(String objectPath, short[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeShortMDArrayBlockWithOffset(objectPath, new MDShortArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeShortMDArray(String objectPath, MDShortArray data) {
        this.writeShortMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeShortMDArray(final String objectPath, final MDShortArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5ShortWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, data.longDimensions(), 2, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT16, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createShortMDArray(String objectPath, int[] dimensions) {
        this.createShortMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createShortMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createShortMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, nullDimensions, MDArray.toLong(dimensions), 2, registry);
                } else {
                    HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, MDArray.toLong(dimensions), null, 2, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createShortMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ShortWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I16LE : HDF5Constants.H5T_STD_U16LE, features, dimensions, MDArray.toLong(blockDimensions), 2, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeShortMDArrayBlock(String objectPath, MDShortArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeShortMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeShortMDArrayBlockWithOffset(final String objectPath, final MDShortArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileId, objectPath, ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeShortMDArrayBlockWithOffset(final String objectPath, final MDShortArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileId, objectPath, ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5ShortWriter)HDF5ShortWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

