/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.h5ar.DeleteFromArchiveException;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndex;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.IPathVisitor;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5ArchiveDeleter {
    private final IHDF5Writer hdf5Writer;
    private final DirectoryIndexProvider indexProvider;

    public HDF5ArchiveDeleter(IHDF5Writer hdf5Writer, DirectoryIndexProvider indexProvider) {
        this.hdf5Writer = hdf5Writer;
        this.indexProvider = indexProvider;
    }

    public HDF5ArchiveDeleter delete(List<String> hdf5ObjectPaths, IPathVisitor pathVisitorOrNull) {
        for (String path : hdf5ObjectPaths) {
            String normalizedPath = Utils.normalizePath(path);
            String group = Utils.getParentPath(normalizedPath);
            DirectoryIndex index = this.indexProvider.get(group, false);
            try {
                this.hdf5Writer.delete(normalizedPath);
                String name = normalizedPath.substring(group.length() + 1);
                index.remove(name);
                if (pathVisitorOrNull == null) continue;
                pathVisitorOrNull.visit(normalizedPath);
            }
            catch (HDF5Exception ex) {
                this.indexProvider.getErrorStrategy().dealWithError(new DeleteFromArchiveException(path, ex));
            }
        }
        return this;
    }
}

