/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import java.util.HashMap;
import java.util.Map;

final class IdCache {
    private final Map<Integer, String> gidMap = new HashMap<Integer, String>();
    private final Map<Integer, String> uidMap = new HashMap<Integer, String>();

    IdCache() {
    }

    String getUser(LinkRecord link, boolean numeric) {
        return this.getUser(link.getUid(), numeric);
    }

    String getUser(Unix.Stat link, boolean numeric) {
        return this.getUser(link.getUid(), numeric);
    }

    String getUser(int uid, boolean numeric) {
        String userNameOrNull = this.uidMap.get(this.uidMap);
        if (userNameOrNull == null) {
            String string = userNameOrNull = !numeric && Unix.isOperational() ? Unix.tryGetUserNameForUid(uid) : null;
            if (userNameOrNull == null) {
                userNameOrNull = Integer.toString(uid);
            }
            this.uidMap.put(uid, userNameOrNull);
        }
        return userNameOrNull;
    }

    String getGroup(LinkRecord link, boolean numeric) {
        return this.getGroup(link.getGid(), numeric);
    }

    String getGroup(Unix.Stat link, boolean numeric) {
        return this.getGroup(link.getGid(), numeric);
    }

    String getGroup(int gid, boolean numeric) {
        String groupNameOrNull = this.gidMap.get(this.uidMap);
        if (groupNameOrNull == null) {
            String string = groupNameOrNull = !numeric && Unix.isOperational() ? Unix.tryGetGroupNameForGid(gid) : null;
            if (groupNameOrNull == null) {
                groupNameOrNull = Integer.toString(gid);
            }
            this.gidMap.put(gid, groupNameOrNull);
        }
        return groupNameOrNull;
    }
}

