/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.forester.development.SupportCount;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class count_support {
    private static final String PRG_NAME = "count_support";
    private static final String PRG_VERSION = "1.0";
    private static final String PRG_DATE = "2008.03.04";
    private static final boolean WRITE_EVALUATORS_AS_NHX = false;

    public static void main(String[] args) {
        PhylogenyWriter w;
        PhylogenyParser pp;
        PhylogenyFactory factory;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (args.length < 3 || args.length > 7) {
            System.out.println();
            System.out.println("count_support: wrong number of arguments");
            System.out.println();
            System.out.println("Usage: \"count_support [options] <file containing phylogeny to be evaluated> <file with phylogenies to be used for evaluation> <outfile> [outfile for evaluator phylogenies, always unstripped if -t=<d> option is used, otherwise strippedness is dependent on -s option]\"\n");
            System.out.println(" Options: -s strip external nodes from evaluator phylogenies not found in phylogeny to be evaluated");
            System.out.println("        : -t=<d> threshold for similarity (0.0 to 1.0)");
            System.out.println("        : -n no branch lengths in outfile for evaluator phylogenies");
            System.out.println();
            System.exit(-1);
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add("s");
        allowed_options.add("t");
        allowed_options.add("n");
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "Unknown option(s): " + dissallowed_options);
        }
        File phylogeny_infile = cla.getFile(0);
        File evaluators_infile = cla.getFile(1);
        File phylogeny_outfile = cla.getFile(2);
        File evaluators_outfile = null;
        boolean branch_lengths_in_ev_out = true;
        if (cla.isOptionSet("n")) {
            branch_lengths_in_ev_out = false;
        }
        if (cla.getNumberOfNames() == 4) {
            evaluators_outfile = cla.getFile(3);
        } else if (!branch_lengths_in_ev_out) {
            ForesterUtil.fatalError(PRG_NAME, "Cannot use -n option if no outfile for evaluators specified");
        }
        Phylogeny p = null;
        Phylogeny[] ev = null;
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            pp = ForesterUtil.createParserDependingOnFileType(phylogeny_infile, true);
            p = factory.create(phylogeny_infile, pp)[0];
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + phylogeny_infile + "\" [" + e.getMessage() + "]");
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            pp = ForesterUtil.createParserDependingOnFileType(evaluators_infile, true);
            ev = factory.create(evaluators_infile, pp);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + evaluators_infile + "\" [" + e.getMessage() + "]");
        }
        boolean strip2 = false;
        if (cla.isOptionSet("s")) {
            strip2 = true;
        }
        double threshhold = -1.0;
        if (cla.isOptionSet("t")) {
            try {
                threshhold = cla.getOptionValueAsDouble("t");
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line arguments: " + e.getMessage());
            }
            if (threshhold < 0.0 || threshhold > 1.0) {
                ForesterUtil.fatalError(PRG_NAME, "support threshold has to be between 0.0 and 1.0 (inclusive)");
            }
        }
        List<Phylogeny> evaluator_phylogenies_above_threshold = null;
        try {
            if (threshhold >= 0.0) {
                evaluator_phylogenies_above_threshold = SupportCount.count(p, ev, strip2, threshhold, true);
                if (evaluator_phylogenies_above_threshold.size() < 1) {
                    ForesterUtil.fatalError(PRG_NAME, "appears like threshold for similarity is set too high");
                }
            } else {
                SupportCount.count(p, ev, strip2, true);
            }
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, "Failure during support counting: " + e.getMessage());
        }
        if (threshhold >= 0.0) {
            count_support.normalizeSupport(p, 100.0, evaluator_phylogenies_above_threshold.size());
            System.out.println(String.valueOf(evaluator_phylogenies_above_threshold.size()) + " out of " + ev.length + " evaluator phylogenies are above threshold of " + threshhold);
        }
        try {
            w = new PhylogenyWriter();
            w.toPhyloXML(phylogeny_outfile, p, 1);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + e.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Wrote phylogeny with support values to: " + phylogeny_outfile);
        if (evaluators_outfile != null) {
            try {
                w = new PhylogenyWriter();
                if (evaluator_phylogenies_above_threshold != null) {
                    System.out.println("Writing " + evaluator_phylogenies_above_threshold.size() + " evaluator phylogenies above threshold of " + threshhold + " to: " + evaluators_outfile);
                    w.toNewHampshire(evaluator_phylogenies_above_threshold, true, branch_lengths_in_ev_out, evaluators_outfile, ";" + ForesterUtil.getLineSeparator());
                } else {
                    System.out.println("Writing " + ev.length + " evaluator phylogenies to :" + evaluators_outfile);
                    w.toNewHampshire(Arrays.asList(ev), true, branch_lengths_in_ev_out, evaluators_outfile, ";" + ForesterUtil.getLineSeparator());
                }
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + e.getMessage() + "]");
            }
        }
        System.out.println();
        System.out.println("Done.");
        System.out.println();
    }

    private static void normalizeSupport(Phylogeny p, double normalized_max, int number_phylos) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        int n = 0;
        PhylogenyNodeIterator iter = p.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isRoot() || node.isExternal()) continue;
            double b = PhylogenyMethods.getConfidenceValue(node);
            if (b > max) {
                max = b;
            }
            if (b >= 0.0 && b < min) {
                min = b;
            }
            sum += b;
            ++n;
        }
        double av = sum / (double)n;
        System.out.println("Max support before normalization is    : " + max);
        System.out.println("Min support before normalization is    : " + min);
        System.out.println("Average support before normalization is: " + av + " (=" + sum + "/" + n + ")");
        System.out.println("Normalizing so that theoretical maximum support value is: " + normalized_max);
        System.out.println("Number of phylogenies used in support analysis: " + number_phylos);
        double f = normalized_max / (double)number_phylos;
        min = Double.MAX_VALUE;
        max = -1.7976931348623157E308;
        sum = 0.0;
        n = 0;
        PhylogenyNodeIterator iter2 = p.iteratorPostorder();
        while (iter2.hasNext()) {
            PhylogenyNode node = iter2.next();
            if (node.isRoot() || node.isExternal()) {
                PhylogenyMethods.setBootstrapConfidence(node, -9999.0);
                continue;
            }
            double b = PhylogenyMethods.getConfidenceValue(node);
            b = f * b;
            PhylogenyMethods.setBootstrapConfidence(node, b);
            if (b > max) {
                max = b;
            }
            if (b >= 0.0 && b < min) {
                min = b;
            }
            sum += b;
            ++n;
        }
        av = sum / (double)n;
        System.out.println("Max support after normalization is    : " + max);
        System.out.println("Min support after normalization is    : " + min);
        System.out.println("Average support after normalization is: " + av + " (=" + sum + "/" + n + ")");
    }
}

