/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class nhx_too {
    private static final String PRG_NAME = "nhx_too";
    private static final String PRG_VERSION = "0.1";
    private static final String PRG_DATE = "2008.03.04";
    private static final String INT_NODE_NAME_IS_SUPPORT = "is";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (args.length < 3 || args.length > 3) {
            System.out.println();
            System.out.println("nhx_too: wrong number of arguments");
            System.out.println();
            System.out.println("Usage: \"nhx_too [options] <infile> <outfile>\n");
            System.out.println(" Options: -is: internal node names are support values (i.e. MrBayes output)");
            System.out.println();
            System.exit(-1);
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(INT_NODE_NAME_IS_SUPPORT);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "Unknown option(s): " + dissallowed_options);
        }
        File phylogeny_infile = cla.getFile(0);
        File phylogeny_outfile = cla.getFile(1);
        boolean int_node_name_is_support = false;
        if (cla.isOptionSet(INT_NODE_NAME_IS_SUPPORT)) {
            int_node_name_is_support = true;
        }
        Phylogeny p = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(phylogeny_infile, true);
            p = factory.create(phylogeny_infile, pp)[0];
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + phylogeny_infile + "\" [" + e.getMessage() + "]");
        }
        if (int_node_name_is_support) {
            try {
                ForesterUtil.transferInternalNodeNamesToConfidence(p);
            }
            catch (Exception e) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "Failure during moving of internal names to support values [" + e.getMessage() + "]");
            }
        }
        try {
            PhylogenyWriter w = new PhylogenyWriter();
            w.toNewHampshireX(p, phylogeny_outfile);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + e.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Done [wrote \"" + phylogeny_outfile + "\"].");
        System.out.println();
    }
}

