/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.io.parsers.HmmPfamOutputParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.NeighborJoining;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainCountsDifferenceUtil;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PairwiseGenomeComparator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.Protein;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class surfacing_old {
    public static final String DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS = "graph_analysis_out";
    public static final String DOMAIN_COMBINITONS_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_dc.dot";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_fitch_present_dc.dot";
    public static final String DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX = ".dcc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_DOMAINS = "_dollo_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_DOMAINS = "_fitch_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_DOMAINS = "_dollo_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_glc_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_DOMAINS = "_fitch_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_glc_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_BC = "_fitch_gains_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_HTML_BC = "_fitch_gains_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_BC = "_fitch_losses_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_HTML_BC = "_fitch_losses_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC = "_fitch_present_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_HTML_BC = "_fitch_present_dc.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_D = "_dollo_gains_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_GOID_D = "_dollo_gains_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_HTML_D = "_dollo_gains_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_D = "_dollo_losses_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_HTML_D = "_dollo_losses_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_D = "_dollo_present_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_GOID_D = "_dollo_present_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_HTML_D = "_dollo_present_d.html";
    public static final String DOMAINS_PRESENT_NEXUS = "_dom.nex";
    public static final String BDC_PRESENT_NEXUS = "_dc.nex";
    public static final String PRG_NAME = "surfacing";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_d_dollo.xml";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_d_fitch.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_dc_dollo.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_dc_fitch.xml";
    public static final String NEXUS_EXTERNAL_DOMAINS = "_dom.nex";
    public static final String NEXUS_EXTERNAL_DOMAIN_COMBINATIONS = "_dc.nex";
    public static final String NEXUS_SECONDARY_FEATURES = "_secondary_features.nex";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_gl_secondary_features";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_glc_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_SECONDARY_FEATURES = "_dollo_gains_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_SECONDARY_FEATURES = "_dollo_losses_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_SECONDARY_FEATURES = "_dollo_present_secondary_features";
    public static final String SECONDARY_FEATURES_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_secondary_features_dollo.xml";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_BIOLOGICAL_PROCESS = "_dollo_biol_proc_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_CELLULAR_COMPONENT = "_dollo_cell_comp_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_MOLECULAR_FUNCTION = "_dollo_mol_funct_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_ALL_NAMESPACES = "_dollo_goid_d";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_BIOLOGICAL_PROCESS = "_fitch_biol_proc_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_CELLULAR_COMPONENT = "_fitch_cell_comp_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_MOLECULAR_FUNCTION = "_fitch_mol_funct_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_ALL_NAMESPACES = "_fitch_goid_dc";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_DIR_OPTION = "out_dir";
    private static final String SCORING_OPTION = "scoring";
    private static final DomainSimilarity.DomainSimilarityScoring SCORING_DEFAULT = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
    private static final String SCORING_DOMAIN_COUNT_BASED = "domains";
    private static final String SCORING_PROTEIN_COUNT_BASED = "proteins";
    private static final String SCORING_COMBINATION_BASED = "combinations";
    private static final String DETAILEDNESS_OPTION = "detail";
    private static final DomainSimilarityCalculator.Detailedness DETAILEDNESS_DEFAULT = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    private static final String SPECIES_MATRIX_OPTION = "smatrix";
    private static final String DETAILEDNESS_BASIC = "basic";
    private static final String DETAILEDNESS_LIST_IDS = "list_ids";
    private static final String DETAILEDNESS_PUNCTILIOUS = "punctilious";
    private static final String DOMAIN_SIMILARITY_SORT_OPTION = "sort";
    private static final DomainSimilarity.DomainSimilaritySortField DOMAIN_SORT_FILD_DEFAULT = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
    private static final String DOMAIN_SIMILARITY_SORT_MIN = "min";
    private static final String DOMAIN_SIMILARITY_SORT_MAX = "max";
    private static final String DOMAIN_SIMILARITY_SORT_SD = "sd";
    private static final String DOMAIN_SIMILARITY_SORT_MEAN = "mean";
    private static final String DOMAIN_SIMILARITY_SORT_DIFF = "diff";
    private static final String DOMAIN_SIMILARITY_SORT_COUNTS_DIFF = "count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF = "abs_count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_SPECIES_COUNT = "species";
    private static final String DOMAIN_SIMILARITY_SORT_ALPHA = "alpha";
    private static final String DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION = "species_first";
    private static final String DOMAIN_COUNT_SORT_OPTION = "dc_sort";
    private static final GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder DOMAINS_SORT_ORDER_DEFAULT = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
    private static final String DOMAIN_COUNT_SORT_ALPHA = "alpha";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT = "dom";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT = "prot";
    private static final String DOMAIN_COUNT_SORT_COMBINATIONS_COUNT = "comb";
    private static final String CUTOFF_SCORE_FILE_OPTION = "cos";
    private static final String NOT_IGNORE_DUFS_OPTION = "dufs";
    private static final String MAX_E_VALUE_OPTION = "e";
    private static final String MAX_ALLOWED_OVERLAP_OPTION = "mo";
    private static final String NO_ENGULFING_OVERLAP_OPTION = "no_eo";
    private static final String IGNORE_COMBINATION_WITH_SAME_OPTION = "ignore_self_comb";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_PREFIX = "pwc_";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_OPTION = "pwc";
    private static final String OUTPUT_FILE_OPTION = "o";
    private static final String PFAM_TO_GO_FILE_USE_OPTION = "p2g";
    private static final String GO_OBO_FILE_USE_OPTION = "obo";
    private static final String GO_NAMESPACE_LIMIT_OPTION = "go_namespace";
    private static final String GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION = "molecular_function";
    private static final String GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS = "biological_process";
    private static final String GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT = "cellular_component";
    private static final String SECONDARY_FEATURES_PARSIMONY_MAP_FILE = "secondary";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED = "simple_tab";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML = "simple_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML = "detailed_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION = "ds_output";
    private static final PrintableDomainSimilarity.PRINT_OPTION DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT = PrintableDomainSimilarity.PRINT_OPTION.HTML;
    private static final String IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION = "ignore_singlet_domains";
    private static final String IGNORE_VIRAL_IDS = "ignore_viral_ids";
    private static final boolean IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_DEFAULT = false;
    private static final String IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION = "ignore_species_specific_domains";
    private static final boolean IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION_DEFAULT = false;
    private static final String MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score.pwd";
    private static final String MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains.pwd";
    private static final String MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations.pwd";
    private static final String NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score_NJ.xml";
    private static final String NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains_NJ.xml";
    private static final String NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations_NJ.xml";
    private static final String DISPLAY_M_HISTOGRAMS_OPTION = "mhisto";
    private static final String JACKNIFE_OPTION = "jack";
    private static final String JACKNIFE_RANDOM_SEED_OPTION = "seed";
    private static final String JACKNIFE_RATIO_OPTION = "jack_ratio";
    private static final int JACKNIFE_NUMBER_OF_RESAMPLINGS_DEFAULT = 100;
    private static final long JACKNIFE_RANDOM_SEED_DEFAULT = 19L;
    private static final double JACKNIFE_RATIO_DEFAULT = 0.5;
    private static final String INFERRED_SD_BASED_NJ_SPECIES_TREE_SUFFIX = "_sd_nj.nh";
    private static final String INFERRED_SBC_BASED_NJ_SPECIES_TREE_SUFFIX = "_sbc_nj.nh";
    private static final String FILTER_POSITIVE_OPTION = "pos_filter";
    private static final String FILTER_NEGATIVE_OPTION = "neg_filter";
    private static final String FILTER_NEGATIVE_DOMAINS_OPTION = "neg_dom_filter";
    private static final String INPUT_FILES_FROM_FILE_OPTION = "input";
    private static final String INPUT_SPECIES_TREE_OPTION = "species_tree";
    private static final String SEQ_EXTRACT_OPTION = "prot_extract";
    private static final char SEPARATOR_FOR_INPUT_VALUES = '#';
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "2009.07.06";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/applications/surfacing";
    private static final boolean IGNORE_DUFS_DEFAULT = true;
    private static final boolean IGNORE_COMBINATION_WITH_SAME_DEFAULLT = false;
    private static final double MAX_E_VALUE_DEFAULT = -1.0;
    private static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private static final String DEFAULT_SEARCH_PARAMETER = "ls";
    private static final boolean ALLOW_NON_UNIQUE_QUERY_IN_HMMPFAM_OUTPUT_DEFAULT = true;
    private static final boolean VERBOSE_DEFAULT = true;
    private static final String RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION = "random_seed";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS = "consider_bdc_direction";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY = "consider_bdc_adj";
    private static final String SEQ_EXTRACT_SUFFIX = ".prot";
    private static final String PLUS_MINUS_ANALYSIS_OPTION = "plus_minus";
    private static final String PLUS_MINUS_DOM_SUFFIX = "_plus_minus_dom.txt";
    private static final String PLUS_MINUS_DOM_SUFFIX_HTML = "_plus_minus_dom.html";
    private static final String PLUS_MINUS_DC_SUFFIX_HTML = "_plus_minus_dc.html";
    private static final int PLUS_MINUS_ANALYSIS_MIN_DIFF_DEFAULT = 0;
    private static final double PLUS_MINUS_ANALYSIS_FACTOR_DEFAULT = 1.0;
    private static final String PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_all.txt";
    private static final String PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_passing.txt";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS = "all_prot";
    private static final boolean VERBOSE = false;
    private static final String OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_gains_counts";
    private static final String OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_losses_counts";
    private static final String DOMAIN_LENGTHS_ANALYSIS_SUFFIX = "_domain_lengths_analysis";
    private static final boolean PERFORM_DOMAIN_LENGTH_ANALYSIS = true;
    public static final String ALL_PFAMS_ENCOUNTERED_SUFFIX = "_all_encountered_pfams";
    public static final String ALL_PFAMS_ENCOUNTERED_WITH_GO_ANNOTATION_SUFFIX = "_all_encountered_pfams_with_go_annotation";
    public static final String ENCOUNTERED_PFAMS_SUMMARY_SUFFIX = "_encountered_pfams_summary";
    public static final String ALL_PFAMS_GAINED_AS_DOMAINS_SUFFIX = "_all_pfams_gained_as_domains";
    public static final String ALL_PFAMS_LOST_AS_DOMAINS_SUFFIX = "_all_pfams_lost_as_domains";
    public static final String ALL_PFAMS_GAINED_AS_DC_SUFFIX = "_all_pfams_gained_as_dc";
    public static final String ALL_PFAMS_LOST_AS_DC_SUFFIX = "_all_pfams_lost_as_dc";
    public static final String BASE_DIRECTORY_PER_NODE_DOMAIN_GAIN_LOSS_FILES = "PER_NODE_EVENTS";
    public static final String BASE_DIRECTORY_PER_SUBTREE_DOMAIN_GAIN_LOSS_FILES = "PER_SUBTREE_EVENTS";
    public static final String D_PROMISCUITY_FILE_SUFFIX = "_domain_promiscuities";

    private static void checkWriteabilityForPairwiseComparisons(PrintableDomainSimilarity.PRINT_OPTION domain_similarity_print_option, String[][] input_file_properties, String automated_pairwise_comparison_suffix, File outdir) {
        int i = 0;
        while (i < input_file_properties.length) {
            int j = 0;
            while (j < i) {
                String species_i = input_file_properties[i][1];
                String species_j = input_file_properties[j][1];
                String pairwise_similarities_output_file_str = PAIRWISE_DOMAIN_COMPARISONS_PREFIX + species_i + "_" + species_j + automated_pairwise_comparison_suffix;
                switch (domain_similarity_print_option) {
                    case HTML: {
                        if (pairwise_similarities_output_file_str.endsWith(".html")) break;
                        pairwise_similarities_output_file_str = String.valueOf(pairwise_similarities_output_file_str) + ".html";
                    }
                }
                String error = ForesterUtil.isWritableFile(new File(outdir == null ? pairwise_similarities_output_file_str : outdir + ForesterUtil.FILE_SEPARATOR + pairwise_similarities_output_file_str));
                if (!ForesterUtil.isEmpty(error)) {
                    ForesterUtil.fatalError(PRG_NAME, error);
                }
                ++j;
            }
            ++i;
        }
    }

    private static StringBuilder createParametersAsString(boolean ignore_dufs, double e_value_max, int max_allowed_overlap, boolean no_engulfing_overlaps, File cutoff_scores_file, BinaryDomainCombination.DomainCombinationType dc_type) {
        StringBuilder parameters_sb = new StringBuilder();
        parameters_sb.append("E-value: " + e_value_max);
        if (cutoff_scores_file != null) {
            parameters_sb.append(", Cutoff-scores-file: " + cutoff_scores_file);
        } else {
            parameters_sb.append(", Cutoff-scores-file: not-set");
        }
        if (max_allowed_overlap != -1) {
            parameters_sb.append(", Max-overlap: " + max_allowed_overlap);
        } else {
            parameters_sb.append(", Max-overlap: not-set");
        }
        if (no_engulfing_overlaps) {
            parameters_sb.append(", Engulfing-overlaps: not-allowed");
        } else {
            parameters_sb.append(", Engulfing-overlaps: allowed");
        }
        if (ignore_dufs) {
            parameters_sb.append(", Ignore-dufs: true");
        } else {
            parameters_sb.append(", Ignore-dufs: false");
        }
        parameters_sb.append(", DC type (if applicable): " + (Object)((Object)dc_type));
        return parameters_sb;
    }

    private static void executeFitchGainsAnalysis(File output_file, List<BinaryDomainCombination> all_bin_domain_combinations_changed, int sum_of_all_domains_encountered, SortedSet<BinaryDomainCombination> all_bin_domain_combinations_encountered, boolean is_gains_analysis) throws IOException {
        SurfacingUtil.checkForOutputFileWriteability(output_file);
        BufferedWriter out = ForesterUtil.createBufferedWriter(output_file);
        SortedMap<Object, Integer> bdc_to_counts = ForesterUtil.listToSortedCountsMap(all_bin_domain_combinations_changed);
        TreeSet<DomainId> all_domains_in_combination_changed_more_than_once = new TreeSet<DomainId>();
        TreeSet<DomainId> all_domains_in_combination_changed_only_once = new TreeSet<DomainId>();
        int above_one = 0;
        int one = 0;
        for (Object bdc_object : bdc_to_counts.keySet()) {
            BinaryDomainCombination bdc = (BinaryDomainCombination)bdc_object;
            int count = (Integer)bdc_to_counts.get(bdc_object);
            if (count < 1) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "count < 1 ");
            }
            out.write(bdc + "\t" + count + ForesterUtil.LINE_SEPARATOR);
            if (count > 1) {
                all_domains_in_combination_changed_more_than_once.add(bdc.getId0());
                all_domains_in_combination_changed_more_than_once.add(bdc.getId1());
                ++above_one;
                continue;
            }
            if (count != 1) continue;
            all_domains_in_combination_changed_only_once.add(bdc.getId0());
            all_domains_in_combination_changed_only_once.add(bdc.getId1());
            ++one;
        }
        int all = all_bin_domain_combinations_encountered.size();
        int never_lost = -1;
        if (!is_gains_analysis) {
            all_bin_domain_combinations_encountered.removeAll(all_bin_domain_combinations_changed);
            never_lost = all_bin_domain_combinations_encountered.size();
            for (BinaryDomainCombination bdc : all_bin_domain_combinations_encountered) {
                out.write(bdc + "\t" + "0" + ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (is_gains_analysis) {
            out.write("Sum of all distinct domain combinations appearing once               : " + one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations appearing more than once     : " + above_one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations apppearing only once     : " + all_domains_in_combination_changed_only_once.size() + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations apppearing more than once: " + all_domains_in_combination_changed_more_than_once.size() + ForesterUtil.LINE_SEPARATOR);
        } else {
            out.write("Sum of all distinct domain combinations never lost                   : " + never_lost + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations lost once                    : " + one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations lost more than once          : " + above_one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations lost only once           : " + all_domains_in_combination_changed_only_once.size() + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations lost more than once: " + all_domains_in_combination_changed_more_than_once.size() + ForesterUtil.LINE_SEPARATOR);
        }
        out.write("All binary combinations                                              : " + all + ForesterUtil.LINE_SEPARATOR);
        out.write("All domains                                                          : " + sum_of_all_domains_encountered);
        ((Writer)out).close();
        ForesterUtil.programMessage(PRG_NAME, "Wrote fitch domain combination dynamics counts analysis to \"" + output_file + "\"");
    }

    private static void executePlusMinusAnalysis(File output_file, List<String> plus_minus_analysis_high_copy_base, List<String> plus_minus_analysis_high_copy_target, List<String> plus_minus_analysis_low_copy, List<GenomeWideCombinableDomains> gwcd_list, SortedMap<Species, List<Protein>> protein_lists_per_species, Map<DomainId, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, List<Object> plus_minus_analysis_numbers) {
        HashSet<String> all_spec = new HashSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            all_spec.add(gwcd.getSpecies().getSpeciesId());
        }
        File html_out_dom = new File(output_file + PLUS_MINUS_DOM_SUFFIX_HTML);
        File plain_out_dom = new File(output_file + PLUS_MINUS_DOM_SUFFIX);
        File html_out_dc = new File(output_file + PLUS_MINUS_DC_SUFFIX_HTML);
        File all_domains_go_ids_out_dom = new File(output_file + PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX);
        File passing_domains_go_ids_out_dom = new File(output_file + PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX);
        File proteins_file_base = new File("" + output_file);
        int min_diff = (Integer)plus_minus_analysis_numbers.get(0);
        double factor = (Double)plus_minus_analysis_numbers.get(1);
        try {
            DomainCountsDifferenceUtil.calculateCopyNumberDifferences(gwcd_list, protein_lists_per_species, plus_minus_analysis_high_copy_base, plus_minus_analysis_high_copy_target, plus_minus_analysis_low_copy, min_diff, factor, plain_out_dom, html_out_dom, html_out_dc, domain_id_to_go_ids_map, go_id_to_term_map, all_domains_go_ids_out_dom, passing_domains_go_ids_out_dom, proteins_file_base);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + html_out_dom + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + plain_out_dom + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + html_out_dc + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based passing GO ids to \"" + passing_domains_go_ids_out_dom + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based all GO ids to \"" + all_domains_go_ids_out_dom + "\"");
    }

    private static Phylogeny[] getIntrees(File[] intree_files, int number_of_genomes, String[][] input_file_properties) {
        Phylogeny[] intrees = new Phylogeny[intree_files.length];
        int i = 0;
        File[] fileArray = intree_files;
        int n = intree_files.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuilder parent_names;
            int nodes_lacking_name;
            File intree_file = fileArray[n2];
            Phylogeny intree = null;
            String error = ForesterUtil.isReadableFile(intree_file);
            if (!ForesterUtil.isEmpty(error)) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read input tree file [" + intree_file + "]: " + error);
            }
            try {
                Phylogeny[] p_array = ParserBasedPhylogenyFactory.getInstance().create(intree_file, ForesterUtil.createParserDependingOnFileType(intree_file, true));
                if (p_array.length < 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + intree_file + "] does not contain any phylogeny in phyloXML format");
                } else if (p_array.length > 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + intree_file + "] contains more than one phylogeny in phyloXML format");
                }
                intree = p_array[0];
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read input tree from file [" + intree_file + "]: " + error);
            }
            if (intree == null || intree.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + intree_file + "] is empty");
            }
            if (!intree.isRooted()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + intree_file + "] is not rooted");
            }
            if (intree.getNumberOfExternalNodes() < number_of_genomes) {
                ForesterUtil.fatalError(PRG_NAME, "number of external nodes [" + intree.getNumberOfExternalNodes() + "] of input tree [" + intree_file + "] is smaller than the number of genomes the be analyzed [" + number_of_genomes + "]");
            }
            if ((nodes_lacking_name = SurfacingUtil.getNumberOfNodesLackingName(intree, parent_names = new StringBuilder())) > 0) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + intree_file + "] has " + nodes_lacking_name + " node(s) lacking a name [parent names:" + parent_names + "]");
            }
            surfacing_old.preparePhylogenyForParsimonyAnalyses(intree, input_file_properties);
            if (!intree.isCompletelyBinary()) {
                ForesterUtil.printWarningMessage(PRG_NAME, "input tree [" + intree_file + "] is not completely binary");
            }
            intrees[i++] = intree;
            ++n2;
        }
        return intrees;
    }

    private static List<Phylogeny> inferSpeciesTrees(File outfile, List<DistanceMatrix> distances_list) {
        NeighborJoining nj2 = NeighborJoining.createInstance();
        List<Phylogeny> phylogenies = nj2.execute(distances_list);
        PhylogenyWriter w = new PhylogenyWriter();
        try {
            w.toNewHampshire(phylogenies, true, true, outfile, ";");
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to outfile [" + outfile + "]: " + e.getMessage());
        }
        return phylogenies;
    }

    public static void main(String[] args) {
        int filter_size;
        String msg;
        long start_time = new Date().getTime();
        StringBuilder html_desc = new StringBuilder();
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        String nl = ForesterUtil.LINE_SEPARATOR;
        html_desc.append("<table>" + nl);
        html_desc.append("<tr><td>Produced by:</td><td>surfacing</td></tr>" + nl);
        html_desc.append("<tr><td>Version:</td><td>1.00</td></tr>" + nl);
        html_desc.append("<tr><td>Release Date:</td><td>2009.07.06</td></tr>" + nl);
        html_desc.append("<tr><td>Contact:</td><td>czmasek@burnham.org</td></tr>" + nl);
        html_desc.append("<tr><td>WWW:</td><td>www.phylosoft.org/forester/applications/surfacing</td></tr>" + nl);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            surfacing_old.printHelp();
            System.exit(0);
        }
        if (args.length < 1) {
            surfacing_old.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(NOT_IGNORE_DUFS_OPTION);
        allowed_options.add(MAX_E_VALUE_OPTION);
        allowed_options.add(DETAILEDNESS_OPTION);
        allowed_options.add(OUTPUT_FILE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_SORT_OPTION);
        allowed_options.add(SPECIES_MATRIX_OPTION);
        allowed_options.add(SCORING_OPTION);
        allowed_options.add(MAX_ALLOWED_OVERLAP_OPTION);
        allowed_options.add(NO_ENGULFING_OVERLAP_OPTION);
        allowed_options.add(DOMAIN_COUNT_SORT_OPTION);
        allowed_options.add(CUTOFF_SCORE_FILE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION);
        allowed_options.add(OUTPUT_DIR_OPTION);
        allowed_options.add(IGNORE_COMBINATION_WITH_SAME_OPTION);
        allowed_options.add(PFAM_TO_GO_FILE_USE_OPTION);
        allowed_options.add(GO_OBO_FILE_USE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_PRINT_OPTION);
        allowed_options.add(GO_NAMESPACE_LIMIT_OPTION);
        allowed_options.add(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
        allowed_options.add(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION);
        allowed_options.add(DISPLAY_M_HISTOGRAMS_OPTION);
        allowed_options.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS);
        allowed_options.add(JACKNIFE_OPTION);
        allowed_options.add(JACKNIFE_RANDOM_SEED_OPTION);
        allowed_options.add(JACKNIFE_RATIO_OPTION);
        allowed_options.add(INPUT_SPECIES_TREE_OPTION);
        allowed_options.add(FILTER_POSITIVE_OPTION);
        allowed_options.add(FILTER_NEGATIVE_OPTION);
        allowed_options.add(INPUT_FILES_FROM_FILE_OPTION);
        allowed_options.add(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
        allowed_options.add(FILTER_NEGATIVE_DOMAINS_OPTION);
        allowed_options.add(IGNORE_VIRAL_IDS);
        allowed_options.add(SEQ_EXTRACT_OPTION);
        allowed_options.add(SECONDARY_FEATURES_PARSIMONY_MAP_FILE);
        allowed_options.add(PLUS_MINUS_ANALYSIS_OPTION);
        allowed_options.add(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS);
        allowed_options.add(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS);
        allowed_options.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY);
        boolean ignore_dufs = true;
        boolean ignore_combination_with_same = false;
        double e_value_max = -1.0;
        int max_allowed_overlap = -1;
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        boolean output_binary_domain_combinationsfor_graph_analysis = false;
        if (cla.isOptionSet(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS)) {
            output_binary_domain_combinationsfor_graph_analysis = true;
        }
        if (cla.isOptionSet(MAX_E_VALUE_OPTION)) {
            try {
                e_value_max = cla.getOptionValueAsDouble(MAX_E_VALUE_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (cla.isOptionSet(MAX_ALLOWED_OVERLAP_OPTION)) {
            try {
                max_allowed_overlap = cla.getOptionValueAsInt(MAX_ALLOWED_OVERLAP_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for maximal allowed domain overlap");
            }
        }
        boolean no_engulfing_overlaps = false;
        if (cla.isOptionSet(NO_ENGULFING_OVERLAP_OPTION)) {
            no_engulfing_overlaps = true;
        }
        boolean ignore_virus_like_ids = false;
        if (cla.isOptionSet(IGNORE_VIRAL_IDS)) {
            ignore_virus_like_ids = true;
        }
        if (cla.isOptionSet(NOT_IGNORE_DUFS_OPTION)) {
            ignore_dufs = false;
        }
        if (cla.isOptionSet(IGNORE_COMBINATION_WITH_SAME_OPTION)) {
            ignore_combination_with_same = true;
        }
        boolean ignore_domains_without_combs_in_all_spec = false;
        if (cla.isOptionSet(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION)) {
            ignore_domains_without_combs_in_all_spec = true;
        }
        boolean ignore_species_specific_domains = false;
        if (cla.isOptionSet(IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION)) {
            ignore_species_specific_domains = true;
        }
        File output_file = null;
        if (cla.isOptionSet(OUTPUT_FILE_OPTION)) {
            if (!cla.isOptionValueSet(OUTPUT_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities output file: -o=<file>");
            }
            output_file = new File(cla.getOptionValue(OUTPUT_FILE_OPTION));
            SurfacingUtil.checkForOutputFileWriteability(output_file);
        }
        File cutoff_scores_file = null;
        Map<String, String> individual_domain_score_cutoffs = null;
        if (cla.isOptionSet(CUTOFF_SCORE_FILE_OPTION)) {
            String error;
            if (!cla.isOptionValueSet(CUTOFF_SCORE_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for individual domain score cutoffs file: -cos=<file>");
            }
            if (!ForesterUtil.isEmpty(error = ForesterUtil.isReadableFile(cutoff_scores_file = new File(cla.getOptionValue(CUTOFF_SCORE_FILE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read individual domain score cutoffs file: " + error);
            }
            try {
                BasicTable<String> scores_table = BasicTableParser.parse(cutoff_scores_file, " ");
                individual_domain_score_cutoffs = scores_table.getColumnsAsMap(0, 1);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from individual domain score cutoffs file: " + e);
            }
        }
        BinaryDomainCombination.DomainCombinationType dc_type = BinaryDomainCombination.DomainCombinationType.BASIC;
        if (cla.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS)) {
            dc_type = BinaryDomainCombination.DomainCombinationType.DIRECTED;
        }
        if (cla.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY)) {
            dc_type = BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT;
        }
        File out_dir = null;
        if (cla.isOptionSet(OUTPUT_DIR_OPTION)) {
            boolean success;
            if (!cla.isOptionValueSet(OUTPUT_DIR_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for output directory: -out_dir=<dir>");
            }
            if ((out_dir = new File(cla.getOptionValue(OUTPUT_DIR_OPTION))).exists() && out_dir.listFiles().length > 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + out_dir + "\" aready exists and is not empty");
            }
            if (!(out_dir.exists() || (success = out_dir.mkdir()) && out_dir.exists())) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create \"" + out_dir + "\"");
            }
            if (!out_dir.canWrite()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot write to \"" + out_dir + "\"");
            }
        }
        File positive_filter_file = null;
        File negative_filter_file = null;
        File negative_domains_filter_file = null;
        if (cla.isOptionSet(FILTER_NEGATIVE_OPTION) && cla.isOptionSet(FILTER_POSITIVE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative and positive protein filter");
        }
        if (cla.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION) && (cla.isOptionSet(FILTER_NEGATIVE_OPTION) || cla.isOptionSet(FILTER_POSITIVE_OPTION))) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative or positive protein filter together wirh a negative domains filter");
        }
        if (cla.isOptionSet(FILTER_NEGATIVE_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_NEGATIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative filter: -neg_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(negative_filter_file = new File(cla.getOptionValue(FILTER_NEGATIVE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + negative_filter_file + "\": " + msg);
            }
        } else if (cla.isOptionSet(FILTER_POSITIVE_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_POSITIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for positive filter: -pos_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(positive_filter_file = new File(cla.getOptionValue(FILTER_POSITIVE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + positive_filter_file + "\": " + msg);
            }
        } else if (cla.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative domains filter: -neg_dom_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(negative_domains_filter_file = new File(cla.getOptionValue(FILTER_NEGATIVE_DOMAINS_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + negative_domains_filter_file + "\": " + msg);
            }
        }
        ArrayList<String> plus_minus_analysis_high_copy_base_species = new ArrayList<String>();
        ArrayList<String> plus_minus_analysis_high_copy_target_species = new ArrayList<String>();
        ArrayList<String> plus_minus_analysis_high_low_copy_species = new ArrayList<String>();
        ArrayList<Object> plus_minus_analysis_numbers = new ArrayList<Object>();
        surfacing_old.processPlusMinusAnalysisOption(cla, plus_minus_analysis_high_copy_base_species, plus_minus_analysis_high_copy_target_species, plus_minus_analysis_high_low_copy_species, plus_minus_analysis_numbers);
        File input_files_file = null;
        String[] input_file_names_from_file = null;
        if (cla.isOptionSet(INPUT_FILES_FROM_FILE_OPTION)) {
            String msg2;
            if (!cla.isOptionValueSet(INPUT_FILES_FROM_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input files file: -input=<file>");
            }
            if (!ForesterUtil.isEmpty(msg2 = ForesterUtil.isReadableFile(input_files_file = new File(cla.getOptionValue(INPUT_FILES_FROM_FILE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + input_files_file + "\": " + msg2);
            }
            try {
                input_file_names_from_file = ForesterUtil.file2array(input_files_file);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read from \"" + input_files_file + "\": " + e);
            }
        }
        if (cla.getNumberOfNames() < 1 && (input_file_names_from_file == null || input_file_names_from_file.length < 1)) {
            ForesterUtil.fatalError(PRG_NAME, "No hmmpfam output file indicated is input: use comand line directly or input=<file>");
        }
        DomainSimilarity.DomainSimilarityScoring scoring = SCORING_DEFAULT;
        if (cla.isOptionSet(SCORING_OPTION)) {
            String scoring_str;
            if (!cla.isOptionValueSet(SCORING_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for scoring method for domain combinations similarity calculation: -scoring=<domains|proteins|combinations>\"");
            }
            if ((scoring_str = cla.getOptionValue(SCORING_OPTION)).equals(SCORING_DOMAIN_COUNT_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.DOMAINS;
            } else if (scoring_str.equals(SCORING_COMBINATION_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
            } else if (scoring_str.equals(SCORING_PROTEIN_COUNT_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.PROTEINS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + scoring_str + "\" for scoring method for domain combinations similarity calculation: \"-" + SCORING_OPTION + "=<" + SCORING_DOMAIN_COUNT_BASED + "|" + SCORING_PROTEIN_COUNT_BASED + "|" + SCORING_COMBINATION_BASED + ">\"");
            }
        }
        boolean sort_by_species_count_first = false;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION)) {
            sort_by_species_count_first = true;
        }
        boolean species_matrix = false;
        if (cla.isOptionSet(SPECIES_MATRIX_OPTION)) {
            species_matrix = true;
        }
        boolean output_protein_lists_for_all_domains = false;
        if (cla.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS)) {
            output_protein_lists_for_all_domains = true;
        }
        DomainSimilarityCalculator.Detailedness detailedness = DETAILEDNESS_DEFAULT;
        if (cla.isOptionSet(DETAILEDNESS_OPTION)) {
            String detness;
            if (!cla.isOptionValueSet(DETAILEDNESS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for -detail=<basic|list_ids|punctilious>\"");
            }
            if ((detness = cla.getOptionValue(DETAILEDNESS_OPTION).toLowerCase()).equals(DETAILEDNESS_BASIC)) {
                detailedness = DomainSimilarityCalculator.Detailedness.BASIC;
            } else if (detness.equals(DETAILEDNESS_LIST_IDS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES;
            } else if (detness.equals(DETAILEDNESS_PUNCTILIOUS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + detness + "\" for detailedness: \"-" + DETAILEDNESS_OPTION + "=<" + DETAILEDNESS_BASIC + "|" + DETAILEDNESS_LIST_IDS + "|" + DETAILEDNESS_PUNCTILIOUS + ">\"");
            }
        }
        String automated_pairwise_comparison_suffix = null;
        boolean perform_pwc = false;
        boolean write_pwc_files = false;
        if (cla.isOptionSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
            perform_pwc = true;
            if (!cla.isOptionValueSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
                write_pwc_files = false;
            } else {
                write_pwc_files = true;
                automated_pairwise_comparison_suffix = "_" + cla.getOptionValue(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
            }
        }
        String query_domain_ids = null;
        if (cla.isOptionSet(SEQ_EXTRACT_OPTION)) {
            if (!cla.isOptionValueSet(SEQ_EXTRACT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no domain ids given for sequences with given domains to be extracted : -prot_extract=<ordered domain sequences, domain ids separated by '~', sequences separated by '#'>");
            }
            query_domain_ids = cla.getOptionValue(SEQ_EXTRACT_OPTION);
        }
        DomainSimilarity.DomainSimilaritySortField domain_similarity_sort_field = DOMAIN_SORT_FILD_DEFAULT;
        DomainSimilarity.DomainSimilaritySortField domain_similarity_sort_field_for_automated_pwc = DOMAIN_SORT_FILD_DEFAULT;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
            String sort_str;
            if (!cla.isOptionValueSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities sorting: -sort=<alpha|max|min|mean|diff|abs_count_diff|count_diff|species|sd>\"");
            }
            if ((sort_str = cla.getOptionValue(DOMAIN_SIMILARITY_SORT_OPTION).toLowerCase()).equals("alpha")) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MAX)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MIN)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MIN;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MEAN)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MEAN;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MEAN;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_SPECIES_COUNT)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_SD)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.SD;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_COUNTS_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort_str + "\" for domain combinations similarities sorting: \"-" + DOMAIN_SIMILARITY_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_SIMILARITY_SORT_MAX + "|" + DOMAIN_SIMILARITY_SORT_MIN + "|" + DOMAIN_SIMILARITY_SORT_MEAN + "|" + DOMAIN_SIMILARITY_SORT_DIFF + "|" + DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF + "|" + DOMAIN_SIMILARITY_SORT_COUNTS_DIFF + "|" + "|" + DOMAIN_SIMILARITY_SORT_SPECIES_COUNT + "|" + DOMAIN_SIMILARITY_SORT_SD + ">\"");
            }
        }
        PrintableDomainSimilarity.PRINT_OPTION domain_similarity_print_option = DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
            String sort;
            if (!cla.isOptionValueSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for print option: -detailed_html|simple_html|simple_tab>\"");
            }
            if ((sort = cla.getOptionValue(DOMAIN_SIMILARITY_PRINT_OPTION).toLowerCase()).equals(DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML)) {
                domain_similarity_print_option = PrintableDomainSimilarity.PRINT_OPTION.HTML;
            } else if (sort.equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML)) {
                ForesterUtil.fatalError(PRG_NAME, "simple HTML output not implemented yet :(");
            } else if (sort.equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED)) {
                domain_similarity_print_option = PrintableDomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort + "\" for print option: -" + DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED + ">\"");
            }
        }
        GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order = DOMAINS_SORT_ORDER_DEFAULT;
        if (cla.isOptionSet(DOMAIN_COUNT_SORT_OPTION)) {
            String sort;
            if (!cla.isOptionValueSet(DOMAIN_COUNT_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for sorting of domain counts: -dc_sort=<alpha|dom|prot|comb>\"");
            }
            if ((sort = cla.getOptionValue(DOMAIN_COUNT_SORT_OPTION).toLowerCase()).equals("alpha")) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
            } else if (sort.equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT;
            } else if (sort.equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT;
            } else if (sort.equals(DOMAIN_COUNT_SORT_COMBINATIONS_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort + "\" for sorting of domain counts: \"-" + DOMAIN_COUNT_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT + "|" + DOMAIN_COUNT_SORT_COMBINATIONS_COUNT + ">\"");
            }
        }
        String[][] input_file_properties = null;
        input_file_properties = input_file_names_from_file != null ? surfacing_old.processInputFileNames(input_file_names_from_file) : surfacing_old.processInputFileNames(cla.getNames());
        int number_of_genomes = input_file_properties.length;
        if (number_of_genomes < 2) {
            ForesterUtil.fatalError(PRG_NAME, "cannot analyze less than two files");
        }
        if (number_of_genomes < 3 && perform_pwc) {
            ForesterUtil.fatalError(PRG_NAME, "cannot use : -pwc=<suffix> to turn on pairwise analyses with less than three input files");
        }
        surfacing_old.checkWriteabilityForPairwiseComparisons(domain_similarity_print_option, input_file_properties, automated_pairwise_comparison_suffix, out_dir);
        int i = 0;
        while (i < number_of_genomes) {
            File dcc_outfile = new File(String.valueOf(input_file_properties[i][0]) + DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX);
            if (out_dir != null) {
                dcc_outfile = new File(out_dir + ForesterUtil.FILE_SEPARATOR + dcc_outfile);
            }
            SurfacingUtil.checkForOutputFileWriteability(dcc_outfile);
            ++i;
        }
        File pfam_to_go_file = null;
        Map<DomainId, List<GoId>> domain_id_to_go_ids_map = null;
        int domain_id_to_go_ids_count = 0;
        if (cla.isOptionSet(PFAM_TO_GO_FILE_USE_OPTION)) {
            String error;
            if (!cla.isOptionValueSet(PFAM_TO_GO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for Pfam to GO mapping file: -p2g=<file>");
            }
            if (!ForesterUtil.isEmpty(error = ForesterUtil.isReadableFile(pfam_to_go_file = new File(cla.getOptionValue(PFAM_TO_GO_FILE_USE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read Pfam to GO mapping file: " + error);
            }
            try {
                PfamToGoParser parser = new PfamToGoParser(pfam_to_go_file);
                List<PfamToGoMapping> pfam_to_go_mappings = parser.parse();
                domain_id_to_go_ids_map = SurfacingUtil.createDomainIdToGoIdMap(pfam_to_go_mappings);
                if (parser.getMappingCount() < domain_id_to_go_ids_map.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getMappingCount() < domain_id_to_go_ids_map.size()");
                }
                domain_id_to_go_ids_count = parser.getMappingCount();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from Pfam to GO mapping file: " + e);
            }
        }
        File go_obo_file = null;
        List<GoTerm> go_terms = null;
        if (cla.isOptionSet(GO_OBO_FILE_USE_OPTION)) {
            String error;
            if (!cla.isOptionValueSet(GO_OBO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -obo=<file>");
            }
            if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.size() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO OBO file (-obo=<file>) without Pfam to GO mapping file (p2g=<file>)");
            }
            if (!ForesterUtil.isEmpty(error = ForesterUtil.isReadableFile(go_obo_file = new File(cla.getOptionValue(GO_OBO_FILE_USE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read GO OBO file: " + error);
            }
            try {
                OBOparser parser = new OBOparser(go_obo_file, OBOparser.ReturnType.BASIC_GO_TERM);
                go_terms = parser.parse();
                if (parser.getGoTermCount() != go_terms.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getGoTermCount() != go_terms.size()");
                }
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from GO OBO file: " + e.getLocalizedMessage());
            }
        }
        Map<GoId, GoTerm> go_id_to_term_map = null;
        if (domain_id_to_go_ids_map != null && domain_id_to_go_ids_map.size() > 0 && go_terms != null && go_terms.size() > 0) {
            go_id_to_term_map = GoUtils.createGoIdToGoTermMap(go_terms);
        }
        GoNameSpace go_namespace_limit = null;
        if (cla.isOptionSet(GO_NAMESPACE_LIMIT_OPTION)) {
            String go_namespace_limit_str;
            if (go_id_to_term_map == null || go_id_to_term_map.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO namespace limit (-go_namespace=<namespace>) without Pfam to GO mapping file (p2g=<file>) and GO OBO file (-obo=<file>)");
            }
            if (!cla.isOptionValueSet(GO_NAMESPACE_LIMIT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO namespace limit: \"-go_namespace=<molecular_function|biological_process|cellular_component>\"");
            }
            if ((go_namespace_limit_str = cla.getOptionValue(GO_NAMESPACE_LIMIT_OPTION).toLowerCase()).equals(GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION)) {
                go_namespace_limit = GoNameSpace.createMolecularFunction();
            } else if (go_namespace_limit_str.equals(GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS)) {
                go_namespace_limit = GoNameSpace.createBiologicalProcess();
            } else if (go_namespace_limit_str.equals(GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT)) {
                go_namespace_limit = GoNameSpace.createCellularComponent();
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + go_namespace_limit_str + "\" for GO namespace limit: \"-" + GO_NAMESPACE_LIMIT_OPTION + "=<" + GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION + "|" + GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS + "|" + GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT + ">\"");
            }
        }
        if (domain_similarity_sort_field == DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE && number_of_genomes > 2) {
            domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
        }
        boolean jacknifed_distances = false;
        int jacknife_resamplings = 100;
        double jacknife_ratio = 0.5;
        long random_seed = 19L;
        if (cla.isOptionSet(JACKNIFE_OPTION)) {
            if (number_of_genomes < 3 || !perform_pwc) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use jacknife resampling analysis (-jack[=<number of resamplings>]) without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            jacknifed_distances = true;
            if (cla.isOptionHasAValue(JACKNIFE_OPTION)) {
                try {
                    jacknife_resamplings = cla.getOptionValueAsInt(JACKNIFE_OPTION);
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for number of resamplings");
                }
                if (jacknife_resamplings < 2) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use less than 2 resamplings");
                }
            }
            if (cla.isOptionSet(JACKNIFE_RATIO_OPTION) && cla.isOptionHasAValue(JACKNIFE_RATIO_OPTION)) {
                try {
                    jacknife_ratio = cla.getOptionValueAsDouble(JACKNIFE_RATIO_OPTION);
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for jacknife ratio");
                }
                if (jacknife_ratio <= 0.0 || jacknife_ratio >= 1.0) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use illegal value for jacknife ratio: " + jacknife_ratio);
                }
            }
            if (cla.isOptionSet(JACKNIFE_RANDOM_SEED_OPTION) && cla.isOptionHasAValue(JACKNIFE_RANDOM_SEED_OPTION)) {
                try {
                    random_seed = cla.getOptionValueAsLong(JACKNIFE_RANDOM_SEED_OPTION);
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for random generator seed");
                }
            }
        }
        File[] intree_files = null;
        Phylogeny[] intrees = null;
        if (cla.isOptionSet(INPUT_SPECIES_TREE_OPTION)) {
            String intrees_str;
            if (number_of_genomes < 3) {
                ForesterUtil.fatalError(PRG_NAME, "cannot infer gains and losses on input species trees (-species_tree without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            if (!cla.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input tree: -species_tree=<tree file in phyloXML format>");
            }
            if ((intrees_str = cla.getOptionValue(INPUT_SPECIES_TREE_OPTION)).indexOf("#") > 0) {
                String[] intrees_strs = intrees_str.split("#");
                intree_files = new File[intrees_strs.length];
                int i2 = 0;
                String[] stringArray = intrees_strs;
                int n = intrees_strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    intree_files[i2++] = new File(s.trim());
                    ++n2;
                }
            } else {
                intree_files = new File[]{new File(intrees_str)};
            }
            intrees = surfacing_old.getIntrees(intree_files, number_of_genomes, input_file_properties);
        }
        long random_number_seed_for_fitch_parsimony = 0L;
        boolean radomize_fitch_parsimony = false;
        if (cla.isOptionSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
            if (!cla.isOptionValueSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for random number seed: -random_seed=<seed>");
            }
            try {
                random_number_seed_for_fitch_parsimony = cla.getOptionValueAsLong(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            radomize_fitch_parsimony = true;
        }
        TreeSet<DomainId> filter = null;
        if (positive_filter_file != null || negative_filter_file != null || negative_domains_filter_file != null) {
            filter = new TreeSet<DomainId>();
            if (positive_filter_file != null) {
                surfacing_old.processFilter(positive_filter_file, filter);
            } else if (negative_filter_file != null) {
                surfacing_old.processFilter(negative_filter_file, filter);
            } else if (negative_domains_filter_file != null) {
                surfacing_old.processFilter(negative_domains_filter_file, filter);
            }
        }
        Map[] domain_id_to_secondary_features_maps = null;
        File[] secondary_features_map_files = null;
        File domain_lengths_analysis_outfile = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + DOMAIN_LENGTHS_ANALYSIS_SUFFIX);
        SurfacingUtil.checkForOutputFileWriteability(domain_lengths_analysis_outfile);
        if (cla.isOptionSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
            if (!cla.isOptionValueSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for secondary features map file: -secondary=<file>");
            }
            String[] secondary_features_map_files_strs = cla.getOptionValue(SECONDARY_FEATURES_PARSIMONY_MAP_FILE).split("#");
            secondary_features_map_files = new File[secondary_features_map_files_strs.length];
            domain_id_to_secondary_features_maps = new Map[secondary_features_map_files_strs.length];
            int i3 = 0;
            String[] stringArray = secondary_features_map_files_strs;
            int n = secondary_features_map_files_strs.length;
            int n3 = 0;
            while (n3 < n) {
                String secondary_features_map_files_str = stringArray[n3];
                secondary_features_map_files[i3] = new File(secondary_features_map_files_str);
                String error = ForesterUtil.isReadableFile(secondary_features_map_files[i3]);
                if (!ForesterUtil.isEmpty(error)) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + error);
                }
                try {
                    domain_id_to_secondary_features_maps[i3] = SurfacingUtil.createDomainIdToSecondaryFeaturesMap(secondary_features_map_files[i3]);
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + e.getMessage());
                }
                catch (Exception e) {
                    ForesterUtil.fatalError(PRG_NAME, "problem with contents of features map file [" + secondary_features_map_files[i3] + "]: " + e.getMessage());
                }
                ++i3;
                ++n3;
            }
        }
        if (out_dir == null) {
            ForesterUtil.fatalError(PRG_NAME, "no output directory indicated (-out_dir=<dir>)");
        }
        if (output_file == null) {
            ForesterUtil.fatalError(PRG_NAME, "no name for (main) output file indicated (-o=<file>)");
        }
        if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) Pfam to GO id mapping file provided ('pfam2go file') (-p2g=<file>)");
        }
        if (go_id_to_term_map == null || go_id_to_term_map.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) go id to term mapping file provided ('GO OBO file') (-obo=<file>)");
        }
        boolean display_histograms = false;
        if (cla.isOptionSet(DISPLAY_M_HISTOGRAMS_OPTION)) {
            display_histograms = true;
        }
        System.out.println("Output directory            : " + out_dir);
        if (input_file_names_from_file != null) {
            System.out.println("Input files names from      : " + input_files_file + " [" + input_file_names_from_file.length + " input files]");
            html_desc.append("<tr><td>Input files names from:</td><td>" + input_files_file + " [" + input_file_names_from_file.length + " input files]</td></tr>" + nl);
        }
        if (positive_filter_file != null) {
            filter_size = filter.size();
            System.out.println("Positive protein filter     : " + positive_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Positive protein filter:</td><td>" + positive_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (negative_filter_file != null) {
            filter_size = filter.size();
            System.out.println("Negative protein filter     : " + negative_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Negative protein filter:</td><td>" + negative_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (negative_domains_filter_file != null) {
            filter_size = filter.size();
            System.out.println("Negative domain filter      : " + negative_domains_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Negative domain filter:</td><td>" + negative_domains_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (plus_minus_analysis_high_copy_base_species.size() > 0) {
            String plus0 = "";
            for (String s : plus_minus_analysis_high_copy_base_species) {
                plus0 = String.valueOf(plus0) + "+" + s + " ";
            }
            String plus1 = "";
            for (String s : plus_minus_analysis_high_copy_target_species) {
                plus1 = String.valueOf(plus1) + "*" + s + " ";
            }
            String minus = "";
            for (String s : plus_minus_analysis_high_low_copy_species) {
                minus = String.valueOf(minus) + "-" + s + " ";
            }
            System.out.println("Plus-minus analysis         : " + plus1 + "&& " + plus0 + "&& " + minus);
            html_desc.append("<tr><td>Plus-minus analysis:</td><td>" + plus1 + "&& " + plus0 + "&& " + minus + "</td></tr>" + nl);
        }
        if (cutoff_scores_file != null) {
            System.out.println("Cutoff scores file          : " + cutoff_scores_file);
            html_desc.append("<tr><td>Cutoff scores file:</td><td>" + cutoff_scores_file + "</td></tr>" + nl);
        }
        if (e_value_max >= 0.0) {
            System.out.println("E-value maximum (inclusive) : " + e_value_max);
            html_desc.append("<tr><td>E-value maximum (inclusive):</td><td>" + e_value_max + "</td></tr>" + nl);
        }
        System.out.println("Ignore DUFs                 : " + ignore_dufs);
        if (ignore_virus_like_ids) {
            System.out.println("Ignore virus like ids       : " + ignore_virus_like_ids);
            html_desc.append("<tr><td>Ignore virus, phage, transposition related ids:</td><td>" + ignore_virus_like_ids + "</td></tr>" + nl);
        }
        html_desc.append("<tr><td>Ignore DUFs:</td><td>" + ignore_dufs + "</td></tr>" + nl);
        if (max_allowed_overlap != -1) {
            System.out.println("Max allowed domain overlap  : " + max_allowed_overlap);
            html_desc.append("<tr><td>Max allowed domain overlap:</td><td>" + max_allowed_overlap + "</td></tr>" + nl);
        }
        if (no_engulfing_overlaps) {
            System.out.println("Ignore engulfed domains     : " + no_engulfing_overlaps);
            html_desc.append("<tr><td>Ignore (lower confidence) engulfed domains:</td><td>" + no_engulfing_overlaps + "</td></tr>" + nl);
        }
        System.out.println("Ignore singlet domains      : " + ignore_domains_without_combs_in_all_spec);
        html_desc.append("<tr><td>Ignore singlet domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + ignore_domains_without_combs_in_all_spec + "</td></tr>" + nl);
        System.out.println("Ignore species specific doms: " + ignore_species_specific_domains);
        html_desc.append("<tr><td>Ignore species specific domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + ignore_species_specific_domains + "</td></tr>" + nl);
        System.out.println("Ignore combination with self: " + ignore_combination_with_same);
        html_desc.append("<tr><td>Ignore combination with self for domain combination similarity analyses:</td><td>" + ignore_combination_with_same + "</td></tr>" + nl);
        System.out.println("Consider directedness       : " + (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC));
        html_desc.append("<tr><td>Consider directedness of binary domain combinations:</td><td>" + (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC) + "</td></tr>" + nl);
        if (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC) {
            System.out.println("Consider adjacency          : " + (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT));
            html_desc.append("<tr><td>Consider djacency of binary domain combinations:</td><td>" + (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) + "</td></tr>" + nl);
        }
        System.out.print("Domain counts sort order    : ");
        switch (dc_sort_order) {
            case ALPHABETICAL_KEY_ID: {
                System.out.println("alphabetical");
                break;
            }
            case KEY_DOMAIN_COUNT: {
                System.out.println("domain count");
                break;
            }
            case KEY_DOMAIN_PROTEINS_COUNT: {
                System.out.println("domain proteins count");
                break;
            }
            case COMBINATIONS_COUNT: {
                System.out.println("domain combinations count");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for dc sort order");
            }
        }
        if (domain_id_to_go_ids_map != null) {
            System.out.println("Pfam to GO mappings from    : " + pfam_to_go_file + " [" + domain_id_to_go_ids_count + " mappings]");
            html_desc.append("<tr><td>Pfam to GO mappings from:</td><td>" + pfam_to_go_file + " [" + domain_id_to_go_ids_count + " mappings]" + "</td></tr>" + nl);
        }
        if (go_terms != null) {
            System.out.println("GO terms from               : " + go_obo_file + " [" + go_terms.size() + " terms]");
            html_desc.append("<tr><td>GO terms from:</td><td>" + go_obo_file + " [" + go_terms.size() + " terms]" + "</td></tr>" + nl);
        }
        if (go_namespace_limit != null) {
            System.out.println("Limit GO terms to           : " + go_namespace_limit.toString());
            html_desc.append("<tr><td>Limit GO terms to</td><td>" + go_namespace_limit + "</td></tr>" + nl);
        }
        if (perform_pwc) {
            System.out.println("Suffix for PWC files        : " + automated_pairwise_comparison_suffix);
            html_desc.append("<tr><td>Suffix for PWC files</td><td>" + automated_pairwise_comparison_suffix + "</td></tr>" + nl);
        }
        if (out_dir != null) {
            System.out.println("Output directory            : " + out_dir);
        }
        if (query_domain_ids != null) {
            System.out.println("Query domains (ordered)     : " + query_domain_ids);
            html_desc.append("<tr><td></td><td>" + query_domain_ids + "</td></tr>" + nl);
        }
        System.out.println("Write similarities to       : " + output_file);
        System.out.print("  Scoring method            : ");
        html_desc.append("<tr><td>Scoring method:</td><td>");
        switch (scoring) {
            case COMBINATIONS: {
                System.out.println("domain combinations based");
                html_desc.append("domain combinations based</td></tr>" + nl);
                break;
            }
            case DOMAINS: {
                System.out.println("domain counts based");
                html_desc.append("domain counts based</td></tr>" + nl);
                break;
            }
            case PROTEINS: {
                System.out.println("domain proteins counts based");
                html_desc.append("domain proteins counts based</td></tr>" + nl);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        System.out.print("  Sort by                   : ");
        html_desc.append("<tr><td>Sort by:</td><td>");
        switch (domain_similarity_sort_field) {
            case MIN: {
                System.out.print("score minimum");
                html_desc.append("score minimum");
                break;
            }
            case MAX: {
                System.out.print("score maximum");
                html_desc.append("score maximum");
                break;
            }
            case MEAN: {
                System.out.print("score mean");
                html_desc.append("score mean");
                break;
            }
            case SD: {
                System.out.print("score standard deviation");
                html_desc.append("score standard deviation");
                break;
            }
            case SPECIES_COUNT: {
                System.out.print("species number");
                html_desc.append("species number");
                break;
            }
            case DOMAIN_ID: {
                System.out.print("alphabetical domain identifier");
                html_desc.append("alphabetical domain identifier");
                break;
            }
            case MAX_DIFFERENCE: {
                System.out.print("(maximal) difference");
                html_desc.append("(maximal) difference");
                break;
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                System.out.print("absolute (maximal) counts difference");
                html_desc.append("absolute (maximal) counts difference");
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                System.out.print("(maximal) counts difference");
                html_desc.append("(maximal) counts  difference");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
            }
        }
        if (sort_by_species_count_first) {
            System.out.println(" (sort by species count first)");
            html_desc.append(" (sort by species count first)");
        } else {
            System.out.println();
        }
        html_desc.append("</td></tr>" + nl);
        System.out.print("  Detailedness              : ");
        switch (detailedness) {
            case BASIC: {
                System.out.println(DETAILEDNESS_BASIC);
                break;
            }
            case LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES: {
                System.out.println("list combining domains for each species");
                break;
            }
            case PUNCTILIOUS: {
                System.out.println(DETAILEDNESS_PUNCTILIOUS);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for detailedness");
            }
        }
        System.out.print("  Print option              : ");
        switch (domain_similarity_print_option) {
            case HTML: {
                System.out.println("HTML");
                break;
            }
            case SIMPLE_TAB_DELIMITED: {
                System.out.println("simple tab delimited");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for print option");
            }
        }
        System.out.print("  Species matrix            : " + species_matrix);
        System.out.println();
        if (perform_pwc) {
            System.out.println("Pairwise comparisons: ");
            html_desc.append("<tr><td>Pairwise comparisons:</td><td></td></tr>");
            System.out.print("  Sort by                   : ");
            html_desc.append("<tr><td>Sort by:</td><td>");
            switch (domain_similarity_sort_field_for_automated_pwc) {
                case MEAN: {
                    System.out.print("score mean");
                    html_desc.append("score mean");
                    break;
                }
                case DOMAIN_ID: {
                    System.out.print("alphabetical domain identifier");
                    html_desc.append("alphabetical domain identifier");
                    break;
                }
                case MAX_DIFFERENCE: {
                    System.out.print("difference");
                    html_desc.append("difference");
                    break;
                }
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    System.out.print("absolute counts difference");
                    html_desc.append("absolute counts difference");
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    System.out.print("counts difference");
                    html_desc.append("counts difference");
                    break;
                }
                default: {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
                }
            }
            System.out.println();
            html_desc.append("</td></tr>" + nl);
            if (jacknifed_distances) {
                html_desc.append("<tr><td>Jacknife:</td><td>" + jacknife_resamplings + " resamplings</td></tr>" + nl);
                html_desc.append("<tr><td>Jacknife ratio:</td><td>" + ForesterUtil.round(jacknife_ratio, 2) + "</td></tr>" + nl);
                html_desc.append("<tr><td>Jacknife random number seed:</td><td>" + random_seed + "</td></tr>" + nl);
                System.out.println("  Jacknife                  : " + jacknife_resamplings + " resamplings");
                System.out.println("    Ratio                   : " + ForesterUtil.round(jacknife_ratio, 2));
                System.out.println("    Random number seed      : " + random_seed);
            }
            if (intrees != null && intrees.length > 0) {
                File[] s = intree_files;
                int minus = intree_files.length;
                int plus1 = 0;
                while (plus1 < minus) {
                    File intree_file = s[plus1];
                    html_desc.append("<tr><td>Intree for gain/loss parsimony analysis:</td><td>" + intree_file + "</td></tr>" + nl);
                    System.out.println("  Intree for gain/loss pars.: " + intree_file);
                    ++plus1;
                }
            }
            if (radomize_fitch_parsimony) {
                html_desc.append("<tr><td>    Random number seed for Fitch parsimony analysis:</td><td>" + random_number_seed_for_fitch_parsimony + "</td></tr>" + nl);
                System.out.println("    Random number seed      : " + random_number_seed_for_fitch_parsimony);
            }
            if (domain_id_to_secondary_features_maps != null && domain_id_to_secondary_features_maps.length > 0) {
                int i4 = 0;
                while (i4 < secondary_features_map_files.length) {
                    html_desc.append("<tr><td>Secondary features map file:</td><td>" + secondary_features_map_files[i4] + "</td></tr>" + nl);
                    System.out.println("Secondary features map file : " + secondary_features_map_files[i4] + " [mappings for " + domain_id_to_secondary_features_maps[i4].size() + " domain ids]");
                    ++i4;
                }
            }
        }
        System.out.println();
        html_desc.append("<tr><td>Command line:</td><td>" + cla.getCommandLineArgsAsString() + "</td></tr>" + nl);
        System.out.println("Command line                : " + cla.getCommandLineArgsAsString());
        BufferedWriter[] query_domains_writer_ary = null;
        List[] query_domain_ids_array = null;
        if (query_domain_ids != null) {
            String[] query_domain_ids_str_array = query_domain_ids.split("#");
            query_domain_ids_array = new ArrayList[query_domain_ids_str_array.length];
            query_domains_writer_ary = new BufferedWriter[query_domain_ids_str_array.length];
            int i5 = 0;
            while (i5 < query_domain_ids_str_array.length) {
                String query_domain_ids_str = query_domain_ids_str_array[i5];
                String[] query_domain_ids_str_ary = query_domain_ids_str.split("~");
                ArrayList<DomainId> query = new ArrayList<DomainId>();
                String[] stringArray = query_domain_ids_str_ary;
                int n = query_domain_ids_str_ary.length;
                int n4 = 0;
                while (n4 < n) {
                    String element = stringArray[n4];
                    query.add(new DomainId(element));
                    ++n4;
                }
                query_domain_ids_array[i5] = query;
                query_domain_ids_str = query_domain_ids_str.replace('~', '_');
                String protein_names_writer_str = String.valueOf(query_domain_ids_str) + SEQ_EXTRACT_SUFFIX;
                if (out_dir != null) {
                    protein_names_writer_str = out_dir + ForesterUtil.FILE_SEPARATOR + protein_names_writer_str;
                }
                try {
                    query_domains_writer_ary[i5] = new BufferedWriter(new FileWriter(protein_names_writer_str));
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "Could not open [" + protein_names_writer_str + "]: " + e.getLocalizedMessage());
                }
                ++i5;
            }
        }
        TreeMap<Species, List<Protein>> protein_lists_per_species = null;
        boolean need_protein_lists_per_species = false;
        if (plus_minus_analysis_high_copy_base_species.size() > 0 || output_protein_lists_for_all_domains) {
            need_protein_lists_per_species = true;
        }
        if (need_protein_lists_per_species) {
            protein_lists_per_species = new TreeMap<Species, List<Protein>>();
        }
        ArrayList<GenomeWideCombinableDomains> gwcd_list = new ArrayList<GenomeWideCombinableDomains>(number_of_genomes);
        TreeSet<DomainId> all_domains_encountered = new TreeSet<DomainId>();
        TreeSet<BinaryDomainCombination> all_bin_domain_combinations_encountered = new TreeSet<BinaryDomainCombination>();
        ArrayList<BinaryDomainCombination> all_bin_domain_combinations_gained_fitch = null;
        ArrayList<BinaryDomainCombination> all_bin_domain_combinations_lost_fitch = null;
        if (intrees != null && intrees.length == 1) {
            all_bin_domain_combinations_gained_fitch = new ArrayList<BinaryDomainCombination>();
            all_bin_domain_combinations_lost_fitch = new ArrayList<BinaryDomainCombination>();
        }
        DomainLengthsTable domain_lengths_table = new DomainLengthsTable();
        File per_genome_domain_promiscuity_statistics_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + D_PROMISCUITY_FILE_SUFFIX);
        BufferedWriter per_genome_domain_promiscuity_statistics_writer = null;
        try {
            per_genome_domain_promiscuity_statistics_writer = new BufferedWriter(new FileWriter(per_genome_domain_promiscuity_statistics_file));
            per_genome_domain_promiscuity_statistics_writer.write("Species:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Mean:\t");
            per_genome_domain_promiscuity_statistics_writer.write("SD:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Median:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Min:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Max:\t");
            per_genome_domain_promiscuity_statistics_writer.write("N:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Max Promiscuous Domains:" + ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getMessage());
        }
        int i6 = 0;
        while (i6 < number_of_genomes) {
            System.out.println();
            System.out.println(String.valueOf(i6 + 1) + "/" + number_of_genomes);
            System.out.println("Processing                                     : " + input_file_properties[i6][0]);
            HmmPfamOutputParser parser = null;
            if (positive_filter_file != null || negative_filter_file != null || negative_domains_filter_file != null) {
                HmmPfamOutputParser.FilterType filter_type = HmmPfamOutputParser.FilterType.NONE;
                if (positive_filter_file != null) {
                    filter_type = HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN;
                } else if (negative_filter_file != null) {
                    filter_type = HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN;
                } else if (negative_domains_filter_file != null) {
                    filter_type = HmmPfamOutputParser.FilterType.NEGATIVE_DOMAIN;
                }
                parser = new HmmPfamOutputParser(new File(input_file_properties[i6][0]), input_file_properties[i6][1], input_file_properties[i6][2], filter, filter_type);
            } else {
                parser = new HmmPfamOutputParser(new File(input_file_properties[i6][0]), input_file_properties[i6][1], input_file_properties[i6][2]);
            }
            if (e_value_max >= 0.0) {
                parser.setEValueMaximum(e_value_max);
            }
            parser.setIgnoreDufs(ignore_dufs);
            parser.setIgnoreVirusLikeIds(ignore_virus_like_ids);
            parser.setIgnoreEngulfedDomains(no_engulfing_overlaps);
            if (max_allowed_overlap != -1) {
                parser.setMaxAllowedOverlap(max_allowed_overlap);
            }
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            if (individual_domain_score_cutoffs != null) {
                parser.setIndividualDomainScoreCutoffs(individual_domain_score_cutoffs);
            }
            parser.setAllowNonUniqueQuery(true);
            parser.setVerbose(true);
            List<Protein> protein_list = null;
            try {
                protein_list = parser.parse();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            catch (Exception e) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, e.getMessage(), e);
            }
            System.out.println("Number of proteins encountered                 : " + parser.getProteinsEncountered());
            System.out.println("Number of proteins stored                      : " + protein_list.size());
            System.out.println("Domains encountered                            : " + parser.getDomainsEncountered());
            System.out.println("Domains stored                                 : " + parser.getDomainsStored());
            System.out.println("Distinct domains stored                        : " + parser.getDomainsStoredSet().size());
            System.out.println("Domains ignored due to individual score cutoffs: " + parser.getDomainsIgnoredDueToIndividualScoreCutoff());
            System.out.println("Domains ignored due to E-value                 : " + parser.getDomainsIgnoredDueToEval());
            System.out.println("Domains ignored due to DUF designation         : " + parser.getDomainsIgnoredDueToDuf());
            if (ignore_virus_like_ids) {
                System.out.println("Domains ignored due virus like ids             : " + parser.getDomainsIgnoredDueToVirusLikeIds());
            }
            System.out.println("Domains ignored due negative domain filter     : " + parser.getDomainsIgnoredDueToNegativeDomainFilter());
            System.out.println("Domains ignored due to overlap                 : " + parser.getDomainsIgnoredDueToOverlap());
            if (negative_filter_file != null) {
                System.out.println("Proteins ignored due to negative filter        : " + parser.getProteinsIgnoredDueToFilter());
            }
            if (positive_filter_file != null) {
                System.out.println("Proteins ignored due to positive filter        : " + parser.getProteinsIgnoredDueToFilter());
            }
            System.out.println("Time for processing                            : " + parser.getTime() + "ms");
            html_desc.append("<tr><td>" + input_file_properties[i6][0] + " [species: " + input_file_properties[i6][1] + "]" + ":</td><td>domains analyzed: " + parser.getDomainsStored() + "; domains ignored: [ind score cutoffs: " + parser.getDomainsIgnoredDueToIndividualScoreCutoff() + "] [E-value cutoff: " + parser.getDomainsIgnoredDueToEval() + "] [DUF: " + parser.getDomainsIgnoredDueToDuf() + "] [virus like ids: " + parser.getDomainsIgnoredDueToVirusLikeIds() + "] [negative domain filter: " + parser.getDomainsIgnoredDueToNegativeDomainFilter() + "] [overlap: " + parser.getDomainsIgnoredDueToOverlap() + "]");
            if (negative_filter_file != null) {
                html_desc.append("; proteins ignored due to negative filter: " + parser.getProteinsIgnoredDueToFilter());
            }
            if (positive_filter_file != null) {
                html_desc.append("; proteins ignored due to positive filter: " + parser.getProteinsIgnoredDueToFilter());
            }
            html_desc.append("</td></tr>" + nl);
            gwcd_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same, new BasicSpecies(input_file_properties[i6][1]), domain_id_to_go_ids_map, dc_type));
            domain_lengths_table.addLengths(protein_list);
            if (((GenomeWideCombinableDomains)gwcd_list.get(i6)).getSize() > 0) {
                SurfacingUtil.writeDomainCombinationsCountsFile(input_file_properties, out_dir, per_genome_domain_promiscuity_statistics_writer, (GenomeWideCombinableDomains)gwcd_list.get(i6), i6, dc_sort_order);
                if (output_binary_domain_combinationsfor_graph_analysis) {
                    SurfacingUtil.writeBinaryDomainCombinationsFileForGraphAnalysis(input_file_properties, out_dir, (GenomeWideCombinableDomains)gwcd_list.get(i6), i6, dc_sort_order);
                }
                SurfacingUtil.addAllDomainIdsToSet((GenomeWideCombinableDomains)gwcd_list.get(i6), all_domains_encountered);
                SurfacingUtil.addAllBinaryDomainCombinationToSet((GenomeWideCombinableDomains)gwcd_list.get(i6), all_bin_domain_combinations_encountered);
            }
            if (query_domains_writer_ary != null) {
                int j = 0;
                while (j < query_domain_ids_array.length) {
                    try {
                        SurfacingUtil.extractProteinNames(protein_list, query_domain_ids_array[j], (Writer)query_domains_writer_ary[j], "\t");
                        query_domains_writer_ary[j].flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
            }
            if (need_protein_lists_per_species) {
                protein_lists_per_species.put(new BasicSpecies(input_file_properties[i6][1]), protein_list);
            }
            System.gc();
            ++i6;
        }
        try {
            per_genome_domain_promiscuity_statistics_writer.flush();
            per_genome_domain_promiscuity_statistics_writer.close();
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.toString());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain promiscuities to: " + per_genome_domain_promiscuity_statistics_file);
        if (query_domains_writer_ary != null) {
            int j = 0;
            while (j < query_domain_ids_array.length) {
                try {
                    query_domains_writer_ary[j].close();
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, e.toString());
                }
                ++j;
            }
        }
        try {
            SurfacingUtil.executeDomainLengthAnalysis(input_file_properties, number_of_genomes, domain_lengths_table, domain_lengths_analysis_outfile);
        }
        catch (IOException e1) {
            ForesterUtil.fatalError(PRG_NAME, e1.toString());
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain length data to: " + domain_lengths_analysis_outfile);
        System.out.println();
        long analysis_start_time = new Date().getTime();
        PairwiseDomainSimilarityCalculator pw_calc = null;
        BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(domain_similarity_sort_field, sort_by_species_count_first, number_of_genomes == 2);
        switch (scoring) {
            case COMBINATIONS: {
                pw_calc = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            case DOMAINS: {
                pw_calc = new DomainCountsBasedPairwiseSimilarityCalculator();
                break;
            }
            case PROTEINS: {
                pw_calc = new ProteinCountsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        DomainSimilarityCalculator.GoAnnotationOutput go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
        if (domain_id_to_go_ids_map != null) {
            go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
        }
        SortedSet<DomainSimilarity> similarities = calc.calculateSimilarities(pw_calc, gwcd_list, ignore_domains_without_combs_in_all_spec, ignore_species_specific_domains);
        SurfacingUtil.decoratePrintableDomainSimilarities(similarities, detailedness, go_annotation_output, go_id_to_term_map, go_namespace_limit);
        DescriptiveStatistics pw_stats = null;
        try {
            String my_outfile = output_file.toString();
            if (!my_outfile.endsWith(".html")) {
                my_outfile = String.valueOf(my_outfile) + ".html";
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(out_dir == null ? my_outfile : out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile));
            ArrayList<Species> species_order = null;
            if (species_matrix) {
                species_order = new ArrayList<Species>();
                int i7 = 0;
                while (i7 < number_of_genomes) {
                    species_order.add(new BasicSpecies(input_file_properties[i7][1]));
                    ++i7;
                }
            }
            html_desc.append("<tr><td>Sum of all distinct binary combinations:</td><td>" + all_bin_domain_combinations_encountered.size() + "</td></tr>" + nl);
            html_desc.append("<tr><td>Sum of all distinct domains:</td><td>" + all_domains_encountered.size() + "</td></tr>" + nl);
            html_desc.append("<tr><td>Analysis date/time:</td><td>" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()) + "</td></tr>" + nl);
            html_desc.append("</table>" + nl);
            pw_stats = SurfacingUtil.writeDomainSimilaritiesToFile(html_desc, new StringBuilder(String.valueOf(number_of_genomes) + " genomes"), writer, similarities, number_of_genomes == 2, species_order, domain_similarity_print_option, domain_similarity_sort_field, scoring, true);
            ForesterUtil.programMessage(PRG_NAME, "Wrote main output (includes domain similarities) to: \"" + (out_dir == null ? my_outfile : out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile) + "\"");
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write similarites to: \"" + output_file + "\" [" + e.getMessage() + "]");
        }
        System.out.println();
        Species[] species = new Species[number_of_genomes];
        int i8 = 0;
        while (i8 < number_of_genomes) {
            species[i8] = new BasicSpecies(input_file_properties[i8][1]);
            ++i8;
        }
        ArrayList<Phylogeny> inferred_trees = null;
        if (number_of_genomes > 2 && perform_pwc) {
            PairwiseGenomeComparator pwgc = new PairwiseGenomeComparator();
            pwgc.performPairwiseComparisons(html_desc, sort_by_species_count_first, detailedness, ignore_domains_without_combs_in_all_spec, ignore_species_specific_domains, domain_similarity_sort_field_for_automated_pwc, domain_similarity_print_option, scoring, domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, species, number_of_genomes, gwcd_list, pw_calc, automated_pairwise_comparison_suffix, true, PAIRWISE_DOMAIN_COMPARISONS_PREFIX, PRG_NAME, display_histograms, out_dir, write_pwc_files);
            String matrix_output_file = new String(output_file.toString());
            if (matrix_output_file.indexOf(46) > 1) {
                matrix_output_file = matrix_output_file.substring(0, matrix_output_file.indexOf(46));
            }
            if (out_dir != null) {
                matrix_output_file = out_dir + ForesterUtil.FILE_SEPARATOR + matrix_output_file;
                output_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file);
            }
            SurfacingUtil.writeMatrixToFile(new File(String.valueOf(matrix_output_file) + MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getDomainDistanceScoresMeans());
            SurfacingUtil.writeMatrixToFile(new File(String.valueOf(matrix_output_file) + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedBinaryCombinationsBasedDistances());
            SurfacingUtil.writeMatrixToFile(new File(String.valueOf(matrix_output_file) + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedDomainsBasedDistances());
            Phylogeny nj_gd = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(String.valueOf(matrix_output_file) + NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getDomainDistanceScoresMeans().get(0));
            Phylogeny nj_bc = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(String.valueOf(matrix_output_file) + NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedBinaryCombinationsBasedDistances().get(0));
            Phylogeny nj_d = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(String.valueOf(matrix_output_file) + NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedDomainsBasedDistances().get(0));
            inferred_trees = new ArrayList<Phylogeny>();
            inferred_trees.add(nj_gd);
            inferred_trees.add(nj_bc);
            inferred_trees.add(nj_d);
            if (jacknifed_distances) {
                pwgc.performPairwiseComparisonsJacknifed(species, number_of_genomes, gwcd_list, true, jacknife_resamplings, jacknife_ratio, random_seed);
                SurfacingUtil.writeMatrixToFile(new File(String.valueOf(matrix_output_file) + "_" + ForesterUtil.round(jacknife_ratio, 2) + "_" + jacknife_resamplings + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedBinaryCombinationsBasedDistances());
                SurfacingUtil.writeMatrixToFile(new File(String.valueOf(matrix_output_file) + "_" + ForesterUtil.round(jacknife_ratio, 2) + "_" + jacknife_resamplings + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedDomainsBasedDistances());
            }
        }
        if (out_dir != null && !perform_pwc) {
            output_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file);
        }
        surfacing_old.writePresentToNexus(output_file, positive_filter_file, filter, gwcd_list);
        if (intrees != null && intrees.length > 0 && number_of_genomes > 2) {
            StringBuilder parameters_sb = surfacing_old.createParametersAsString(ignore_dufs, e_value_max, max_allowed_overlap, no_engulfing_overlaps, cutoff_scores_file, dc_type);
            String s = "_";
            if (radomize_fitch_parsimony) {
                s = String.valueOf(s) + random_number_seed_for_fitch_parsimony + "_";
            }
            int i9 = 0;
            Phylogeny[] phylogenyArray = intrees;
            int n = intrees.length;
            int n5 = 0;
            while (n5 < n) {
                Phylogeny intree = phylogenyArray[n5];
                String outfile_name = String.valueOf(ForesterUtil.removeSuffix(output_file.toString())) + s + ForesterUtil.removeSuffix(intree_files[i9].toString());
                DomainParsimonyCalculator domain_parsimony = DomainParsimonyCalculator.createInstance(intree, gwcd_list);
                SurfacingUtil.executeParsimonyAnalysis(random_number_seed_for_fitch_parsimony, radomize_fitch_parsimony, outfile_name, domain_parsimony, intree, domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, parameters_sb.toString(), domain_id_to_secondary_features_maps, positive_filter_file == null ? null : filter, output_binary_domain_combinationsfor_graph_analysis, all_bin_domain_combinations_gained_fitch, all_bin_domain_combinations_lost_fitch, dc_type);
                if (domain_id_to_secondary_features_maps != null && domain_id_to_secondary_features_maps.length > 0) {
                    int j = 0;
                    Map[] mapArray = domain_id_to_secondary_features_maps;
                    int n6 = domain_id_to_secondary_features_maps.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Map domain_id_to_secondary_features_map = mapArray[n7];
                        TreeMap<Species, MappingResults> mapping_results_map = new TreeMap<Species, MappingResults>();
                        DomainParsimonyCalculator secondary_features_parsimony = DomainParsimonyCalculator.createInstance(intree, gwcd_list, domain_id_to_secondary_features_map);
                        SurfacingUtil.executeParsimonyAnalysisForSecondaryFeatures(String.valueOf(outfile_name) + "_" + secondary_features_map_files[j++], secondary_features_parsimony, intree, parameters_sb.toString(), mapping_results_map);
                        if (i9 == 0) {
                            System.out.println();
                            System.out.println("Mapping to secondary features:");
                            for (Species spec : mapping_results_map.keySet()) {
                                MappingResults mapping_results = (MappingResults)mapping_results_map.get(spec);
                                int total_domains = mapping_results.getSumOfFailures() + mapping_results.getSumOfSuccesses();
                                System.out.print(spec + ":");
                                System.out.print(" mapped domains = " + mapping_results.getSumOfSuccesses());
                                System.out.print(", not mapped domains = " + mapping_results.getSumOfFailures());
                                if (total_domains > 0) {
                                    System.out.println(", mapped ratio = " + 100 * mapping_results.getSumOfSuccesses() / total_domains + "%");
                                    continue;
                                }
                                System.out.println(", mapped ratio = n/a (total domains = 0 )");
                            }
                        }
                        ++n7;
                    }
                }
                ++i9;
                ++n5;
            }
        }
        if (plus_minus_analysis_high_copy_base_species.size() > 0) {
            surfacing_old.executePlusMinusAnalysis(output_file, plus_minus_analysis_high_copy_base_species, plus_minus_analysis_high_copy_target_species, plus_minus_analysis_high_low_copy_species, gwcd_list, protein_lists_per_species, domain_id_to_go_ids_map, go_id_to_term_map, plus_minus_analysis_numbers);
        }
        if (output_protein_lists_for_all_domains) {
            surfacing_old.writeProteinListsForAllSpecies(out_dir, protein_lists_per_species, gwcd_list);
        }
        if (all_bin_domain_combinations_gained_fitch != null) {
            try {
                surfacing_old.executeFitchGainsAnalysis(new File(output_file + OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX), all_bin_domain_combinations_gained_fitch, all_domains_encountered.size(), all_bin_domain_combinations_encountered, true);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
        }
        if (all_bin_domain_combinations_lost_fitch != null) {
            try {
                surfacing_old.executeFitchGainsAnalysis(new File(output_file + OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX), all_bin_domain_combinations_lost_fitch, all_domains_encountered.size(), all_bin_domain_combinations_encountered, false);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
        }
        Runtime rt = Runtime.getRuntime();
        long free_memory = rt.freeMemory() / 1000000L;
        long total_memory = rt.totalMemory() / 1000000L;
        System.out.println();
        System.out.println("Time for analysis : " + (new Date().getTime() - analysis_start_time) + "ms");
        System.out.println("Total running time: " + (new Date().getTime() - start_time) + "ms ");
        System.out.println("Free memory       : " + free_memory + "MB, total memory: " + total_memory + "MB");
        System.out.println();
        System.out.println("If this application is useful to you, please cite:");
        System.out.println(WWW);
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void preparePhylogenyForParsimonyAnalyses(Phylogeny intree, String[][] input_file_properties) {
        String[] genomes = new String[input_file_properties.length];
        int i = 0;
        while (i < input_file_properties.length) {
            if (intree.getNodes(input_file_properties[i][1]).size() > 1) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + input_file_properties[i][1] + "] is not unique in input tree " + intree.getName());
            }
            genomes[i] = input_file_properties[i][1];
            ++i;
        }
        PhylogenyMethods.deleteExternalNodesPositiveSelection(genomes, intree);
        i = 0;
        while (i < input_file_properties.length) {
            try {
                intree.getNode(input_file_properties[i][1]);
            }
            catch (IllegalArgumentException e) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + input_file_properties[i][1] + "] not present/not unique in input tree");
            }
            ++i;
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -Xms256m -Xmx512m -cp forester.jar org.forester.applications.surfacing [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Note: This software might need a significant amount of memory (heap space);");
        System.out.println("       hence use \"-Xms128m -Xmx512m\" (or more) to prevent a \"java.lang.OutOfMemoryError\".");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("detail: level of detail for similarities output file (default:" + (Object)((Object)DETAILEDNESS_DEFAULT) + ")");
        System.out.println("ignore_self_comb: to ignore combinations with self (default: not to ignore)");
        System.out.println("ignore_singlet_domains: to ignore domains without combinations in any species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("ignore_species_specific_domains: to ignore domains specific to one species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("dufs: to _not_ ignore DUFs (domains with unknown function) (default: ignore DUFs)");
        System.out.println("ignore_viral_ids: to ignore domains with ids containing 'vir', 'retro', 'transpos', 'phage', or starting with 'rv' or 'gag_'");
        System.out.println("sort: sorting for similarities (default: " + (Object)((Object)DOMAIN_SORT_FILD_DEFAULT) + ")");
        System.out.println("o: name for (main) output file (mandatory)");
        System.out.println("e: max (inclusive) E-value");
        System.out.println("mo: maximal allowed domain overlap");
        System.out.println("no_eo: to ignore engulfed lower confidence domains");
        System.out.println("smatrix: species matrix");
        System.out.println("scoring: scoring (default:" + (Object)((Object)SCORING_DEFAULT) + ")");
        System.out.println("dc_sort: sorting for domain counts (default:" + (Object)((Object)DOMAINS_SORT_ORDER_DEFAULT) + ")");
        System.out.println("ds_output: domain similarity print option (default:" + (Object)((Object)DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT) + ")");
        System.out.println("cos: cutoff score file");
        System.out.println("species_first: sort by species count first");
        System.out.println("out_dir: output directory");
        System.out.println("p2g: Pfam to GO mapping file");
        System.out.println("obo: GO terms file (OBO format)");
        System.out.println("go_namespace: limit GO term to one GO namespace");
        System.out.println("pwc[=<suffix for pairwise comparison output files>]: to perform pairwise comparison based analyses");
        System.out.println("species_tree: species tree, to perform (Dollo, Fitch) parismony analyses");
        System.out.println("mhisto: to display multiple histograms (using fluorite)");
        System.out.println("jack: perform jacknife resampling for domain and binary domain combination based distance matrices [default resamplings: 100]");
        System.out.println("jack_ratio: ratio for jacknife resampling [default: 0.5]");
        System.out.println("seed: seed for random number generator for jacknife resampling [default: 19]");
        System.out.println("species_tree=<treefiles in phyloXML format, separated by #>: to infer domain/binary domain combination gains/losses on given species trees");
        System.out.println("pos_filter=<file>: to filter out proteins not containing at least one domain listed in <file>");
        System.out.println("neg_filter=<file>: to filter out proteins containing at least one domain listed in <file>");
        System.out.println("neg_dom_filter=<file>: to filter out (ignore) domains listed in <file>");
        System.out.println("input=<file>: to read input files from <file>");
        System.out.println("random_seed=<seed>: seed for random number generator for Fitch Parsimony analysis (type: long, default: no randomization - given a choice, prefer absence");
        System.out.println("consider_bdc_direction: to consider directedness in binary combinations: e.g. A-B != B-A");
        System.out.println("consider_bdc_adj: to consider directedness and adjacency in binary combinations");
        System.out.println("prot_extract=<domain ids (Pfam names)>: to extract sequence names of sequences containing matching domains and/or domain-sequences (order N to C) (domain separator: '~', domain sequences speparator: '#', e.g. 'NACHT#BIR~CARD')");
        System.out.println("secondary=<file>: to perfom parsimony analysis on secondary features");
        System.out.println("plus_minus=<file>: to presence/absence genome analysis");
        System.out.println("graph_analysis_out: to output binary domain combinations for (downstream) graph analysis");
        System.out.println("all_prot: to output all proteins per domain");
        System.out.println();
        System.out.println();
        System.out.println("Example: java -Xms128m -Xmx512m -cp path/to/forester.jarorg.forester.application.surfacing -detail=punctilious -o=TEST.html -pwc=TEST -cos=Pfam_ls_22_TC2 -p2g=pfam2go -obo=gene_ontology_edit.obo -dc_sort=dom -ignore_with_self -no_singles -e=0.001 -mo=1 -no_eo -ds_output=detailed_html -scoring=domains -sort=alpha -jack=50 human mouse brafl strpu");
        System.out.println();
    }

    private static void processFilter(File filter_file, SortedSet<DomainId> filter) {
        SortedSet<String> filter_str = null;
        try {
            filter_str = ForesterUtil.file2set(filter_file);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (filter_str != null) {
            for (String string : filter_str) {
                filter.add(new DomainId(string));
            }
        }
    }

    private static String[][] processInputFileNames(String[] names) {
        String[][] input_file_properties = new String[names.length][];
        int i = 0;
        while (i < names.length) {
            if (names[i].indexOf(35) < 0) {
                input_file_properties[i] = new String[3];
                input_file_properties[i][0] = names[i];
                input_file_properties[i][1] = names[i];
                input_file_properties[i][2] = DEFAULT_SEARCH_PARAMETER;
            } else {
                input_file_properties[i] = names[i].split("#");
                if (input_file_properties[i].length != 3) {
                    ForesterUtil.fatalError(PRG_NAME, "properties for the input files (hmmpfam output) are expected to be in the following format \"<hmmpfam output file>#<species>#<search parameter>\" (or just one word, which is both the filename and the species id), instead received \"" + names[i] + "\"");
                }
            }
            String error = ForesterUtil.isReadableFile(new File(input_file_properties[i][0]));
            if (!ForesterUtil.isEmpty(error)) {
                ForesterUtil.fatalError(PRG_NAME, error);
            }
            ++i;
        }
        return input_file_properties;
    }

    private static void processPlusMinusAnalysisOption(CommandLineArguments cla, List<String> high_copy_base, List<String> high_copy_target, List<String> low_copy, List<Object> numbers) {
        if (cla.isOptionSet(PLUS_MINUS_ANALYSIS_OPTION)) {
            File plus_minus_file;
            String msg;
            if (!cla.isOptionValueSet(PLUS_MINUS_ANALYSIS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for 'plus-minus' file: -plus_minus=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(plus_minus_file = new File(cla.getOptionValue(PLUS_MINUS_ANALYSIS_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + plus_minus_file + "\": " + msg);
            }
            surfacing_old.processPlusMinusFile(plus_minus_file, high_copy_base, high_copy_target, low_copy, numbers);
        }
    }

    private static void processPlusMinusFile(File plus_minus_file, List<String> high_copy_base, List<String> high_copy_target, List<String> low_copy, List<Object> numbers) {
        SortedSet<String> species_set = null;
        int min_diff = 0;
        double factor = 1.0;
        try {
            species_set = ForesterUtil.file2set(plus_minus_file);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (species_set != null) {
            for (String species : species_set) {
                String species_trimmed = species.substring(1);
                if (species.startsWith("+")) {
                    if (low_copy.contains(species_trimmed)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    high_copy_base.add(species_trimmed);
                } else if (species.startsWith("*")) {
                    if (low_copy.contains(species_trimmed)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '*' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    high_copy_target.add(species_trimmed);
                } else if (species.startsWith("-")) {
                    if (high_copy_base.contains(species_trimmed) || high_copy_target.contains(species_trimmed)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' or '*' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    low_copy.add(species_trimmed);
                } else if (species.startsWith("$D")) {
                    try {
                        min_diff = Integer.parseInt(species.substring(3));
                    }
                    catch (NumberFormatException e) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse integer value for minimal difference from: \"" + species.substring(3) + "\"");
                    }
                } else if (species.startsWith("$F")) {
                    try {
                        factor = Double.parseDouble(species.substring(3));
                    }
                    catch (NumberFormatException e) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse double value for factor from: \"" + species.substring(3) + "\"");
                    }
                } else if (!species.startsWith("#")) {
                    ForesterUtil.fatalError(PRG_NAME, "species/genome names in 'plus minus' file must begin with '*' (high copy target genome), '+' (high copy base genomes), '-' (low copy genomes), '$D=<integer>' minimal Difference (default is 1), '$F=<double>' factor (default is 1.0), double), or '#' (ignore) suffix, encountered: \"" + species + "\"");
                }
                numbers.add(new Integer(String.valueOf(min_diff)));
                numbers.add(new Double(String.valueOf(factor)));
            }
        } else {
            ForesterUtil.fatalError(PRG_NAME, "'plus minus' file [" + plus_minus_file + "] appears empty");
        }
    }

    private static void writePresentToNexus(File output_file, File positive_filter_file, SortedSet<DomainId> filter, List<GenomeWideCombinableDomains> gwcd_list) {
        try {
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(gwcd_list, positive_filter_file == null ? null : filter), output_file + "_dom.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(gwcd_list), output_file + "_dc.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
        }
    }

    private static void writeProteinListsForAllSpecies(File output_dir, SortedMap<Species, List<Protein>> protein_lists_per_species, List<GenomeWideCombinableDomains> gwcd_list) {
        TreeSet<DomainId> all_domains = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            all_domains.addAll(gwcd.getAllDomainIds());
        }
        for (DomainId domain : all_domains) {
            File out = new File(output_dir + ForesterUtil.FILE_SEPARATOR + domain + SEQ_EXTRACT_SUFFIX);
            SurfacingUtil.checkForOutputFileWriteability(out);
            try {
                BufferedWriter proteins_file_writer = new BufferedWriter(new FileWriter(out));
                SurfacingUtil.extractProteinNames(protein_lists_per_species, domain, (Writer)proteins_file_writer, "\t");
                ((Writer)proteins_file_writer).close();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "Wrote proteins list to \"" + out + "\"");
        }
    }
}

