/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.WebLink;
import org.forester.util.ForesterUtil;

final class Configuration {
    static final String VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA = "validate_against_phyloxml_xsd_schema";
    private static final String WEB_LINK_KEY = "web_link";
    private static final String DISPLAY_COLOR_KEY = "display_color";
    private static final int DEPRECATED = -2;
    private TRIPLET _native_ui = TRIPLET.TRUE;
    private boolean _use_tabbed_display = false;
    private boolean _hide_controls_and_menus = false;
    private Options.CLADOGRAM_TYPE _cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
    private SortedMap<String, WebLink> _weblinks = null;
    private SortedMap<String, Color> _display_colors = null;
    private boolean _antialias_screen = true;
    private Options.PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private String _base_font_family_name = "";
    private int _base_font_size = -1;
    private int _graphics_export_x = -1;
    private int _graphics_export_y = -1;
    private short _ov_max_width = (short)80;
    private short _ov_max_height = (short)80;
    private Options.OVERVIEW_PLACEMENT_TYPE _ov_placement = Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
    private double _min_confidence_value = 0.0;
    private float _print_line_width = 0.5f;
    private boolean _show_scale = false;
    private boolean _show_branch_length_values = false;
    private boolean _show_overview = true;
    private short _number_of_digits_after_comma_for_confidence_values = 1;
    private short _number_of_digits_after_comma_for_branch_length_values = (short)2;
    private boolean _editable = true;
    private boolean _nh_parsing_replace_underscores = false;
    private boolean _nh_parsing_extract_pfam_taxonomy_codes = false;
    private boolean _internal_number_are_confidence_for_nh_parsing = false;
    private boolean _nh_parsing_ignore_quotes = true;
    private boolean _validate_against_phyloxml_xsd_schema = true;
    private boolean _background_color_gradient = false;
    static final int display_as_phylogram = 0;
    static final int show_node_names = 1;
    static final int show_tax_code = 2;
    static final int show_annotation = 3;
    static final int write_confidence_values = 4;
    static final int write_events = 5;
    static final int color_according_to_species = 6;
    static final int color_branches = 7;
    static final int width_branches = 8;
    static final int show_domain_architectures = 9;
    static final int show_binary_characters = 10;
    static final int show_binary_character_counts = 11;
    static final int show_gene_names = 12;
    static final int show_sequence_acc = 13;
    static final int display_internal_data = 14;
    static final int dynamically_hide_data = 15;
    static final int show_taxonomy_names = 16;
    static final int color_according_to_annotation = 17;
    static final int show_property = 18;
    static final int show_gene_symbols = 19;
    static final int node_data_popup = 20;
    static final int display_node_data = 0;
    static final int collapse_uncollapse = 1;
    static final int reroot = 2;
    static final int subtree = 3;
    static final int swap = 4;
    static final int color_subtree = 5;
    static final int open_seq_web = 6;
    static final int open_tax_web = 7;
    static final int cut_subtree = 8;
    static final int copy_subtree = 9;
    static final int paste_subtree = 10;
    static final int delete_subtree_or_node = 11;
    static final int add_new_node = 12;
    static final int edit_node_data = 13;
    static final int blast = 14;
    String config_filename;
    String default_config_filename = "_aptx_configuration_file";
    static final String[][] display_options = new String[][]{{"Phylogram", "display", "?"}, {"Node Name", "display", "yes"}, {"Taxonomy Code", "display", "yes"}, {"Annotation", "nodisplay", "no"}, {"Confidence Value", "display", "?"}, {"Event", "display", "?"}, {"Taxonomy Colorize", "display", "yes"}, {"Colorize Branches", "display", "no"}, {"Use Branch-Width", "nodisplay", "no"}, {"Domains", "nodisplay", "no"}, {"Binary Characters", "nodisplay", "no"}, {"Binary Char Counts", "nodisplay", "no"}, {"Prot/Gene Name", "display", "no"}, {"Prot/Gene Acc", "display", "no"}, {"Show Internal Data", "display", "yes"}, {"Dyna Hide", "display", "yes"}, {"Taxonomy Name", "display", "yes"}, {"Annotation Colorize", "nodisplay", "no"}, {"Property", "nodisplay", "no"}, {"Prot/Gene Symbol", "display", "no"}, {"Rollover", "display", "yes"}};
    static final String[][] clickto_options = new String[][]{{"Display Node Data", "display"}, {"Collapse/Uncollapse", "display"}, {"Root/Reroot", "display"}, {"Sub/Super Tree", "display"}, {"Swap Descendants", "display"}, {"Colorize Subtree", "display"}, {"Open Sequence Web", "nodisplay"}, {"Open Taxonomy Web", "nodisplay"}, {"Cut Subtree", "display"}, {"Copy Subtree", "display"}, {"Paste Subtree", "display"}, {"Delete Subtree/Node", "display"}, {"Add New Node", "display"}, {"Edit Node Data", "display"}, {"Blast", "display"}};
    int default_clickto = 0;
    TreeColorSet tree_color_set;
    TreeFontSet tree_font_set;
    private static Hashtable<String, Color> _species_colors;
    private static Hashtable<String, Color> _domain_colors;
    private static Hashtable<String, Color> _annotation_colors;
    boolean verbose = false;
    private Options.NODE_LABEL_DIRECTION _node_label_direction = Options.NODE_LABEL_DIRECTION.HORIZONTAL;
    private TRIPLET _use_native_ui;
    private static String DEFAULT_FONT_FAMILY;

    static {
        DEFAULT_FONT_FAMILY = "";
        String[] stringArray = Constants.DEFAULT_FONT_CHOICES;
        int n = Constants.DEFAULT_FONT_CHOICES.length;
        int n2 = 0;
        while (n2 < n) {
            String font_name = stringArray[n2];
            if (Arrays.binarySearch(Util.getAvailableFontFamiliesSorted(), font_name) >= 0) {
                DEFAULT_FONT_FAMILY = font_name;
                break;
            }
            ++n2;
        }
        if (ForesterUtil.isEmpty(DEFAULT_FONT_FAMILY)) {
            DEFAULT_FONT_FAMILY = Constants.DEFAULT_FONT_CHOICES[Constants.DEFAULT_FONT_CHOICES.length - 1];
        }
    }

    Configuration(String cf, boolean is_url, boolean is_applet) {
        this.config_filename = ForesterUtil.isEmpty(cf) ? this.default_config_filename : cf;
        this.setWebLinks(new TreeMap<String, WebLink>());
        this.setDisplayColors(new TreeMap<String, Color>());
        this.config_filename = this.config_filename.trim();
        URL u = null;
        if (is_url) {
            try {
                u = new URL(this.config_filename);
                try {
                    InputStreamReader isr = new InputStreamReader(u.openStream());
                    BufferedReader bf = new BufferedReader(isr);
                    this.readConfig(bf);
                    bf.close();
                    ForesterUtil.programMessage("Archaeopteryx", "successfully read from configuration url [" + this.config_filename + "]");
                }
                catch (Exception e) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration url [" + this.config_filename + "]");
            }
        } else {
            File f = new File(this.config_filename);
            if (!f.exists()) {
                f = new File(String.valueOf(this.config_filename) + ".txt");
            }
            if (f.exists() && f.canRead()) {
                try {
                    BufferedReader bf = new BufferedReader(new FileReader(f));
                    this.readConfig(bf);
                    bf.close();
                }
                catch (Exception e) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + e);
                }
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration file [" + this.config_filename + "]");
            }
        }
    }

    private void createWebLink(String url_str, String desc, String source_identifier) {
        WebLink weblink = null;
        boolean ex = false;
        try {
            weblink = new WebLink(new URL(url_str.trim()), desc.trim(), source_identifier.trim());
        }
        catch (MalformedURLException e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not create URL from [" + url_str + "]");
            ex = true;
        }
        if (!ex && weblink != null) {
            this.getWebLinks().put(weblink.getSourceIdentifier().toLowerCase(), weblink);
        }
    }

    boolean doCheckOption(int which) {
        return display_options[which][2].equalsIgnoreCase("yes") || display_options[which][2].equalsIgnoreCase("true");
    }

    boolean doDisplayClickToOption(int which) {
        return clickto_options[which][1].equalsIgnoreCase("display");
    }

    boolean doDisplayOption(int which) {
        return display_options[which][1].equalsIgnoreCase("display");
    }

    boolean doGuessCheckOption(int which) {
        return display_options[which][2].equals("?");
    }

    Map<String, Color> getAnnotationColors() {
        if (_annotation_colors == null) {
            _annotation_colors = new Hashtable();
        }
        return _annotation_colors;
    }

    public String getBaseFontFamilyName() {
        return this._base_font_family_name;
    }

    int getBaseFontSize() {
        return this._base_font_size;
    }

    Options.CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    private int getClickToIndex(String name) {
        int index = -1;
        if (name.equals("edit_info")) {
            index = 0;
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [edit_info] is deprecated, use [display node data] instead");
        } else if (name.equals("display_node_data")) {
            index = 0;
        } else if (name.equals("collapse_uncollapse")) {
            index = 1;
        } else if (name.equals("reroot")) {
            index = 2;
        } else if (name.equals("subtree")) {
            index = 3;
        } else if (name.equals("swap")) {
            index = 4;
        } else {
            if (name.equals("display_sequences")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_sequences] is deprecated");
                return -2;
            }
            if (name.equals("open_seq_web")) {
                index = 6;
            } else if (name.equals("open_tax_web")) {
                index = 7;
            } else if (name.equals("cut_subtree")) {
                index = 8;
            } else if (name.equals("copy_subtree")) {
                index = 9;
            } else if (name.equals("paste_subtree")) {
                index = 10;
            } else if (name.equals("delete")) {
                index = 11;
            } else if (name.equals("add_new_node")) {
                index = 12;
            } else if (name.equals("edit_node_data")) {
                index = 13;
            } else {
                if (name.equals("display_node_popup")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_node_popup] is deprecated");
                    return -2;
                }
                if (name.equals("custom_option")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [custom_option] is deprecated");
                    return -2;
                }
                if (name.equals("color_subtree")) {
                    index = 5;
                } else if (name.equals("go_to_swiss_prot")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [go_to_swiss_prot] is deprecated");
                    return -2;
                }
            }
        }
        return index;
    }

    int getClickToOptionsCount() {
        return clickto_options.length;
    }

    String getClickToTitle(int which) {
        return clickto_options[which][0];
    }

    int getDefaultDisplayClicktoOption() {
        return this.default_clickto;
    }

    SortedMap<String, Color> getDisplayColors() {
        return this._display_colors;
    }

    String getDisplayTitle(int which) {
        return display_options[which][0];
    }

    Map<String, Color> getDomainColors() {
        if (_domain_colors == null) {
            _domain_colors = new Hashtable();
        }
        return _domain_colors;
    }

    int getGraphicsExportX() {
        return this._graphics_export_x;
    }

    int getGraphicsExportY() {
        return this._graphics_export_y;
    }

    double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    Options.NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    short getOvMaxHeight() {
        return this._ov_max_height;
    }

    short getOvMaxWidth() {
        return this._ov_max_width;
    }

    Options.OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    float getPrintLineWidth() {
        return this._print_line_width;
    }

    Hashtable<String, Color> getSpeciesColors() {
        if (_species_colors == null) {
            _species_colors = new Hashtable();
        }
        return _species_colors;
    }

    TreeColorSet getTreeColorSet() {
        return null;
    }

    TreeFontSet getTreeFontSet() {
        return null;
    }

    WebLink getWebLink(String source) {
        return this.getWebLinks().get(source);
    }

    Map<String, WebLink> getWebLinks() {
        return this._weblinks;
    }

    boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    boolean isDrawAsPhylogram() {
        return this.doCheckOption(0);
    }

    boolean isEditable() {
        return this._editable;
    }

    boolean isExtractPfamTaxonomyCodesInNhParsing() {
        return this._nh_parsing_extract_pfam_taxonomy_codes;
    }

    boolean isHasWebLink(String source) {
        return this.getWebLinks().containsKey(source);
    }

    boolean isHideControlPanelAndMenubar() {
        return this._hide_controls_and_menus;
    }

    boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    boolean isNhParsingIgnoreQuotes() {
        return this._nh_parsing_ignore_quotes;
    }

    boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    boolean isShowBranchLengthValues() {
        return this._show_branch_length_values;
    }

    boolean isShowOverview() {
        return this._show_overview;
    }

    boolean isShowScale() {
        return this._show_scale;
    }

    final boolean isUseNativeUI() {
        if (this._use_native_ui == null || this._use_native_ui == TRIPLET.UNKNOWN) {
            this._use_native_ui = this._native_ui == TRIPLET.UNKNOWN && Util.isMac() && Util.isJava15() ? TRIPLET.TRUE : (this._native_ui == TRIPLET.TRUE ? TRIPLET.TRUE : TRIPLET.FALSE);
        }
        return this._use_native_ui == TRIPLET.TRUE;
    }

    boolean isUseTabbedDisplay() {
        return this._use_tabbed_display;
    }

    private boolean parseBoolean(String str) {
        String my_str = str.trim().toLowerCase();
        if (my_str.equals("yes") || my_str.equals("true")) {
            return true;
        }
        if (my_str.equals("no") || my_str.equals("false")) {
            return false;
        }
        ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse boolean value from [" + str + "]");
        return false;
    }

    private double parseDouble(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse double from [" + str + "]");
            d = 0.0;
        }
        return d;
    }

    private float parseFloat(String str) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(str);
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse float from [" + str + "]");
            f = 0.0f;
        }
        return f;
    }

    private int parseInt(String str) {
        int i = -1;
        try {
            i = Integer.parseInt(str);
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse integer from [" + str + "]");
            i = -1;
        }
        return i;
    }

    private short parseShort(String str) {
        int i = -1;
        try {
            i = Short.parseShort(str);
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse short from [" + str + "]");
            i = -1;
        }
        return (short)i;
    }

    private void processFontFamily(StringTokenizer st) {
        String[] fonts;
        this.setBaseFontFamilyName("");
        String font_str = ((String)st.nextElement()).trim();
        String[] stringArray = fonts = font_str.split(",+");
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            String font = stringArray[n2];
            font = font.replace('_', ' ').trim();
            if (Arrays.binarySearch(Util.getAvailableFontFamiliesSorted(), font) >= 0) {
                this.setBaseFontFamilyName(font);
                break;
            }
            ++n2;
        }
    }

    private void readConfig(BufferedReader conf_in) throws IOException {
        String line;
        do {
            if ((line = conf_in.readLine()) == null || (line = line.trim()).startsWith("#") || ForesterUtil.isEmpty(line)) continue;
            line = line.replaceAll("\\s+", "\t");
            StringTokenizer st = new StringTokenizer(line, "\t");
            this.setKeyValue(st);
        } while (line != null);
    }

    private void setAntialiasScreen(boolean antialias_screen) {
        this._antialias_screen = antialias_screen;
    }

    private void setBaseFontFamilyName(String base_font_family_name) {
        this._base_font_family_name = base_font_family_name;
    }

    private void setBaseFontSize(int base_font_size) {
        this._base_font_size = base_font_size;
    }

    private void setCladogramType(Options.CLADOGRAM_TYPE cladogram_type) {
        this._cladogram_type = cladogram_type;
    }

    void setDisplayColors(SortedMap<String, Color> display_colors) {
        this._display_colors = display_colors;
    }

    private void setEditable(boolean editable) {
        this._editable = editable;
    }

    private void setExtractPfamTaxonomyCodesInNhParsing(boolean nh_parsing_extract_pfam_taxonomy_codes) {
        this._nh_parsing_extract_pfam_taxonomy_codes = nh_parsing_extract_pfam_taxonomy_codes;
    }

    private void setGraphicsExportX(int graphics_export_x) {
        this._graphics_export_x = graphics_export_x;
    }

    private void setGraphicsExportY(int graphics_export_y) {
        this._graphics_export_y = graphics_export_y;
    }

    private void setInternalNumberAreConfidenceForNhParsing(boolean internal_number_are_confidence_for_nh_parsing) {
        this._internal_number_are_confidence_for_nh_parsing = internal_number_are_confidence_for_nh_parsing;
    }

    private void setKeyValue(StringTokenizer st) {
        String key = (String)st.nextElement();
        key = key.replace(':', ' ');
        key = key.trim();
        if ((key = key.toLowerCase()).equals("default_click_to")) {
            String clickto_name = (String)st.nextElement();
            this.default_clickto = this.getClickToIndex(clickto_name);
            if (this.default_clickto == -1) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "invalid value [" + clickto_name + "] for [default_click_to]");
                this.default_clickto = 0;
            }
        } else if (key.equals("native_ui")) {
            String my_str = ((String)st.nextElement()).trim().toLowerCase();
            if (my_str.equals("yes") || my_str.equals("true")) {
                this._native_ui = TRIPLET.TRUE;
            } else if (my_str.equals("no") || my_str.equals("false")) {
                this._native_ui = TRIPLET.FALSE;
            } else if (my_str.equals("?")) {
                this._native_ui = TRIPLET.UNKNOWN;
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse yes/no/? value from [" + my_str + "]");
                this._native_ui = TRIPLET.FALSE;
            }
        } else if (key.equals(VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA)) {
            this.setValidatePhyloXmlAgainstSchema(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("antialias_screen")) {
            this.setAntialiasScreen(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("phylogeny_graphics_type")) {
            String type_str = ((String)st.nextElement()).trim();
            if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
            } else if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
            } else {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [phylogeny_graphics_type]");
            }
        } else if (key.equals("min_confidence_value")) {
            String mcv_str = ((String)st.nextElement()).trim();
            double d = this.parseDouble(mcv_str);
            this.setMinConfidenceValue(d);
        } else if (key.equals("font_family")) {
            this.processFontFamily(st);
        } else if (key.equals("font_size")) {
            String size_str = ((String)st.nextElement()).trim();
            int i = this.parseInt(size_str);
            this.setBaseFontSize(i);
        } else if (key.equals("graphics_export_x")) {
            String str = ((String)st.nextElement()).trim();
            int i = this.parseInt(str);
            this.setGraphicsExportX(i);
        } else if (key.equals("graphics_export_y")) {
            String str = ((String)st.nextElement()).trim();
            int i = this.parseInt(str);
            this.setGraphicsExportY(i);
        } else if (key.equals("pdf_export_line_width")) {
            String str = ((String)st.nextElement()).trim();
            float f = this.parseFloat(str);
            if (f > 0.0f) {
                this.setPrintLineWidth(f);
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "value for [pdf_export_line_width] cannot be zero or negative");
            }
        } else if (key.equals("show_scale")) {
            this.setShowScale(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("show_overview")) {
            this.setShowOverview(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("show_branch_length_values")) {
            this.setShowBranchLengthValues(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("background_gradient")) {
            this.setBackgroundColorGradient(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("cladogram_type")) {
            String type_str = ((String)st.nextElement()).trim();
            if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.NON_LINED_UP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
            } else if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
            } else if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [cladogram_type]");
            }
        } else if (key.equals("non_lined_up_cladogram")) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [non_lined_up_cladogram] is deprecated, use [cladogram_type] instead");
        } else if (key.equals("hide_controls_and_menus")) {
            this._hide_controls_and_menus = this.parseBoolean((String)st.nextElement());
        } else if (key.equals("use_tabbed_display")) {
            this._use_tabbed_display = this.parseBoolean((String)st.nextElement());
        } else if (key.equals("overview_width")) {
            short i = this.parseShort(((String)st.nextElement()).trim());
            this.setOvMaxWidth(i);
        } else if (key.equals("overview_height")) {
            short i = this.parseShort(((String)st.nextElement()).trim());
            this.setOvMaxHeight(i);
        } else if (key.equals("overview_placement_type")) {
            String type_str = ((String)st.nextElement()).trim();
            if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
            } else if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
            } else if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
            } else if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
            } else {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [overview_placement_type]");
            }
        } else if (key.equals("node_label_direction")) {
            String type_str = ((String)st.nextElement()).trim();
            if (type_str.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.HORIZONTAL.toString())) {
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            } else if (type_str.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.RADIAL.toString())) {
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [node_label_direction]");
            }
        } else if (key.equals("branch_length_value_digits")) {
            short i = this.parseShort(((String)st.nextElement()).trim());
            if (i >= 0) {
                this.setNumberOfDigitsAfterCommaForBranchLengthValue(i);
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + i + "] for [branch_length_value_digits]");
            }
        } else if (key.equals("confidence_value_digits")) {
            short i = this.parseShort(((String)st.nextElement()).trim());
            if (i >= 0) {
                this.setNumberOfDigitsAfterCommaForConfidenceValues(i);
            } else {
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + i + "] for [confidence_value_digits]");
            }
        } else if (key.equals("allow_editing")) {
            this.setEditable(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("replace_underscores_in_nh_parsing")) {
            boolean r = this.parseBoolean((String)st.nextElement());
            if (r && this.isExtractPfamTaxonomyCodesInNhParsing()) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
            } else {
                this.setReplaceUnderscoresInNhParsing(r);
            }
        } else if (key.equals("extract_pfam_tax_codes_in_nh_parsing")) {
            boolean e = this.parseBoolean((String)st.nextElement());
            if (e && this.isReplaceUnderscoresInNhParsing()) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
            } else {
                this.setExtractPfamTaxonomyCodesInNhParsing(e);
            }
        } else if (key.equals("internal_labels_are_confidence_values")) {
            this.setInternalNumberAreConfidenceForNhParsing(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("ignore_quotation_marks_in_nh_parsing")) {
            this.setNhParsingIgnoreQuotes(this.parseBoolean((String)st.nextElement()));
        } else if (key.equals("glyph_type")) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [glyph_type] is deprecated");
        } else if (st.countTokens() >= 2) {
            int key_index = -1;
            if (key.equals("use_real_br_lengths") || key.equals("phylogram")) {
                key_index = 0;
                if (key.equals("use_real_br_lengths")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [use_real_br_lengths] is deprecated, use [phylogram] instead");
                }
            } else if (key.equals("rollover")) {
                key_index = 20;
            } else if (key.equals("color_according_to_species")) {
                key_index = 6;
            } else if (key.equals("show_node_names")) {
                key_index = 1;
            } else if (key.equals("show_taxonomy") || key.equals("show_taxonomy_code")) {
                key_index = 2;
                if (key.equals("show_taxonomy")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [show_taxonomy] is deprecated, use [show_taxonomy_code] instead");
                }
            } else if (key.equals("write_br_length_values")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_br_length_values] is deprecated");
                key_index = -2;
            } else if (key.equals("write_bootstrap_values") || key.equals("write_confidence_values")) {
                key_index = 4;
                if (key.equals("write_bootstrap_values")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_bootstrap_values] is deprecated, use [write_confidence_values] instead");
                }
            } else if (key.equals("write_events") || key.equals("write_dup_spec")) {
                key_index = 5;
                if (key.equals("write_dup_spec")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_dup_spec] is deprecated, use [write_events] instead");
                }
            } else if (key.equals("color_branches")) {
                key_index = 7;
            } else if (key.equals("width_branches")) {
                key_index = 8;
            } else if (key.equals("color_orthologous")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_orthologous] is deprecated");
            } else if (key.equals("color_subtree_neighbors")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_subtree_neighbors] is deprecated");
            } else if (key.equals("color_super_orthologous")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_super_orthologous] is deprecated");
            } else if (key.equals("mark_nodes_with_box")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [mark_nodes_with_box] is deprecated");
                key_index = -2;
            } else if (key.equals("show_domain_architectures")) {
                key_index = 9;
            } else if (key.equals("show_annotations")) {
                key_index = 3;
            } else if (key.equals("show_binary_characters")) {
                key_index = 10;
            } else if (key.equals("show_binary_character_counts")) {
                key_index = 11;
            } else if (key.equals("show_gene_names")) {
                key_index = 12;
            } else if (key.equals("show_gene_symbols")) {
                key_index = 19;
            } else if (key.equals("show_sequence_acc")) {
                key_index = 13;
            } else if (key.equals("show_node_ids")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [show_node_ids] is deprecated");
                key_index = -2;
            } else if (key.equals("display_internal_data")) {
                key_index = 14;
            } else if (key.equals("dynamically_hide_data")) {
                key_index = 15;
            } else if (key.equals("show_taxonomy_names")) {
                key_index = 16;
            } else if (key.equals("color_according_to_annotation")) {
                key_index = 17;
            } else if (key.equals("show_property")) {
                key_index = 18;
            }
            if (key_index >= 0) {
                Configuration.display_options[key_index][1] = (String)st.nextElement();
                Configuration.display_options[key_index][2] = (String)st.nextElement();
            } else if (key_index != -2) {
                if (key.equals("click_to")) {
                    String click_to_name = (String)st.nextElement();
                    key_index = this.getClickToIndex(click_to_name);
                    if (key_index >= 0) {
                        Configuration.clickto_options[key_index][1] = (String)st.nextElement();
                    } else if (key_index != -2) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "unknown click-to option: " + click_to_name);
                    }
                } else if (key.equals("species_color")) {
                    this.getSpeciesColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                } else if (key.equals("domain_color")) {
                    this.getDomainColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                } else if (key.equals("annotation_color")) {
                    this.getAnnotationColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                } else if (key.equals("function_color")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [function_color] is deprecated");
                } else if (key.equals(DISPLAY_COLOR_KEY)) {
                    this.getDisplayColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                } else if (key.equals(WEB_LINK_KEY)) {
                    if (st.countTokens() == 3) {
                        this.createWebLink((String)st.nextElement(), (String)st.nextElement(), (String)st.nextElement());
                    } else {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "illegal format in configuration file for key [" + key + "]");
                    }
                } else {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + key + "] in: " + this.config_filename);
                }
            }
        } else {
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + key + "] in: " + this.config_filename);
        }
    }

    private void setMinConfidenceValue(double min_confidence_value) {
        this._min_confidence_value = min_confidence_value;
    }

    private void setNhParsingIgnoreQuotes(boolean nh_parsing_ignore_quotes) {
        this._nh_parsing_ignore_quotes = nh_parsing_ignore_quotes;
    }

    void setNodeLabelDirection(Options.NODE_LABEL_DIRECTION node_label_direction) {
        this._node_label_direction = node_label_direction;
    }

    private void setNumberOfDigitsAfterCommaForBranchLengthValue(short _number_of_digits_after_comma_for_branch_length_values) {
        this._number_of_digits_after_comma_for_branch_length_values = _number_of_digits_after_comma_for_branch_length_values;
    }

    private void setNumberOfDigitsAfterCommaForConfidenceValues(short _number_of_digits_after_comma_for_confidence_values) {
        this._number_of_digits_after_comma_for_confidence_values = _number_of_digits_after_comma_for_confidence_values;
    }

    private void setOvMaxHeight(short ov_max_height) {
        this._ov_max_height = ov_max_height;
    }

    private void setOvMaxWidth(short ov_max_width) {
        this._ov_max_width = ov_max_width;
    }

    private void setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE ov_placement) {
        this._ov_placement = ov_placement;
    }

    void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE phylogeny_graphics_type) {
        this._phylogeny_graphics_type = phylogeny_graphics_type;
    }

    private void setPrintLineWidth(float print_line_width) {
        this._print_line_width = print_line_width;
    }

    private void setReplaceUnderscoresInNhParsing(boolean nh_parsing_replace_underscores) {
        this._nh_parsing_replace_underscores = nh_parsing_replace_underscores;
    }

    private void setShowBranchLengthValues(boolean show_branch_length_values) {
        this._show_branch_length_values = show_branch_length_values;
    }

    private void setShowOverview(boolean show_overview) {
        this._show_overview = show_overview;
    }

    private void setShowScale(boolean show_scale) {
        this._show_scale = show_scale;
    }

    void setWebLinks(SortedMap<String, WebLink> weblinks) {
        this._weblinks = weblinks;
    }

    static String getDefaultFontFamilyName() {
        return DEFAULT_FONT_FAMILY;
    }

    private void setValidatePhyloXmlAgainstSchema(boolean validate_against_phyloxml_xsd_schema) {
        this._validate_against_phyloxml_xsd_schema = validate_against_phyloxml_xsd_schema;
    }

    boolean isValidatePhyloXmlAgainstSchema() {
        return this._validate_against_phyloxml_xsd_schema;
    }

    public void setBackgroundColorGradient(boolean background_color_gradient) {
        this._background_color_gradient = background_color_gradient;
    }

    public boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    static enum TRIPLET {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

