/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

public final class AminoAcid {
    public static final char UNKNOWN = '?';
    public static final byte UNKNOWN_CODE = 20;
    public static final char GAP = '-';
    public static final byte GAP_CODE = 21;
    public static final char TERMINATE = '*';
    public static final byte TERMINATE_CODE = 22;
    private static final char[] AMINO_ACID_TABLE = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', '?', '-', '*'};

    private AminoAcid() {
    }

    public static char getResidue(byte state) {
        return AMINO_ACID_TABLE[state];
    }

    public static byte getState(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 4;
            }
            case 'D': 
            case 'd': {
                return 3;
            }
            case 'E': 
            case 'e': {
                return 6;
            }
            case 'F': 
            case 'f': {
                return 13;
            }
            case 'G': 
            case 'g': {
                return 7;
            }
            case 'H': 
            case 'h': {
                return 8;
            }
            case 'I': 
            case 'i': {
                return 9;
            }
            case 'K': 
            case 'k': {
                return 11;
            }
            case 'L': 
            case 'l': {
                return 10;
            }
            case 'M': 
            case 'm': {
                return 12;
            }
            case 'N': 
            case 'n': {
                return 2;
            }
            case 'P': 
            case 'p': {
                return 14;
            }
            case 'Q': 
            case 'q': {
                return 5;
            }
            case 'R': 
            case 'r': {
                return 1;
            }
            case 'S': 
            case 's': {
                return 15;
            }
            case 'T': 
            case 't': {
                return 16;
            }
            case 'V': 
            case 'v': {
                return 19;
            }
            case 'W': 
            case 'w': {
                return 17;
            }
            case 'Y': 
            case 'y': {
                return 18;
            }
            case '-': {
                return 21;
            }
            case '*': {
                return 22;
            }
        }
        return 20;
    }

    public static boolean isGap(byte state) {
        return state == 21;
    }

    public static boolean isTerminate(byte state) {
        return state == 22;
    }

    public static boolean isUnassignable(byte state) {
        return state > 22;
    }

    public static boolean isUnknown(byte state) {
        return state == 20;
    }
}

