/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.BinaryCharactersParser;
import org.forester.io.parsers.phyloxml.phylogenydata.BranchWidthParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ColorParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ConfidenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.DateParser;
import org.forester.io.parsers.phyloxml.phylogenydata.EventParser;
import org.forester.io.parsers.phyloxml.phylogenydata.IdentifierParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PropertyParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ReferenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.SequenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.TaxonomyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PhyloXmlHandler
extends DefaultHandler {
    private static final String PHYLOXML = "phyloxml";
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;

    PhyloXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode new_node = new PhylogenyNode();
        this.getCurrentNode().addAsChild(new_node);
        this.setCurrentNode(new_node);
    }

    @Override
    public void characters(char[] chars, int start_index, int end_index) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("clade") && !this.getCurrentElementName().equals("phylogeny")) {
            if (!ForesterUtil.isEmpty(this.getCurrentXmlElement().getValueAsString())) {
                this.getCurrentXmlElement().appendValue(new String(chars, start_index, end_index));
            } else {
                this.getCurrentXmlElement().setValue(new String(chars, start_index, end_index));
            }
        }
    }

    @Override
    public void endElement(String namespace_uri, String local_name, String qualified_name) throws SAXException {
        if (ForesterUtil.isEmpty(namespace_uri) || namespace_uri.startsWith("http://www.phyloxml.org")) {
            if (local_name.equals("clade")) {
                try {
                    PhyloXmlHandler.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.getCurrentXmlElement().setValue(null);
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException ex) {
                    throw new SAXException(ex.getMessage());
                }
            }
            if (local_name.equals("phylogeny")) {
                try {
                    PhyloXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException ex) {
                    throw new SAXException(ex.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (!local_name.equals(PHYLOXML) && this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new IllegalStateException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new IllegalStateException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode node = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(node);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String element_name) {
        this._current_element_name = element_name;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement element) {
        this._current_xml_element = element;
    }

    private void setPhylogenies(List<Phylogeny> phylogenies) {
        this._phylogenies = phylogenies;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String namespace_uri, String local_name, String qualified_name, Attributes attributes) throws SAXException {
        if (ForesterUtil.isEmpty(namespace_uri) || namespace_uri.startsWith("http://www.phyloxml.org")) {
            this.setCurrentElementName(local_name);
            if (local_name.equals("clade")) {
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                this.getCurrentXmlElement().addChildElement(element);
                this.setCurrentXmlElement(element);
                this.newClade();
            } else if (local_name.equals("phylogeny")) {
                this.setCurrentXmlElement(new XmlElement("", "", "", null));
                this.newPhylogeny();
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                if (element.isHasAttribute("rerootable")) {
                    this.getCurrentPhylogeny().setRerootable(Boolean.parseBoolean(element.getAttribute("rerootable")));
                }
                if (element.isHasAttribute("branch_length_unit")) {
                    this.getCurrentPhylogeny().setDistanceUnit(element.getAttribute("branch_length_unit"));
                }
                if (element.isHasAttribute("rooted")) {
                    this.getCurrentPhylogeny().setRooted(Boolean.parseBoolean(element.getAttribute("rooted")));
                }
                if (element.isHasAttribute("type")) {
                    this.getCurrentPhylogeny().setType(element.getAttribute("type"));
                }
            } else if (!local_name.equals(PHYLOXML) && this.getCurrentPhylogeny() != null) {
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                this.getCurrentXmlElement().addChildElement(element);
                this.setCurrentXmlElement(element);
            }
        }
    }

    public static boolean attributeEqualsValue(XmlElement element, String attributeName, String attributeValue) {
        String attr = element.getAttribute(attributeName);
        return attr != null && attr.equals(attributeValue);
    }

    public static String getAtttributeValue(XmlElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        if (attr != null) {
            return attr;
        }
        return "";
    }

    private static void mapElementToPhylogeny(XmlElement xml_element, Phylogeny phylogeny) throws PhylogenyParserException {
        int i = 0;
        while (i < xml_element.getNumberOfChildElements()) {
            XmlElement element = xml_element.getChildElement(i);
            String qualified_name = element.getQualifiedName();
            if (qualified_name.equals("name")) {
                phylogeny.setName(element.getValueAsString());
            } else if (qualified_name.equals("description")) {
                phylogeny.setDescription(element.getValueAsString());
            } else if (qualified_name.equals("id")) {
                phylogeny.setIdentifier((Identifier)IdentifierParser.getInstance().parse(element));
            } else if (qualified_name.equals("confidence")) {
                phylogeny.setConfidence((Confidence)ConfidenceParser.getInstance().parse(element));
            }
            ++i;
        }
    }

    private static void mapElementToPhylogenyNode(XmlElement xml_element, PhylogenyNode node) throws PhylogenyParserException {
        if (xml_element.isHasAttribute("branch_length")) {
            double d = 0.0;
            try {
                d = Double.parseDouble(xml_element.getAttribute("branch_length"));
            }
            catch (NumberFormatException e) {
                throw new PhylogenyParserException("ill formatted distance in clade attribute [" + xml_element.getAttribute("branch_length") + "]: " + e.getMessage());
            }
            node.setDistanceToParent(d);
        }
        int i = 0;
        while (i < xml_element.getNumberOfChildElements()) {
            XmlElement element = xml_element.getChildElement(i);
            String qualified_name = element.getQualifiedName();
            if (qualified_name.equals("branch_length")) {
                if (node.getDistanceToParent() != -1024.0) {
                    throw new PhylogenyParserException("ill advised attempt to set distance twice for the same clade (probably via element and via attribute)");
                }
                node.setDistanceToParent(element.getValueAsDouble());
            }
            if (qualified_name.equals("name")) {
                node.setName(element.getValueAsString());
            } else if (qualified_name.equals("taxonomy")) {
                node.getNodeData().setTaxonomy((Taxonomy)TaxonomyParser.getInstance().parse(element));
            } else if (qualified_name.equals("sequence")) {
                node.getNodeData().setSequence((Sequence)SequenceParser.getInstance().parse(element));
            } else if (!qualified_name.equals("distribution")) {
                if (qualified_name.equals("date")) {
                    node.getNodeData().setDate((Date)DateParser.getInstance().parse(element));
                } else if (qualified_name.equals("reference")) {
                    node.getNodeData().setReference((Reference)ReferenceParser.getInstance().parse(element));
                } else if (qualified_name.equals("binary_characters")) {
                    node.getNodeData().setBinaryCharacters((BinaryCharacters)BinaryCharactersParser.getInstance().parse(element));
                } else if (qualified_name.equals("color")) {
                    node.getBranchData().setBranchColor((BranchColor)ColorParser.getInstance().parse(element));
                } else if (qualified_name.equals("confidence")) {
                    node.getBranchData().addConfidence((Confidence)ConfidenceParser.getInstance().parse(element));
                } else if (qualified_name.equals("width")) {
                    node.getBranchData().setBranchWidth((BranchWidth)BranchWidthParser.getInstance().parse(element));
                } else if (qualified_name.equals("events")) {
                    node.getNodeData().setEvent((Event)EventParser.getInstance().parse(element));
                } else if (qualified_name.equals("property")) {
                    if (!node.getNodeData().isHasProperties()) {
                        node.getNodeData().setProperties(new PropertiesMap());
                    }
                    node.getNodeData().getProperties().addProperty((Property)PropertyParser.getInstance().parse(element));
                }
            }
            ++i;
        }
    }
}

