/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.ConfidenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public class EventParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new EventParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private EventParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhylogenyParserException {
        String type = "";
        Confidence conf = null;
        int duplications = -1;
        int speciations = -1;
        int losses = -1;
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("type")) {
                type = child_element.getValueAsString();
            } else if (child_element.getQualifiedName().equals("confidence")) {
                conf = (Confidence)ConfidenceParser.getInstance().parse(child_element);
            } else if (child_element.getQualifiedName().equals("duplications")) {
                duplications = child_element.getValueAsInt();
            } else if (child_element.getQualifiedName().equals("speciations")) {
                speciations = child_element.getValueAsInt();
            } else if (child_element.getQualifiedName().equals("losses")) {
                losses = child_element.getValueAsInt();
            }
            ++i;
        }
        Event event = null;
        if (ForesterUtil.isEmpty(type)) {
            event = new Event(duplications, speciations, losses);
        } else {
            try {
                event = new Event(duplications, speciations, losses, type);
            }
            catch (Exception e) {
                throw new PhylogenyParserException("problem with " + element.toString() + ": " + e.getMessage());
            }
        }
        if (conf != null) {
            event.setConfidence(conf);
        }
        return event;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

