/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDI;

public class TaxonomyAssigner
extends SDI {
    public TaxonomyAssigner(Phylogeny gene_tree, Phylogeny species_tree) {
        super(gene_tree, species_tree);
        this.getSpeciesTree().preOrderReId(0);
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    void geneTreePostOrderTraversal(PhylogenyNode g) {
        if (!g.isExternal()) {
            PhylogenyNodeIterator iter = g.iterateChildNodesForward();
            while (iter.hasNext()) {
                this.geneTreePostOrderTraversal(iter.next());
            }
            PhylogenyNode[] linked_nodes = new PhylogenyNode[g.getNumberOfDescendants()];
            int i = 0;
            while (i < linked_nodes.length) {
                linked_nodes[i] = g.getChildNode(i).getLink();
                ++i;
            }
            int[] min_max = GSDI.obtainMinMaxIdIndices(linked_nodes);
            int min_i = min_max[0];
            int max_i = min_max[1];
            while (linked_nodes[min_i] != linked_nodes[max_i]) {
                linked_nodes[max_i] = linked_nodes[max_i].getParent();
                int[] min_max_ = GSDI.obtainMinMaxIdIndices(linked_nodes);
                min_i = min_max_[0];
                max_i = min_max_[1];
            }
            PhylogenyNode s = linked_nodes[max_i];
            g.setLink(s);
            if (s.getNodeData().isHasTaxonomy()) {
                g.getNodeData().setTaxonomy((Taxonomy)s.getNodeData().getTaxonomy().copy());
            }
        }
    }

    public static void execute(Phylogeny gene_tree, Phylogeny species_tree) {
        new TaxonomyAssigner(gene_tree, species_tree);
    }
}

