/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.IOException;
import org.forester.development.DevelopmentTools;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.GSDI;

public final class TestGSDI {
    private static final Phylogeny createPhylogeny(String nhx) throws IOException {
        Phylogeny p = ParserBasedPhylogenyFactory.getInstance().create(nhx, new NHXParser())[0];
        p.setRooted(true);
        return p;
    }

    private static final Event getEvent(Phylogeny p, String n1, String n2) {
        return PhylogenyMethods.getInstance().getLCA(p.getNode(n1), p.getNode(n2)).getNodeData().getEvent();
    }

    public static boolean test() {
        if (!TestGSDI.testGSDI_general()) {
            return false;
        }
        return TestGSDI.testGSDI_against_binary_gene_tree();
    }

    private static boolean testGSDI_against_binary_gene_tree() {
        GSDI sdi2;
        block3: {
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                String multi_species_2_str = "(((((([&&NHX:S=1],[&&NHX:S=2]),([&&NHX:S=3],[&&NHX:S=4],[&&NHX:S=5])),([&&NHX:S=6],[&&NHX:S=7],[&&NHX:S=8],[&&NHX:S=9])),([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13],[&&NHX:S=14])),([&&NHX:S=15],([&&NHX:S=16],[&&NHX:S=17]),([&&NHX:S=18],[&&NHX:S=19],[&&NHX:S=20]),([&&NHX:S=21],[&&NHX:S=22],[&&NHX:S=23],[&&NHX:S=24])));";
                String gene_2_1_str = "(((((([&&NHX:S=1],[&&NHX:S=2])1_2,([&&NHX:S=3],[&&NHX:S=4])),([&&NHX:S=6],[&&NHX:S=7])6_7_8_9)1_9,([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13])12_13_14)1_14,([&&NHX:S=15],([&&NHX:S=21],[&&NHX:S=24])21_22_23_24)15_24);";
                Phylogeny multi_species_2 = factory.create("(((((([&&NHX:S=1],[&&NHX:S=2]),([&&NHX:S=3],[&&NHX:S=4],[&&NHX:S=5])),([&&NHX:S=6],[&&NHX:S=7],[&&NHX:S=8],[&&NHX:S=9])),([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13],[&&NHX:S=14])),([&&NHX:S=15],([&&NHX:S=16],[&&NHX:S=17]),([&&NHX:S=18],[&&NHX:S=19],[&&NHX:S=20]),([&&NHX:S=21],[&&NHX:S=22],[&&NHX:S=23],[&&NHX:S=24])));", new NHXParser())[0];
                Phylogeny gene_2_1 = factory.create("(((((([&&NHX:S=1],[&&NHX:S=2])1_2,([&&NHX:S=3],[&&NHX:S=4])),([&&NHX:S=6],[&&NHX:S=7])6_7_8_9)1_9,([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13])12_13_14)1_14,([&&NHX:S=15],([&&NHX:S=21],[&&NHX:S=24])21_22_23_24)15_24);", new NHXParser())[0];
                multi_species_2.setRooted(true);
                gene_2_1.setRooted(true);
                sdi2 = new GSDI(gene_2_1, multi_species_2, false);
                if (sdi2.getSpeciationOrDuplicationEventsSum() == 0) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }
        return sdi2.getDuplicationsSum() == 0;
    }

    private static boolean testGSDI_general() {
        GSDI sdi7_4_2;
        block605: {
            block604: {
                Phylogeny s_7_4;
                block603: {
                    Phylogeny g_7_4_1;
                    block602: {
                        block601: {
                            block600: {
                                block599: {
                                    block598: {
                                        block597: {
                                            block596: {
                                                block595: {
                                                    block594: {
                                                        block593: {
                                                            block592: {
                                                                GSDI sdi7_4_1;
                                                                block591: {
                                                                    block590: {
                                                                        block589: {
                                                                            Phylogeny g2_101;
                                                                            block588: {
                                                                                block587: {
                                                                                    block586: {
                                                                                        block585: {
                                                                                            block584: {
                                                                                                block583: {
                                                                                                    block582: {
                                                                                                        block581: {
                                                                                                            GSDI sdi2_101;
                                                                                                            block580: {
                                                                                                                block579: {
                                                                                                                    Phylogeny s2;
                                                                                                                    block578: {
                                                                                                                        Phylogeny g2_100;
                                                                                                                        block577: {
                                                                                                                            block576: {
                                                                                                                                block575: {
                                                                                                                                    block574: {
                                                                                                                                        block573: {
                                                                                                                                            block572: {
                                                                                                                                                block571: {
                                                                                                                                                    block570: {
                                                                                                                                                        GSDI sdi2_100;
                                                                                                                                                        block569: {
                                                                                                                                                            block568: {
                                                                                                                                                                block567: {
                                                                                                                                                                    GSDI sdi2_38;
                                                                                                                                                                    block566: {
                                                                                                                                                                        block565: {
                                                                                                                                                                            block564: {
                                                                                                                                                                                Phylogeny g2_37;
                                                                                                                                                                                block563: {
                                                                                                                                                                                    block562: {
                                                                                                                                                                                        block561: {
                                                                                                                                                                                            block560: {
                                                                                                                                                                                                GSDI sdi2_37;
                                                                                                                                                                                                block559: {
                                                                                                                                                                                                    block558: {
                                                                                                                                                                                                        block557: {
                                                                                                                                                                                                            Phylogeny g2_36;
                                                                                                                                                                                                            block556: {
                                                                                                                                                                                                                block555: {
                                                                                                                                                                                                                    block554: {
                                                                                                                                                                                                                        block553: {
                                                                                                                                                                                                                            GSDI sdi2_36;
                                                                                                                                                                                                                            block552: {
                                                                                                                                                                                                                                block551: {
                                                                                                                                                                                                                                    block550: {
                                                                                                                                                                                                                                        Phylogeny g2_35;
                                                                                                                                                                                                                                        block549: {
                                                                                                                                                                                                                                            block548: {
                                                                                                                                                                                                                                                block547: {
                                                                                                                                                                                                                                                    block546: {
                                                                                                                                                                                                                                                        block545: {
                                                                                                                                                                                                                                                            GSDI sdi2_35;
                                                                                                                                                                                                                                                            block544: {
                                                                                                                                                                                                                                                                block543: {
                                                                                                                                                                                                                                                                    block542: {
                                                                                                                                                                                                                                                                        Phylogeny g2_34;
                                                                                                                                                                                                                                                                        block541: {
                                                                                                                                                                                                                                                                            block540: {
                                                                                                                                                                                                                                                                                block539: {
                                                                                                                                                                                                                                                                                    block538: {
                                                                                                                                                                                                                                                                                        GSDI sdi2_34;
                                                                                                                                                                                                                                                                                        block537: {
                                                                                                                                                                                                                                                                                            block536: {
                                                                                                                                                                                                                                                                                                block535: {
                                                                                                                                                                                                                                                                                                    Phylogeny g2_33;
                                                                                                                                                                                                                                                                                                    block534: {
                                                                                                                                                                                                                                                                                                        block533: {
                                                                                                                                                                                                                                                                                                            block532: {
                                                                                                                                                                                                                                                                                                                block531: {
                                                                                                                                                                                                                                                                                                                    block530: {
                                                                                                                                                                                                                                                                                                                        block529: {
                                                                                                                                                                                                                                                                                                                            block528: {
                                                                                                                                                                                                                                                                                                                                block527: {
                                                                                                                                                                                                                                                                                                                                    block526: {
                                                                                                                                                                                                                                                                                                                                        block525: {
                                                                                                                                                                                                                                                                                                                                            block524: {
                                                                                                                                                                                                                                                                                                                                                GSDI sdi2_33;
                                                                                                                                                                                                                                                                                                                                                block523: {
                                                                                                                                                                                                                                                                                                                                                    block522: {
                                                                                                                                                                                                                                                                                                                                                        block521: {
                                                                                                                                                                                                                                                                                                                                                            Phylogeny g2_32;
                                                                                                                                                                                                                                                                                                                                                            block520: {
                                                                                                                                                                                                                                                                                                                                                                block519: {
                                                                                                                                                                                                                                                                                                                                                                    block518: {
                                                                                                                                                                                                                                                                                                                                                                        block517: {
                                                                                                                                                                                                                                                                                                                                                                            block516: {
                                                                                                                                                                                                                                                                                                                                                                                block515: {
                                                                                                                                                                                                                                                                                                                                                                                    block514: {
                                                                                                                                                                                                                                                                                                                                                                                        block513: {
                                                                                                                                                                                                                                                                                                                                                                                            block512: {
                                                                                                                                                                                                                                                                                                                                                                                                block511: {
                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_32;
                                                                                                                                                                                                                                                                                                                                                                                                    block510: {
                                                                                                                                                                                                                                                                                                                                                                                                        block509: {
                                                                                                                                                                                                                                                                                                                                                                                                            block508: {
                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_31;
                                                                                                                                                                                                                                                                                                                                                                                                                block507: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block506: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block505: {
                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_31;
                                                                                                                                                                                                                                                                                                                                                                                                                            block504: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block503: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block502: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_30;
                                                                                                                                                                                                                                                                                                                                                                                                                                        block501: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block500: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block499: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_30;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block498: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block497: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block496: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_29;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block495: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block494: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block493: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_29;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block492: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block491: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block490: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_28;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block489: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block488: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block487: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_28;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block486: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block485: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block484: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_27;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block483: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block482: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block481: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_27;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block480: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block479: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block478: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_26;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block477: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block476: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block475: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_26;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block474: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block473: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block472: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_25;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block471: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block470: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block469: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_25;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block468: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block467: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block466: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_24;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block465: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block464: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block463: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_24;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block462: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block461: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block460: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_23;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block459: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block458: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block457: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_23;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block456: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block455: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block454: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_22;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block453: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block452: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block451: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_22;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block450: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block449: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block448: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_21;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block447: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block446: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block445: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_21;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block444: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block443: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block442: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_20;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block441: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block440: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block439: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_20;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block438: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block437: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block436: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_19;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block435: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block434: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block433: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_19;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block432: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block431: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block430: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_18;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block429: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block428: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block427: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_18;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block426: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block425: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block424: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_17;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block423: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block422: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        GSDI sdi2_17;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block421: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block420: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block419: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny g2_16;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block418: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block417: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_16;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block416: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block415: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block414: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_15;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block413: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block412: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                GSDI sdi2_15;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block411: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block410: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block409: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny g2_14;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block408: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block407: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_14;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block406: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block405: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block404: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_13;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block403: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block402: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        GSDI sdi2_13;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block401: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block400: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block399: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny g2_12;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block398: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block397: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_12;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block396: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block395: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block394: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_11;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block393: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block392: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                GSDI sdi2_11;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block391: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block390: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block389: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny g2_10;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block388: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block387: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_10;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block386: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block385: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block384: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_9;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block383: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block382: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        GSDI sdi2_9;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block381: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block380: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block379: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny g2_8;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    PhylogenyMethods pm;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block378: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block377: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_8;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block376: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block375: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block374: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_7;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block373: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block372: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                GSDI sdi2_7;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block371: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block370: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block369: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny g2_6;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block368: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block367: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi2_6;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block366: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block365: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block364: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g2_5;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block363: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block362: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        GSDI sdi2_5;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block361: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block360: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block359: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny g2_4;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block358: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block357: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_4;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block356: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block355: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block354: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_3;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block353: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_3;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block352: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block351: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block350: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block349: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block348: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block347: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block346: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block345: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block344: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block343: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block342: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g2_0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block341: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2_0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block340: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block339: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block338: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny gene7_2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block337: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block336: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block335: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block334: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block333: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block332: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block331: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block330: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block329: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block328: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g5;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block327: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block326: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block325: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block324: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block323: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny s1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block322: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g4;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block321: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block320: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block319: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block318: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny g3;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block317: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block316: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block315: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block314: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block313: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny g2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block312: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block311: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block310: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block309: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block308: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny g1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block307: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block306: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block305: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block304: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    pm = PhylogenyMethods.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String s1_ = "((([&&NHX:S=A2],[&&NHX:S=A1]),[&&NHX:S=B],[&&NHX:S=C]),[&&NHX:S=D])";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    s1 = ParserBasedPhylogenyFactory.getInstance().create("((([&&NHX:S=A2],[&&NHX:S=A1]),[&&NHX:S=B],[&&NHX:S=C]),[&&NHX:S=D])", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    s1.setRooted(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g1 = TestGSDI.createPhylogeny("((((B[&&NHX:S=B],A1[&&NHX:S=A1]),C[&&NHX:S=C]),A2[&&NHX:S=A2]),D[&&NHX:S=D])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi1 = new GSDI(g1, s1, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi1.getDuplicationsSum() == 1) break block304;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g1.getNode("B"), g1.getNode("A1")).getNodeData().getEvent().isSpeciation()) break block305;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g1.getNode("C"), g1.getNode("A1")).getNodeData().getEvent().isSpeciationOrDuplication()) break block306;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g1.getNode("A2"), g1.getNode("A1")).getNodeData().getEvent().isDuplication()) break block307;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g1.getNode("D"), g1.getNode("A1")).getNodeData().getEvent().isSpeciation()) break block308;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2 = TestGSDI.createPhylogeny("((((A2[&&NHX:S=A2],A1[&&NHX:S=A1]),B[&&NHX:S=B]),C[&&NHX:S=C]),D[&&NHX:S=D])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi2 = new GSDI(g2, s1, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2.getDuplicationsSum() == 0) break block309;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2.getNode("A1"), g2.getNode("A2")).getNodeData().getEvent().isSpeciation()) break block310;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g2.getNode("A1"), g2.getNode("B")).getNodeData().getEvent().isSpeciation()) break block311;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g2.getNode("A1"), g2.getNode("C")).getNodeData().getEvent().isSpeciationOrDuplication()) break block312;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g2.getNode("A1"), g2.getNode("D")).getNodeData().getEvent().isSpeciation()) break block313;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        g3 = TestGSDI.createPhylogeny("((((A2[&&NHX:S=A2],A1[&&NHX:S=A1]),C[&&NHX:S=C]),B[&&NHX:S=B]),D[&&NHX:S=D])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        GSDI sdi3 = new GSDI(g3, s1, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi3.getDuplicationsSum() == 0) break block314;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g3.getNode("A1"), g3.getNode("A2")).getNodeData().getEvent().isSpeciation()) break block315;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g3.getNode("A1"), g3.getNode("C")).getNodeData().getEvent().isSpeciation()) break block316;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g3.getNode("A1"), g3.getNode("B")).getNodeData().getEvent().isSpeciationOrDuplication()) break block317;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g3.getNode("A1"), g3.getNode("D")).getNodeData().getEvent().isSpeciation()) break block318;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g4 = TestGSDI.createPhylogeny("(((B[&&NHX:S=B],C1[&&NHX:S=C]),C2[&&NHX:S=C]),D[&&NHX:S=D])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi4 = new GSDI(g4, s1, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi4.getDuplicationsSum() == 1) break block319;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g4.getNode("B"), g4.getNode("C1")).getNodeData().getEvent().isSpeciation()) break block320;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g4.getNode("B"), g4.getNode("C2")).getNodeData().getEvent().isDuplication()) break block321;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g4.getNode("B"), g4.getNode("D")).getNodeData().getEvent().isSpeciation()) break block322;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g5 = TestGSDI.createPhylogeny("(((D1[&&NHX:S=D],A1[&&NHX:S=A1]),B[&&NHX:S=B]),((D2[&&NHX:S=D],D3[&&NHX:S=D]),C[&&NHX:S=C]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GSDI sdi5 = new GSDI(g5, s1, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi5.getDuplicationsSum() == 3) break block323;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g5.getNode("D1"), g5.getNode("A1")).getNodeData().getEvent().isSpeciation()) break block324;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g5.getNode("D1"), g5.getNode("B")).getNodeData().getEvent().isDuplication()) break block325;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g5.getNode("D1"), g5.getNode("D2")).getNodeData().getEvent().isDuplication()) break block326;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g5.getNode("D2"), g5.getNode("D3")).getNodeData().getEvent().isDuplication()) break block327;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g5.getNode("C"), g5.getNode("D3")).getNodeData().getEvent().isSpeciation()) break block328;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny species7 = TestGSDI.createPhylogeny("(((((((([&&NHX:S=a1],[&&NHX:S=a2]),([&&NHX:S=b1],[&&NHX:S=b2])),[&&NHX:S=x]),(([&&NHX:S=m1],[&&NHX:S=m2]),([&&NHX:S=n1],[&&NHX:S=n2]))),(([&&NHX:S=i1],[&&NHX:S=i2]),([&&NHX:S=j1],[&&NHX:S=j2]))),(([&&NHX:S=e1],[&&NHX:S=e2]),([&&NHX:S=f1],[&&NHX:S=f2]))),[&&NHX:S=y]),[&&NHX:S=z])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            gene7_2 = TestGSDI.createPhylogeny("(((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),x[&&NHX:S=x]),m1[&&NHX:S=m1]),i1[&&NHX:S=i1]),j2[&&NHX:S=j2]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            gene7_2.setRooted(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GSDI sdi7_2 = new GSDI(gene7_2, species7, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi7_2.getDuplicationsSum() == 1) break block329;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(gene7_2, "a1", "a2").isSpeciation()) break block330;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(gene7_2, "a1", "b1").isSpeciation()) break block331;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(gene7_2, "a1", "x").isSpeciation()) break block332;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(gene7_2, "a1", "m1").isSpeciation()) break block333;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(gene7_2, "a1", "i1").isSpeciation()) break block334;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(gene7_2, "a1", "j2").isDuplication()) break block335;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(gene7_2, "a1", "e1").isSpeciation()) break block336;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(gene7_2, "a1", "y").isSpeciation()) break block337;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(gene7_2, "a1", "z").isSpeciation()) break block338;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String s2_ = "((([&&NHX:S=a1],[&&NHX:S=a2],[&&NHX:S=a3],[&&NHX:S=a4]),([&&NHX:S=b1],[&&NHX:S=b2],[&&NHX:S=b3],[&&NHX:S=b4]),([&&NHX:S=c1],[&&NHX:S=c2],[&&NHX:S=c3],[&&NHX:S=c4]),([&&NHX:S=d1],[&&NHX:S=d2],[&&NHX:S=d3],[&&NHX:S=d4])),(([&&NHX:S=e1],[&&NHX:S=e2],[&&NHX:S=e3],[&&NHX:S=e4]),([&&NHX:S=f1],[&&NHX:S=f2],[&&NHX:S=f3],[&&NHX:S=f4]),([&&NHX:S=g1],[&&NHX:S=g2],[&&NHX:S=g3],[&&NHX:S=g4]),([&&NHX:S=h1],[&&NHX:S=h2],[&&NHX:S=h3],[&&NHX:S=h4])),(([&&NHX:S=i1],[&&NHX:S=i2],[&&NHX:S=i3],[&&NHX:S=i4]),([&&NHX:S=j1],[&&NHX:S=j2],[&&NHX:S=j3],[&&NHX:S=j4]),([&&NHX:S=k1],[&&NHX:S=k2],[&&NHX:S=k3],[&&NHX:S=k4]),([&&NHX:S=l1],[&&NHX:S=l2],[&&NHX:S=l3],[&&NHX:S=l4])),(([&&NHX:S=m1],[&&NHX:S=m2],[&&NHX:S=m3],[&&NHX:S=m4]),([&&NHX:S=n1],[&&NHX:S=n2],[&&NHX:S=n3],[&&NHX:S=n4]),([&&NHX:S=o1],[&&NHX:S=o2],[&&NHX:S=o3],[&&NHX:S=o4]),([&&NHX:S=p1],[&&NHX:S=p2],[&&NHX:S=p3],[&&NHX:S=p4])),[&&NHX:S=x],[&&NHX:S=y],[&&NHX:S=z])";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    s2 = ParserBasedPhylogenyFactory.getInstance().create("((([&&NHX:S=a1],[&&NHX:S=a2],[&&NHX:S=a3],[&&NHX:S=a4]),([&&NHX:S=b1],[&&NHX:S=b2],[&&NHX:S=b3],[&&NHX:S=b4]),([&&NHX:S=c1],[&&NHX:S=c2],[&&NHX:S=c3],[&&NHX:S=c4]),([&&NHX:S=d1],[&&NHX:S=d2],[&&NHX:S=d3],[&&NHX:S=d4])),(([&&NHX:S=e1],[&&NHX:S=e2],[&&NHX:S=e3],[&&NHX:S=e4]),([&&NHX:S=f1],[&&NHX:S=f2],[&&NHX:S=f3],[&&NHX:S=f4]),([&&NHX:S=g1],[&&NHX:S=g2],[&&NHX:S=g3],[&&NHX:S=g4]),([&&NHX:S=h1],[&&NHX:S=h2],[&&NHX:S=h3],[&&NHX:S=h4])),(([&&NHX:S=i1],[&&NHX:S=i2],[&&NHX:S=i3],[&&NHX:S=i4]),([&&NHX:S=j1],[&&NHX:S=j2],[&&NHX:S=j3],[&&NHX:S=j4]),([&&NHX:S=k1],[&&NHX:S=k2],[&&NHX:S=k3],[&&NHX:S=k4]),([&&NHX:S=l1],[&&NHX:S=l2],[&&NHX:S=l3],[&&NHX:S=l4])),(([&&NHX:S=m1],[&&NHX:S=m2],[&&NHX:S=m3],[&&NHX:S=m4]),([&&NHX:S=n1],[&&NHX:S=n2],[&&NHX:S=n3],[&&NHX:S=n4]),([&&NHX:S=o1],[&&NHX:S=o2],[&&NHX:S=o3],[&&NHX:S=o4]),([&&NHX:S=p1],[&&NHX:S=p2],[&&NHX:S=p3],[&&NHX:S=p4])),[&&NHX:S=x],[&&NHX:S=y],[&&NHX:S=z])", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    s2.setRooted(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_0 = TestGSDI.createPhylogeny("(m1[&&NHX:S=m1],m3[&&NHX:S=m3])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_0 = new GSDI(g2_0, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_0.getDuplicationsSum() == 0) break block339;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_0.getSpeciationOrDuplicationEventsSum() == 0) break block340;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_0.getSpeciationsSum() == 1) break block341;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_0.getNode("m1"), g2_0.getNode("m3")).getNodeData().getEvent().isSpeciation()) break block342;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_1 = TestGSDI.createPhylogeny("(e2[&&NHX:S=e2],h2[&&NHX:S=h2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_1 = new GSDI(g2_1, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_1.getDuplicationsSum() == 0) break block343;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_1.getSpeciationOrDuplicationEventsSum() == 0) break block344;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_1.getSpeciationsSum() == 1) break block345;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_1.getNode("e2"), g2_1.getNode("h2")).getNodeData().getEvent().isSpeciation()) break block346;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_2 = TestGSDI.createPhylogeny("(e2[&&NHX:S=e2],p4[&&NHX:S=p4])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_2 = new GSDI(g2_2, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_2.getDuplicationsSum() == 0) break block347;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_2.getSpeciationOrDuplicationEventsSum() == 0) break block348;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_2.getSpeciationsSum() == 1) break block349;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_2.getNode("e2"), g2_2.getNode("p4")).getNodeData().getEvent().isSpeciation()) break block350;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_3 = TestGSDI.createPhylogeny("(e2a[&&NHX:S=e2],e2b[&&NHX:S=e2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_3 = new GSDI(g2_3, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_3.getDuplicationsSum() == 1) break block351;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_3.getSpeciationOrDuplicationEventsSum() == 0) break block352;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_3.getSpeciationsSum() == 0) break block353;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_3.getNode("e2a"), g2_3.getNode("e2b")).getNodeData().getEvent().isDuplication()) break block354;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_4 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],j4[&&NHX:S=j4]),i3[&&NHX:S=i3])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_4 = new GSDI(g2_4, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_4.getDuplicationsSum() == 0) break block355;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_4.getSpeciationOrDuplicationEventsSum() == 0) break block356;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_4.getSpeciationsSum() == 2) break block357;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_4.getNode("j1"), g2_4.getNode("j4")).getNodeData().getEvent().isSpeciation()) break block358;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g2_4.getNode("j1"), g2_4.getNode("i3")).getNodeData().getEvent().isSpeciation()) break block359;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                g2_5 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],j4[&&NHX:S=j4]),f3[&&NHX:S=f3])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                sdi2_5 = new GSDI(g2_5, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_5.getDuplicationsSum() == 0) break block360;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_5.getSpeciationOrDuplicationEventsSum() == 0) break block361;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_5.getSpeciationsSum() == 2) break block362;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g2_5.getNode("j1"), g2_5.getNode("j4")).getNodeData().getEvent().isSpeciation()) break block363;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g2_5.getNode("j1"), g2_5.getNode("f3")).getNodeData().getEvent().isSpeciation()) break block364;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_6 = TestGSDI.createPhylogeny("((j3[&&NHX:S=j3],i4[&&NHX:S=i4]),f3[&&NHX:S=f3])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_6 = new GSDI(g2_6, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_6.getDuplicationsSum() == 0) break block365;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_6.getSpeciationOrDuplicationEventsSum() == 0) break block366;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_6.getSpeciationsSum() == 2) break block367;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (pm.getLCA(g2_6.getNode("j3"), g2_6.getNode("i4")).getNodeData().getEvent().isSpeciation()) break block368;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g2_6.getNode("j3"), g2_6.getNode("f3")).getNodeData().getEvent().isSpeciation()) break block369;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        g2_7 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],k1[&&NHX:S=k1]),i1[&&NHX:S=i1])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sdi2_7 = new GSDI(g2_7, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_7.getDuplicationsSum() == 0) break block370;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_7.getSpeciationOrDuplicationEventsSum() == 1) break block371;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_7.getSpeciationsSum() == 1) break block372;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (pm.getLCA(g2_7.getNode("j1"), g2_7.getNode("k1")).getNodeData().getEvent().isSpeciation()) break block373;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_7.getNode("j1"), g2_7.getNode("i1")).getNodeData().getEvent().isSpeciationOrDuplication()) break block374;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_8 = TestGSDI.createPhylogeny("(j1[&&NHX:S=j1],(k1[&&NHX:S=k1],i1[&&NHX:S=i1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_8 = new GSDI(g2_8, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_8.getDuplicationsSum() == 0) break block375;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_8.getSpeciationOrDuplicationEventsSum() == 1) break block376;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_8.getSpeciationsSum() == 1) break block377;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (pm.getLCA(g2_8.getNode("j1"), g2_8.getNode("k1")).getNodeData().getEvent().isSpeciationOrDuplication()) break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (pm.getLCA(g2_8.getNode("k1"), g2_8.getNode("i1")).getNodeData().getEvent().isSpeciation()) break block379;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                g2_9 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],k4[&&NHX:S=k4]),f2[&&NHX:S=f2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                sdi2_9 = new GSDI(g2_9, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_9.getDuplicationsSum() == 0) break block380;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_9.getSpeciationOrDuplicationEventsSum() == 0) break block381;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_9.getSpeciationsSum() == 2) break block382;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_9, "j1", "k4").isSpeciation()) break block383;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_9, "j1", "f2").isSpeciation()) break block384;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_10 = TestGSDI.createPhylogeny("((m1[&&NHX:S=m1],k4[&&NHX:S=k4]),f2[&&NHX:S=f2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_10 = new GSDI(g2_10, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_10.getDuplicationsSum() == 0) break block385;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_10.getSpeciationOrDuplicationEventsSum() == 1) break block386;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_10.getSpeciationsSum() == 1) break block387;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_10, "m1", "k4").isSpeciation()) break block388;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_10, "m1", "f2").isSpeciationOrDuplication()) break block389;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        g2_11 = TestGSDI.createPhylogeny("((m1[&&NHX:S=m1],k4[&&NHX:S=k4]),x[&&NHX:S=x])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sdi2_11 = new GSDI(g2_11, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_11.getDuplicationsSum() == 0) break block390;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_11.getSpeciationOrDuplicationEventsSum() == 1) break block391;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_11.getSpeciationsSum() == 1) break block392;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_11, "m1", "k4").isSpeciation()) break block393;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_11, "m1", "x").isSpeciationOrDuplication()) break block394;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_12 = TestGSDI.createPhylogeny("(m1[&&NHX:S=m1],(k4[&&NHX:S=k4],x[&&NHX:S=x]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_12 = new GSDI(g2_12, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_12.getDuplicationsSum() == 0) break block395;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_12.getSpeciationOrDuplicationEventsSum() == 1) break block396;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_12.getSpeciationsSum() == 1) break block397;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_12, "x", "k4").isSpeciation()) break block398;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_12, "m1", "x").isSpeciationOrDuplication()) break block399;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                g2_13 = TestGSDI.createPhylogeny("(x[&&NHX:S=x],(y[&&NHX:S=y],z[&&NHX:S=z]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                sdi2_13 = new GSDI(g2_13, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_13.getDuplicationsSum() == 0) break block400;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_13.getSpeciationOrDuplicationEventsSum() == 1) break block401;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_13.getSpeciationsSum() == 1) break block402;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_13, "y", "z").isSpeciation()) break block403;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_13, "x", "z").isSpeciationOrDuplication()) break block404;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_14 = TestGSDI.createPhylogeny("(a1_1[&&NHX:S=a1],(b1[&&NHX:S=b1],a1[&&NHX:S=a1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_14 = new GSDI(g2_14, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_14.getDuplicationsSum() == 1) break block405;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_14.getSpeciationOrDuplicationEventsSum() == 0) break block406;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_14.getSpeciationsSum() == 1) break block407;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_14, "b1", "a1").isSpeciation()) break block408;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_14, "b1", "a1_1").isDuplication()) break block409;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        g2_15 = TestGSDI.createPhylogeny("(a2[&&NHX:S=a2],(b1[&&NHX:S=b1],a1[&&NHX:S=a1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sdi2_15 = new GSDI(g2_15, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_15.getDuplicationsSum() == 1) break block410;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_15.getSpeciationOrDuplicationEventsSum() == 0) break block411;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_15.getSpeciationsSum() == 1) break block412;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_15, "b1", "a1").isSpeciation()) break block413;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_15, "b1", "a2").isDuplication()) break block414;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_16 = TestGSDI.createPhylogeny("(n2[&&NHX:S=n2],(j3[&&NHX:S=j3],n1[&&NHX:S=n1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_16 = new GSDI(g2_16, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_16.getDuplicationsSum() == 1) break block415;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_16.getSpeciationOrDuplicationEventsSum() == 0) break block416;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_16.getSpeciationsSum() == 1) break block417;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_16, "j3", "n1").isSpeciation()) break block418;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_16, "j3", "n2").isDuplication()) break block419;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                g2_17 = TestGSDI.createPhylogeny("(p4[&&NHX:S=p4],(j3[&&NHX:S=j3],n1[&&NHX:S=n1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                sdi2_17 = new GSDI(g2_17, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_17.getDuplicationsSum() == 1) break block420;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_17.getSpeciationOrDuplicationEventsSum() == 0) break block421;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_17.getSpeciationsSum() == 1) break block422;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_17, "j3", "n1").isSpeciation()) break block423;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_17, "j3", "p4").isDuplication()) break block424;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_18 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n12[&&NHX:S=n1]),(n13[&&NHX:S=n1],n14[&&NHX:S=n1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_18 = new GSDI(g2_18, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_18.getDuplicationsSum() == 3) break block425;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_18.getSpeciationOrDuplicationEventsSum() == 0) break block426;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_18.getSpeciationsSum() == 0) break block427;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_18, "n11", "n12").isDuplication()) break block428;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_18, "n13", "n14").isDuplication()) break block429;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_18, "n11", "n13").isDuplication()) break block430;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_19 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n21[&&NHX:S=n2]),(n12[&&NHX:S=n1],n22[&&NHX:S=n2]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_19 = new GSDI(g2_19, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_19.getDuplicationsSum() == 1) break block431;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_19.getSpeciationOrDuplicationEventsSum() == 0) break block432;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_19.getSpeciationsSum() == 2) break block433;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_19, "n11", "n21").isSpeciation()) break block434;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_19, "n12", "n22").isSpeciation()) break block435;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_19, "n11", "n12").isDuplication()) break block436;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_20 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n2[&&NHX:S=n2]),(n12[&&NHX:S=n1],n3[&&NHX:S=n3]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_20 = new GSDI(g2_20, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_20.getDuplicationsSum() == 1) break block437;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_20.getSpeciationOrDuplicationEventsSum() == 0) break block438;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_20.getSpeciationsSum() == 2) break block439;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_20, "n11", "n2").isSpeciation()) break block440;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_20, "n12", "n3").isSpeciation()) break block441;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_20, "n11", "n12").isDuplication()) break block442;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_21 = TestGSDI.createPhylogeny("((n1[&&NHX:S=n1],n2[&&NHX:S=n2]),(n3[&&NHX:S=n3],a1[&&NHX:S=a1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_21 = new GSDI(g2_21, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_21.getDuplicationsSum() == 1) break block443;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_21.getSpeciationOrDuplicationEventsSum() == 0) break block444;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_21.getSpeciationsSum() == 2) break block445;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_21, "n1", "n2").isSpeciation()) break block446;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_21, "n3", "a1").isSpeciation()) break block447;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_21, "n2", "a1").isDuplication()) break block448;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_22 = TestGSDI.createPhylogeny("((n1[&&NHX:S=n1],n2[&&NHX:S=n2]),(n3[&&NHX:S=n3],n4[&&NHX:S=n4]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_22 = new GSDI(g2_22, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_22.getDuplicationsSum() == 0) break block449;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_22.getSpeciationOrDuplicationEventsSum() == 1) break block450;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_22.getSpeciationsSum() == 2) break block451;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_22, "n1", "n2").isSpeciation()) break block452;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_22, "n3", "n4").isSpeciation()) break block453;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_22, "n1", "n3").isSpeciationOrDuplication()) break block454;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_23 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),(c1[&&NHX:S=c1],d1[&&NHX:S=d1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_23 = new GSDI(g2_23, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_23.getDuplicationsSum() == 0) break block455;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_23.getSpeciationOrDuplicationEventsSum() == 1) break block456;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_23.getSpeciationsSum() == 2) break block457;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_23, "a1", "b1").isSpeciation()) break block458;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_23, "c1", "d1").isSpeciation()) break block459;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_23, "a1", "c1").isSpeciationOrDuplication()) break block460;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_24 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],e1[&&NHX:S=e1]),(i1[&&NHX:S=i1],m1[&&NHX:S=m1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_24 = new GSDI(g2_24, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_24.getDuplicationsSum() == 0) break block461;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_24.getSpeciationOrDuplicationEventsSum() == 1) break block462;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_24.getSpeciationsSum() == 2) break block463;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_24, "a1", "e1").isSpeciation()) break block464;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_24, "i1", "m1").isSpeciation()) break block465;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_24, "a1", "i1").isSpeciationOrDuplication()) break block466;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_25 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),(b1[&&NHX:S=b1],c1[&&NHX:S=c1]))");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_25 = new GSDI(g2_25, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_25.getDuplicationsSum() == 0) break block467;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_25.getSpeciationOrDuplicationEventsSum() == 1) break block468;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_25.getSpeciationsSum() == 2) break block469;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_25, "a1", "a4").isSpeciation()) break block470;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_25, "b1", "c1").isSpeciation()) break block471;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_25, "a1", "b1").isSpeciationOrDuplication()) break block472;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_26 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),b1[&&NHX:S=b1]),e1[&&NHX:S=e1])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_26 = new GSDI(g2_26, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_26.getDuplicationsSum() == 0) break block473;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_26.getSpeciationOrDuplicationEventsSum() == 0) break block474;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_26.getSpeciationsSum() == 3) break block475;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_26, "a1", "a4").isSpeciation()) break block476;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_26, "a1", "b1").isSpeciation()) break block477;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_26, "a1", "e1").isSpeciation()) break block478;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_27 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_27 = new GSDI(g2_27, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_27.getDuplicationsSum() == 0) break block479;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_27.getSpeciationOrDuplicationEventsSum() == 1) break block480;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_27.getSpeciationsSum() == 2) break block481;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_27, "a1", "a4").isSpeciation()) break block482;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_27, "a1", "b1").isSpeciation()) break block483;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_27, "a1", "c1").isSpeciationOrDuplication()) break block484;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_28 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),e1[&&NHX:S=e1])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_28 = new GSDI(g2_28, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_28.getDuplicationsSum() == 0) break block485;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_28.getSpeciationOrDuplicationEventsSum() == 1) break block486;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_28.getSpeciationsSum() == 2) break block487;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_28, "a1", "b1").isSpeciation()) break block488;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_28, "a1", "c1").isSpeciationOrDuplication()) break block489;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_28, "a1", "e1").isSpeciation()) break block490;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_29 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_29 = new GSDI(g2_29, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_29.getDuplicationsSum() == 0) break block491;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_29.getSpeciationOrDuplicationEventsSum() == 2) break block492;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_29.getSpeciationsSum() == 1) break block493;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_29, "a1", "b1").isSpeciation()) break block494;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_29, "a1", "c1").isSpeciationOrDuplication()) break block495;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_29, "a1", "d1").isSpeciationOrDuplication()) break block496;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            g2_30 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),a2[&&NHX:S=a2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_30 = new GSDI(g2_30, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_30.getDuplicationsSum() == 1) break block497;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_30.getSpeciationOrDuplicationEventsSum() == 1) break block498;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_30.getSpeciationsSum() == 1) break block499;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_30, "a1", "b1").isSpeciation()) break block500;
                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_30, "a1", "c1").isSpeciationOrDuplication()) break block501;
                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_30, "a1", "a2").isDuplication()) break block502;
                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    g2_31 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),c2[&&NHX:S=c2])");
                                                                                                                                                                                                                                                                                                                                                                                                                                    sdi2_31 = new GSDI(g2_31, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_31.getDuplicationsSum() == 1) break block503;
                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (sdi2_31.getSpeciationOrDuplicationEventsSum() == 1) break block504;
                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_31.getSpeciationsSum() == 1) break block505;
                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_31, "a1", "b1").isSpeciation()) break block506;
                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_31, "a1", "c1").isSpeciationOrDuplication()) break block507;
                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_31, "a1", "c2").isDuplication()) break block508;
                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            g2_32 = TestGSDI.createPhylogeny("((((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1]),x[&&NHX:S=x]),p1[&&NHX:S=p1]),i1[&&NHX:S=i1]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
                                                                                                                                                                                                                                                                                                                                                                                                            sdi2_32 = new GSDI(g2_32, s2, false);
                                                                                                                                                                                                                                                                                                                                                                                                            if (sdi2_32.getDuplicationsSum() == 0) break block509;
                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (sdi2_32.getSpeciationOrDuplicationEventsSum() == 7) break block510;
                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (sdi2_32.getSpeciationsSum() == 3) break block511;
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_32, "a1", "a2").isSpeciation()) break block512;
                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_32, "a1", "b1").isSpeciation()) break block513;
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_32, "a1", "c1").isSpeciationOrDuplication()) break block514;
                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_32, "a1", "d1").isSpeciationOrDuplication()) break block515;
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_32, "a1", "x").isSpeciation()) break block516;
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_32, "a1", "p1").isSpeciationOrDuplication()) break block517;
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_32, "a1", "i1").isSpeciationOrDuplication()) break block518;
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_32, "a1", "e1").isSpeciationOrDuplication()) break block519;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_32, "a1", "y").isSpeciationOrDuplication()) break block520;
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_32, "a1", "z").isSpeciationOrDuplication()) break block521;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        g2_33 = TestGSDI.createPhylogeny("(((((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1]),x[&&NHX:S=x]),p1[&&NHX:S=p1]),i1[&&NHX:S=i1]),k2[&&NHX:S=k2]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
                                                                                                                                                                                                                                                                                                                                                        sdi2_33 = new GSDI(g2_33, s2, false);
                                                                                                                                                                                                                                                                                                                                                        if (sdi2_33.getDuplicationsSum() == 1) break block522;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (sdi2_33.getSpeciationOrDuplicationEventsSum() == 7) break block523;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (sdi2_33.getSpeciationsSum() == 3) break block524;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_33, "a1", "a2").isSpeciation()) break block525;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_33, "a1", "b1").isSpeciation()) break block526;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_33, "a1", "c1").isSpeciationOrDuplication()) break block527;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_33, "a1", "d1").isSpeciationOrDuplication()) break block528;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_33, "a1", "x").isSpeciation()) break block529;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_33, "a1", "p1").isSpeciationOrDuplication()) break block530;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_33, "a1", "i1").isSpeciationOrDuplication()) break block531;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_33, "a1", "k2").isDuplication()) break block532;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_33, "a1", "e1").isSpeciationOrDuplication()) break block533;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_33, "a1", "y").isSpeciationOrDuplication()) break block534;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_33, "a1", "z").isSpeciationOrDuplication()) break block535;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                g2_34 = TestGSDI.createPhylogeny("(((n1_0[&&NHX:S=n1],n2_0[&&NHX:S=n2]),(n1_1[&&NHX:S=n1],n3_0[&&NHX:S=n3])),n4_0[&&NHX:S=n4])");
                                                                                                                                                                                                                                                                                                sdi2_34 = new GSDI(g2_34, s2, false);
                                                                                                                                                                                                                                                                                                if (sdi2_34.getDuplicationsSum() == 1) break block536;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (sdi2_34.getSpeciationOrDuplicationEventsSum() == 1) break block537;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (sdi2_34.getSpeciationsSum() == 2) break block538;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_34, "n1_0", "n2_0").isSpeciation()) break block539;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_34, "n1_1", "n3_0").isSpeciation()) break block540;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_34, "n1_0", "n1_1").isDuplication()) break block541;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_34, "n1_0", "n4_0").isSpeciationOrDuplication()) break block542;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    g2_35 = TestGSDI.createPhylogeny("((((n1_0[&&NHX:S=n1],n2_0[&&NHX:S=n2]),(n1_1[&&NHX:S=n1],n3_0[&&NHX:S=n3])),n4_0[&&NHX:S=n4]),a1_0[&&NHX:S=a1])");
                                                                                                                                                                                                                                                                    sdi2_35 = new GSDI(g2_35, s2, false);
                                                                                                                                                                                                                                                                    if (sdi2_35.getDuplicationsSum() == 1) break block543;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (sdi2_35.getSpeciationOrDuplicationEventsSum() == 1) break block544;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (sdi2_35.getSpeciationsSum() == 3) break block545;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_35, "n1_0", "n2_0").isSpeciation()) break block546;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_35, "n1_1", "n3_0").isSpeciation()) break block547;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_35, "n1_0", "n1_1").isDuplication()) break block548;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_35, "n1_0", "n4_0").isSpeciationOrDuplication()) break block549;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_35, "n1_0", "a1_0").isSpeciation()) break block550;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    g2_36 = TestGSDI.createPhylogeny("(((a1_0[&&NHX:S=a1],b1_0[&&NHX:S=b1]),(a1_1[&&NHX:S=a1],c1_0[&&NHX:S=c1])),d1_0[&&NHX:S=d1])");
                                                                                                                                                                                                                                    sdi2_36 = new GSDI(g2_36, s2, false);
                                                                                                                                                                                                                                    if (sdi2_36.getDuplicationsSum() == 1) break block551;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (sdi2_36.getSpeciationOrDuplicationEventsSum() == 1) break block552;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (sdi2_36.getSpeciationsSum() == 2) break block553;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (TestGSDI.getEvent(g2_36, "a1_0", "b1_0").isSpeciation()) break block554;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (TestGSDI.getEvent(g2_36, "a1_1", "c1_0").isSpeciation()) break block555;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (TestGSDI.getEvent(g2_36, "a1_0", "c1_0").isDuplication()) break block556;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (TestGSDI.getEvent(g2_36, "a1_0", "d1_0").isSpeciationOrDuplication()) break block557;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        g2_37 = TestGSDI.createPhylogeny("(((a1_0[&&NHX:S=a1],b1_0[&&NHX:S=b1]),(a2_0[&&NHX:S=a2],c1_0[&&NHX:S=c1])),d1_0[&&NHX:S=d1])");
                                                                                                                                                                                                        sdi2_37 = new GSDI(g2_37, s2, false);
                                                                                                                                                                                                        if (sdi2_37.getDuplicationsSum() == 1) break block558;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (sdi2_37.getSpeciationOrDuplicationEventsSum() == 1) break block559;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (sdi2_37.getSpeciationsSum() == 2) break block560;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (TestGSDI.getEvent(g2_37, "a1_0", "b1_0").isSpeciation()) break block561;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (TestGSDI.getEvent(g2_37, "a2_0", "c1_0").isSpeciation()) break block562;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (TestGSDI.getEvent(g2_37, "a1_0", "c1_0").isDuplication()) break block563;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (TestGSDI.getEvent(g2_37, "a1_0", "d1_0").isSpeciationOrDuplication()) break block564;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            Phylogeny g2_38 = TestGSDI.createPhylogeny("(((([&&NHX:S=n1],[&&NHX:S=n1]),([&&NHX:S=n1],[&&NHX:S=n1])),[&&NHX:S=n1]),[&&NHX:S=n1])");
                                                                                                                                                                            sdi2_38 = new GSDI(g2_38, s2, false);
                                                                                                                                                                            if (sdi2_38.getDuplicationsSum() == 5) break block565;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (sdi2_38.getSpeciationOrDuplicationEventsSum() == 0) break block566;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (sdi2_38.getSpeciationsSum() == 0) break block567;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                g2_100 = TestGSDI.createPhylogeny("(((e1[&&NHX:S=e1],f2[&&NHX:S=f2]),(d3[&&NHX:S=d3],g4[&&NHX:S=g4])),(((a1[&&NHX:S=a1],h2[&&NHX:S=h2]),c3[&&NHX:S=c3]),(i4[&&NHX:S=i4],b1[&&NHX:S=b1])))");
                                                                                                                                                                sdi2_100 = new GSDI(g2_100, s2, false);
                                                                                                                                                                if (sdi2_100.getDuplicationsSum() == 4) break block568;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (sdi2_100.getSpeciationOrDuplicationEventsSum() == 0) break block569;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (sdi2_100.getSpeciationsSum() == 4) break block570;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (TestGSDI.getEvent(g2_100, "e1", "f2").isSpeciation()) break block571;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (TestGSDI.getEvent(g2_100, "d3", "g4").isSpeciation()) break block572;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (TestGSDI.getEvent(g2_100, "e1", "d3").isDuplication()) break block573;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (TestGSDI.getEvent(g2_100, "a1", "h2").isSpeciation()) break block574;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (TestGSDI.getEvent(g2_100, "a1", "c3").isDuplication()) break block575;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (TestGSDI.getEvent(g2_100, "i4", "b1").isSpeciation()) break block576;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (TestGSDI.getEvent(g2_100, "a1", "i4").isDuplication()) break block577;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (TestGSDI.getEvent(g2_100, "e1", "a1").isDuplication()) break block578;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    g2_101 = TestGSDI.createPhylogeny("(((e1[&&NHX:S=e1],f2[&&NHX:S=f2]),(d3[&&NHX:S=d3],g4[&&NHX:S=g4])),(((a1[&&NHX:S=a1],b2[&&NHX:S=b2]),c3[&&NHX:S=c3]),(i4[&&NHX:S=i4],j1[&&NHX:S=j1])))");
                                                                                                                    sdi2_101 = new GSDI(g2_101, s2, false);
                                                                                                                    if (sdi2_101.getDuplicationsSum() == 2) break block579;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (sdi2_101.getSpeciationOrDuplicationEventsSum() == 1) break block580;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (sdi2_101.getSpeciationsSum() == 5) break block581;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (TestGSDI.getEvent(g2_101, "e1", "f2").isSpeciation()) break block582;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (TestGSDI.getEvent(g2_101, "d3", "g4").isSpeciation()) break block583;
                                                                                                    return false;
                                                                                                }
                                                                                                if (TestGSDI.getEvent(g2_101, "e1", "d3").isDuplication()) break block584;
                                                                                                return false;
                                                                                            }
                                                                                            if (TestGSDI.getEvent(g2_101, "a1", "b2").isSpeciation()) break block585;
                                                                                            return false;
                                                                                        }
                                                                                        if (TestGSDI.getEvent(g2_101, "a1", "c3").isSpeciationOrDuplication()) break block586;
                                                                                        return false;
                                                                                    }
                                                                                    if (TestGSDI.getEvent(g2_101, "i4", "j1").isSpeciation()) break block587;
                                                                                    return false;
                                                                                }
                                                                                if (TestGSDI.getEvent(g2_101, "a1", "i4").isSpeciation()) break block588;
                                                                                return false;
                                                                            }
                                                                            if (TestGSDI.getEvent(g2_101, "e1", "a1").isDuplication()) break block589;
                                                                            return false;
                                                                        }
                                                                        s_7_4 = DevelopmentTools.createBalancedPhylogeny(7, 4);
                                                                        DevelopmentTools.numberSpeciesInOrder(s_7_4);
                                                                        g_7_4_1 = TestGSDI.createPhylogeny("((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1[&&NHX:S=1],2[&&NHX:S=2]),3[&&NHX:S=3]),4[&&NHX:S=4]),5[&&NHX:S=5]),6[&&NHX:S=6]),7[&&NHX:S=7]),8[&&NHX:S=8]),9[&&NHX:S=9]),10[&&NHX:S=10]),11[&&NHX:S=11]),12[&&NHX:S=12]),13[&&NHX:S=13]),14[&&NHX:S=14]),15[&&NHX:S=15]),16[&&NHX:S=16]),17[&&NHX:S=17]),18[&&NHX:S=18]),19[&&NHX:S=19]),20[&&NHX:S=20]),21[&&NHX:S=21]),22[&&NHX:S=22]),23[&&NHX:S=23]),24[&&NHX:S=24]),25[&&NHX:S=25]),26[&&NHX:S=26]),27[&&NHX:S=27]),28[&&NHX:S=28]),29[&&NHX:S=29]),30[&&NHX:S=30]),31[&&NHX:S=31]),32[&&NHX:S=32]),33[&&NHX:S=33]),34[&&NHX:S=34]),35[&&NHX:S=35]),36[&&NHX:S=36]),37[&&NHX:S=37]),38[&&NHX:S=38]),39[&&NHX:S=39]),40[&&NHX:S=40]),41[&&NHX:S=41]),42[&&NHX:S=42]),43[&&NHX:S=43]),44[&&NHX:S=44]),45[&&NHX:S=45]),46[&&NHX:S=46]),47[&&NHX:S=47]),48[&&NHX:S=48]),49[&&NHX:S=49]),50[&&NHX:S=50]),51[&&NHX:S=51]),52[&&NHX:S=52]),53[&&NHX:S=53]),54[&&NHX:S=54]),55[&&NHX:S=55]),56[&&NHX:S=56]),57[&&NHX:S=57]),58[&&NHX:S=58]),59[&&NHX:S=59]),60[&&NHX:S=60]),61[&&NHX:S=61]),62[&&NHX:S=62]),63[&&NHX:S=63]),64[&&NHX:S=64]),65[&&NHX:S=65])");
                                                                        sdi7_4_1 = new GSDI(g_7_4_1, s_7_4, false);
                                                                        if (sdi7_4_1.getDuplicationsSum() == 54) break block590;
                                                                        return false;
                                                                    }
                                                                    if (sdi7_4_1.getSpeciationOrDuplicationEventsSum() == 6) break block591;
                                                                    return false;
                                                                }
                                                                if (sdi7_4_1.getSpeciationsSum() == 4) break block592;
                                                                return false;
                                                            }
                                                            if (TestGSDI.getEvent(g_7_4_1, "1", "2").isSpeciation()) break block593;
                                                            return false;
                                                        }
                                                        if (TestGSDI.getEvent(g_7_4_1, "1", "3").isSpeciationOrDuplication()) break block594;
                                                        return false;
                                                    }
                                                    if (TestGSDI.getEvent(g_7_4_1, "1", "4").isSpeciationOrDuplication()) break block595;
                                                    return false;
                                                }
                                                if (TestGSDI.getEvent(g_7_4_1, "1", "5").isSpeciation()) break block596;
                                                return false;
                                            }
                                            if (TestGSDI.getEvent(g_7_4_1, "1", "6").isDuplication()) break block597;
                                            return false;
                                        }
                                        if (TestGSDI.getEvent(g_7_4_1, "1", "9").isSpeciationOrDuplication()) break block598;
                                        return false;
                                    }
                                    if (TestGSDI.getEvent(g_7_4_1, "1", "13").isSpeciationOrDuplication()) break block599;
                                    return false;
                                }
                                if (TestGSDI.getEvent(g_7_4_1, "1", "17").isSpeciation()) break block600;
                                return false;
                            }
                            if (TestGSDI.getEvent(g_7_4_1, "1", "33").isSpeciationOrDuplication()) break block601;
                            return false;
                        }
                        if (TestGSDI.getEvent(g_7_4_1, "1", "49").isSpeciationOrDuplication()) break block602;
                        return false;
                    }
                    if (TestGSDI.getEvent(g_7_4_1, "1", "65").isSpeciation()) break block603;
                    return false;
                }
                Phylogeny g_7_4_2 = TestGSDI.createPhylogeny("(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1[&&NHX:S=1],2[&&NHX:S=2]),3[&&NHX:S=3]),4[&&NHX:S=4]),5[&&NHX:S=5]),6[&&NHX:S=6]),7[&&NHX:S=7]),8[&&NHX:S=8]),9[&&NHX:S=9]),10[&&NHX:S=10]),11[&&NHX:S=11]),12[&&NHX:S=12]),13[&&NHX:S=13]),14[&&NHX:S=14]),15[&&NHX:S=15]),16[&&NHX:S=16]),17[&&NHX:S=17]),18[&&NHX:S=18]),19[&&NHX:S=19]),20[&&NHX:S=20]),21[&&NHX:S=21]),22[&&NHX:S=22]),23[&&NHX:S=23]),24[&&NHX:S=24]),25[&&NHX:S=25]),26[&&NHX:S=26]),27[&&NHX:S=27]),28[&&NHX:S=28]),29[&&NHX:S=29]),30[&&NHX:S=30]),31[&&NHX:S=31]),32[&&NHX:S=32]),33[&&NHX:S=33]),34[&&NHX:S=34]),35[&&NHX:S=35]),36[&&NHX:S=36]),37[&&NHX:S=37]),38[&&NHX:S=38]),39[&&NHX:S=39]),40[&&NHX:S=40]),41[&&NHX:S=41]),42[&&NHX:S=42]),43[&&NHX:S=43]),44[&&NHX:S=44]),45[&&NHX:S=45]),46[&&NHX:S=46]),47[&&NHX:S=47]),48[&&NHX:S=48]),49[&&NHX:S=49]),50[&&NHX:S=50]),51[&&NHX:S=51]),52[&&NHX:S=52]),53[&&NHX:S=53]),54[&&NHX:S=54]),55[&&NHX:S=55]),56[&&NHX:S=56]),57[&&NHX:S=57]),58[&&NHX:S=58]),59[&&NHX:S=59]),60[&&NHX:S=60]),61[&&NHX:S=61]),62[&&NHX:S=62]),63[&&NHX:S=63]),64[&&NHX:S=64]),65[&&NHX:S=65]),66[&&NHX:S=66]),257[&&NHX:S=257]),258[&&NHX:S=258]),513[&&NHX:S=513]),514[&&NHX:S=514]),769[&&NHX:S=769]),770[&&NHX:S=770])");
                sdi7_4_2 = new GSDI(g_7_4_2, s_7_4, false);
                if (sdi7_4_2.getDuplicationsSum() == 58) break block604;
                return false;
            }
            if (sdi7_4_2.getSpeciationOrDuplicationEventsSum() == 8) break block605;
            return false;
        }
        return sdi7_4_2.getSpeciationsSum() == 5;
    }
}

