/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.List;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;

public class CombinationsBasedPairwiseDomainSimilarityCalculator
implements PairwiseDomainSimilarityCalculator {
    @Override
    public PairwiseDomainSimilarity calculateSimilarity(CombinableDomains domains_1, CombinableDomains domains_2) {
        if (!domains_1.getKeyDomain().equals(domains_2.getKeyDomain())) {
            throw new IllegalArgumentException("attempt to calculate similarity between domain collection with different keys");
        }
        List<DomainId> d1 = domains_1.getCombinableDomains();
        List<DomainId> d2 = domains_2.getCombinableDomains();
        int same = 0;
        int different = 0;
        for (DomainId domain : d1) {
            if (d2.contains(domain)) {
                ++same;
                continue;
            }
            ++different;
        }
        for (DomainId domain : d2) {
            if (d1.contains(domain)) continue;
            ++different;
        }
        int difference = domains_1.getNumberOfCombinableDomains() - domains_2.getNumberOfCombinableDomains();
        return new CombinationsBasedPairwiseDomainSimilarity(same, different, difference);
    }
}

