/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DolloParsimony;
import org.forester.phylogenyinference.FitchParsimony;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.Species;
import org.forester.util.ForesterUtil;

public final class DomainParsimonyCalculator {
    private static final String TYPE_FORBINARY_CHARACTERS = "parsimony inferred";
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _binary_internal_states_matrix;
    private final List<GenomeWideCombinableDomains> _gwcd_list;
    private final Phylogeny _phylogeny;
    private int _total_losses;
    private int _total_gains;
    private int _total_unchanged;
    private int _cost;
    private Map<DomainId, Set<String>> _domain_id_to_secondary_features_map;
    private SortedSet<DomainId> _positive_filter;

    private DomainParsimonyCalculator(Phylogeny phylogeny) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = null;
    }

    private DomainParsimonyCalculator(Phylogeny phylogeny, List<GenomeWideCombinableDomains> gwcd_list) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = gwcd_list;
    }

    private DomainParsimonyCalculator(Phylogeny phylogeny, List<GenomeWideCombinableDomains> gwcd_list, Map<DomainId, Set<String>> domain_id_to_secondary_features_map) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = gwcd_list;
        this.setDomainIdToSecondaryFeaturesMap(domain_id_to_secondary_features_map);
    }

    int calculateNumberOfBinaryDomainCombination() {
        if (this.getGenomeWideCombinableDomainsList().isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        HashSet<BinaryDomainCombination> all_binary_combinations = new HashSet<BinaryDomainCombination>();
        for (GenomeWideCombinableDomains gwcd : this.getGenomeWideCombinableDomainsList()) {
            for (BinaryDomainCombination bc : gwcd.toBinaryDomainCombinations()) {
                all_binary_combinations.add(bc);
            }
        }
        return all_binary_combinations.size();
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfBinaryDomainCombinationPresenceOrAbsence() {
        return DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(this.getGenomeWideCombinableDomainsList());
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence() {
        return DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(this.getGenomeWideCombinableDomainsList(), this.getPositiveFilter());
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfSecondaryFeaturePresenceOrAbsence(Map<Species, MappingResults> mapping_results_map) {
        return DomainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(this.getGenomeWideCombinableDomainsList(), this.getDomainIdToSecondaryFeaturesMap(), mapping_results_map);
    }

    Phylogeny decoratePhylogenyWithDomains(Phylogeny phylogeny) {
        PhylogenyNodeIterator it = phylogeny.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            String node_identifier = node.getNodeName();
            BinaryCharacters bc = new BinaryCharacters(this.getUnitsOnNode(node_identifier), this.getUnitsGainedOnNode(node_identifier), this.getUnitsLostOnNode(node_identifier), TYPE_FORBINARY_CHARACTERS, this.getSumOfPresentOnNode(node_identifier), this.getSumOfGainsOnNode(node_identifier), this.getSumOfLossesOnNode(node_identifier));
            node.getNodeData().setBinaryCharacters(bc);
        }
        return phylogeny;
    }

    private void executeDolloParsimony(boolean on_domain_presence) {
        this.reset();
        DolloParsimony dollo = DolloParsimony.createInstance();
        dollo.setReturnGainLossMatrix(true);
        dollo.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> states = null;
        states = on_domain_presence ? this.createMatrixOfDomainPresenceOrAbsence() : this.createMatrixOfBinaryDomainCombinationPresenceOrAbsence();
        dollo.execute(this.getPhylogeny(), states);
        this.setGainLossMatrix(dollo.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(dollo.getInternalStatesMatrix());
        this.setCost(dollo.getCost());
        this.setTotalGains(dollo.getTotalGains());
        this.setTotalLosses(dollo.getTotalLosses());
        this.setTotalUnchanged(dollo.getTotalUnchanged());
    }

    public void executeDolloParsimonyOnBinaryDomainCombintionPresence() {
        this.executeDolloParsimony(false);
    }

    public void executeDolloParsimonyOnDomainPresence() {
        this.executeDolloParsimony(true);
    }

    public void executeDolloParsimonyOnDomainPresence(SortedSet<DomainId> positive_filter) {
        this.setPositiveFilter(positive_filter);
        this.executeDolloParsimony(true);
        this.setPositiveFilter(null);
    }

    public void executeDolloParsimonyOnSecondaryFeatures(Map<Species, MappingResults> mapping_results_map) {
        if (this.getDomainIdToSecondaryFeaturesMap() == null) {
            throw new IllegalStateException("Domain id to secondary features map has apparently not been set");
        }
        this.reset();
        DolloParsimony dollo = DolloParsimony.createInstance();
        dollo.setReturnGainLossMatrix(true);
        dollo.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> states = this.createMatrixOfSecondaryFeaturePresenceOrAbsence(mapping_results_map);
        dollo.execute(this.getPhylogeny(), states);
        this.setGainLossMatrix(dollo.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(dollo.getInternalStatesMatrix());
        this.setCost(dollo.getCost());
        this.setTotalGains(dollo.getTotalGains());
        this.setTotalLosses(dollo.getTotalLosses());
        this.setTotalUnchanged(dollo.getTotalUnchanged());
    }

    private void executeFitchParsimony(boolean on_domain_presence, boolean use_last, boolean randomize, long random_number_seed) {
        this.reset();
        if (use_last) {
            System.out.println("   Fitch parsimony: use_last = true");
        }
        FitchParsimony<CharacterStateMatrix.BinaryStates> fitch = new FitchParsimony<CharacterStateMatrix.BinaryStates>();
        fitch.setRandomize(randomize);
        if (randomize) {
            fitch.setRandomNumberSeed(random_number_seed);
        }
        fitch.setUseLast(use_last);
        fitch.setReturnGainLossMatrix(true);
        fitch.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> states = null;
        states = on_domain_presence ? DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(this.getGenomeWideCombinableDomainsList()) : DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(this.getGenomeWideCombinableDomainsList());
        fitch.execute(this.getPhylogeny(), states);
        this.setGainLossMatrix(fitch.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(fitch.getInternalStatesMatrix());
        this.setCost(fitch.getCost());
        this.setTotalGains(fitch.getTotalGains());
        this.setTotalLosses(fitch.getTotalLosses());
        this.setTotalUnchanged(fitch.getTotalUnchanged());
    }

    public void executeFitchParsimonyOnBinaryDomainCombintion(boolean use_last) {
        this.executeFitchParsimony(false, use_last, false, 0L);
    }

    public void executeFitchParsimonyOnBinaryDomainCombintion(long random_number_seed) {
        this.executeFitchParsimony(false, false, true, random_number_seed);
    }

    public void executeFitchParsimonyOnDomainPresence(boolean use_last) {
        this.executeFitchParsimony(true, use_last, false, 0L);
    }

    public void executeFitchParsimonyOnDomainPresence(long random_number_seed) {
        this.executeFitchParsimony(true, false, true, random_number_seed);
    }

    public void executeOnGivenBinaryStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> binary_states_matrix, String[] character_labels) {
        this.reset();
        if (binary_states_matrix.getNumberOfCharacters() != character_labels.length) {
            throw new IllegalArgumentException("binary states matrix number of characters is not equal to the number of character labels provided");
        }
        if (binary_states_matrix.getNumberOfIdentifiers() != this.getPhylogeny().getNumberOfBranches()) {
            throw new IllegalArgumentException("binary states matrix number of identifiers is not equal to the number of tree nodes provided");
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix = new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(binary_states_matrix.getNumberOfIdentifiers(), binary_states_matrix.getNumberOfCharacters());
        int total_gains = 0;
        int total_losses = 0;
        int total_unchanged = 0;
        int i = 0;
        PhylogenyNodeIterator it = this.getPhylogeny().iteratorPostorder();
        while (it.hasNext()) {
            gl_matrix.setIdentifier(i++, it.next().getNodeName());
        }
        int c = 0;
        while (c < character_labels.length) {
            gl_matrix.setCharacter(c, character_labels[c]);
            PhylogenyNodeIterator it2 = this.getPhylogeny().iteratorPostorder();
            while (it2.hasNext()) {
                PhylogenyNode node = it2.next();
                String name = node.getNodeName();
                CharacterStateMatrix.BinaryStates bin_state = binary_states_matrix.getState(binary_states_matrix.getIdentifierIndex(name), c);
                PhylogenyNode parent_node = this.getPhylogeny().getNode(name).getParent();
                CharacterStateMatrix.GainLossStates gl_state = null;
                if (node.isRoot()) {
                    ++total_unchanged;
                    gl_state = bin_state == CharacterStateMatrix.BinaryStates.ABSENT ? CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT : CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                } else {
                    CharacterStateMatrix.BinaryStates parent_bin_state = binary_states_matrix.getState(binary_states_matrix.getIdentifierIndex(parent_node.getNodeName()), c);
                    if (bin_state == CharacterStateMatrix.BinaryStates.ABSENT) {
                        if (parent_bin_state == CharacterStateMatrix.BinaryStates.ABSENT) {
                            ++total_unchanged;
                            gl_state = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
                        } else {
                            ++total_losses;
                            gl_state = CharacterStateMatrix.GainLossStates.LOSS;
                        }
                    } else if (parent_bin_state == CharacterStateMatrix.BinaryStates.ABSENT) {
                        ++total_gains;
                        gl_state = CharacterStateMatrix.GainLossStates.GAIN;
                    } else {
                        ++total_unchanged;
                        gl_state = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                    }
                }
                gl_matrix.setState(name, c, gl_state);
            }
            ++c;
        }
        this.setTotalGains(total_gains);
        this.setTotalLosses(total_losses);
        this.setTotalUnchanged(total_unchanged);
        this.setCost(total_gains + total_losses);
        this.setGainLossMatrix(gl_matrix);
    }

    public int getCost() {
        return this._cost;
    }

    private Map<DomainId, Set<String>> getDomainIdToSecondaryFeaturesMap() {
        return this._domain_id_to_secondary_features_map;
    }

    public CharacterStateMatrix<Integer> getGainLossCountsMatrix() {
        BasicCharacterStateMatrix<Integer> matrix = new BasicCharacterStateMatrix<Integer>(this.getGainLossMatrix().getNumberOfIdentifiers(), 3);
        int i = 0;
        while (i < this.getGainLossMatrix().getNumberOfIdentifiers()) {
            matrix.setIdentifier(i, this.getGainLossMatrix().getIdentifier(i));
            ++i;
        }
        matrix.setCharacter(0, "GAINS");
        matrix.setCharacter(1, "LOSSES");
        matrix.setCharacter(2, "NET");
        i = 0;
        while (i < this.getGainLossMatrix().getNumberOfIdentifiers()) {
            int gains = 0;
            int losses = 0;
            int c = 0;
            while (c < this.getGainLossMatrix().getNumberOfCharacters()) {
                CharacterStateMatrix.GainLossStates s = this.getGainLossMatrix().getState(i, c);
                if (s == CharacterStateMatrix.GainLossStates.GAIN) {
                    ++gains;
                } else if (s == CharacterStateMatrix.GainLossStates.LOSS) {
                    ++losses;
                }
                ++c;
            }
            matrix.setState(i, 0, (Integer)gains);
            matrix.setState(i, 1, (Integer)losses);
            matrix.setState(i, 2, (Integer)(gains - losses));
            ++i;
        }
        return matrix;
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        return this._gain_loss_matrix;
    }

    private List<GenomeWideCombinableDomains> getGenomeWideCombinableDomainsList() {
        return this._gwcd_list;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getInternalStatesMatrix() {
        return this._binary_internal_states_matrix;
    }

    public int getNetGainsOnNode(String node_identifier) {
        if (this.getGainLossMatrix() == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        int net = 0;
        int id_index = this.getGainLossMatrix().getIdentifierIndex(node_identifier);
        int c = 0;
        while (c < this.getGainLossMatrix().getNumberOfCharacters()) {
            if (this.getGainLossMatrix().getState(id_index, c) == CharacterStateMatrix.GainLossStates.GAIN) {
                ++net;
            } else if (this.getGainLossMatrix().getState(id_index, c) == CharacterStateMatrix.GainLossStates.LOSS) {
                --net;
            }
            ++c;
        }
        return net;
    }

    private Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    private SortedSet<DomainId> getPositiveFilter() {
        return this._positive_filter;
    }

    public int getSumOfGainsOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN);
    }

    public int getSumOfLossesOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS);
    }

    public int getSumOfPresentOnNode(String node_identifier) {
        return this.getSumOfGainsOnNode(node_identifier) + this.getSumOfUnchangedPresentOnNode(node_identifier);
    }

    int getSumOfUnchangedAbsentOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT);
    }

    int getSumOfUnchangedOnNode(String node_identifier) {
        return this.getSumOfUnchangedPresentOnNode(node_identifier) + this.getSumOfUnchangedAbsentOnNode(node_identifier);
    }

    int getSumOfUnchangedPresentOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT);
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    public SortedSet<String> getUnitsGainedOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN);
    }

    public SortedSet<String> getUnitsLostOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS);
    }

    public SortedSet<String> getUnitsOnNode(String node_identifier) {
        SortedSet<String> present = this.getUnitsGainedOnNode(node_identifier);
        present.addAll(this.getUnitsUnchangedPresentOnNode(node_identifier));
        return present;
    }

    SortedSet<String> getUnitsUnchangedAbsentOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT);
    }

    SortedSet<String> getUnitsUnchangedPresentOnNode(String node_identifier) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(node_identifier, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT);
    }

    private void init() {
        this.setDomainIdToSecondaryFeaturesMap(null);
        this.setPositiveFilter(null);
        this.reset();
    }

    private void reset() {
        this.setGainLossMatrix(null);
        this.setBinaryInternalStatesMatrix(null);
        this.setCost(-1);
        this.setTotalGains(-1);
        this.setTotalLosses(-1);
        this.setTotalUnchanged(-1);
    }

    private void setBinaryInternalStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> binary_states_matrix) {
        this._binary_internal_states_matrix = binary_states_matrix;
    }

    private void setCost(int cost) {
        this._cost = cost;
    }

    private void setDomainIdToSecondaryFeaturesMap(Map<DomainId, Set<String>> domain_id_to_secondary_features_map) {
        this._domain_id_to_secondary_features_map = domain_id_to_secondary_features_map;
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gain_loss_matrix) {
        this._gain_loss_matrix = gain_loss_matrix;
    }

    private void setPositiveFilter(SortedSet<DomainId> positive_filter) {
        this._positive_filter = positive_filter;
    }

    private void setTotalGains(int total_gains) {
        this._total_gains = total_gains;
    }

    private void setTotalLosses(int total_losses) {
        this._total_losses = total_losses;
    }

    private void setTotalUnchanged(int total_unchanged) {
        this._total_unchanged = total_unchanged;
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny) {
        return new DomainParsimonyCalculator(phylogeny);
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny, List<GenomeWideCombinableDomains> gwcd_list) {
        if (phylogeny.getNumberOfExternalNodes() != gwcd_list.size()) {
            throw new IllegalArgumentException("number of external nodes [" + phylogeny.getNumberOfExternalNodes() + "] does not equal size of genome wide combinable domains list [" + gwcd_list.size() + "]");
        }
        return new DomainParsimonyCalculator(phylogeny, gwcd_list);
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny, List<GenomeWideCombinableDomains> gwcd_list, Map<DomainId, Set<String>> domain_id_to_secondary_features_map) {
        if (phylogeny.getNumberOfExternalNodes() != gwcd_list.size()) {
            throw new IllegalArgumentException("size of external nodes does not equal size of genome wide combinable domains list");
        }
        return new DomainParsimonyCalculator(phylogeny, gwcd_list, domain_id_to_secondary_features_map);
    }

    public static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfBinaryDomainCombinationPresenceOrAbsence(List<GenomeWideCombinableDomains> gwcd_list) {
        if (gwcd_list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        int number_of_identifiers = gwcd_list.size();
        TreeSet<BinaryDomainCombination> all_binary_combinations = new TreeSet<BinaryDomainCombination>();
        HashSet[] binary_combinations_per_genome = new HashSet[number_of_identifiers];
        int identifier_index = 0;
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            binary_combinations_per_genome[identifier_index] = new HashSet();
            for (BinaryDomainCombination bc : gwcd.toBinaryDomainCombinations()) {
                all_binary_combinations.add(bc);
                binary_combinations_per_genome[identifier_index].add(bc);
            }
            ++identifier_index;
        }
        int number_of_characters = all_binary_combinations.size();
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(number_of_identifiers, number_of_characters);
        int character_index = 0;
        for (BinaryDomainCombination bc : all_binary_combinations) {
            matrix.setCharacter(character_index++, bc.toString());
        }
        identifier_index = 0;
        HashSet<String> all_identifiers = new HashSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            String species_id = gwcd.getSpecies().getSpeciesId();
            if (all_identifiers.contains(species_id)) {
                throw new AssertionError((Object)("species [" + species_id + "] is not unique"));
            }
            all_identifiers.add(species_id);
            matrix.setIdentifier(identifier_index, species_id);
            int ci = 0;
            while (ci < matrix.getNumberOfCharacters()) {
                BinaryDomainCombination bc = null;
                bc = gwcd.getDomainCombinationType() == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? AdjactantDirectedBinaryDomainCombination.createInstance(matrix.getCharacter(ci)) : (gwcd.getDomainCombinationType() == BinaryDomainCombination.DomainCombinationType.DIRECTED ? DirectedBinaryDomainCombination.createInstance(matrix.getCharacter(ci)) : BasicBinaryDomainCombination.createInstance(matrix.getCharacter(ci)));
                if (binary_combinations_per_genome[identifier_index].contains(bc)) {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.PRESENT);
                } else {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.ABSENT);
                }
                ++ci;
            }
            ++identifier_index;
        }
        return matrix;
    }

    static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence(List<GenomeWideCombinableDomains> gwcd_list) {
        return DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(gwcd_list, null);
    }

    public static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence(List<GenomeWideCombinableDomains> gwcd_list, SortedSet<DomainId> positive_filter) {
        if (gwcd_list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        if (positive_filter != null && positive_filter.size() < 1) {
            throw new IllegalArgumentException("positive filter is empty");
        }
        int number_of_identifiers = gwcd_list.size();
        TreeSet<DomainId> all_domain_ids = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            for (DomainId domain : gwcd.getAllDomainIds()) {
                all_domain_ids.add(domain);
            }
        }
        int number_of_characters = all_domain_ids.size();
        if (positive_filter != null) {
            number_of_characters = positive_filter.size();
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(number_of_identifiers, number_of_characters);
        int character_index = 0;
        for (DomainId id : all_domain_ids) {
            if (positive_filter == null) {
                matrix.setCharacter(character_index++, id.getId());
                continue;
            }
            if (!positive_filter.contains(id)) continue;
            matrix.setCharacter(character_index++, id.getId());
        }
        int identifier_index = 0;
        HashSet<String> all_identifiers = new HashSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            String species_id = gwcd.getSpecies().getSpeciesId();
            if (all_identifiers.contains(species_id)) {
                throw new IllegalArgumentException("species [" + species_id + "] is not unique");
            }
            all_identifiers.add(species_id);
            matrix.setIdentifier(identifier_index, species_id);
            int ci = 0;
            while (ci < matrix.getNumberOfCharacters()) {
                if (ForesterUtil.isEmpty(matrix.getCharacter(ci))) {
                    throw new IllegalArgumentException("problem with character #" + ci + ", possibly using domain(s) in positive filter not present in the genomes analyzed");
                }
                DomainId id = new DomainId(matrix.getCharacter(ci));
                if (gwcd.contains(id)) {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.PRESENT);
                } else {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.ABSENT);
                }
                ++ci;
            }
            ++identifier_index;
        }
        return matrix;
    }

    static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfSecondaryFeaturePresenceOrAbsence(List<GenomeWideCombinableDomains> gwcd_list, Map<DomainId, Set<String>> domain_id_to_second_features_map, Map<Species, MappingResults> mapping_results_map) {
        if (gwcd_list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        if (domain_id_to_second_features_map == null || domain_id_to_second_features_map.isEmpty()) {
            throw new IllegalArgumentException("domain id to secondary features map is null or empty");
        }
        int number_of_identifiers = gwcd_list.size();
        TreeSet all_secondary_features = new TreeSet();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            int mapped = 0;
            int not_mapped = 0;
            for (DomainId domain : gwcd.getAllDomainIds()) {
                if (domain_id_to_second_features_map.containsKey(domain)) {
                    all_secondary_features.addAll(domain_id_to_second_features_map.get(domain));
                    ++mapped;
                    continue;
                }
                ++not_mapped;
            }
            if (mapping_results_map == null) continue;
            MappingResults mr = new MappingResults();
            mr.setDescription(gwcd.getSpecies().getSpeciesId());
            mr.setSumOfSuccesses(mapped);
            mr.setSumOfFailures(not_mapped);
            mapping_results_map.put(gwcd.getSpecies(), mr);
        }
        int number_of_characters = all_secondary_features.size();
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(number_of_identifiers, number_of_characters);
        int character_index = 0;
        for (String second_id : all_secondary_features) {
            matrix.setCharacter(character_index++, second_id);
        }
        int identifier_index = 0;
        HashSet<String> all_identifiers = new HashSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            String species_id = gwcd.getSpecies().getSpeciesId();
            if (all_identifiers.contains(species_id)) {
                throw new IllegalArgumentException("species [" + species_id + "] is not unique");
            }
            all_identifiers.add(species_id);
            matrix.setIdentifier(identifier_index, species_id);
            HashSet all_second_per_gwcd = new HashSet();
            for (DomainId domain : gwcd.getAllDomainIds()) {
                if (!domain_id_to_second_features_map.containsKey(domain)) continue;
                all_second_per_gwcd.addAll(domain_id_to_second_features_map.get(domain));
            }
            int ci = 0;
            while (ci < matrix.getNumberOfCharacters()) {
                if (all_second_per_gwcd.contains(matrix.getCharacter(ci))) {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.PRESENT);
                } else {
                    matrix.setState(identifier_index, ci, CharacterStateMatrix.BinaryStates.ABSENT);
                }
                ++ci;
            }
            ++identifier_index;
        }
        return matrix;
    }

    private static int getStateSumDeltaOnNode(String node_identifier, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gain_loss_matrix, CharacterStateMatrix.GainLossStates state) {
        if (gain_loss_matrix == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        if (ForesterUtil.isEmpty(node_identifier)) {
            throw new IllegalArgumentException("node identifier must not be empty");
        }
        if (gain_loss_matrix.isEmpty()) {
            throw new IllegalStateException("gain loss matrix is empty");
        }
        int sum = 0;
        int id_index = gain_loss_matrix.getIdentifierIndex(node_identifier);
        int c = 0;
        while (c < gain_loss_matrix.getNumberOfCharacters()) {
            if (gain_loss_matrix.getState(id_index, c) == state) {
                ++sum;
            }
            ++c;
        }
        return sum;
    }

    private static SortedSet<String> getUnitsDeltaOnNode(String node_identifier, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gain_loss_matrix, CharacterStateMatrix.GainLossStates state) {
        if (gain_loss_matrix == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        if (ForesterUtil.isEmpty(node_identifier)) {
            throw new IllegalArgumentException("node identifier must not be empty");
        }
        if (gain_loss_matrix.isEmpty()) {
            throw new IllegalStateException("gain loss matrix is empty");
        }
        TreeSet<String> d = new TreeSet<String>();
        int id_index = gain_loss_matrix.getIdentifierIndex(node_identifier);
        int c = 0;
        while (c < gain_loss_matrix.getNumberOfCharacters()) {
            if (gain_loss_matrix.getState(id_index, c) == state) {
                if (d.contains(gain_loss_matrix.getCharacter(c))) {
                    throw new AssertionError((Object)("this should not have happended: character [" + gain_loss_matrix.getCharacter(c) + "] already in set"));
                }
                d.add(gain_loss_matrix.getCharacter(c));
            }
            ++c;
        }
        return d;
    }
}

