/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.ShapeProducer;

public class AWTPathProducer
implements PathHandler,
ShapeProducer {
    protected ExtendedGeneralPath path;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    protected int windingRule;

    public static Shape createShape(Reader reader, int n) throws IOException, ParseException {
        PathParser pathParser = new PathParser();
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(n);
        pathParser.setPathHandler(aWTPathProducer);
        pathParser.parse(reader);
        return aWTPathProducer.getShape();
    }

    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public Shape getShape() {
        return this.path;
    }

    public void startPath() throws ParseException {
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(this.windingRule);
    }

    public void endPath() throws ParseException {
    }

    public void movetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    public void movetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    public void closePath() throws ParseException {
        this.path.closePath();
        Point2D point2D = this.path.getCurrentPoint();
        this.currentX = (float)point2D.getX();
        this.currentY = (float)point2D.getY();
    }

    public void linetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    public void linetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    public void linetoHorizontalRel(float f) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    public void linetoHorizontalAbs(float f) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    public void linetoVerticalRel(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY += f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    public void linetoVerticalAbs(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY = f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    public void curvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = this.currentX + f3;
        this.yCenter = this.currentY + f4;
        this.path.curveTo(this.currentX + f, this.currentY + f2, this.xCenter, this.yCenter, this.currentX += f5, this.currentY += f6);
    }

    public void curvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = f3;
        this.yCenter = f4;
        this.currentX = f5;
        this.currentY = f6;
        this.path.curveTo(f, f2, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoCubicSmoothRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    public void curvetoCubicSmoothAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoQuadraticRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    public void curvetoQuadraticAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoQuadraticSmoothRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f, this.currentY += f2);
    }

    public void curvetoQuadraticSmoothAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.currentX = f;
        this.currentY = f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void arcRel(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX += f4;
        this.yCenter = this.currentY += f5;
        this.path.arcTo((double)f, (double)f2, (double)f3, bl, bl2, (double)this.currentX, (double)this.currentY);
    }

    public void arcAbs(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX = f4;
        this.yCenter = this.currentY = f5;
        this.path.arcTo((double)f, (double)f2, (double)f3, bl, bl2, (double)this.currentX, (double)this.currentY);
    }
}

