/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class AddReferenceAlleleToHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(AddReferenceAlleleToHDF5Plugin.class);
    private ArgsEngine myArgsEngine = null;
    private String inHDF5FileName = null;
    private String refGenomeFileStr = null;
    private String genomeVersion = null;
    private BufferedReader refReader = null;
    private PositionListBuilder newPosListBuilder = null;
    private int currChr = Integer.MIN_VALUE;
    private int currPos = Integer.MIN_VALUE;
    private String contextSeq;
    private final boolean writePositions = false;

    public AddReferenceAlleleToHDF5Plugin() {
        super(null, false);
    }

    public AddReferenceAlleleToHDF5Plugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)"\n\nThe options for the TASSEL5 AddReferenceAlleleToHDF5Plugin are as follows:\n  -i    Input HDF5 genotype (*.h5) file to be annotated with the reference allele.\n  -ref  Path to reference genome in fasta format.\n  -ver  Genome version.\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-file", true);
            this.myArgsEngine.add("-ref", "--referenceGenome", true);
            this.myArgsEngine.add("-ver", "--genome-version", true);
        }
        this.myArgsEngine.parse(args);
        this.inHDF5FileName = this.myArgsEngine.getString("-i");
        File inFile = null;
        if (this.inHDF5FileName != null) {
            inFile = new File(this.inHDF5FileName);
            if (!inFile.exists()) {
                this.printUsage();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String errMessage = "\nThe input HDF5 genotype (*.h5) file name you supplied does not exist:\n" + this.inHDF5FileName + "\n\n";
                myLogger.error((Object)errMessage);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                throw new IllegalArgumentException(errMessage);
            }
        } else {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String errMessage = "\nPlease specify an input HDF5 genotype (*.h5) file to be annotated with the reference allele (-i option)\n\n";
            myLogger.error((Object)errMessage);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException(errMessage);
        }
        if (this.myArgsEngine.getBoolean("-ref")) {
            this.refGenomeFileStr = this.myArgsEngine.getString("-ref");
            File refGenomeFile = new File(this.refGenomeFileStr);
            if (!refGenomeFile.exists() || !refGenomeFile.isFile()) {
                this.printUsage();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String errMessage = "\nCan't find the reference genome fasta file specified by the -ref option:\n  " + this.refGenomeFileStr + "\n\n";
                myLogger.error((Object)errMessage);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                throw new IllegalArgumentException();
            }
        } else {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String errMessage = "\nPlease specify a reference genome fasta file (-ref option)\n\n";
            myLogger.error((Object)errMessage);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException(errMessage);
        }
        this.refReader = Utils.getBufferedReader(this.refGenomeFileStr);
        if (!this.myArgsEngine.getBoolean("-ver")) {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String errMessage = "\nPlease specify the name of the reference genome version (e.g. -ver \"B73 RefGen_v2\")\n\n";
            myLogger.error((Object)errMessage);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException(errMessage);
        }
        this.genomeVersion = this.myArgsEngine.getString("-ver");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        String message = this.addRefAlleleToHDF5GenoTable();
        if (message != null) {
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new IllegalStateException(message);
        }
        try {
            this.refReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fireProgress(100);
        return null;
    }

    private String addRefAlleleToHDF5GenoTable() {
        String message = this.populatePositionsWithRefAllele();
        if (message != null) {
            return message;
        }
        PositionList newPos = this.newPosListBuilder.build();
        String genomeVer = newPos.hasReference() ? newPos.genomeVersion() : "unknown";
        myLogger.info((Object)("\nGenome version: " + genomeVer + "\n"));
        String outHDF5FileName = this.inHDF5FileName.replaceFirst("\\.h5$", "_withRef.h5");
        GenotypeTableBuilder newGenos = GenotypeTableBuilder.getTaxaIncremental(newPos, outHDF5FileName);
        IHDF5Writer h5Reader = HDF5Factory.open((String)this.inHDF5FileName);
        List<String> taxaNames = HDF5Utils.getAllTaxaNames((IHDF5Reader)h5Reader);
        int nTaxaWritten = 0;
        for (String taxonName : taxaNames) {
            Taxon taxon = HDF5Utils.getTaxon((IHDF5Reader)h5Reader, taxonName);
            byte[] genos = HDF5Utils.getHDF5GenotypesCalls((IHDF5Reader)h5Reader, taxonName);
            byte[][] depth = HDF5Utils.getHDF5GenotypesDepth((IHDF5Reader)h5Reader, taxonName);
            newGenos.addTaxon(taxon, genos, depth);
            if (++nTaxaWritten % 100 != 0) continue;
            myLogger.info((Object)("...finished writing genotypes and depth for " + nTaxaWritten + " taxa "));
        }
        newGenos.build();
        myLogger.info((Object)"\n\nFinished adding reference alleles to file:");
        myLogger.info((Object)("  " + outHDF5FileName + "\n\n"));
        return null;
    }

    private String populatePositionsWithRefAllele() {
        IHDF5Writer h5Writer = HDF5Factory.open((String)this.inHDF5FileName);
        PositionList oldPosList = PositionListBuilder.getInstance((IHDF5Reader)h5Writer);
        this.newPosListBuilder = new PositionListBuilder();
        for (Position oldPos : oldPosList) {
            byte strand;
            int pos;
            int chr = oldPos.getChromosome().getChromosomeNumber();
            byte refAllele = this.retrieveRefAllele(chr, pos = oldPos.getPosition(), strand = oldPos.getStrand());
            if (refAllele == -128) {
                return "\nCould not find position " + pos + " on chromosome " + chr + " in the reference genome fasta file.\n\n\n";
            }
            GeneralPosition newPos = new GeneralPosition.Builder(oldPos).allele(WHICH_ALLELE.Reference, refAllele).build();
            this.newPosListBuilder.add(newPos);
        }
        this.newPosListBuilder.genomeVersion(this.genomeVersion);
        myLogger.info((Object)"Finished populating positions with RefAllele");
        return null;
    }

    private byte retrieveRefAllele(int chr, int pos, int strand) {
        this.findChrInRefGenomeFile(chr);
        char currChar = this.findPositionInRefGenomeFile(pos);
        if (this.currPos == pos) {
            byte refAllele = NucleotideAlignmentConstants.getNucleotideAlleleByte(currChar);
            if (strand == -1) {
                refAllele = NucleotideAlignmentConstants.getNucleotideComplement(refAllele);
            }
            return refAllele;
        }
        myLogger.warn((Object)("currPos:" + this.currPos));
        return -128;
    }

    private void findChrInRefGenomeFile(int chr) {
        String temp = "Nothing has been read from the reference genome fasta file yet";
        try {
            while (this.refReader.ready() && this.currChr < chr) {
                temp = this.refReader.readLine().trim();
                if (temp.startsWith(">")) {
                    String chrS = temp.replace(">", "");
                    chrS = chrS.replace("chr", "");
                    try {
                        this.currChr = Integer.parseInt(chrS);
                    }
                    catch (NumberFormatException e) {
                        myLogger.error((Object)("\n\nAddReferenceAlleleToHDF5Plugin detected a non-numeric chromosome name in the reference genome sequence fasta file: " + chrS + "\n\nPlease change the FASTA headers in your reference genome sequence to integers " + "(>1, >2, >3, etc.) OR to 'chr' followed by an integer (>chr1, >chr2, >chr3, etc.)\n\n"));
                        System.exit(1);
                    }
                    myLogger.info((Object)("\nCurrently reading chromosome " + this.currChr + " from reference genome fasta file\n\n"));
                }
                this.currPos = 0;
            }
        }
        catch (IOException e) {
            myLogger.error((Object)("Exception caught while reading the reference genome fasta file:\n  " + e + "\nLast line read:\n  " + temp));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException iE) {
                // empty catch block
            }
            e.printStackTrace();
            System.exit(1);
        }
        if (this.currChr != chr) {
            myLogger.error((Object)("\nCould not find chromosome " + chr + " in the reference genome fasta file.\nMake sure that the chromosomes are in numerical order in that file\n\n\n"));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private char findPositionInRefGenomeFile(int pos) {
        char currChar = '\uffff';
        this.contextSeq = "";
        try {
            while (this.currPos < pos) {
                int intChar = this.refReader.read();
                if (intChar == -1) {
                    this.currPos = Integer.MAX_VALUE;
                    return '\uffff';
                }
                currChar = (char)intChar;
                if (Character.isWhitespace(currChar)) continue;
                ++this.currPos;
                if (pos - this.currPos >= 60) continue;
                this.contextSeq = this.contextSeq + currChar;
            }
        }
        catch (IOException e) {
            myLogger.error((Object)("\n\nError reading reference genome file:\n  " + e + "\n\n"));
            System.exit(1);
        }
        return currChar;
    }

    private void writePosition(Position pos, String contextSeq) {
        myLogger.info((Object)(pos.getSNPID() + "\t" + pos.getChromosome().getChromosomeNumber() + "\t" + pos.getPosition() + "\t" + pos.getStrand() + "\t" + pos.getAllele(WHICH_ALLELE.GlobalMajor) + "\t" + pos.getAllele(WHICH_ALLELE.GlobalMinor) + "\t" + pos.getAllele(WHICH_ALLELE.Reference) + "\t" + pos.getGlobalMAF() + "\t" + pos.getGlobalSiteCoverage() + "\t" + contextSeq));
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Add reference allele";
    }

    @Override
    public String getToolTipText() {
        return "Add reference allele to HDF5 genotypes";
    }
}

