/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.dna.snp.genotypecall.GenotypeMergeRule;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class MergeGenotypeTablesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeGenotypeTablesPlugin.class);

    public MergeGenotypeTablesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        List<Datum> inputs = input.getDataOfType(GenotypeTable.class);
        if (inputs == null || inputs.size() < 2) {
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Must select at least two alignments.");
            } else {
                myLogger.warn((Object)"performFunction: Must select at least two alignments.");
            }
            return null;
        }
        try {
            GenotypeTable[] alignments = new GenotypeTable[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                alignments[i] = (GenotypeTable)inputs.get(i).getData();
            }
            GenotypeTable merged = MergeGenotypeTablesPlugin.mergeGenotypeTables(alignments);
            DataSet result = new DataSet(new Datum("Merged Genotype Table", merged, null), (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(result, MergeGenotypeTablesPlugin.class));
            DataSet dataSet = result;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MergeGenotypeTablesPlugin.class.getResource("/net/maizegenetics/analysis/images/Merge.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Merge Genotype Tables";
    }

    @Override
    public String getToolTipText() {
        return "Merge Genotype Tables";
    }

    public static GenotypeTable mergeGenotypeTables(GenotypeTable[] alignments) {
        if (alignments == null || alignments.length == 0) {
            return null;
        }
        TaxaList masterTaxa = MergeGenotypeTablesPlugin.generateMasterTaxaList(alignments);
        PositionList masterPos = MergeGenotypeTablesPlugin.generateMasterPositionList(alignments);
        myLogger.info((Object)"Creating helper data structures (to speed merging)");
        HashMap[] taxaHashes = MergeGenotypeTablesPlugin.makeTaxaHashes(alignments);
        HashMap[] posHashes = MergeGenotypeTablesPlugin.makePositionHashes(alignments);
        double errorRate = 0.01;
        myLogger.info((Object)("Merging genotype calls with assumed error rate " + errorRate));
        BasicGenotypeMergeRule mergeRule = new BasicGenotypeMergeRule(errorRate);
        GenotypeTableBuilder genoBuilder = GenotypeTableBuilder.getTaxaIncremental(masterPos, (GenotypeMergeRule)mergeRule);
        for (Taxon t : masterTaxa) {
            byte[] taxonCalls = new byte[masterPos.size()];
            for (int i_pos = 0; i_pos < masterPos.size(); ++i_pos) {
                Position p = (Position)masterPos.get(i_pos);
                ArrayList<Byte> callList = new ArrayList<Byte>(alignments.length);
                for (int i_align = 0; i_align < alignments.length; ++i_align) {
                    int sitenum;
                    int taxonnum;
                    byte genotype;
                    GenotypeTable a = alignments[i_align];
                    if (!taxaHashes[i_align].containsKey(t) || !posHashes[i_align].containsKey(p) || (genotype = a.genotype(taxonnum = ((Integer)taxaHashes[i_align].get(t)).intValue(), sitenum = ((Integer)posHashes[i_align].get(p)).intValue())) == -1) continue;
                    callList.add(genotype);
                }
                Byte[] calls = callList.toArray(new Byte[0]);
                taxonCalls[i_pos] = MergeGenotypeTablesPlugin.mergeCalls(calls);
            }
            genoBuilder.addTaxon(t, taxonCalls);
        }
        myLogger.info((Object)("Finalizing genotype table with " + masterTaxa.size() + " taxa and " + masterPos.size() + "sites"));
        GenotypeTable genos = genoBuilder.build();
        return genos;
    }

    public static TaxaList generateMasterTaxaList(GenotypeTable[] alignments) {
        myLogger.info((Object)"Creating unified taxa list");
        HashSet<Taxon> taxaSet = new HashSet<Taxon>();
        for (GenotypeTable a : alignments) {
            taxaSet.addAll(a.taxa());
        }
        Object[] taxaArray = taxaSet.toArray(new Taxon[0]);
        Arrays.sort(taxaArray);
        TaxaListBuilder taxaBuilder = new TaxaListBuilder();
        taxaBuilder.addAll((Taxon[])taxaArray);
        return taxaBuilder.build();
    }

    public static PositionList generateMasterPositionList(GenotypeTable[] alignments) {
        myLogger.info((Object)"Creating unified position list");
        HashSet<Position> posSet = new HashSet<Position>();
        for (GenotypeTable a : alignments) {
            posSet.addAll(a.positions());
        }
        PositionListBuilder posBuilder = new PositionListBuilder();
        posBuilder.addAll(posSet);
        return posBuilder.build();
    }

    public static HashMap[] makeTaxaHashes(GenotypeTable[] alignments) {
        HashMap[] taxaHashes = new HashMap[alignments.length];
        for (int i = 0; i < alignments.length; ++i) {
            taxaHashes[i] = new HashMap();
            GenotypeTable a = alignments[i];
            Taxon[] taxaArray = a.taxa().toArray(new Taxon[0]);
            for (int t = 0; t < taxaArray.length; ++t) {
                taxaHashes[i].put(taxaArray[t], t);
            }
        }
        return taxaHashes;
    }

    public static HashMap[] makePositionHashes(GenotypeTable[] alignments) {
        HashMap[] posHashes = new HashMap[alignments.length];
        for (int i = 0; i < alignments.length; ++i) {
            posHashes[i] = new HashMap();
            GenotypeTable a = alignments[i];
            Position[] posArray = a.positions().toArray(new Position[0]);
            for (int t = 0; t < posArray.length; ++t) {
                posHashes[i].put(posArray[t], t);
            }
        }
        return posHashes;
    }

    public static byte mergeCalls(Byte[] calls) {
        if (calls.length > 0) {
            return calls[calls.length - 1];
        }
        return -1;
    }
}

