/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.CustomSNPLog;
import net.maizegenetics.analysis.gbs.CustomSNPLogRecord;
import net.maizegenetics.analysis.gbs.TagLocusSiteQualityScores;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagLocus;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteFileMap;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;
import org.biojava3.core.util.ConcurrencyTools;

public class DiscoverySNPCallerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DiscoverySNPCallerPlugin.class);
    private PluginParameter<String> myInputTagsByTaxa = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Tags by Taxa File").required(true).inFile().description("Input TagsByTaxa file (if hdf5 format, use .hdf or .h5 extension)").build();
    private PluginParameter<Boolean> myUseByteFormat = new PluginParameter.Builder<Boolean>("y", Boolean.valueOf(false), Boolean.class).guiName("Use Byte Format").description("Use byte format TagsByTaxa file (*.tbt.byte)").build();
    private PluginParameter<String> myInputTOPM = new PluginParameter.Builder<String>("m", null, String.class).guiName("Input TOPM File").required(true).inFile().description("TagsOnPhysicalMap (TOPM) file containing genomic positions of tags").build();
    private PluginParameter<String> myOutputTOPM = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output TOPM File").required(true).outFile().description("Output TagsOnPhysicalMap (TOPM) file with allele calls (variants) added (for use with ProductionSNPCallerPlugin").build();
    private PluginParameter<String> myLogFile = new PluginParameter.Builder<String>("log", null, String.class).guiName("Log File").outFile().description("TagLocus log file name. (Default: TagLocusLog.txt)").build();
    private PluginParameter<Double> myMinF = new PluginParameter.Builder<Double>("mnF", Double.valueOf(-2.0), Double.class).guiName("Minimum F").description("Minimum F (inbreeding coefficient)").build();
    private PluginParameter<String> myPedigreeFile = new PluginParameter.Builder<String>("p", null, String.class).guiName("Pedigree File").inFile().description("Pedigree file containing full sample names (or expected names after merging) & expected inbreeding coefficient (F) for each.  Only taxa with expected F >= mnF used to calculate F = 1-Ho/He. (default: use ALL taxa to calculate F").build();
    private PluginParameter<Double> myMinMinorAlleleFreq = new PluginParameter.Builder<Double>("mnMAF", Double.valueOf(0.01), Double.class).guiName("Min Minor Allele Freq").description("Minimum minor allele frequency").build();
    private PluginParameter<Integer> myMinMinorAlleleCount = new PluginParameter.Builder<Integer>("mnMAC", Integer.valueOf(10), Integer.class).guiName("Min Minor Allele Count").description("Minimum minor allele count").build();
    private PluginParameter<Double> myMinLocusCoverage = new PluginParameter.Builder<Double>("mnLCov", Double.valueOf(0.1), Double.class).guiName("Min Locus Coverage").description("Minimum locus coverage (proportion of Taxa with a genotype)").build();
    private PluginParameter<Double> myAveSeqErrorRate = new PluginParameter.Builder<Double>("eR", Double.valueOf(0.01), Double.class).guiName("Ave Seq Error Rate").description("Average sequencing error rate per base (used to decide between heterozygous and homozygous calls)").build();
    private PluginParameter<String> myRefGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").inFile().description("Path to reference genome in fasta format. Ensures that a tag from the reference genome is always included when the tags at a locus are aligned against each other to call SNPs. The reference allele for each site is then provided in the output HapMap files, under the taxon name \"REFERENCE_GENOME\" (first taxon). DEFAULT: Don't use reference genome.").build();
    private PluginParameter<Integer> myStartChr = new PluginParameter.Builder<Integer>("sC", null, Integer.class).guiName("Start Chromosome").required(true).description("Start Chromosome").build();
    private PluginParameter<Integer> myEndChr = new PluginParameter.Builder<Integer>("eC", null, Integer.class).guiName("End Chromosome").required(true).description("End Chromosome").build();
    private PluginParameter<Boolean> myIncludeRareAlleles = new PluginParameter.Builder<Boolean>("inclRare", Boolean.valueOf(false), Boolean.class).guiName("Include Rare Alleles").description("Include the rare alleles at site (3 or 4th states)").build();
    private PluginParameter<Boolean> myIncludeGaps = new PluginParameter.Builder<Boolean>("inclGaps", Boolean.valueOf(false), Boolean.class).guiName("Include Gaps").description("Include sites where major or minor allele is a GAP").build();
    private PluginParameter<Boolean> myCallBiSNPsWGap = new PluginParameter.Builder<Boolean>("callBiSNPsWGap", Boolean.valueOf(false), Boolean.class).guiName("Call Biallelic SNPs with Gap").description("Include sites where the third allele is a GAP (mutually exclusive with inclGaps)").build();
    private TagsOnPhysicalMap theTOPM = null;
    private TagsByTaxa theTBT = null;
    private boolean usePedigree = false;
    private HashMap<String, Double> taxaFs = null;
    private boolean[] useTaxaForMinF = null;
    private int nInbredTaxa = Integer.MIN_VALUE;
    private int minTaxaWithLocus;
    private boolean includeReference = false;
    private long[] refGenomeChr = null;
    private boolean fuzzyStartPositions = false;
    private int locusBorder = 0;
    private static final int CHR = 0;
    private static final int STRAND = 1;
    private static final int START_POS = 2;
    private boolean customSNPLogging = true;
    private CustomSNPLog myCustomSNPLog = null;
    private boolean customFiltering = false;

    public DiscoverySNPCallerPlugin() {
        super(null, false);
    }

    public DiscoverySNPCallerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        myLogger.info((Object)("Finding SNPs in " + this.inputTagsByTaxaFile() + "."));
        myLogger.info((Object)String.format("StartChr:%d EndChr:%d %n", this.startChromosome(), this.endChromosome()));
        this.theTOPM.sortTable(true);
        myLogger.info((Object)"\nAs a check, here are the first 5 tags in the TOPM (sorted by position):");
        this.theTOPM.printRows(5, true, true);
        DataOutputStream locusLogDOS = this.openLocusLog(this.logFile());
        if (this.customSNPLogging) {
            this.myCustomSNPLog = new CustomSNPLog(this.logFile());
        }
        for (int chr = this.startChromosome().intValue(); chr <= this.endChromosome(); ++chr) {
            myLogger.info((Object)("\n\nProcessing chromosome " + chr + "..."));
            if (this.includeReference) {
                this.refGenomeChr = this.readReferenceGenomeChr(this.referenceGenomeFile(), chr);
                if (this.refGenomeChr == null) {
                    myLogger.info((Object)("  WARNING: chromosome " + chr + " not found in the reference genome file. Skipping this chromosome."));
                    continue;
                }
            }
            this.discoverSNPsOnChromosome(chr, locusLogDOS);
            myLogger.info((Object)("Finished processing chromosome " + chr + "\n\n"));
        }
        if (this.outputTOPMFile().endsWith(".txt")) {
            this.theTOPM.writeTextFile(new File(this.outputTOPMFile()));
        } else {
            this.theTOPM.writeBinaryFile(new File(this.outputTOPMFile()));
        }
        try {
            locusLogDOS.close();
        }
        catch (Exception e) {
            this.catchLocusLogException(e);
        }
        if (this.customSNPLogging) {
            this.myCustomSNPLog.close();
        }
        ConcurrencyTools.shutdown();
        return null;
    }

    @Override
    public void postProcessParameters() {
        if (this.myInputTagsByTaxa.isEmpty()) {
            throw new IllegalArgumentException("DiscoverySNPCallerPlugin: postProcessParameters: Input Tags by Taxa File not Set.");
        }
        if (this.inputTagsByTaxaFile().endsWith(".hdf") || this.inputTagsByTaxaFile().endsWith(".h5")) {
            this.theTBT = new TagsByTaxaByteHDF5TagGroups(this.inputTagsByTaxaFile());
        } else if (this.useByteFormat().booleanValue()) {
            this.theTBT = new TagsByTaxaByteFileMap(this.inputTagsByTaxaFile());
        }
        boolean loadBinary = !this.inputTOPMFile().endsWith(".txt");
        this.theTOPM = new TagsOnPhysicalMap(this.inputTOPMFile(), loadBinary);
        if (this.myLogFile.isEmpty()) {
            try {
                File outDir = new File(this.outputTOPMFile()).getCanonicalFile().getParentFile();
                this.logFile(outDir.getCanonicalPath() + File.separator + "TagLocusLog.txt");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem creating the tagLocusLog file. Program aborted: " + e);
            }
        }
        if (!this.myPedigreeFile.isEmpty()) {
            this.taxaFs = DiscoverySNPCallerPlugin.readTaxaFsFromFile(new File(this.pedigreeFile()));
            if (this.taxaFs == null) {
                throw new IllegalArgumentException("Problem reading the pedigree file. Progam aborted.");
            }
            if (!this.maskNonInbredTaxa()) {
                throw new IllegalArgumentException("Mismatch between taxa names in the pedigree file and TBT. Progam aborted.");
            }
            this.usePedigree = true;
        }
        this.minTaxaWithLocus = (int)Math.round((double)this.theTBT.getTaxaCount() * this.minLocusCoverage());
        if (!this.myRefGenome.isEmpty()) {
            this.includeReference = true;
        }
        if (this.callBiallelicSNPsWithGap().booleanValue() && this.includeGaps().booleanValue()) {
            throw new IllegalArgumentException("The callBiSNPsWGap option is mutually exclusive with the inclGaps option.");
        }
        if (this.endChromosome() - this.startChromosome() < 0) {
            throw new IllegalArgumentException("The start chromosome is larger than the end chromosome.");
        }
        myLogger.info((Object)String.format("minTaxaWithLocus:%d MinF:%g MinMAF:%g MinMAC:%d %n", this.minTaxaWithLocus, this.minimumF(), this.minMinorAlleleFreq(), this.minMinorAlleleCount()));
        myLogger.info((Object)String.format("includeRare:%s includeGaps:%s %n", this.includeRareAlleles(), this.includeGaps()));
    }

    public String inputTagsByTaxaFile() {
        return this.myInputTagsByTaxa.value();
    }

    public DiscoverySNPCallerPlugin inputTagsByTaxaFile(String value) {
        this.myInputTagsByTaxa = new PluginParameter<String>(this.myInputTagsByTaxa, value);
        return this;
    }

    public Boolean useByteFormat() {
        return this.myUseByteFormat.value();
    }

    public DiscoverySNPCallerPlugin useByteFormat(Boolean value) {
        this.myUseByteFormat = new PluginParameter<Boolean>(this.myUseByteFormat, value);
        return this;
    }

    public String inputTOPMFile() {
        return this.myInputTOPM.value();
    }

    public DiscoverySNPCallerPlugin inputTOPMFile(String value) {
        this.myInputTOPM = new PluginParameter<String>(this.myInputTOPM, value);
        return this;
    }

    public String outputTOPMFile() {
        return this.myOutputTOPM.value();
    }

    public DiscoverySNPCallerPlugin outputTOPMFile(String value) {
        this.myOutputTOPM = new PluginParameter<String>(this.myOutputTOPM, value);
        return this;
    }

    public String logFile() {
        return this.myLogFile.value();
    }

    public DiscoverySNPCallerPlugin logFile(String value) {
        this.myLogFile = new PluginParameter<String>(this.myLogFile, value);
        return this;
    }

    public Double minimumF() {
        return this.myMinF.value();
    }

    public DiscoverySNPCallerPlugin minimumF(Double value) {
        this.myMinF = new PluginParameter<Double>(this.myMinF, value);
        return this;
    }

    public String pedigreeFile() {
        return this.myPedigreeFile.value();
    }

    public DiscoverySNPCallerPlugin pedigreeFile(String value) {
        this.myPedigreeFile = new PluginParameter<String>(this.myPedigreeFile, value);
        return this;
    }

    public Double minMinorAlleleFreq() {
        return this.myMinMinorAlleleFreq.value();
    }

    public DiscoverySNPCallerPlugin minMinorAlleleFreq(Double value) {
        this.myMinMinorAlleleFreq = new PluginParameter<Double>(this.myMinMinorAlleleFreq, value);
        return this;
    }

    public Integer minMinorAlleleCount() {
        return this.myMinMinorAlleleCount.value();
    }

    public DiscoverySNPCallerPlugin minMinorAlleleCount(Integer value) {
        this.myMinMinorAlleleCount = new PluginParameter<Integer>(this.myMinMinorAlleleCount, value);
        return this;
    }

    public Double minLocusCoverage() {
        return this.myMinLocusCoverage.value();
    }

    public DiscoverySNPCallerPlugin minLocusCoverage(Double value) {
        this.myMinLocusCoverage = new PluginParameter<Double>(this.myMinLocusCoverage, value);
        return this;
    }

    public Double aveSeqErrorRate() {
        return this.myAveSeqErrorRate.value();
    }

    public DiscoverySNPCallerPlugin aveSeqErrorRate(Double value) {
        this.myAveSeqErrorRate = new PluginParameter<Double>(this.myAveSeqErrorRate, value);
        return this;
    }

    public String referenceGenomeFile() {
        return this.myRefGenome.value();
    }

    public DiscoverySNPCallerPlugin referenceGenomeFile(String value) {
        this.myRefGenome = new PluginParameter<String>(this.myRefGenome, value);
        return this;
    }

    public Boolean includeRareAlleles() {
        return this.myIncludeRareAlleles.value();
    }

    public DiscoverySNPCallerPlugin includeRareAlleles(Boolean value) {
        this.myIncludeRareAlleles = new PluginParameter<Boolean>(this.myIncludeRareAlleles, value);
        return this;
    }

    public Boolean includeGaps() {
        return this.myIncludeGaps.value();
    }

    public DiscoverySNPCallerPlugin includeGaps(Boolean value) {
        this.myIncludeGaps = new PluginParameter<Boolean>(this.myIncludeGaps, value);
        return this;
    }

    public Boolean callBiallelicSNPsWithGap() {
        return this.myCallBiSNPsWGap.value();
    }

    public DiscoverySNPCallerPlugin callBiallelicSNPsWithGap(Boolean value) {
        this.myCallBiSNPsWGap = new PluginParameter<Boolean>(this.myCallBiSNPsWGap, value);
        return this;
    }

    public Integer startChromosome() {
        return this.myStartChr.value();
    }

    public DiscoverySNPCallerPlugin startChromosome(Integer value) {
        this.myStartChr = new PluginParameter<Integer>(this.myStartChr, value);
        return this;
    }

    public Integer endChromosome() {
        return this.myEndChr.value();
    }

    public DiscoverySNPCallerPlugin endChromosome(Integer value) {
        this.myEndChr = new PluginParameter<Integer>(this.myEndChr, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Discovery SNP Caller";
    }

    @Override
    public String getToolTipText() {
        return "Discovery SNP Caller";
    }

    public void discoverSNPsOnChromosome(int targetChromo, DataOutputStream locusLogDOS) {
        long time = System.currentTimeMillis();
        TagLocus currTAL = new TagLocus(Integer.MIN_VALUE, -128, Integer.MIN_VALUE, Integer.MIN_VALUE, this.includeReference, this.fuzzyStartPositions, this.aveSeqErrorRate());
        int[] currPos = null;
        int countLoci = 0;
        int siteCnt = 0;
        for (int i = 0; i < this.theTOPM.getSize(); ++i) {
            int ri = this.theTOPM.getReadIndexForPositionIndex(i);
            int[] newPos = this.theTOPM.getPositionArray(ri);
            if (newPos[0] != targetChromo) continue;
            if (this.fuzzyStartPositions && this.nearbyTag(newPos, currPos) || Arrays.equals(newPos, currPos)) {
                currTAL.addTag(ri, this.theTOPM, this.theTBT, this.includeReference, this.fuzzyStartPositions);
                continue;
            }
            int nTaxaCovered = currTAL.getNumberTaxaCovered();
            if (currTAL.getSize() > 1 && nTaxaCovered >= this.minTaxaWithLocus) {
                ++countLoci;
                if ((siteCnt += this.findSNPsInTagLocus(currTAL, locusLogDOS)) % 100 == 0) {
                    double rate = (double)siteCnt / (double)(System.currentTimeMillis() - time);
                    myLogger.info((Object)String.format("Chr:%d Pos:%d Loci=%d SNPs=%d rate=%g SNP/millisec", currPos[0], currPos[2], countLoci, siteCnt, rate));
                }
            } else if (currPos != null) {
                this.logRejectedTagLocus(currTAL, locusLogDOS);
            }
            if ((currPos = newPos)[1] != -128 && currPos[2] != Integer.MIN_VALUE) {
                currTAL = new TagLocus(currPos[0], (byte)currPos[1], currPos[2], this.theTOPM.getTagLength(ri), this.includeReference, this.fuzzyStartPositions, this.aveSeqErrorRate());
                currTAL.addTag(ri, this.theTOPM, this.theTBT, this.includeReference, this.fuzzyStartPositions);
                continue;
            }
            currPos = null;
        }
        if (currTAL.getSize() > 1 && currTAL.getNumberTaxaCovered() >= this.minTaxaWithLocus) {
            this.findSNPsInTagLocus(currTAL, locusLogDOS);
        } else if (currPos != null) {
            this.logRejectedTagLocus(currTAL, locusLogDOS);
        }
        myLogger.info((Object)("Number of marker sites recorded for chr" + targetChromo + ": " + siteCnt));
    }

    boolean nearbyTag(int[] newTagPos, int[] currTagPos) {
        if (newTagPos == null || currTagPos == null) {
            return false;
        }
        if (newTagPos[0] == currTagPos[0] && newTagPos[2] - currTagPos[2] < this.locusBorder) {
            currTagPos[2] = newTagPos[2];
            return true;
        }
        return false;
    }

    private synchronized int findSNPsInTagLocus(TagLocus theTAL, DataOutputStream locusLogDOS) {
        byte[][] callsBySite;
        boolean refTagUsed = false;
        if (theTAL.getSize() < 2) {
            this.logRejectedTagLocus(theTAL, locusLogDOS);
            return 0;
        }
        if (this.includeReference) {
            if (this.fuzzyStartPositions) {
                String refSeqInRegion = this.getRefSeqInRegion(theTAL);
                callsBySite = theTAL.getSNPCallsQuant(refSeqInRegion, (boolean)this.callBiallelicSNPsWithGap());
            } else {
                this.addRefTag(theTAL);
                refTagUsed = true;
                callsBySite = theTAL.getSNPCallsQuant(this.callBiallelicSNPsWithGap(), this.includeReference);
            }
        } else {
            callsBySite = theTAL.getSNPCallsQuant(this.callBiallelicSNPsWithGap(), this.includeReference);
        }
        if (callsBySite == null) {
            this.logAcceptedTagLocus(theTAL.getLocusReport(this.minTaxaWithLocus, null), locusLogDOS);
            return 0;
        }
        int[] positionsInLocus = theTAL.getPositionsOfVariableSites();
        byte strand = theTAL.getStrand();
        boolean[] varSiteKept = new boolean[callsBySite.length];
        TagLocusSiteQualityScores SiteQualityScores = new TagLocusSiteQualityScores(callsBySite.length);
        for (int s = 0; s < callsBySite.length; ++s) {
            int position;
            byte[] alleles = null;
            alleles = this.isSiteGood(callsBySite[s]);
            if (alleles == null || this.includeReference && !this.fuzzyStartPositions && theTAL.getRefGeno(s) == 85) continue;
            int n = position = strand == -1 ? theTAL.getMinStartPosition() - positionsInLocus[s] : theTAL.getMinStartPosition() + positionsInLocus[s];
            if (this.customSNPLogging) {
                CustomSNPLogRecord mySNPLogRecord = new CustomSNPLogRecord(s, theTAL, position, this.useTaxaForMinF, refTagUsed);
                this.myCustomSNPLog.writeEntry(mySNPLogRecord.toString());
                SiteQualityScores.addSite(s, mySNPLogRecord.getInbredCoverage(), mySNPLogRecord.getInbredHetScore(), alleles, position);
                if (this.customFiltering && !mySNPLogRecord.isGoodSNP()) continue;
            }
            varSiteKept[s] = true;
            if (this.customFiltering) continue;
            this.updateTOPM(theTAL, s, position, strand, alleles);
        }
        this.logAcceptedTagLocus(theTAL.getLocusReport(this.minTaxaWithLocus, varSiteKept), locusLogDOS);
        if (this.customFiltering) {
            this.updateTOPM(theTAL, varSiteKept, SiteQualityScores);
        }
        return callsBySite.length;
    }

    private void updateTOPM(TagLocus myTAL, boolean[] varSiteKept, TagLocusSiteQualityScores SiteQualityScores) {
        SiteQualityScores.sortByQuality();
        byte strand = myTAL.getStrand();
        for (int s = 0; s < SiteQualityScores.getSize(); ++s) {
            int siteInTAL = SiteQualityScores.getSiteInTAL(s);
            if (!varSiteKept[siteInTAL]) continue;
            this.updateTOPM(myTAL, siteInTAL, SiteQualityScores.getPosition(s), strand, SiteQualityScores.getAlleles(s));
        }
    }

    private void updateTOPM(TagLocus myTAL, int variableSite, int position, int strand, byte[] alleles) {
        for (int tg = 0; tg < myTAL.getSize(); ++tg) {
            int topmTagIndex = myTAL.getTOPMIndexOfTag(tg);
            if (topmTagIndex == Integer.MIN_VALUE) continue;
            byte baseToAdd = myTAL.getCallAtVariableSiteForTag(variableSite, tg);
            boolean matched = false;
            for (byte cb : alleles) {
                if (baseToAdd != cb) continue;
                matched = true;
                break;
            }
            byte offset = (byte)(position - myTAL.getMinStartPosition());
            if (!matched) {
                baseToAdd = -1;
            }
            if (strand == -1) {
                baseToAdd = NucleotideAlignmentConstants.getNucleotideComplement(baseToAdd);
            }
            baseToAdd = DiscoverySNPCallerPlugin.getIUPACAllele(baseToAdd);
            this.theTOPM.addVariant(topmTagIndex, offset, baseToAdd);
        }
    }

    private byte[] isSiteGood(byte[] calls) {
        double obsF;
        int[][] allelesByFreq = GenotypeTableUtils.getAllelesSortedByFrequency(calls);
        if (allelesByFreq[0].length < 2) {
            return null;
        }
        int aCnt = allelesByFreq[1][0] + allelesByFreq[1][1];
        double theMAF = (double)allelesByFreq[1][1] / (double)aCnt;
        if (theMAF < this.minMinorAlleleFreq() && allelesByFreq[1][1] < this.minMinorAlleleCount()) {
            return null;
        }
        byte majAllele = (byte)allelesByFreq[0][0];
        byte minAllele = (byte)allelesByFreq[0][1];
        if (!(this.includeGaps().booleanValue() || majAllele != 5 && minAllele != 5)) {
            return null;
        }
        byte homMaj = (byte)(majAllele << 4 | majAllele);
        byte homMin = (byte)(minAllele << 4 | minAllele);
        byte hetG1 = GenotypeTableUtils.getDiploidValue(majAllele, minAllele);
        byte hetG2 = GenotypeTableUtils.getDiploidValue(minAllele, majAllele);
        if (this.minimumF() > -1.0 && (obsF = this.calculateF(calls, allelesByFreq, hetG1, hetG2, theMAF)) < this.minimumF()) {
            return null;
        }
        return this.getGoodAlleles(calls, allelesByFreq, homMaj, homMin, hetG1, hetG2, majAllele, minAllele);
    }

    private double calculateF(byte[] calls, int[][] alleles, byte hetG1, byte hetG2, double theMAF) {
        boolean report = false;
        int hetGCnt = 0;
        if (this.usePedigree) {
            byte[] callsToUse = this.filterCallsForInbreds(calls);
            int[][] allelesToUse = GenotypeTableUtils.getAllelesSortedByFrequency(callsToUse);
            if (allelesToUse[0].length < 2) {
                return 1.0;
            }
            int aCnt = allelesToUse[1][0] + allelesToUse[1][1];
            double newMAF = (double)allelesToUse[1][1] / (double)aCnt;
            if (newMAF <= 0.0) {
                return 1.0;
            }
            byte majAllele = (byte)allelesToUse[0][0];
            byte minAllele = (byte)allelesToUse[0][1];
            byte newHetG1 = GenotypeTableUtils.getDiploidValue(majAllele, minAllele);
            byte newHetG2 = GenotypeTableUtils.getDiploidValue(minAllele, majAllele);
            for (byte i : callsToUse) {
                if (i != newHetG1 && i != newHetG2) continue;
                ++hetGCnt;
            }
            int majGCnt = (allelesToUse[1][0] - hetGCnt) / 2;
            int minGCnt = (allelesToUse[1][1] - hetGCnt) / 2;
            double propHets = (double)hetGCnt / (double)(hetGCnt + majGCnt + minGCnt);
            double expHets = 2.0 * newMAF * (1.0 - newMAF);
            double obsF = 1.0 - propHets / expHets;
            if (report) {
                System.out.printf("%d %d %d propHets:%g expHets:%g obsF:%g %n", majGCnt, minGCnt, hetGCnt, propHets, expHets, obsF);
            }
            return obsF;
        }
        for (byte i : calls) {
            if (i != hetG1 && i != hetG2) continue;
            ++hetGCnt;
        }
        int majGCnt = (alleles[1][0] - hetGCnt) / 2;
        int minGCnt = (alleles[1][1] - hetGCnt) / 2;
        double propHets = (double)hetGCnt / (double)(hetGCnt + majGCnt + minGCnt);
        double expHets = 2.0 * theMAF * (1.0 - theMAF);
        double obsF = 1.0 - propHets / expHets;
        if (report) {
            System.out.printf("%d %d %d propHets:%g expHets:%g obsF:%g %n", majGCnt, minGCnt, hetGCnt, propHets, expHets, obsF);
        }
        return obsF;
    }

    private byte[] getGoodAlleles(byte[] calls, int[][] allelesByFreq, byte homMaj, byte homMin, byte hetG1, byte hetG2, byte majAllele, byte minAllele) {
        if (this.includeRareAlleles().booleanValue()) {
            byte[] byteAlleles = new byte[allelesByFreq[0].length];
            for (int a = 0; a < allelesByFreq[0].length; ++a) {
                byteAlleles[a] = (byte)allelesByFreq[0][a];
            }
            return byteAlleles;
        }
        this.setBadCallsToMissing(calls, homMaj, homMin, hetG1, hetG2, majAllele, minAllele);
        allelesByFreq = GenotypeTableUtils.getAllelesSortedByFrequency(calls);
        if (allelesByFreq[0].length < 2) {
            return null;
        }
        if (allelesByFreq[0].length == 2) {
            return this.getMajMinAllelesOnly(allelesByFreq);
        }
        if (this.callBiallelicSNPsWithGap().booleanValue()) {
            boolean hasGap = false;
            for (int a = 2; a < allelesByFreq[0].length; ++a) {
                if ((byte)allelesByFreq[0][a] != 5) continue;
                hasGap = true;
                break;
            }
            if (hasGap) {
                byte[] byteAlleles = new byte[]{(byte)allelesByFreq[0][0], (byte)allelesByFreq[0][1], 5};
                return byteAlleles;
            }
            return this.getMajMinAllelesOnly(allelesByFreq);
        }
        return this.getMajMinAllelesOnly(allelesByFreq);
    }

    private byte[] getMajMinAllelesOnly(int[][] alleles) {
        byte[] byteAlleles = new byte[]{(byte)alleles[0][0], (byte)alleles[0][1]};
        return byteAlleles;
    }

    private void setBadCallsToMissing(byte[] calls, byte homMaj, byte homMin, byte hetG1, byte hetG2, byte majAllele, byte minAllele) {
        if (this.callBiallelicSNPsWithGap().booleanValue()) {
            for (int i = 0; i < calls.length; ++i) {
                if (this.isGoodBiallelicWithGapCall(calls[i], homMaj, homMin, hetG1, hetG2, majAllele, minAllele)) continue;
                calls[i] = -1;
            }
        } else {
            for (int i = 0; i < calls.length; ++i) {
                if (calls[i] == homMaj || calls[i] == homMin || calls[i] == hetG1 || calls[i] == hetG2) continue;
                calls[i] = -1;
            }
        }
    }

    private boolean isGoodBiallelicWithGapCall(byte call, byte homMaj, byte homMin, byte hetG1, byte hetG2, byte majAllele, byte minAllele) {
        if (call == homMaj) {
            return true;
        }
        if (call == homMin) {
            return true;
        }
        if (call == hetG1) {
            return true;
        }
        if (call == hetG2) {
            return true;
        }
        if (call == GenotypeTableUtils.getDiploidValue(majAllele, (byte)5)) {
            return true;
        }
        if (call == GenotypeTableUtils.getDiploidValue((byte)5, majAllele)) {
            return true;
        }
        if (call == GenotypeTableUtils.getDiploidValue(minAllele, (byte)5)) {
            return true;
        }
        if (call == GenotypeTableUtils.getDiploidValue((byte)5, minAllele)) {
            return true;
        }
        return call == 85;
    }

    private DataOutputStream openLocusLog(String logFileName) {
        try {
            DataOutputStream locusLogDOS = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(logFileName)), 65536));
            locusLogDOS.writeBytes("chr\tstart\tend\tstrand\ttotalbp\tnTags\tnReads\tnTaxaCovered\tminTaxaCovered\tstatus\tnVariableSites\tposVariableSites\tnVarSitesKept\tposVarSitesKept\trefTag?\tmaxTagLen\tminTagLen\n");
            return locusLogDOS;
        }
        catch (Exception e) {
            this.catchLocusLogException(e);
            return null;
        }
    }

    private void logRejectedTagLocus(TagLocus currTAL, DataOutputStream locusLogDOS) {
        String refTag;
        String status;
        int start;
        int end;
        if (currTAL.getStrand() == -1) {
            end = currTAL.getMinStartPosition();
            start = currTAL.getMinStartPosition() - currTAL.getMaxTagLength() + 1;
        } else {
            start = currTAL.getMinStartPosition();
            end = currTAL.getMinStartPosition() + currTAL.getMaxTagLength() - 1;
        }
        int totalbp = end - start + 1;
        if (currTAL.getSize() == 1) {
            status = "invariant\t0";
            refTag = currTAL.getDivergenceOfTag(0) == 0 ? "1" : "0";
        } else {
            status = "tooFewTaxa\tNA";
            boolean refTagFound = false;
            int t = -1;
            while (!refTagFound && t < currTAL.getSize() - 1) {
                if (currTAL.getDivergenceOfTag(++t) != 0) continue;
                refTagFound = true;
            }
            refTag = refTagFound ? "1" : "0";
        }
        try {
            locusLogDOS.writeBytes(currTAL.getChromosome() + "\t" + start + "\t" + end + "\t" + currTAL.getStrand() + "\t" + totalbp + "\t" + currTAL.getSize() + "\t" + currTAL.getTotalNReads() + "\t" + currTAL.getNumberTaxaCovered() + "\t" + this.minTaxaWithLocus + "\t" + status + "\t" + "NA" + "\t" + "0" + "\t" + "NA" + "\t" + refTag + "\t" + currTAL.getMaxTagLength() + "\t" + currTAL.getMinTagLength() + "\n");
        }
        catch (Exception e) {
            this.catchLocusLogException(e);
        }
    }

    private void logAcceptedTagLocus(String locusLogRecord, DataOutputStream locusLogDOS) {
        try {
            locusLogDOS.writeBytes(locusLogRecord);
        }
        catch (Exception e) {
            this.catchLocusLogException(e);
        }
    }

    private void catchLocusLogException(Exception e) {
        System.out.println("ERROR: Unable to write to locus log file: " + e);
        e.printStackTrace();
        System.exit(1);
    }

    private byte[] filterCallsForInbreds(byte[] calls) {
        byte[] callsForInbredsOnly = new byte[this.nInbredTaxa];
        int inbred = 0;
        for (int taxon = 0; taxon < calls.length; ++taxon) {
            if (!this.useTaxaForMinF[taxon]) continue;
            callsForInbredsOnly[inbred] = calls[taxon];
            ++inbred;
        }
        return callsForInbredsOnly;
    }

    public static HashMap<String, Double> readTaxaFsFromFile(File pedigreeFile) {
        int nTaxa;
        HashMap<String, Double> taxaFs;
        block8: {
            taxaFs = new HashMap<String, Double>();
            String inputLine = "Nothing has been read from the pedigree input file yet";
            int nameCol = -1;
            int fCol = -1;
            nTaxa = 0;
            try {
                BufferedReader br = new BufferedReader(new FileReader(pedigreeFile), 65536);
                inputLine = br.readLine();
                String[] cells = inputLine.split("\t");
                for (int col = 0; col < cells.length; ++col) {
                    if (cells[col].equalsIgnoreCase("Name")) {
                        nameCol = col;
                    }
                    if (!cells[col].equalsIgnoreCase("F")) continue;
                    fCol = col;
                }
                if (nameCol > -1 && fCol > -1) {
                    while ((inputLine = br.readLine()) != null) {
                        cells = inputLine.split("\t");
                        if (cells[fCol].equals("NA")) {
                            taxaFs.put(cells[nameCol], -2.0);
                        } else {
                            taxaFs.put(cells[nameCol], Double.parseDouble(cells[fCol]));
                        }
                        ++nTaxa;
                    }
                    break block8;
                }
                throw new Exception("Name and/or F column not found in header");
            }
            catch (Exception e) {
                myLogger.error((Object)("Catch in reading pedigree file e=" + e));
                e.printStackTrace();
                System.out.println(inputLine);
                return null;
            }
        }
        myLogger.info((Object)(nTaxa + " taxa read from the pedigree file"));
        return taxaFs;
    }

    private boolean maskNonInbredTaxa() {
        this.useTaxaForMinF = new boolean[this.theTBT.getTaxaCount()];
        this.nInbredTaxa = 0;
        try {
            for (int taxon = 0; taxon < this.theTBT.getTaxaCount(); ++taxon) {
                if (this.taxaFs.containsKey(this.theTBT.getTaxaName(taxon))) {
                    if (!(this.taxaFs.get(this.theTBT.getTaxaName(taxon)) >= this.minimumF())) continue;
                    this.useTaxaForMinF[taxon] = true;
                    ++this.nInbredTaxa;
                    continue;
                }
                throw new Exception("Taxon " + this.theTBT.getTaxaName(taxon) + " not found in the pedigree file");
            }
            myLogger.info((Object)(this.nInbredTaxa + " taxa with an Expected F >= the mnF of " + this.minimumF() + " were found in the input TBT"));
            return true;
        }
        catch (Exception e) {
            myLogger.error((Object)("Mismatch between TBT and pedigree file e=" + e));
            e.printStackTrace();
            return false;
        }
    }

    private long[] readReferenceGenomeChr(String inFileStr, int targetChr) {
        int nBases = this.getLengthOfReferenceGenomeChr(inFileStr, targetChr);
        if (nBases == 0) {
            return null;
        }
        int basesPerLong = 32;
        int nLongs = nBases % basesPerLong == 0 ? nBases / basesPerLong : nBases / basesPerLong + 1;
        long[] refGenomeChrAsLongs = new long[nLongs];
        myLogger.info((Object)("\n\nReading in the target chromosome " + targetChr + " from the reference genome fasta file: " + inFileStr));
        String temp = "Nothing has been read yet from the reference genome fasta file";
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(inFileStr)));
            StringBuilder currStrB = new StringBuilder();
            int currChr = Integer.MIN_VALUE;
            int chunk = 0;
            while (br.ready()) {
                temp = br.readLine().trim();
                if (temp.startsWith(">")) {
                    if (chunk > 0) break;
                    String chrS = temp.replace(">", "");
                    chrS = chrS.replace("chr", "");
                    currChr = Integer.parseInt(chrS);
                    myLogger.info((Object)("Currently reading chromosome " + currChr + " (target chromosome = " + targetChr + ")"));
                    continue;
                }
                if (currChr != targetChr) continue;
                currStrB.append(temp.replace("N", "A"));
                while (currStrB.length() >= basesPerLong) {
                    refGenomeChrAsLongs[chunk] = BaseEncoder.getLongFromSeq(currStrB.substring(0, basesPerLong));
                    StringBuilder stringBuilder = currStrB = currStrB.length() > basesPerLong ? new StringBuilder(currStrB.substring(basesPerLong)) : new StringBuilder();
                    if (++chunk % 1000000 != 0) continue;
                    myLogger.info((Object)(chunk + " chunks of " + basesPerLong + " bases read from the reference genome fasta file for chromosome " + targetChr));
                }
            }
            if (currStrB.length() > 0) {
                refGenomeChrAsLongs[chunk] = BaseEncoder.getLongFromSeq(currStrB.toString());
                ++chunk;
            }
            myLogger.info((Object)("\n\nFinished reading target chromosome " + targetChr + " into a total of " + chunk + " " + basesPerLong + "bp chunks\n\n"));
            if (chunk != nLongs) {
                throw new Exception("The number of 32 base chunks read (" + chunk + ") was not equal to the expected number (" + nLongs + ")");
            }
            br.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Exception caught while reading the reference genome fasta file at line.  Error=" + e));
            e.printStackTrace();
            System.exit(1);
        }
        return refGenomeChrAsLongs;
    }

    private int getLengthOfReferenceGenomeChr(String inFileStr, int targetChr) {
        myLogger.info((Object)("\n\nDetermining the length (in bases) of target chromosome " + targetChr + " in the reference genome fasta file: " + inFileStr));
        String temp = "Nothing has been read yet from the reference genome fasta file";
        int line = 0;
        int nBases = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(inFileStr)));
            int currChr = Integer.MIN_VALUE;
            while (br.ready()) {
                temp = br.readLine().trim();
                if (++line % 1000000 == 0) {
                    myLogger.info((Object)(line + " lines read from the reference genome fasta file"));
                }
                if (temp.startsWith(">")) {
                    if (nBases > 0) break;
                    String chrS = temp.replace(">", "");
                    chrS = chrS.replace("chr", "");
                    try {
                        currChr = Integer.parseInt(chrS);
                    }
                    catch (NumberFormatException e) {
                        myLogger.error((Object)("\n\nTagsToSNPByAlignment detected a non-numeric chromosome name in the reference genome sequence fasta file: " + chrS + "\n\nPlease change the FASTA headers in your reference genome sequence to integers " + "(>1, >2, >3, etc.) OR to 'chr' followed by an integer (>chr1, >chr2, >chr3, etc.)\n\n"));
                        System.exit(1);
                    }
                    myLogger.info((Object)("Currently reading chromosome " + currChr + " (target chromosome = " + targetChr + ")"));
                    continue;
                }
                if (currChr != targetChr) continue;
                nBases += temp.length();
            }
            if (nBases == 0) {
                throw new Exception("Target chromosome (" + targetChr + ") not found");
            }
            myLogger.info((Object)("The target chromosome " + targetChr + " is " + nBases + " bases long"));
            br.close();
        }
        catch (Exception e) {
            if (nBases == 0) {
                myLogger.warn((Object)("Exception caught while reading the reference genome fasta file at line " + line + "\n   e=" + e + "\n   Skipping this chromosome..."));
            }
            myLogger.error((Object)("Exception caught while reading the reference genome fasta file at line " + line + "\n   e=" + e));
            e.printStackTrace();
            System.exit(1);
        }
        return nBases;
    }

    private String getRefSeqInRegion(TagLocus theTAL) {
        int basesPerLong = 32;
        int refSeqStartPosition = theTAL.getMinStartPosition() - 128;
        int startIndex = Math.max(refSeqStartPosition / basesPerLong - 1, 0);
        int refSeqEndPosition = theTAL.getMaxStartPosition() + 128;
        int endIndex = Math.min(refSeqEndPosition / basesPerLong + 1, this.refGenomeChr.length - 1);
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= endIndex; ++i) {
            sb.append(BaseEncoder.getSequenceFromLong(this.refGenomeChr[i]));
        }
        theTAL.setMinStartPosition(startIndex * basesPerLong + 1);
        return sb.toString();
    }

    private void addRefTag(TagLocus theTAL) {
        int refSeqStartPos;
        int refSeqEndPos;
        int basesPerLong = 32;
        if (theTAL.getStrand() == -1) {
            refSeqEndPos = theTAL.getMinStartPosition();
            refSeqStartPos = refSeqEndPos - theTAL.getMaxTagLength() + 1;
        } else {
            refSeqStartPos = theTAL.getMinStartPosition();
            refSeqEndPos = refSeqStartPos + theTAL.getMaxTagLength() - 1;
        }
        int startIndex = Math.max(refSeqStartPos / basesPerLong - 1, 0);
        int endIndex = Math.min(refSeqEndPos / basesPerLong, this.refGenomeChr.length - 1);
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= endIndex; ++i) {
            sb.append(BaseEncoder.getSequenceFromLong(this.refGenomeChr[i]));
        }
        String refTag = sb.substring(Math.max(refSeqStartPos - startIndex * basesPerLong - 1, 0), Math.min(refSeqStartPos - startIndex * basesPerLong - 1 + theTAL.getMaxTagLength(), sb.length()));
        if (theTAL.getStrand() == -1) {
            refTag = DiscoverySNPCallerPlugin.revComplement(refTag);
        }
        theTAL.addRefTag(refTag, this.theTOPM.getTagSizeInLong(), this.theTOPM.getNullTag());
    }

    public static byte getIUPACAllele(byte allele) {
        byte iupacAllele = 78;
        switch (allele) {
            case 0: {
                iupacAllele = 65;
                break;
            }
            case 1: {
                iupacAllele = 67;
                break;
            }
            case 2: {
                iupacAllele = 71;
                break;
            }
            case 3: {
                iupacAllele = 84;
                break;
            }
            case 5: {
                iupacAllele = 45;
                break;
            }
            default: {
                iupacAllele = 78;
            }
        }
        return iupacAllele;
    }

    public static String revComplement(String seq) {
        StringBuilder sb = new StringBuilder();
        for (int i = seq.length() - 1; i >= 0; --i) {
            sb.append(NucleotideAlignmentConstants.getNucleotideDiploidIUPACComplement(seq.charAt(i)));
        }
        return sb.toString();
    }
}

