/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FastqToTagCountPlugin2
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FastqToTagCountPlugin2.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library, if it differs from the one listed in the key file").build();
    private PluginParameter<Integer> myMaxGoodReads = new PluginParameter.Builder<Integer>("s", Integer.valueOf(300000000), Integer.class).guiName("Max Good Reads").description("Max good reads per lane").build();
    private PluginParameter<Integer> myMinTagCount = new PluginParameter.Builder<Integer>("c", Integer.valueOf(1), Integer.class).guiName("Min Tag Count").description("Minimum tag count").build();
    private PluginParameter<String> myOutputDir = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output Directory").required(true).outDir().description("Output directory to contain .cnt files (one per FASTQ file (one per FASTQ file)").build();

    public FastqToTagCountPlugin2() {
        super(null, false);
    }

    public FastqToTagCountPlugin2(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        FastqToTagCountPlugin2.countTags(this.myKeyFile.value(), this.myEnzyme.value(), this.myInputDir.value(), this.myOutputDir.value(), this.myMaxGoodReads.value(), this.myMinTagCount.value());
        return null;
    }

    public static void countTags(String keyFileS, String enzyme, String fastqDirectory, String outputDir, int maxGoodReads, int minCount) {
        String[] countFileNames = null;
        File inputDirectory = new File(fastqDirectory);
        File[] fastqFiles = DirectoryCrawler.listFiles("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$", inputDirectory.getAbsolutePath());
        if (fastqFiles.length == 0 || fastqFiles == null) {
            myLogger.warn((Object)"Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", or \"_sequence.txt.gz\" in the supplied directory.");
            return;
        }
        myLogger.info((Object)"Using the following FASTQ files:");
        countFileNames = new String[fastqFiles.length];
        for (int i = 0; i < fastqFiles.length; ++i) {
            countFileNames[i] = fastqFiles[i].getName().replaceAll("(?i)\\.fq$|\\.fq\\.gz$|\\.fastq$|_fastq\\.txt$|_fastq\\.gz$|_fastq\\.txt\\.gz$|_sequence\\.txt$|_sequence\\.txt\\.gz$", ".cnt");
            myLogger.info((Object)fastqFiles[i].getAbsolutePath());
        }
        for (int laneNum = 0; laneNum < fastqFiles.length; ++laneNum) {
            ParseBarcodeRead thePBR;
            File outputFile = new File(outputDir + File.separator + countFileNames[laneNum]);
            if (outputFile.isFile()) {
                myLogger.warn((Object)("An output file " + countFileNames[laneNum] + "\n" + " already exists in the output directory for file " + fastqFiles[laneNum] + ".  Skipping."));
                continue;
            }
            myLogger.info((Object)("Reading FASTQ file: " + fastqFiles[laneNum]));
            String[] filenameField = fastqFiles[laneNum].getName().split("_");
            if (filenameField.length == 3) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[1]);
            } else if (filenameField.length == 4) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[2]);
            } else if (filenameField.length == 5) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[1], filenameField[3]);
            } else {
                myLogger.error((Object)("Error in parsing file name: " + fastqFiles[laneNum]));
                myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
                myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
                continue;
            }
            myLogger.info((Object)("Total barcodes found in lane:" + thePBR.getBarCodeCount()));
            if (thePBR.getBarCodeCount() == 0) {
                myLogger.warn((Object)"No barcodes found.  Skipping this flowcell lane.");
                continue;
            }
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
            }
            int goodBarcodedReads = 0;
            try {
                BufferedReader br = Utils.getBufferedReader(fastqFiles[laneNum], 65536);
                TagCountMutable theTC = null;
                try {
                    theTC = new TagCountMutable(2, maxGoodReads);
                }
                catch (OutOfMemoryError e) {
                    myLogger.error((Object)"Your system doesn't have enough memory to store the number of sequencesyou specified.  Try using a smaller value for the minimum number of reads.");
                    System.exit(1);
                }
                int currLine = 0;
                int allReads = 0;
                goodBarcodedReads = 0;
                String sequence = "";
                String qualityScore = "";
                String temp = br.readLine();
                while (temp != null && goodBarcodedReads < maxGoodReads) {
                    ++currLine;
                    try {
                        if ((currLine + 2) % 4 == 0) {
                            sequence = temp;
                        } else if (currLine % 4 == 0) {
                            qualityScore = temp;
                            ++allReads;
                            ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sequence, qualityScore, true, 0);
                            if (rr != null) {
                                ++goodBarcodedReads;
                                theTC.addReadCount(rr.getRead(), rr.getLength(), 1);
                            }
                            if (allReads % 1000000 == 0) {
                                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads));
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        myLogger.error((Object)("Unable to correctly parse the sequence and: " + sequence + " and quality score: " + qualityScore + " from fastq file.  Your fastq file may have been corrupted."));
                        System.exit(1);
                    }
                    temp = br.readLine();
                }
                myLogger.info((Object)("Total number of reads in lane=" + allReads));
                myLogger.info((Object)("Total number of good barcoded reads=" + goodBarcodedReads));
                myLogger.info((Object)"Timing process (sorting, collapsing, and writing TagCount to file).");
                long timePoint1 = System.currentTimeMillis();
                theTC.collapseCounts();
                theTC.writeTagCountFile(outputDir + File.separator + countFileNames[laneNum], TagsByTaxa.FilePacking.Byte, minCount);
                myLogger.info((Object)("Process took " + (System.currentTimeMillis() - timePoint1) + " milliseconds."));
                br.close();
            }
            catch (Exception e) {
                myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
                e.printStackTrace();
            }
            myLogger.info((Object)("Finished reading " + (laneNum + 1) + " of " + fastqFiles.length + " sequence files."));
        }
    }

    public FastqToTagCountPlugin2 inputDir(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String inputDir() {
        return this.myInputDir.value();
    }

    public FastqToTagCountPlugin2 keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public FastqToTagCountPlugin2 enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public FastqToTagCountPlugin2 maxGoodReads(Integer value) {
        this.myMaxGoodReads = new PluginParameter<Integer>(this.myMaxGoodReads, value);
        return this;
    }

    public Integer maxGoodReads() {
        return this.myMaxGoodReads.value();
    }

    public FastqToTagCountPlugin2 minTagCount(Integer value) {
        this.myMinTagCount = new PluginParameter<Integer>(this.myMinTagCount, value);
        return this;
    }

    public Integer minTagCount() {
        return this.myMinTagCount.value();
    }

    public FastqToTagCountPlugin2 outputDir(String value) {
        this.myOutputDir = new PluginParameter<String>(this.myOutputDir, value);
        return this;
    }

    public String outputDir() {
        return this.myOutputDir.value();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Fastq to Tag Count";
    }

    @Override
    public String getToolTipText() {
        return "Fastq to Tag Count";
    }
}

