/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.Clusters;
import net.maizegenetics.dna.tag.ReadsByTaxa;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteFileMap;
import net.maizegenetics.dna.tag.TagsByTaxaUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class MergeTagsByTaxaFilesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeTagsByTaxaFilesPlugin.class);
    static File inputDirectory = null;
    static File hapmapFile = null;
    static String[] infiles = null;
    static String outfilename = null;
    static ArgsEngine myArgsEngine = null;
    static boolean combineSynonymousTaxa = false;
    static int maxTags = 200000000;

    public MergeTagsByTaxaFilesPlugin() {
        super(null, false);
    }

    public MergeTagsByTaxaFilesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public static final void createMergeOutfile(String[] infiles, String outfile) {
        TagCountMutable theTCM = new TagCountMutable(2, maxTags);
        myLogger.info((Object)("Mutable Tag Count Created.  MaxTags:" + theTCM.getSize()));
        myLogger.info((Object)("CurrentSize:" + theTCM.getCurrentSize()));
        TreeSet<String> allTaxa = new TreeSet<String>();
        int filesRead = 0;
        for (String inName : infiles) {
            myLogger.info((Object)("Scanning " + inName + " (file " + ++filesRead + " of " + infiles.length + ")."));
            TagsByTaxa tbtFM = MergeTagsByTaxaFilesPlugin.newTBT(inName);
            if (combineSynonymousTaxa) {
                tbtFM.truncateTaxonNames();
            }
            theTCM.addReadCounts(tbtFM, 1);
            for (String name : tbtFM.getTaxaNames()) {
                allTaxa.add(name);
            }
            myLogger.info((Object)("CurrentSize:" + theTCM.getCurrentSize()));
            myLogger.info((Object)("Current Taxa:" + allTaxa.size()));
            theTCM.collapseCounts();
            myLogger.info((Object)("CurrentSize:" + theTCM.getCurrentSize()));
            myLogger.info((Object)("Size:" + theTCM.getSize()));
        }
        theTCM.shrinkToCurrentRows();
        myLogger.info((Object)("Size:" + theTCM.getSize()));
        String[] tn = allTaxa.toArray(new String[0]);
        TagsByTaxa tbtOut = MergeTagsByTaxaFilesPlugin.newTBT(outfile, tn, theTCM);
    }

    public static final void fillMergeOutfile(String[] infiles, String outfile) {
        TagsByTaxa tbtOut = MergeTagsByTaxaFilesPlugin.newTBT(outfile);
        tbtOut.setMethodByRows(true);
        int count = 0;
        int filesRead = 0;
        for (String inName : infiles) {
            myLogger.info((Object)("Scanning " + inName + " (file " + ++filesRead + " of " + infiles.length + ")."));
            TagsByTaxa tbtFM = MergeTagsByTaxaFilesPlugin.newTBT(inName);
            if (combineSynonymousTaxa) {
                tbtFM.truncateTaxonNames();
            }
            int[] theTR = MergeTagsByTaxaFilesPlugin.taxaRedirect(tbtFM.getTaxaNames(), tbtOut.getTaxaNames());
            for (int i = 0; i < tbtFM.getTagCount(); ++i) {
                int toTag = tbtOut.getTagIndex(tbtFM.getTag(i));
                if (toTag < 0) continue;
                for (int t = 0; t < tbtFM.getTaxaCount(); ++t) {
                    int tagCount;
                    if (theTR[t] < 0 || (tagCount = tbtOut.getReadCountForTagTaxon(toTag, theTR[t]) + tbtFM.getReadCountForTagTaxon(i, t)) <= 0) continue;
                    tbtOut.setReadCountForTagTaxon(toTag, theTR[t], tagCount);
                    ++count;
                }
                if (count % 100000 != 0) continue;
                System.out.printf("Tag:%d BitSet:%d %n", i, count);
            }
        }
        tbtOut.getFileReadyForClosing();
    }

    public static int[] taxaRedirect(String[] fromNames, String[] toNames) {
        int[] theRedirect = new int[fromNames.length];
        block0: for (int t = 0; t < fromNames.length; ++t) {
            theRedirect[t] = -1;
            for (int i = 0; i < toNames.length; ++i) {
                if (!fromNames[t].equals(toNames[i])) continue;
                theRedirect[t] = i;
                continue block0;
            }
        }
        return theRedirect;
    }

    @Override
    public DataSet performFunction(DataSet input) {
        MergeTagsByTaxaFilesPlugin.createMergeOutfile(infiles, outfilename);
        MergeTagsByTaxaFilesPlugin.fillMergeOutfile(infiles, outfilename);
        if (hapmapFile != null) {
            myLogger.info((Object)"Calling SNPs in good reads.");
            ReadsByTaxa rbt = new ReadsByTaxa();
            rbt.readTBTFile(new File(outfilename));
            Clusters cls = new Clusters(rbt);
            cls.networkFilter();
            cls.alleleFrequencyFileter(rbt, 0.2, 0.3);
            cls.heteozygoteFilter(rbt);
            cls.writeHapMap(rbt, hapmapFile.getAbsolutePath(), 0.9f);
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        myLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        if (args.length == 0) {
            MergeTagsByTaxaFilesPlugin.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (myArgsEngine == null) {
            myArgsEngine = new ArgsEngine();
            myArgsEngine.add("-i", "--input-directory", true);
            myArgsEngine.add("-o", "--output_file", true);
            myArgsEngine.add("-s", "--max_tags", true);
            myArgsEngine.add("-x", "--combine-synonymous-taxa");
            myArgsEngine.add("-h", "--write-hapmap", true);
        }
        myArgsEngine.parse(args);
        if (myArgsEngine.getBoolean("-x")) {
            combineSynonymousTaxa = true;
        }
        if (myArgsEngine.getBoolean("-h")) {
            hapmapFile = new File(myArgsEngine.getString("-h"));
        }
        if (myArgsEngine.getBoolean("-s")) {
            maxTags = Integer.parseInt(myArgsEngine.getString("-s"));
        }
        if (myArgsEngine.getBoolean("-o")) {
            outfilename = myArgsEngine.getString("-o");
            File outfile = new File(outfilename);
            if (outfile.isDirectory()) {
                MergeTagsByTaxaFilesPlugin.printUsage();
                throw new IllegalArgumentException("The output filename you provided is a directory, not a file.");
            }
        } else {
            MergeTagsByTaxaFilesPlugin.printUsage();
            throw new IllegalArgumentException("Please specify an output file.");
        }
        if (myArgsEngine.getBoolean("-i")) {
            inputDirectory = new File(myArgsEngine.getString("-i"));
            if (!inputDirectory.isDirectory()) {
                MergeTagsByTaxaFilesPlugin.printUsage();
                throw new IllegalArgumentException("The input name you supplied is not a directory.");
            }
            infiles = DirectoryCrawler.listFileNames(".*\\.tbt\\.bin|.*\\.tbt\\.byte", inputDirectory.getAbsolutePath());
            myLogger.info((Object)"Merging the following .tbt.bin or .tbt.byte files...");
            for (String filename : infiles) {
                if (!TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxaUtils.format(outfilename))) {
                    myLogger.warn((Object)"Input file extension does not match output file extension.");
                }
                myLogger.info((Object)filename);
            }
        } else {
            MergeTagsByTaxaFilesPlugin.printUsage();
            throw new IllegalArgumentException("You forgot to provide an input directory name.");
        }
        myLogger.info((Object)("...to \"" + outfilename + "\"."));
    }

    private static void printUsage() {
        myLogger.info((Object)("\n\n\nUsage is as follows:\n-i  Input directory containing .tbt.bin or .tbt.byte files\n-o  Output file name\n-s  Maximum number of tags the TBT can hold while merging (default: " + maxTags + ")\n" + "-x  Merge tag counts of taxa with identical names (default: false)\n" + "-h  Call snps in output and write to HapMap file with the provided name\n\n\n"), (Throwable)new IllegalArgumentException());
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "FilterErrorForBiparental";
    }

    @Override
    public String getToolTipText() {
        return "FilterErrorForBiparental";
    }

    private static TagsByTaxa newTBT(String filename, String[] taxonNames, TagCountMutable tcm) {
        if (TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxa.FilePacking.Byte)) {
            return new TagsByTaxaByteFileMap(filename, taxonNames, tcm);
        }
        return null;
    }

    private static TagsByTaxa newTBT(String filename) {
        if (TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxa.FilePacking.Byte)) {
            return new TagsByTaxaByteFileMap(filename);
        }
        return null;
    }
}

