/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.util.ArrayList;
import java.util.Arrays;
import net.maizegenetics.dna.tag.TagCounts;

public class UTagPairFinder {
    TagCounts tc;
    int tagSizeInLong;
    long[] lookup;
    int[] indexOfTc;
    Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            long tl = UTagPairFinder.this.lookup[a];
            UTagPairFinder.this.lookup[a] = UTagPairFinder.this.lookup[b];
            UTagPairFinder.this.lookup[b] = tl;
            int ti = UTagPairFinder.this.indexOfTc[a];
            UTagPairFinder.this.indexOfTc[a] = UTagPairFinder.this.indexOfTc[b];
            UTagPairFinder.this.indexOfTc[b] = ti;
        }
    };
    IntComparator comp = new IntComparator(){

        public int compare(int a, int b) {
            if (UTagPairFinder.this.lookup[a] < UTagPairFinder.this.lookup[b]) {
                return -1;
            }
            if (UTagPairFinder.this.lookup[a] > UTagPairFinder.this.lookup[b]) {
                return 1;
            }
            return 0;
        }
    };

    public UTagPairFinder(TagCounts tc) {
        this.tc = tc;
        this.tagSizeInLong = tc.getTagSizeInLong();
        this.initialize();
    }

    public void initialize() {
        this.lookup = new long[this.tc.getSize() * this.tagSizeInLong];
        this.indexOfTc = new int[this.tc.getSize() * this.tagSizeInLong];
        for (int i = 0; i < this.tc.getSize(); ++i) {
            for (int j = 0; j < this.tagSizeInLong; ++j) {
                int dex = this.tagSizeInLong * i + j;
                this.lookup[dex] = this.tc.getTags()[j][i];
                this.indexOfTc[dex] = i;
            }
        }
        GenericSorting.quickSort((int)0, (int)this.lookup.length, (IntComparator)this.comp, (Swapper)this.swapper);
        this.reduceDuplicates();
        System.out.println("Initialization is done");
    }

    public ArrayList<Integer> findOneMismatch(long[] queryLongSeq) {
        ArrayList<Integer> hitIndex = new ArrayList<Integer>();
        for (int i = 0; i < queryLongSeq.length; ++i) {
            int hit = Arrays.binarySearch(this.lookup, queryLongSeq[i]);
            if (hit < 0) continue;
            while (hit > 0 && queryLongSeq[i] == this.lookup[hit - 1]) {
                --hit;
            }
            while (hit < this.lookup.length && this.lookup[hit] == queryLongSeq[i]) {
                int count = 0;
                for (int j = 0; j < this.tagSizeInLong; ++j) {
                    count += this.getMismatchInLong(queryLongSeq[j], this.tc.getTags()[j][this.indexOfTc[hit]]);
                }
                if (count == 1) {
                    hitIndex.add(this.indexOfTc[hit]);
                }
                ++hit;
            }
        }
        return hitIndex;
    }

    public byte getMismatchInLong(long longSeq1, long longSeq2) {
        long mask = 3L;
        long diff = longSeq1 ^ longSeq2;
        byte count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((diff & mask) > 0L) {
                count = (byte)(count + 1);
            }
            diff >>= 2;
        }
        return count;
    }

    private void reduceDuplicates() {
        int start = 0;
        int end = -1;
        int duplicated = 0;
        long currHap = this.lookup[0];
        for (int i = 0; i < this.lookup.length; ++i) {
            if (this.lookup[i] == currHap) {
                end = i;
                continue;
            }
            if (end - start > 1000) {
                for (int j = start; j <= end; ++j) {
                    this.lookup[j] = Long.MAX_VALUE;
                    ++duplicated;
                }
            }
            currHap = this.lookup[i];
            start = end = i;
        }
        GenericSorting.quickSort((int)0, (int)this.lookup.length, (IntComparator)this.comp, (Swapper)this.swapper);
        long[] newlookup = new long[this.lookup.length - duplicated];
        int[] newindexOfRbt = new int[this.lookup.length - duplicated];
        System.arraycopy(this.lookup, 0, newlookup, 0, this.lookup.length - duplicated);
        System.arraycopy(this.indexOfTc, 0, newindexOfRbt, 0, this.indexOfTc.length - duplicated);
        System.out.println("Old Lookup Size:" + this.lookup.length + "  new size:" + newlookup.length);
        this.lookup = newlookup;
        this.indexOfTc = newindexOfRbt;
    }
}

