/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.maizegenetics.util.GeneralAnnotation;

public class Chromosome
implements Comparable<Chromosome>,
GeneralAnnotation {
    private static final long serialVersionUID = -5197800047652332969L;
    public static Chromosome UNKNOWN = new Chromosome("Unknown");
    private final String myName;
    private final int myChromosomeNumber;
    private final int myLength;
    private final GeneralAnnotation myGA;
    private final int hashCode;
    private static final ConcurrentMap<Chromosome, Chromosome> CHR_HASH = new ConcurrentHashMap<Chromosome, Chromosome>(50);

    public static Chromosome getCanonicalChromosome(Chromosome chr) {
        Chromosome canon;
        if (CHR_HASH.size() > 1000) {
            CHR_HASH.clear();
        }
        return (canon = CHR_HASH.putIfAbsent(chr, chr)) == null ? chr : canon;
    }

    public Chromosome(String name, int length, GeneralAnnotation features) {
        this.myName = name;
        this.myLength = length;
        int convChr = Integer.MAX_VALUE;
        try {
            convChr = Integer.parseInt(name);
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        this.myChromosomeNumber = convChr;
        this.myGA = features;
        this.hashCode = this.calcHashCode();
    }

    public Chromosome(String name) {
        this(name, -1, null);
    }

    public String getName() {
        return this.myName;
    }

    public int getChromosomeNumber() {
        return this.myChromosomeNumber;
    }

    public int getLength() {
        return this.myLength;
    }

    @Override
    public Object[] getAnnotation(String annoName) {
        return this.myGA.getAnnotation(annoName);
    }

    @Override
    public String[] getTextAnnotation(String annoName) {
        return this.myGA.getTextAnnotation(annoName);
    }

    @Override
    public double[] getQuantAnnotation(String annoName) {
        return this.myGA.getQuantAnnotation(annoName);
    }

    @Override
    public String getConsensusAnnotation(String annoName) {
        return this.myGA.getConsensusAnnotation(annoName);
    }

    @Override
    public double getAverageAnnotation(String annoName) {
        return this.myGA.getAverageAnnotation(annoName);
    }

    @Override
    public Map.Entry<String, String>[] getAllAnnotationEntries() {
        return this.myGA.getAllAnnotationEntries();
    }

    @Override
    public SetMultimap<String, String> getAnnotationAsMap() {
        ImmutableSetMultimap.Builder result = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (Map.Entry<String, String> en : this.myGA.getAllAnnotationEntries()) {
            result.put((Object)en.getKey(), (Object)en.getValue());
        }
        return result.build();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calcHashCode() {
        int hash = 7;
        hash = 79 * hash + (this.myName != null ? this.myName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chromosome)) {
            return false;
        }
        return this.compareTo((Chromosome)obj) == 0;
    }

    @Override
    public int compareTo(Chromosome o) {
        int result = this.myChromosomeNumber - o.getChromosomeNumber();
        if (result != 0 || this.myChromosomeNumber != Integer.MAX_VALUE) {
            return result;
        }
        return this.myName.compareTo(o.getName());
    }
}

