/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.ArrayList;
import java.util.Arrays;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.map.SingleTagByTaxa;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.VCFUtil;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.biojava3.alignment.Alignments;
import org.biojava3.alignment.SimpleGapPenalty;
import org.biojava3.alignment.SubstitutionMatrixHelper;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.Profile;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public class TagLocus {
    ArrayList<SingleTagByTaxa> theTags = new ArrayList();
    private int minStartPosition;
    private int maxStartPosition;
    private int minTagLength;
    private int maxTagLength;
    private int chromosome;
    private byte strand;
    private int indexOfRef = Integer.MIN_VALUE;
    private int[] tagIndices = null;
    private int[] positionsOfVariableSites;
    private byte[][] allelesAtVariableSitesByTag;
    private byte[] refCallsBySite = null;
    private int nTaxaCovered = Integer.MIN_VALUE;
    private int totalNReads = Integer.MIN_VALUE;
    private String status = "notSet";
    private byte[][] myCommonAlleles = null;
    private byte[][][] myAlleleDepthsInTaxa = null;
    private static final int maxSNPsPerLocus = 64;
    private static final int maxAlignmentSize = 10000;
    private static final int maxCountAtGeno = 500;
    private static final int maxNumAlleles = 3;
    private SubstitutionMatrix<NucleotideCompound> subMatrix = SubstitutionMatrixHelper.getNuc4_4();
    private SimpleGapPenalty gapPen = new SimpleGapPenalty(5, 2);
    private static int[] likelihoodRatioThreshAlleleCnt = null;

    static void setLikelihoodThresh(double errorRate) {
        likelihoodRatioThreshAlleleCnt = new int[500];
        System.out.println("\n\nInitializing the cutoffs for quantitative SNP calling likelihood ratio (pHet/pErr) >1\n");
        System.out.println("totalReadsForSNPInIndiv\tminLessTaggedAlleleCountForHet");
        for (int trials = 0; trials < 2; ++trials) {
            TagLocus.likelihoodRatioThreshAlleleCnt[trials] = 1;
        }
        int lastThresh = 1;
        for (int trials = 2; trials < likelihoodRatioThreshAlleleCnt.length; ++trials) {
            BinomialDistributionImpl binomHet = new BinomialDistributionImpl(trials, 0.5);
            BinomialDistributionImpl binomErr = new BinomialDistributionImpl(trials, errorRate);
            try {
                double LikeRatio = binomHet.cumulativeProbability(lastThresh) / (1.0 - binomErr.cumulativeProbability(lastThresh) + binomErr.probability(lastThresh));
                while (LikeRatio <= 1.0) {
                    LikeRatio = binomHet.cumulativeProbability(++lastThresh) / (1.0 - binomErr.cumulativeProbability(lastThresh) + binomErr.probability(lastThresh));
                }
                TagLocus.likelihoodRatioThreshAlleleCnt[trials] = lastThresh;
                System.out.println(trials + "\t" + lastThresh);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in the TagsAtLocus.BinomialDistributionImpl");
            }
        }
        System.out.println("\n");
    }

    public TagLocus(int chromosome, byte strand, int startPosition, int tagLength, boolean includeRefGenome, boolean fuzzyStartPositions, double errorRate) {
        this.chromosome = chromosome;
        this.strand = includeRefGenome && fuzzyStartPositions ? (byte)1 : strand;
        this.minStartPosition = startPosition;
        this.maxStartPosition = startPosition;
        this.minTagLength = tagLength;
        this.maxTagLength = tagLength;
        this.positionsOfVariableSites = null;
        this.allelesAtVariableSitesByTag = null;
        if (likelihoodRatioThreshAlleleCnt == null) {
            TagLocus.setLikelihoodThresh(errorRate);
        }
    }

    public void addTag(int tagTOPMIndex, TagsOnPhysicalMap theTOPM, TagsByTaxa theTBT, boolean includeRefGenome, boolean fuzzyStartPositions) {
        SingleTagByTaxa singleTBT = new SingleTagByTaxa(tagTOPMIndex, theTOPM, theTBT, includeRefGenome, fuzzyStartPositions);
        if (singleTBT.taxaWithTag > 0) {
            this.theTags.add(singleTBT);
            if (singleTBT.startPosition > this.minStartPosition) {
                this.maxStartPosition = singleTBT.startPosition;
            }
            if (singleTBT.tagLength < this.minTagLength) {
                this.minTagLength = singleTBT.tagLength;
            }
            if (singleTBT.tagLength > this.maxTagLength) {
                this.maxTagLength = singleTBT.tagLength;
            }
        }
    }

    public void addRefTag(String refTag, int nLongsPerTag, String nullTag) {
        this.theTags.add(new SingleTagByTaxa(this.minStartPosition, this.strand, refTag, nLongsPerTag, nullTag));
        this.indexOfRef = this.theTags.size() - 1;
    }

    public int getSize() {
        return this.theTags.size();
    }

    public int getChromosome() {
        return this.chromosome;
    }

    public byte getStrand() {
        return this.strand;
    }

    public int getMinStartPosition() {
        return this.minStartPosition;
    }

    public int getMaxStartPosition() {
        return this.maxStartPosition;
    }

    public int getMinTagLength() {
        return this.minTagLength;
    }

    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    public void setMinStartPosition(int newMinStartPosition) {
        this.minStartPosition = newMinStartPosition;
    }

    public int getTOPMIndexOfTag(int tagIndex) {
        return this.theTags.get((int)tagIndex).tagTOPMIndex;
    }

    public int getTBTIndexOfTag(int tagIndex) {
        return this.theTags.get((int)tagIndex).tagTBTIndex;
    }

    public int getDivergenceOfTag(int tagIndex) {
        return this.theTags.get((int)tagIndex).divergence;
    }

    public byte getCallAtVariableSiteForTag(int site, int tagIndex) {
        return this.allelesAtVariableSitesByTag[site][tagIndex];
    }

    public byte getRefGeno(int site) {
        if (this.refCallsBySite == null || site > this.refCallsBySite.length - 1) {
            return -1;
        }
        return this.refCallsBySite[site];
    }

    public int getNumberTaxaCovered() {
        if (this.theTags.size() < 1) {
            return 0;
        }
        if (this.nTaxaCovered == Integer.MIN_VALUE) {
            this.nTaxaCovered = 0;
            this.totalNReads = 0;
            boolean[] covered = new boolean[this.theTags.get((int)0).tagDist.length];
            for (SingleTagByTaxa sTBT : this.theTags) {
                for (int tx = 0; tx < covered.length; ++tx) {
                    byte reads = sTBT.tagDist[tx];
                    this.totalNReads += reads;
                    if (covered[tx] || reads <= 0) continue;
                    covered[tx] = true;
                }
            }
            for (int tx = 0; tx < covered.length; ++tx) {
                if (!covered[tx]) continue;
                ++this.nTaxaCovered;
            }
            return this.nTaxaCovered;
        }
        return this.nTaxaCovered;
    }

    public int getTotalNReads() {
        if (this.theTags.size() < 1) {
            return 0;
        }
        if (this.totalNReads == Integer.MIN_VALUE) {
            this.getNumberTaxaCovered();
            return this.totalNReads;
        }
        return this.totalNReads;
    }

    private void assignRefTag() {
        int lengthOfRef = Integer.MIN_VALUE;
        int tagIndex = 0;
        for (SingleTagByTaxa sTBT : this.theTags) {
            if (sTBT.divergence == 0 && sTBT.tagLength > lengthOfRef) {
                this.indexOfRef = tagIndex;
                lengthOfRef = sTBT.tagLength;
            }
            ++tagIndex;
        }
    }

    public byte[][] getCommonAlleles() {
        return this.myCommonAlleles;
    }

    public byte[][][] getAlleleDepthsInTaxa() {
        return this.myAlleleDepthsInTaxa;
    }

    public byte[][] getSNPCallsVCF(boolean callBiallelicSNPsWithGap, boolean includeReferenceTag) {
        if (this.theTags.size() < 2) {
            this.status = "invariant";
            return null;
        }
        GenotypeTable tagAlignment = this.getVariableSites();
        if (tagAlignment == null || tagAlignment.numberOfSites() < 1) {
            this.status = "invariant";
            return null;
        }
        int nSites = tagAlignment.numberOfSites();
        int nTaxa = this.theTags.get((int)0).tagDist.length;
        if (nTaxa < 1) {
            this.status = "noTaxa";
            return null;
        }
        this.status = "polymorphic";
        byte[][] callsBySite = new byte[nSites][nTaxa];
        if (includeReferenceTag) {
            this.refCallsBySite = new byte[nSites];
        }
        this.populateAllelesAtVariableSitesByTag(tagAlignment, nSites, includeReferenceTag, callBiallelicSNPsWithGap);
        this.positionsOfVariableSites = new int[nSites];
        this.myCommonAlleles = new byte[3][nSites];
        this.myAlleleDepthsInTaxa = new byte[3][nSites][nTaxa];
        for (int s = 0; s < nSites; ++s) {
            this.positionsOfVariableSites[s] = tagAlignment.chromosomalPosition(s);
            byte[] commonAlleles = this.getCommonAlleles(s, nTaxa, includeReferenceTag);
            int[][] alleleDepthsInTaxa = this.getAlleleDepthsInTaxa(commonAlleles, s, nTaxa, includeReferenceTag);
            this.setAlleleDepthsInTaxaForSite(s, alleleDepthsInTaxa, commonAlleles);
            for (int tx = 0; tx < nTaxa; ++tx) {
                callsBySite[s][tx] = VCFUtil.resolveVCFGeno(commonAlleles, alleleDepthsInTaxa, tx);
            }
        }
        return callsBySite;
    }

    public byte[][] getSNPCallsQuant(boolean callBiallelicSNPsWithGap, boolean includeReferenceTag) {
        if (this.theTags.size() < 2) {
            this.status = "invariant";
            return null;
        }
        GenotypeTable tagAlignment = this.getVariableSites();
        if (tagAlignment == null || tagAlignment.numberOfSites() < 1) {
            this.status = "invariant";
            return null;
        }
        int nSites = tagAlignment.numberOfSites();
        int nTaxa = this.theTags.get((int)0).tagDist.length;
        if (nTaxa < 1) {
            this.status = "noTaxa";
            return null;
        }
        this.status = "polymorphic";
        byte[][] callsBySite = new byte[nSites][nTaxa];
        if (includeReferenceTag) {
            this.refCallsBySite = new byte[nSites];
        }
        this.populateAllelesAtVariableSitesByTag(tagAlignment, nSites, includeReferenceTag, callBiallelicSNPsWithGap);
        this.positionsOfVariableSites = new int[nSites];
        this.myCommonAlleles = new byte[3][nSites];
        this.myAlleleDepthsInTaxa = new byte[3][nSites][nTaxa];
        for (int s = 0; s < nSites; ++s) {
            this.positionsOfVariableSites[s] = tagAlignment.chromosomalPosition(s);
            byte[] commonAlleles = this.getCommonAlleles(s, nTaxa, includeReferenceTag);
            int[][] alleleDepthsInTaxa = this.getAlleleDepthsInTaxa(commonAlleles, s, nTaxa, includeReferenceTag);
            this.setAlleleDepthsInTaxaForSite(s, alleleDepthsInTaxa, commonAlleles);
            for (int tx = 0; tx < nTaxa; ++tx) {
                int count = 0;
                for (int a = 0; a < 3; ++a) {
                    count += alleleDepthsInTaxa[a][tx];
                }
                if (count == 0) {
                    callsBySite[s][tx] = -1;
                    continue;
                }
                boolean done = false;
                for (int a = 0; a < 3; ++a) {
                    if (count - alleleDepthsInTaxa[a][tx] != 0) continue;
                    callsBySite[s][tx] = (byte)(commonAlleles[a] << 4 | commonAlleles[a]);
                    done = true;
                    break;
                }
                if (done) continue;
                callsBySite[s][tx] = this.resolveHetGeno(commonAlleles, alleleDepthsInTaxa, tx);
            }
        }
        return callsBySite;
    }

    public byte[][] getSNPCallsQuant(String refSeq, boolean callBiallelicSNPsWithGap) {
        if (this.theTags.size() < 2) {
            return null;
        }
        GenotypeTable tagAlignment = this.getVariableSites(refSeq);
        if (tagAlignment == null || tagAlignment.numberOfSites() < 1) {
            return null;
        }
        int nSites = tagAlignment.numberOfSites();
        int nTaxa = this.theTags.get((int)0).tagDist.length;
        if (nTaxa < 1) {
            return null;
        }
        byte[][] callsBySite = new byte[nSites][nTaxa];
        int nAlignedTags = tagAlignment.numberOfTaxa();
        this.tagIndices = new int[nAlignedTags];
        this.allelesAtVariableSitesByTag = new byte[nSites][this.theTags.size()];
        for (int tg = 0; tg < nAlignedTags; ++tg) {
            int indexInTheTags;
            this.tagIndices[tg] = indexInTheTags = Integer.parseInt(tagAlignment.taxaName(tg));
            for (int s = 0; s < nSites; ++s) {
                this.allelesAtVariableSitesByTag[s][this.tagIndices[tg]] = tagAlignment.genotype(tg, s);
            }
        }
        this.positionsOfVariableSites = new int[nSites];
        for (int s = 0; s < nSites; ++s) {
            this.positionsOfVariableSites[s] = tagAlignment.chromosomalPosition(s);
            for (int tx = 0; tx < nTaxa; ++tx) {
                int[] alleleCounts = new int[127];
                for (int tg = 0; tg < nAlignedTags; ++tg) {
                    int tagIndex = this.tagIndices[tg];
                    int baseToAdd = this.allelesAtVariableSitesByTag[s][tagIndex];
                    if (baseToAdd == -1 && callBiallelicSNPsWithGap && this.maxStartPosition == this.minStartPosition) {
                        baseToAdd = 85;
                    }
                    int n = baseToAdd;
                    alleleCounts[n] = alleleCounts[n] + this.theTags.get((int)tagIndex).tagDist[tx];
                }
                callsBySite[s][tx] = this.resolveQuantGeno(alleleCounts);
            }
        }
        return callsBySite;
    }

    private void setAlleleDepthsInTaxaForSite(int site, int[][] alleleDepthsInTaxa, byte[] commonAlleles) {
        int a;
        for (a = 0; a < commonAlleles.length; ++a) {
            this.myCommonAlleles[a][site] = commonAlleles[a];
        }
        for (a = 0; a < alleleDepthsInTaxa.length; ++a) {
            for (int tx = 0; tx < alleleDepthsInTaxa[a].length; ++tx) {
                if (alleleDepthsInTaxa[a][tx] > 127) {
                    alleleDepthsInTaxa[a][tx] = 127;
                }
                this.myAlleleDepthsInTaxa[a][site][tx] = (byte)alleleDepthsInTaxa[a][tx];
            }
        }
    }

    private void populateAllelesAtVariableSitesByTag(GenotypeTable tagAlignment, int nSites, boolean includeReferenceTag, boolean callBiallelicSNPsWithGap) {
        int nAlignedTags = tagAlignment.numberOfTaxa();
        this.tagIndices = new int[nAlignedTags];
        this.allelesAtVariableSitesByTag = new byte[nSites][this.theTags.size()];
        for (int tg = 0; tg < nAlignedTags; ++tg) {
            this.tagIndices[tg] = Integer.parseInt(tagAlignment.taxaName(tg).split("_")[0]);
            for (int s = 0; s < nSites; ++s) {
                if (includeReferenceTag && this.tagIndices[tg] == this.theTags.size() - 1) {
                    this.refCallsBySite[s] = tagAlignment.genotype(tg, s);
                    continue;
                }
                int allele = tagAlignment.genotypeArray(tg, s)[0];
                if (callBiallelicSNPsWithGap && allele == 15) {
                    allele = 5;
                }
                this.allelesAtVariableSitesByTag[s][this.tagIndices[tg]] = allele;
            }
        }
    }

    public int[] getPositionsOfVariableSites() {
        return this.positionsOfVariableSites;
    }

    public String getLocusReport(int minTaxaWithLocus, boolean[] varSiteKept) {
        int start;
        int end;
        int refTag = Integer.MIN_VALUE;
        if (this.strand == -1) {
            end = this.minStartPosition;
            start = this.minStartPosition - this.maxTagLength + 1;
        } else {
            start = this.minStartPosition;
            end = this.minStartPosition + this.maxTagLength - 1;
        }
        int totalbp = end - start + 1;
        int nVarSites = 0;
        int nVarSitesKept = 0;
        String posVarSites = "";
        String posVarsKept = "";
        if (this.status.equals("polymorphic")) {
            nVarSites = this.positionsOfVariableSites.length;
            for (int s = 0; s < nVarSites; ++s) {
                String string = posVarSites = s < nVarSites - 1 ? posVarSites + this.positionsOfVariableSites[s] + ":" : posVarSites + this.positionsOfVariableSites[s];
                if (!varSiteKept[s]) continue;
                posVarsKept = posVarsKept + this.positionsOfVariableSites[s] + ":";
                ++nVarSitesKept;
            }
            posVarsKept = posVarsKept.length() > 0 ? posVarsKept.substring(0, posVarsKept.length() - 1) : "NA";
        } else {
            posVarSites = "NA";
            posVarsKept = "NA";
            if (this.status.equals("invariant") || this.status.contains("tooManyTags")) {
                this.assignRefTag();
            }
        }
        refTag = this.indexOfRef == Integer.MIN_VALUE ? 0 : 1;
        return this.chromosome + "\t" + start + "\t" + end + "\t" + this.strand + "\t" + totalbp + "\t" + this.theTags.size() + "\t" + this.getTotalNReads() + "\t" + this.getNumberTaxaCovered() + "\t" + minTaxaWithLocus + "\t" + this.status + "\t" + nVarSites + "\t" + posVarSites + "\t" + nVarSitesKept + "\t" + posVarsKept + "\t" + refTag + "\t" + this.maxTagLength + "\t" + this.minTagLength + "\n";
    }

    private GenotypeTable getVariableSites() {
        int i;
        if (this.theTags.size() < 2) {
            this.status = "invariant";
            return null;
        }
        if (this.theTags.size() > 10000) {
            this.status = "tooManyTags(>10000)";
            return null;
        }
        if (this.indexOfRef == Integer.MIN_VALUE) {
            this.assignRefTag();
        }
        boolean printOutAlignments = true;
        ArrayList<DNASequence> lst = new ArrayList<DNASequence>();
        int tagIndex = 0;
        for (SingleTagByTaxa sTBT : this.theTags) {
            DNASequence ds = new DNASequence(sTBT.tagTrimmed);
            String refMark = tagIndex == this.indexOfRef ? "refTag" : "no";
            ds.setOriginalHeader(tagIndex + "_" + refMark);
            ds.setCompoundSet((CompoundSet)AmbiguityDNACompoundSet.getDNACompoundSet());
            lst.add(ds);
            ++tagIndex;
        }
        Profile profile = Alignments.getMultipleSequenceAlignment(lst, (Object[])new Object[0]);
        int nSites = profile.getAlignedSequence(1).getSequenceAsString().length();
        String[] alignedSeqs = new String[this.theTags.size()];
        GenotypeCallTableBuilder gB = GenotypeCallTableBuilder.getInstance(this.theTags.size(), nSites);
        TaxaListBuilder tlB = new TaxaListBuilder();
        PositionListBuilder pALB = new PositionListBuilder();
        for (i = 0; i < nSites; ++i) {
            pALB.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, i).build());
        }
        for (i = 0; i < alignedSeqs.length; ++i) {
            alignedSeqs[i] = profile.getAlignedSequence(i + 1).getSequenceAsString();
            String taxonName = ((DNASequence)profile.getAlignedSequence(i + 1).getOriginalSequence()).getOriginalHeader();
            if (taxonName.split("_")[1].equals("refTag") && alignedSeqs[i].contains("-")) {
                pALB = new PositionListBuilder();
                pALB.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, 0).build());
                int prevPosition = 0;
                for (int site = 1; site < alignedSeqs[i].length(); ++site) {
                    int currPosition = alignedSeqs[i].charAt(site) == '-' ? prevPosition : prevPosition + 1;
                    pALB.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, currPosition).build());
                    prevPosition = currPosition;
                }
            }
            tlB.add(new Taxon(taxonName));
        }
        profile = null;
        gB.setBases(alignedSeqs);
        GenotypeTable aa = GenotypeTableBuilder.getInstance(gB.build(), pALB.build(), tlB.build());
        GenotypeTable faa = GenotypeTableUtils.removeSitesBasedOnFreqIgnoreMissing(aa, 1.0E-6, 1.0, 2);
        if (printOutAlignments && this.minStartPosition % 1000 == 0) {
            int tg;
            TaxaList tL = tlB.build();
            System.out.println("\nHere is an example alignment for a TagLocus (1 out of every 1000 is displayed):");
            System.out.println("chr" + this.chromosome + "  pos:" + this.minStartPosition + "  strand:" + this.strand + "  All sites:");
            for (tg = 0; tg < alignedSeqs.length; ++tg) {
                String tagStr = aa.genotypeAsStringRow(tg);
                tagStr = tagStr.replaceAll(";", "");
                System.out.println(tagStr + " " + tL.taxaName(tg));
            }
            System.out.println("chr" + this.chromosome + "  pos:" + this.minStartPosition + "  strand:" + this.strand + "  Polymorphic sites only:");
            for (tg = 0; tg < alignedSeqs.length; ++tg) {
                String tagStr = faa.genotypeAsStringRow(tg);
                tagStr = tagStr.replaceAll(";", "");
                System.out.println(tagStr + " " + tL.taxaName(tg));
            }
            System.out.println();
        }
        if (faa.numberOfSites() > 64) {
            this.status = "tooManyVariants(>64)";
            return null;
        }
        if (faa.numberOfSites() < 1) {
            this.status = "noVarSitesInAlign";
            return null;
        }
        if (faa.numberOfTaxa() < 2) {
            this.status = "onlyOneTagInAlign";
            return null;
        }
        return faa;
    }

    private GenotypeTable getVariableSites(String refSeqInRegion) {
        if (this.theTags.size() < 2) {
            return null;
        }
        boolean printOutAlignments = true;
        int startRefGenIndex = 0;
        int endRefGenIndex = 1;
        int startTagIndex = 2;
        int endTagIndex = 3;
        DNASequence dsRefSeq = new DNASequence(refSeqInRegion);
        dsRefSeq.setCompoundSet((CompoundSet)AmbiguityDNACompoundSet.getDNACompoundSet());
        int minRefGenIndex = Integer.MAX_VALUE;
        int maxRefGenIndex = Integer.MIN_VALUE;
        ArrayList<SequencePair<DNASequence, NucleotideCompound>> pairwiseAligns = new ArrayList<SequencePair<DNASequence, NucleotideCompound>>();
        int tagIndex = 0;
        for (SingleTagByTaxa sTBT : this.theTags) {
            DNASequence ds = new DNASequence(sTBT.tagTrimmed);
            ds.setCompoundSet((CompoundSet)AmbiguityDNACompoundSet.getDNACompoundSet());
            SequencePair psa = Alignments.getPairwiseAlignment((Sequence)ds, (Sequence)dsRefSeq, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)this.gapPen, this.subMatrix);
            int[] alignStats = this.getAlignStats((SequencePair<DNASequence, NucleotideCompound>)psa, printOutAlignments, tagIndex, sTBT.tagLength, sTBT.tagStrand);
            minRefGenIndex = this.adjustMinRefGenIndex(minRefGenIndex, alignStats[startRefGenIndex], alignStats[startTagIndex]);
            maxRefGenIndex = this.adjustMaxRefGenIndex(maxRefGenIndex, alignStats[endRefGenIndex], alignStats[endTagIndex], sTBT.tagLength, refSeqInRegion);
            pairwiseAligns.add((SequencePair<DNASequence, NucleotideCompound>)psa);
            ++tagIndex;
        }
        this.minStartPosition += minRefGenIndex - 1;
        if (printOutAlignments && this.minStartPosition > 10000000 && this.minStartPosition < 10100000) {
            System.out.println("minRefGenIndex:" + minRefGenIndex + "  maxRefGenIndex:" + maxRefGenIndex + "  ChrPositionAtMinRefGenIndex:" + this.minStartPosition + "\n");
        }
        String[] aseqs = new String[this.theTags.size()];
        String[] names = new String[this.theTags.size()];
        char[][] myAlign = this.getAlignment(pairwiseAligns, refSeqInRegion, minRefGenIndex, maxRefGenIndex, aseqs, names);
        if (printOutAlignments && this.minStartPosition > 10000000 && this.minStartPosition < 10100000) {
            this.writeAlignment(refSeqInRegion, myAlign, minRefGenIndex, maxRefGenIndex);
        }
        GenotypeTable a = null;
        TaxaList tL = new TaxaListBuilder().addAll(names).build();
        int nSites = aseqs[0].length();
        PositionListBuilder pALB = new PositionListBuilder();
        for (int i = 0; i < nSites; ++i) {
            pALB.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, i).build());
        }
        GenotypeCallTableBuilder gB = GenotypeCallTableBuilder.getInstance(this.theTags.size(), nSites);
        for (int i = 0; i < aseqs.length; ++i) {
            gB.setBaseRangeForTaxon(i, 0, aseqs[i].getBytes());
        }
        a = GenotypeTableBuilder.getInstance(gB.build(), pALB.build(), tL);
        GenotypeTable fa = GenotypeTableUtils.removeSitesBasedOnFreqIgnoreMissing(a, 1.0E-6, 1.0, 2);
        if (printOutAlignments && this.minStartPosition > 10000000 && this.minStartPosition < 10100000) {
            System.out.println("chr" + this.chromosome + "  pos:" + this.minStartPosition + "  strand:" + this.strand + "  FA (alignment filtered for polymorphic sites):\n" + fa.toString());
        }
        if (fa.numberOfSites() > 320 || fa.numberOfSites() < 1 || fa.numberOfTaxa() < 2) {
            return null;
        }
        return fa;
    }

    private int[] getAlignStats(SequencePair<DNASequence, NucleotideCompound> psa, boolean printOutAlignments, int tagIndex, int tagLength, byte tagStrand) {
        int[] alignStats = new int[5];
        int startRefGenIndex = 0;
        int endRefGenIndex = 1;
        int startTagIndex = 2;
        int endTagIndex = 3;
        int alignedTagLen = 4;
        alignStats[startRefGenIndex] = psa.getIndexInTargetAt(1);
        alignStats[endRefGenIndex] = psa.getIndexInTargetAt(psa.getLength());
        alignStats[startTagIndex] = psa.getIndexInQueryAt(1);
        alignStats[endTagIndex] = psa.getIndexInQueryAt(psa.getLength());
        alignStats[alignedTagLen] = alignStats[endTagIndex] - alignStats[startTagIndex] + 1;
        if (printOutAlignments && this.minStartPosition > 10000000 && this.minStartPosition < 10100000) {
            System.out.println("tagIndex:" + tagIndex + "  startRefGenIndex:" + alignStats[startRefGenIndex] + "  endRefGenIndex:" + alignStats[endRefGenIndex] + "  tagLength:" + tagLength + "  startTagIndex:" + alignStats[startTagIndex] + "  endTagIndex:" + alignStats[endTagIndex] + "  alignedTagLen:" + alignStats[alignedTagLen] + "  originalStrand: " + tagStrand + "\n" + psa);
        }
        return alignStats;
    }

    private int adjustMinRefGenIndex(int minRefGenIndex, int startRefGenIndex, int startTagIndex) {
        if (startRefGenIndex < minRefGenIndex) {
            minRefGenIndex = startRefGenIndex;
        }
        if (startTagIndex > 1 && startTagIndex < 4 && startRefGenIndex - startTagIndex + 1 < minRefGenIndex && startRefGenIndex - startTagIndex + 1 > 0) {
            minRefGenIndex = startRefGenIndex - startTagIndex + 1;
        }
        return minRefGenIndex;
    }

    private int adjustMaxRefGenIndex(int maxRefGenIndex, int endRefGenIndex, int endTagIndex, int tagLength, String refSeq) {
        if (endRefGenIndex > maxRefGenIndex) {
            maxRefGenIndex = endRefGenIndex;
        }
        if (endTagIndex < tagLength && tagLength - endTagIndex < 3 && endRefGenIndex + tagLength - endTagIndex > maxRefGenIndex && endRefGenIndex + tagLength - endTagIndex <= refSeq.length()) {
            maxRefGenIndex = endRefGenIndex + tagLength - endTagIndex;
        }
        return maxRefGenIndex;
    }

    private char[][] getAlignment(ArrayList<SequencePair<DNASequence, NucleotideCompound>> pairwiseAligns, String refSeq, int minRefGenIndex, int maxRefGenIndex, String[] aseqs, String[] names) {
        int totAlignedLen = maxRefGenIndex - minRefGenIndex + 1;
        char[][] myAlign = new char[this.theTags.size()][totAlignedLen];
        for (int t = 0; t < myAlign.length; ++t) {
            Arrays.fill(myAlign[t], 'N');
        }
        int tagIndex = 0;
        for (SingleTagByTaxa sTBT : this.theTags) {
            SequencePair<DNASequence, NucleotideCompound> psa = pairwiseAligns.get(tagIndex);
            int tagStart = psa.getIndexInQueryAt(1);
            int tagEnd = psa.getIndexInQueryAt(psa.getLength());
            int refSeqStart = psa.getIndexInTargetAt(1);
            int refSeqEnd = psa.getIndexInTargetAt(psa.getLength());
            if (tagStart > 1 && tagStart < 4 && refSeqStart - minRefGenIndex - tagStart + 1 > -1) {
                for (int offset = tagStart - 1; offset > 0; --offset) {
                    myAlign[tagIndex][refSeqStart - minRefGenIndex - offset] = sTBT.tagTrimmed.charAt(tagStart - offset - 1);
                }
            }
            for (int i = 1; i <= psa.getLength(); ++i) {
                char refBase = ((NucleotideCompound)psa.getCompoundInTargetAt(i)).getBase().charAt(0);
                if (refBase == '-') continue;
                myAlign[tagIndex][psa.getIndexInTargetAt((int)i) - minRefGenIndex] = ((NucleotideCompound)psa.getCompoundInQueryAt(i)).getBase().charAt(0);
            }
            int extension = sTBT.tagLength - tagEnd;
            if (extension > 0 && extension < 3 && refSeqEnd - minRefGenIndex + extension < refSeq.length()) {
                for (int offset = sTBT.tagLength - tagEnd; offset > 0; --offset) {
                    myAlign[tagIndex][refSeqEnd - minRefGenIndex + offset] = sTBT.tagTrimmed.charAt(sTBT.tagLength - offset);
                }
            }
            aseqs[tagIndex] = new String(myAlign[tagIndex]);
            names[tagIndex] = tagIndex + "";
            ++tagIndex;
        }
        return myAlign;
    }

    private void writeAlignment(String refSeq, char[][] myAlign, int minRefGenIndex, int maxRefGenIndex) {
        System.out.println("All tags in the region aligned to the reference sequence (first line) (insertions relative to the reference excluded):");
        System.out.println(refSeq.substring(minRefGenIndex - 1, maxRefGenIndex));
        for (int tagIndex = 0; tagIndex < myAlign.length; ++tagIndex) {
            for (int b = 0; b < myAlign[tagIndex].length; ++b) {
                System.out.print(myAlign[tagIndex][b]);
            }
            System.out.print("\n");
        }
        System.out.print("\n");
    }

    private byte[] getCommonAlleles(int s, int nTaxa, boolean includeReferenceTag) {
        int[] alleleCounts = new int[16];
        int nTags = includeReferenceTag ? this.theTags.size() - 1 : this.theTags.size();
        for (int tg = 0; tg < nTags; ++tg) {
            byte baseToAdd = this.allelesAtVariableSitesByTag[s][tg];
            for (int tx = 0; tx < nTaxa; ++tx) {
                byte by = baseToAdd;
                alleleCounts[by] = alleleCounts[by] + this.theTags.get((int)tg).tagDist[tx];
            }
        }
        byte[] commonAlleles = new byte[3];
        int[][] sortedAlleleCounts = this.sortAllelesByCount(alleleCounts);
        for (int i = 0; i < 3; ++i) {
            commonAlleles[i] = (byte)sortedAlleleCounts[0][i];
        }
        return commonAlleles;
    }

    private int[][] getAlleleDepthsInTaxa(byte[] commonAlleles, int s, int nTaxa, boolean includeReferenceTag) {
        int[][] allelesInTaxa = new int[3][nTaxa];
        int nTags = includeReferenceTag ? this.theTags.size() - 1 : this.theTags.size();
        for (int tg = 0; tg < nTags; ++tg) {
            byte baseToAdd = this.allelesAtVariableSitesByTag[s][tg];
            for (int a = 0; a < 3; ++a) {
                if (baseToAdd != commonAlleles[a]) continue;
                for (int tx = 0; tx < nTaxa; ++tx) {
                    int[] nArray = allelesInTaxa[a];
                    int n = tx;
                    nArray[n] = nArray[n] + this.theTags.get((int)tg).tagDist[tx];
                }
            }
        }
        return allelesInTaxa;
    }

    private byte resolveHetGeno(byte[] alleles, int[][] allelesInTaxa, int tx) {
        int max = 0;
        int maxAllele = 15;
        int nextMax = 0;
        int nextMaxAllele = 15;
        for (int a = 0; a < 3; ++a) {
            if (allelesInTaxa[a][tx] > max) {
                nextMax = max;
                nextMaxAllele = maxAllele;
                max = allelesInTaxa[a][tx];
                maxAllele = alleles[a];
                continue;
            }
            if (allelesInTaxa[a][tx] <= nextMax) continue;
            nextMax = allelesInTaxa[a][tx];
            nextMaxAllele = alleles[a];
        }
        int totCount = max + nextMax;
        if (totCount < 500) {
            if (nextMax < likelihoodRatioThreshAlleleCnt[totCount]) {
                return (byte)(maxAllele << 4 | maxAllele);
            }
            return (byte)(maxAllele << 4 | nextMaxAllele);
        }
        if ((double)(nextMax / totCount) < 0.1) {
            return (byte)(maxAllele << 4 | maxAllele);
        }
        return (byte)(maxAllele << 4 | nextMaxAllele);
    }

    private byte resolveQuantGeno(int[] alleleCounts) {
        int[][] sortedAlleleCounts = this.sortAllelesByCount(alleleCounts);
        int a1Count = sortedAlleleCounts[1][0];
        if (a1Count == 0) {
            return -1;
        }
        int a2Count = sortedAlleleCounts[1][1];
        byte a1 = (byte)sortedAlleleCounts[0][0];
        if (a2Count == 0) {
            return a1;
        }
        byte a2 = (byte)sortedAlleleCounts[0][1];
        int totCount = a1Count + a2Count;
        if (totCount < 500) {
            if (a2Count < likelihoodRatioThreshAlleleCnt[totCount]) {
                return a1;
            }
            return GenotypeTableUtils.getDiploidValue(a1, a2);
        }
        if ((double)(a2Count / totCount) < 0.1) {
            return a1;
        }
        return GenotypeTableUtils.getDiploidValue(a1, a2);
    }

    private int[][] sortAllelesByCount(int[] alleleCounts) {
        byte[] alleles = new byte[]{0, 1, 2, 3, 5};
        int[][] result = new int[2][alleles.length];
        for (int i = 0; i < alleles.length; ++i) {
            result[0][i] = alleles[i];
            result[1][i] = alleleCounts[alleles[i]];
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < alleles.length - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    private String padTagWithNs(SingleTagByTaxa tag, String refSeq) {
        StringBuilder sb = new StringBuilder();
        char[] nullBases = tag.tagStrand == -1 ? new char[tag.startPosition - this.minStartPosition - tag.tagTrimmed.length() + 1] : new char[tag.startPosition - this.minStartPosition];
        Arrays.fill(nullBases, 'N');
        sb.append(nullBases);
        sb.append(tag.tagTrimmed);
        nullBases = tag.tagStrand == -1 ? new char[refSeq.length() - sb.length()] : new char[refSeq.length() - sb.length()];
        Arrays.fill(nullBases, 'N');
        sb.append(nullBases);
        return sb.toString();
    }
}

