/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import java.io.IOException;
import java.io.PushbackReader;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceParseException;
import net.maizegenetics.util.FormattedInput;
import net.maizegenetics.util.InputSource;

public class ReadDistanceMatrix {
    private ReadDistanceMatrix() {
    }

    public static DistanceMatrix readDistanceMatrix(PushbackReader input) throws DistanceParseException {
        return ReadDistanceMatrix.readSquare(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceMatrix readDistanceMatrix(String file) throws DistanceParseException, IOException {
        try (InputSource input = null;){
            input = InputSource.openFile(file);
            DistanceMatrix distanceMatrix = ReadDistanceMatrix.readSquare(input);
            return distanceMatrix;
        }
    }

    private static DistanceMatrix readSquare(PushbackReader in) throws DistanceParseException {
        FormattedInput fi = FormattedInput.getInstance();
        try {
            int numSeqs = fi.readInt(in);
            fi.nextLine(in);
            double[][] distance = new double[numSeqs][numSeqs];
            Taxon[] ids = new Taxon[numSeqs];
            for (int i = 0; i < numSeqs; ++i) {
                ids[i] = new Taxon(fi.readWord(in).trim());
                for (int j = 0; j < numSeqs; ++j) {
                    distance[i][j] = fi.readDouble(in);
                }
                fi.nextLine(in);
            }
            TaxaList idGroup = new TaxaListBuilder().addAll(ids).build();
            return new DistanceMatrix(distance, idGroup);
        }
        catch (IOException e) {
            throw new DistanceParseException("IO error");
        }
        catch (NumberFormatException e) {
            throw new DistanceParseException("Number format error");
        }
    }
}

