/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.PrintWriter;
import java.util.Vector;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeFactory;
import net.maizegenetics.util.FormattedOutput;
import org.apache.log4j.Logger;

public class NodeUtils {
    private static final Logger myLogger = Logger.getLogger(NodeUtils.class);

    public static void getExternalNodes(Node root, Vector store) {
        if (root.isLeaf()) {
            store.addElement(root);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                NodeUtils.getExternalNodes(root.getChild(i), store);
            }
        }
    }

    public static Node[] getExternalNodes(Node root) {
        Vector v = new Vector();
        NodeUtils.getExternalNodes(root, v);
        Object[] result = new Node[v.size()];
        v.copyInto(result);
        return result;
    }

    public static void getInternalNodes(Node root, Vector store) {
        if (!root.isLeaf()) {
            store.addElement(root);
            for (int i = 0; i < root.getChildCount(); ++i) {
                NodeUtils.getInternalNodes(root.getChild(i), store);
            }
        }
    }

    public static Node[] getInternalNodes(Node root, boolean includeRoot) {
        Vector v = new Vector();
        NodeUtils.getInternalNodes(root, v);
        Object[] result = new Node[v.size()];
        v.copyInto(result);
        if (includeRoot) {
            return result;
        }
        Node[] adjustedResult = new Node[result.length - 1];
        System.arraycopy(result, 1, adjustedResult, 0, adjustedResult.length);
        return adjustedResult;
    }

    public static int getMaxNodeDepth(Node root) {
        int max = 0;
        for (int i = 0; i < root.getChildCount(); ++i) {
            int depth = NodeUtils.getMaxNodeDepth(root.getChild(i));
            if (depth <= max) continue;
            max = depth;
        }
        return max + 1;
    }

    public static final double[] getPathLengthInfo(Node root) {
        double[] lengthInfo = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        NodeUtils.getLengthInfo(root, 0.0, lengthInfo);
        return lengthInfo;
    }

    public static final double getMaximumPathLengthLengthToLeaf(Node root) {
        if (root.isLeaf()) {
            return 0.0;
        }
        double maxLength = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < root.getChildCount(); ++i) {
            Node c = root.getChild(i);
            double length = c.getBranchLength() + NodeUtils.getMaximumPathLengthLengthToLeaf(c);
            maxLength = Math.max(length, maxLength);
        }
        return maxLength;
    }

    public static final double getMinimumPathLengthLengthToLeaf(Node root) {
        if (root.isLeaf()) {
            return 0.0;
        }
        double minLength = Double.POSITIVE_INFINITY;
        for (int i = 0; i < root.getChildCount(); ++i) {
            Node c = root.getChild(i);
            double length = c.getBranchLength() + NodeUtils.getMinimumPathLengthLengthToLeaf(c);
            minLength = Math.min(length, minLength);
        }
        return minLength;
    }

    private static final void getLengthInfo(Node root, double lengthFromRoot, double[] lengthInfo) {
        if (root.isLeaf()) {
            if (lengthFromRoot < lengthInfo[1]) {
                if (lengthFromRoot < lengthInfo[0]) {
                    lengthInfo[1] = lengthInfo[0];
                    lengthInfo[0] = lengthFromRoot;
                } else {
                    lengthInfo[1] = lengthFromRoot;
                }
            }
            if (lengthFromRoot > lengthInfo[2]) {
                if (lengthFromRoot > lengthInfo[3]) {
                    lengthInfo[2] = lengthInfo[3];
                    lengthInfo[3] = lengthFromRoot;
                } else {
                    lengthInfo[2] = lengthFromRoot;
                }
            }
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                Node c = root.getChild(i);
                NodeUtils.getLengthInfo(c, lengthFromRoot + c.getBranchLength(), lengthInfo);
            }
        }
    }

    public static void lengths2Heights(Node root) {
        NodeUtils.lengths2Heights(root, NodeUtils.getMaximumPathLengthLengthToLeaf(root));
    }

    public static int getInternalNodeCount(Node root) {
        if (root.isLeaf()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < root.getChildCount(); ++i) {
            count += NodeUtils.getInternalNodeCount(root.getChild(i));
        }
        return count + 1;
    }

    public static void lengths2HeightsKeepTips(Node node, boolean useMax) {
        if (!node.isLeaf()) {
            int i;
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                NodeUtils.lengths2HeightsKeepTips(node.getChild(i2), useMax);
            }
            double totalHL = 0.0;
            double maxHL = 0.0;
            double hl = 0.0;
            double maxH = 0.0;
            double h = 0.0;
            for (i = 0; i < node.getChildCount(); ++i) {
                h = node.getChild(i).getNodeHeight();
                hl = node.getChild(i).getBranchLength() + h;
                if (hl > maxHL) {
                    maxHL = hl;
                }
                if (h > maxH) {
                    maxH = h;
                }
                totalHL += hl;
            }
            if (useMax) {
                hl = maxHL;
            } else {
                hl = totalHL / (double)node.getChildCount();
                if (hl < maxH) {
                    hl = maxHL;
                }
            }
            node.setNodeHeight(hl);
            for (i = 0; i < node.getChildCount(); ++i) {
                h = node.getChild(i).getNodeHeight();
                node.getChild(i).setBranchLength(hl - h);
            }
        }
    }

    private static void lengths2Heights(Node node, double newHeight) {
        if (!node.isRoot()) {
            node.setNodeHeight(newHeight -= node.getBranchLength());
        } else {
            node.setNodeHeight(newHeight);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeUtils.lengths2Heights(node.getChild(i), newHeight);
        }
    }

    public static void exchangeInfo(Node node1, Node node2) {
        Taxon swaps = node1.getIdentifier();
        node1.setIdentifier(node2.getIdentifier());
        node2.setIdentifier(swaps);
        double swapd = node1.getBranchLength();
        node1.setBranchLength(node2.getBranchLength());
        node2.setBranchLength(swapd);
        swapd = node1.getNodeHeight();
        node1.setNodeHeight(node2.getNodeHeight());
        node2.setNodeHeight(swapd);
        swapd = node1.getBranchLengthSE();
        node1.setBranchLengthSE(node2.getBranchLengthSE());
        node2.setBranchLengthSE(swapd);
    }

    public static void heights2Lengths(Node node) {
        NodeUtils.heights2Lengths(node, true);
    }

    public static void heights2Lengths(Node node, boolean respectMinimum) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeUtils.heights2Lengths(node.getChild(i));
        }
        if (node.isRoot()) {
            node.setBranchLength(0.0);
        } else {
            node.setBranchLength(node.getParent().getNodeHeight() - node.getNodeHeight());
            if (respectMinimum && node.getBranchLength() < 1.0E-9) {
                node.setBranchLength(1.0E-9);
            }
        }
    }

    public static void localHeights2Lengths(Node node, boolean respectMinimum) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChild(i);
            child.setBranchLength(node.getNodeHeight() - child.getNodeHeight());
        }
        if (node.isRoot()) {
            node.setBranchLength(0.0);
        } else {
            node.setBranchLength(node.getParent().getNodeHeight() - node.getNodeHeight());
            if (respectMinimum && node.getBranchLength() < 1.0E-9) {
                node.setBranchLength(1.0E-9);
            }
        }
    }

    public static double findLargestChild(Node node) {
        double max = node.getChild(0).getNodeHeight();
        for (int j = 1; j < node.getChildCount(); ++j) {
            double h = node.getChild(j).getNodeHeight();
            if (!(h > max)) continue;
            max = h;
        }
        return max;
    }

    public static void removeChild(Node parent, Node child) {
        int rm = -1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (child != parent.getChild(i)) continue;
            rm = i;
            break;
        }
        parent.removeChild(rm);
    }

    public static void removeBranch(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            throw new IllegalArgumentException("INTERNAL NODE REQUIRED (NOT ROOT)");
        }
        Node parent = node.getParent();
        int numChilds = node.getChildCount();
        for (int i = 0; i < numChilds; ++i) {
            parent.addChild(node.getChild(i));
        }
        int rm = -1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (node != parent.getChild(i)) continue;
            rm = i;
            break;
        }
        parent.removeChild(rm);
        node.setParent(parent);
        node.setNumber(rm);
    }

    public static void restoreBranch(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            throw new IllegalArgumentException("INTERNAL NODE REQUIRED (NOT ROOT)");
        }
        Node parent = node.getParent();
        int numChilds = node.getChildCount();
        for (int i = 0; i < numChilds; ++i) {
            Node c = node.getChild(i);
            NodeUtils.removeChild(parent, c);
            c.setParent(node);
        }
        parent.insertChild(node, node.getNumber());
    }

    public static void joinChilds(Node node, int n1, int n2) {
        int c2;
        int c1;
        if (n1 == n2) {
            throw new IllegalArgumentException("CHILDREN MUST BE DIFFERENT");
        }
        if (n2 < n1) {
            c1 = n2;
            c2 = n1;
        } else {
            c1 = n1;
            c2 = n2;
        }
        Node newNode = NodeFactory.createNode();
        Node child1 = node.getChild(c1);
        Node child2 = node.getChild(c2);
        node.setChild(c1, newNode);
        newNode.setParent(node);
        node.removeChild(c2);
        newNode.addChild(child1);
        newNode.addChild(child2);
    }

    public static Node preorderSuccessor(Node node) {
        Node next = null;
        if (node.isLeaf()) {
            Node cn = node;
            Node ln = null;
            do {
                if (cn.isRoot()) {
                    next = cn;
                    break;
                }
                ln = cn;
            } while ((cn = cn.getParent()).getChild(cn.getChildCount() - 1) == ln);
            if (next == null) {
                for (int i = 0; i < cn.getChildCount() - 1; ++i) {
                    if (cn.getChild(i) != ln) continue;
                    next = cn.getChild(i + 1);
                    break;
                }
            }
        } else {
            next = node.getChild(0);
        }
        return next;
    }

    public static Node postorderSuccessor(Node node) {
        Node cn = null;
        Node parent = node.getParent();
        if (node.isRoot()) {
            cn = node;
        } else {
            if (parent.getChild(parent.getChildCount() - 1) == node) {
                return parent;
            }
            for (int i = 0; i < parent.getChildCount() - 1; ++i) {
                if (parent.getChild(i) != node) continue;
                cn = parent.getChild(i + 1);
                break;
            }
        }
        while (cn.getChildCount() > 0) {
            cn = cn.getChild(0);
        }
        return cn;
    }

    public static void printNH(PrintWriter out, Node node, boolean printLengths, boolean printInternalLabels) {
        NodeUtils.printNH(out, node, printLengths, printInternalLabels, 0, true);
    }

    public static int printNH(PrintWriter out, Node node, boolean printLengths, boolean printInternalLabels, int column, boolean breakLines) {
        if (breakLines) {
            column = NodeUtils.breakLine(out, column);
        }
        if (!node.isLeaf()) {
            out.print("(");
            ++column;
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i != 0) {
                    out.print(",");
                    ++column;
                }
                column = NodeUtils.printNH(out, node.getChild(i), printLengths, printInternalLabels, column, breakLines);
            }
            out.print(")");
            ++column;
        }
        if (!node.isRoot()) {
            if (node.isLeaf() || printInternalLabels) {
                if (breakLines) {
                    column = NodeUtils.breakLine(out, column);
                }
                String id = node.getIdentifier().toString();
                out.print(id);
                column += id.length();
            }
            if (printLengths) {
                out.print(":");
                ++column;
                if (breakLines) {
                    column = NodeUtils.breakLine(out, column);
                }
                column += FormattedOutput.getInstance().displayDecimal(out, node.getBranchLength(), 7);
            }
        }
        return column;
    }

    private static int breakLine(PrintWriter out, int column) {
        if (column > 70) {
            out.println();
            column = 0;
        }
        return column;
    }

    public static final Node[] findByIdentifier(Node node, String[] identifierNames) {
        Node[] nodes = new Node[identifierNames.length];
        boolean foundSomething = false;
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = NodeUtils.findByIdentifier(node, identifierNames[i]);
            foundSomething = foundSomething || nodes[i] != null;
        }
        if (!foundSomething) {
            return null;
        }
        return nodes;
    }

    public static final Node[] findByIdentifier(Node node, Taxon[] identifiers) {
        Node[] nodes = new Node[identifiers.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = NodeUtils.findByIdentifier(node, identifiers[i]);
        }
        return nodes;
    }

    public static final Node findByIdentifier(Node node, Taxon identifier) {
        return NodeUtils.findByIdentifier(node, identifier.getName());
    }

    public static final Node findByIdentifier(Node node, String identifierName) {
        myLogger.debug((Object)("node identifier = " + node.getIdentifier()));
        myLogger.debug((Object)("target identifier name = " + identifierName));
        if (node.getIdentifier().getName().equals(identifierName)) {
            return node;
        }
        Node pos = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            pos = NodeUtils.findByIdentifier(node.getChild(i), identifierName);
            if (pos == null) continue;
            return pos;
        }
        if (pos != null) {
            return pos;
        }
        return null;
    }

    public static double getDistanceToRoot(Node node) {
        if (node.isRoot()) {
            return 0.0;
        }
        return node.getBranchLength() + NodeUtils.getDistanceToRoot(node.getParent());
    }

    public static int getLeafCount(Node node) {
        int count = 0;
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                count += NodeUtils.getLeafCount(node.getChild(i));
            }
        } else {
            count = 1;
        }
        return count;
    }

    public static boolean isAncestor(Node possibleAncestor, Node node) {
        if (node == possibleAncestor) {
            return true;
        }
        while (!node.isRoot()) {
            if ((node = node.getParent()) != possibleAncestor) continue;
            return true;
        }
        return false;
    }

    public static Node getFirstCommonAncestor(Node[] nodes) {
        Node currentCA = nodes[0];
        for (int i = 1; i < nodes.length; ++i) {
            if (currentCA == null || nodes[i] == null || (currentCA = NodeUtils.getFirstCommonAncestor(currentCA, nodes[i])) != null) continue;
            return null;
        }
        return currentCA;
    }

    public static Node getFirstCommonAncestor(Node nodeOne, Node nodeTwo) {
        if (NodeUtils.isAncestor(nodeTwo, nodeOne)) {
            return nodeTwo;
        }
        if (NodeUtils.isAncestor(nodeOne, nodeTwo)) {
            return nodeOne;
        }
        while (!nodeTwo.isRoot()) {
            if (!NodeUtils.isAncestor(nodeTwo = nodeTwo.getParent(), nodeOne)) continue;
            return nodeTwo;
        }
        return null;
    }

    public static final int getUnrootedBranchCount(Node center) {
        if (center.isRoot()) {
            return center.getChildCount();
        }
        return center.getChildCount() + 1;
    }

    public static final void convertNegativeBranchLengthsToZeroLength(Node node) {
        NodeUtils.convertNegativeBranchLengthsToZeroLengthImpl(node);
        NodeUtils.lengths2Heights(node);
    }

    private static final void convertNegativeBranchLengthsToZeroLengthImpl(Node node) {
        if (node.getBranchLength() < 0.0) {
            node.setBranchLength(0.0);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeUtils.convertNegativeBranchLengthsToZeroLengthImpl(node.getChild(i));
        }
    }
}

