/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import java.util.logging.Logger;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.TranscriptSequence;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.CompoundSet;

public class CDSSequence
extends DNASequence {
    private static final Logger log = Logger.getLogger(CDSSequence.class.getName());
    Integer phase = 0;
    TranscriptSequence parentTranscriptSequence;

    public CDSSequence(TranscriptSequence parentSequence, int bioBegin, int bioEnd, int phase) {
        this.parentTranscriptSequence = parentSequence;
        this.setParentSequence(this.parentTranscriptSequence);
        this.setBioBegin(bioBegin);
        this.setBioEnd(bioEnd);
        this.phase = phase;
    }

    public Integer getPhase() {
        return this.phase;
    }

    public Strand getStrand() {
        return this.parentTranscriptSequence.getStrand();
    }

    public String getCodingSequence() {
        String sequence = this.getSequenceAsString(this.getBioBegin(), this.getBioEnd(), this.getStrand());
        if (this.getStrand() == Strand.NEGATIVE) {
            StringBuilder b = new StringBuilder(this.getLength());
            CompoundSet compoundSet = this.getCompoundSet();
            for (int i = 0; i < sequence.length(); ++i) {
                String nucleotide = sequence.charAt(i) + "";
                NucleotideCompound nucleotideCompound = (NucleotideCompound)compoundSet.getCompoundForString(nucleotide);
                b.append(nucleotideCompound.getComplement().getShortName());
            }
            sequence = b.toString();
        }
        return sequence;
    }
}

