/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;
import org.forester.util.GeneralTable;

public class goac {
    private static final String ALL = "{ALL}";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "goac";
    private static final String PRG_VERSION = "1.03";
    private static final String PRG_DATE = "2009.05.08";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/goac";

    private static void addStats(SortedMap<String, List<GoId>> data_to_be_analyzed, GeneralTable<String, Double> table) {
        for (String go : table.getColumnIdentifiers()) {
            BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
            for (String label : data_to_be_analyzed.keySet()) {
                if (label.equals(ALL)) continue;
                Double value = table.getValue(go, label);
                stats.addValue(value == null ? 0.0 : value);
            }
            table.setValue(go, "{AVG}", stats.arithmeticMean());
            table.setValue(go, "{SUM}", stats.getSum());
            table.setValue(go, "{MED}", stats.median());
            table.setValue(go, "{SD}", stats.sampleStandardDeviation());
            table.setValue(go, "{MIN}", stats.getMin());
            table.setValue(go, "{MAX}", stats.getMax());
        }
    }

    public static void main(String[] args) {
        String dissallowed_options;
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            goac.printHelp();
            System.exit(0);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        if (cla.getNumberOfNames() != 3) {
            goac.printHelp();
            System.exit(-1);
        }
        if ((dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        File obofile = cla.getFile(0);
        File query_superterms_file = cla.getFile(1);
        File exp_file = cla.getFile(2);
        OBOparser parser = new OBOparser(obofile, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> all_go_terms = null;
        try {
            all_go_terms = parser.parse();
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.toString());
        }
        Map<GoId, GoTerm> goid_to_term_map = GoUtils.createGoIdToGoTermMap(all_go_terms);
        ArrayList<GoId> query_superterms_ids = new ArrayList<GoId>();
        SortedMap<String, List<GoId>> query_superterms_id_raw = null;
        try {
            query_superterms_id_raw = GoUtils.parseGoIds(query_superterms_file, "#", "");
        }
        catch (IOException e) {
            ForesterUtil.printErrorMessage(PRG_NAME, e.getMessage());
            System.exit(-1);
        }
        List queries = (List)query_superterms_id_raw.get("");
        for (GoId id : queries) {
            if (!goid_to_term_map.containsKey(id)) {
                ForesterUtil.printErrorMessage(PRG_NAME, "\"" + id + "\" not present in \"" + obofile + "\"");
                System.exit(-1);
            }
            query_superterms_ids.add(id);
        }
        SortedMap<String, List<GoId>> data_to_be_analyzed = null;
        try {
            data_to_be_analyzed = GoUtils.parseGoIds(exp_file, "#", ">");
        }
        catch (IOException e) {
            ForesterUtil.printErrorMessage(PRG_NAME, e.getMessage());
            System.exit(-1);
        }
        ArrayList<GoId> all_ids = new ArrayList<GoId>();
        for (String label : data_to_be_analyzed.keySet()) {
            List experiment_set_ids = (List)data_to_be_analyzed.get(label);
            for (GoId go_id : experiment_set_ids) {
                if (!goid_to_term_map.containsKey(go_id)) {
                    ForesterUtil.printErrorMessage(PRG_NAME, "GO id [" + go_id + "] not found in GO id to term map");
                    System.exit(-1);
                }
                all_ids.add(go_id);
            }
        }
        if (data_to_be_analyzed.size() > 1) {
            data_to_be_analyzed.put(ALL, all_ids);
        }
        GeneralTable<String, Double> table_counts = new GeneralTable<String, Double>();
        GeneralTable<String, Double> table_percentage = new GeneralTable<String, Double>();
        for (String label : data_to_be_analyzed.keySet()) {
            System.out.println();
            System.out.println(String.valueOf(label) + "\t\t\t\t");
            List experiment_set_ids = (List)data_to_be_analyzed.get(label);
            LinkedHashMap<GoId, Integer> counts_id = null;
            try {
                counts_id = GoUtils.countCategoriesId(query_superterms_ids, experiment_set_ids, goid_to_term_map);
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage(PRG_NAME, e.getMessage());
                System.exit(-1);
            }
            int sum = 0;
            for (GoId id : counts_id.keySet()) {
                sum += ((Integer)counts_id.get(id)).intValue();
            }
            if (sum > 0) {
                table_counts.setValue("{total}", label, Double.valueOf(sum));
            }
            for (GoId id : counts_id.keySet()) {
                int counts = (Integer)counts_id.get(id);
                double percentage = 0.0;
                if (sum > 0) {
                    percentage = 100.0 * (double)counts / (double)sum;
                }
                System.out.println(String.valueOf(counts) + "\t" + counts + "/" + sum + "\t" + percentage + "\t" + id + "\t" + goid_to_term_map.get(id).getName());
                table_counts.setValue(goid_to_term_map.get(id).getName(), label, Double.valueOf(counts));
                table_percentage.setValue(goid_to_term_map.get(id).getName(), label, percentage);
            }
        }
        goac.addStats(data_to_be_analyzed, table_counts);
        goac.addStats(data_to_be_analyzed, table_percentage);
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(table_counts.toString(ForesterUtil.FORMATTER_3));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(table_percentage.toString(ForesterUtil.FORMATTER_3));
        System.out.println();
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        System.out.println("Usage:");
        System.out.println();
        System.out.println("goac <file with all GO terms, in 'obo' format> <file with ancestral term ids> <file with go ids to be analyzed>");
        System.out.println();
        System.out.println();
    }
}

