/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public final class support_transfer {
    public static void main(String[] args) {
        Phylogeny phylogeny_w_bl = null;
        Phylogeny phylogeny_w_support_vals = null;
        File infile_bl = null;
        File infile_support_vals = null;
        File outfile = null;
        int index_of_tree_w_bl = 0;
        if (args.length != 3 && args.length != 4) {
            System.err.println("SupportTransfer: Wrong number of arguments. Usage: \"java transfersBranchLenghts <treefile with correct b.l.> <treefile with bootstraps><outputfile> [number of tree with correct bl to use in case treefile contains more than one, default 0]\"");
            System.exit(-1);
        }
        if (args.length == 4) {
            index_of_tree_w_bl = new Integer(args[3]);
        }
        try {
            infile_bl = new File(args[0]);
            infile_support_vals = new File(args[1]);
            outfile = new File(args[2]);
            if (outfile.exists()) {
                System.out.println("transfersBranchLenghts: " + outfile.getAbsolutePath() + " does already exist.");
                System.exit(-1);
            }
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser pp_bl = ForesterUtil.createParserDependingOnFileType(infile_bl, true);
            PhylogenyParser pp_s = ForesterUtil.createParserDependingOnFileType(infile_support_vals, true);
            if (pp_bl instanceof NHXParser) {
                ((NHXParser)pp_bl).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.YES);
            }
            phylogeny_w_bl = factory.create(infile_bl, pp_bl)[index_of_tree_w_bl];
            phylogeny_w_support_vals = factory.create(infile_support_vals, pp_s)[0];
        }
        catch (IOException e) {
            System.out.println("SupportTransfer: Could not read tree(s): " + e);
            System.exit(-1);
        }
        try {
            double max_bs = PhylogenyMethods.getMaximumConfidenceValue(phylogeny_w_support_vals);
            PhylogenyMethods.normalizeBootstrapValues(phylogeny_w_support_vals, max_bs, 100.0);
            support_transfer.transferSupportValues(phylogeny_w_support_vals, phylogeny_w_bl);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(outfile, phylogeny_w_bl, 0);
        }
        catch (IOException e) {
            System.out.println("Failure to write phylogeny '" + outfile + "\" [" + e.getMessage() + "]");
            System.exit(-1);
        }
    }

    public static final void moveBranchLengthsToBootstrap(Phylogeny p) {
        PhylogenyNodeIterator iter = p.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isInternal() && node.getDistanceToParent() > 0.0) {
                PhylogenyMethods.setBootstrapConfidence(node, node.getDistanceToParent());
            } else {
                PhylogenyMethods.setBootstrapConfidence(node, -9999.0);
            }
            node.setDistanceToParent(-1024.0);
        }
    }

    public static final void transferSupportValues(Phylogeny from, Phylogeny to) {
        PhylogenyNodeIterator it_to = to.iteratorPostorder();
        block0: while (it_to.hasNext()) {
            PhylogenyNode node_to = it_to.next();
            if (node_to.isExternal()) continue;
            List<String> ext_children_to = node_to.getAllExternalDescendantsNames();
            PhylogenyNodeIterator it_from = from.iteratorPostorder();
            while (it_from.hasNext()) {
                PhylogenyNode node_from = it_from.next();
                List<String> ext_children_from = node_from.getAllExternalDescendantsNames();
                if (ext_children_from.size() != ext_children_to.size() || !ext_children_from.containsAll(ext_children_to)) continue;
                PhylogenyMethods.setBootstrapConfidence(node_to, PhylogenyMethods.getConfidenceValue(node_from));
                continue block0;
            }
            String message = "Attempt to transfer support values from nonidentical topologies";
            throw new IllegalArgumentException("Attempt to transfer support values from nonidentical topologies");
        }
    }
}

