/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.UrlTreeReader;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.WebLink;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public abstract class MainFrame
extends JFrame
implements ActionListener {
    static final String USE_MOUSEWHEEL_SHIFT_TO_ROTATE = "In this display type, use mousewheel + Shift to rotate [or A and S]";
    static final String PHYLOXML_REF_TOOL_TIP = "Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356";
    static final String APTX_REF_TOOL_TIP = "Zmasek...";
    private static final long serialVersionUID = 3655000897845508358L;
    static final Font menu_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
    static final String TYPE_MENU_HEADER = "Type";
    static final String RECTANGULAR_TYPE_CBMI_LABEL = "Rectangular";
    static final String EURO_TYPE_CBMI_LABEL = "Euro Type";
    static final String CURVED_TYPE_CBMI_LABEL = "Curved";
    static final String TRIANGULAR_TYPE_CBMI_LABEL = "Triangular";
    static final String CONVEX_TYPE_CBMI_LABEL = "Convex";
    static final String ROUNDED_TYPE_CBMI_LABEL = "Rounded";
    static final String UNROOTED_TYPE_CBMI_LABEL = "Unrooted (alpha)";
    static final String CIRCULAR_TYPE_CBMI_LABEL = "Circular (alpha)";
    static final String OPTIONS_HEADER = "Options";
    static final String SEARCH_SUBHEADER = "Search:";
    static final String DISPLAY_SUBHEADER = "Display:";
    static final String SEARCH_TERMS_ONLY_LABEL = "Match Complete Terms Only";
    static final String SEARCH_CASE_SENSITIVE_LABEL = "Case Sensitive";
    static final String INVERSE_SEARCH_RESULT_LABEL = "Negate Result";
    static final String DISPLAY_BRANCH_LENGTH_VALUES_LABEL = "Display Branch Length Values";
    static final String DISPLAY_SCALE_LABEL = "Display Scale";
    static final String NON_LINED_UP_CLADOGRAMS_LABEL = "Non-Lined Up Cladograms";
    static final String UNIFORM_CLADOGRAMS_LABEL = "Total Node Sum Dependent Cladograms";
    static final String LABEL_DIRECTION_LABEL = "Radial Labels";
    static final String LABEL_DIRECTION_TIP = "To use radial node labels in radial and unrooted display types";
    static final String SCREEN_ANTIALIAS_LABEL = "Antialias";
    static final String BG_GRAD_LABEL = "Background Color Gradient";
    static final String DISPLAY_NODE_BOXES_LABEL = "Display Node Boxes";
    static final String SHOW_OVERVIEW_LABEL = "Show Overview";
    static final String FONT_SIZE_MENU_LABEL = "Font Size";
    static final String NONUNIFORM_CLADOGRAMS_LABEL = "External Node Sum Dependent Cladograms";
    JMenuBar _jmenubar;
    JMenu _file_jmenu;
    JMenu _tools_menu;
    JMenu _view_jmenu;
    JMenu _options_jmenu;
    JMenu _font_size_menu;
    JMenu _help_jmenu;
    JMenuItem[] _load_phylogeny_from_webservice_menu_items;
    JMenuItem _open_item;
    JMenuItem _open_url_item;
    JMenuItem _save_item;
    JMenuItem _save_all_item;
    JMenuItem _close_item;
    JMenuItem _exit_item;
    JMenuItem _new_item;
    JMenuItem _midpoint_root_item;
    JMenuItem _taxcolor_item;
    JMenuItem _confcolor_item;
    JMenuItem _infer_common_sn_names_item;
    JMenuItem _collapse_species_specific_subtrees;
    JMenuItem _collapse_below_threshold;
    JMenuItem _super_tiny_fonts_item;
    JMenuItem _tiny_fonts_item;
    JMenuItem _small_fonts_item;
    JMenuItem _medium_fonts_item;
    JMenuItem _large_fonts_item;
    JMenuItem _choose_font_mi;
    JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    JCheckBoxMenuItem _screen_antialias_cbmi;
    JCheckBoxMenuItem _background_gradient_cbmi;
    JCheckBoxMenuItem _show_node_boxes_cbmi;
    JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    JRadioButtonMenuItem _uniform_cladograms_rbmi;
    JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    JCheckBoxMenuItem _show_branch_length_values_cbmi;
    JCheckBoxMenuItem _show_scale_cbmi;
    JCheckBoxMenuItem _show_overview_cbmi;
    JMenuItem _overview_placment_mi;
    JMenuItem _choose_minimal_confidence_mi;
    JCheckBoxMenuItem _graphics_export_visible_only_cbmi;
    JCheckBoxMenuItem _antialias_print_cbmi;
    JCheckBoxMenuItem _print_black_and_white_cbmi;
    JCheckBoxMenuItem _print_using_actual_size_cbmi;
    JCheckBoxMenuItem _graphics_export_using_actual_size_cbmi;
    JMenuItem _print_size_mi;
    JMenuItem _choose_pdf_width_mi;
    JCheckBoxMenuItem _internal_number_are_confidence_for_nh_parsing_cbmi;
    JCheckBoxMenuItem _extract_pfam_style_tax_codes_cbmi;
    JCheckBoxMenuItem _replace_underscores_cbmi;
    JCheckBoxMenuItem _ignore_quotes_in_nh_parsing_cbmi;
    JCheckBoxMenuItem _search_case_senstive_cbmi;
    JCheckBoxMenuItem _search_whole_words_only_cbmi;
    JCheckBoxMenuItem _inverse_search_result_cbmi;
    JMenu _type_menu;
    JCheckBoxMenuItem _rectangular_type_cbmi;
    JCheckBoxMenuItem _triangular_type_cbmi;
    JCheckBoxMenuItem _curved_type_cbmi;
    JCheckBoxMenuItem _convex_type_cbmi;
    JCheckBoxMenuItem _euro_type_cbmi;
    JCheckBoxMenuItem _rounded_type_cbmi;
    JCheckBoxMenuItem _unrooted_type_cbmi;
    JCheckBoxMenuItem _circular_type_cbmi;
    JMenuItem _view_as_NH_item;
    JMenuItem _view_as_NHX_item;
    JMenuItem _view_as_XML_item;
    JMenuItem _view_as_nexus_item;
    JMenuItem _about_item;
    JMenuItem _help_item;
    JMenuItem _website_item;
    JMenuItem _phyloxml_website_item;
    JMenuItem _phyloxml_ref_item;
    JMenuItem _aptx_ref_item;
    MainPanel _mainpanel;
    Container _contentpane;
    TextFrame _textframe;
    Configuration _configuration;
    JMenuItem _remove_branch_color_item;
    Options _options;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$forester$archaeopteryx$webservices$WebservicesManager$WsPhylogenyFormat;

    MainFrame() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        boolean is_applet = false;
        JApplet applet = null;
        if (this.getCurrentTreePanel() != null && (is_applet = this.getCurrentTreePanel().isApplet())) {
            applet = this.getCurrentTreePanel().obtainApplet();
        }
        if (o == this._open_url_item) {
            this.readPhylogeniesFromURL();
        } else if (o == this._exit_item) {
            this.close();
        } else if (o == this._taxcolor_item) {
            this.taxColor();
        } else if (o == this._confcolor_item) {
            this.confColor();
        } else if (o == this._infer_common_sn_names_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().inferCommonPartOfScientificNames();
            }
        } else if (o == this._collapse_species_specific_subtrees) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (o == this._remove_branch_color_item) {
            this.removeBranchColors();
        } else if (o == this._midpoint_root_item) {
            this.midpointRoot();
        } else if (o == this._switch_colors_mi) {
            this.switchColors();
        } else if (o == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this._view_as_NHX_item) {
            this.viewAsNHX();
        } else if (o == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (o == this._super_tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._small_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._medium_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._large_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._choose_font_mi) {
            this.chooseFont();
        } else if (o == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (o == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (o == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        } else if (o == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_node_boxes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._search_whole_words_only_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_branch_length_values_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (o == this._rectangular_type_cbmi || o == this._triangular_type_cbmi || o == this._curved_type_cbmi || o == this._convex_type_cbmi || o == this._euro_type_cbmi || o == this._rounded_type_cbmi || o == this._unrooted_type_cbmi || o == this._circular_type_cbmi) {
            this.typeChanged(o);
        } else if (o == this._about_item) {
            MainFrame.about();
        } else if (o == this._help_item) {
            MainFrame.help(this.getConfiguration().getWebLinks());
        } else if (o == this._website_item) {
            try {
                Util.openWebsite("http://www.phylosoft.org/archaeopteryx/", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_website_item) {
            try {
                Util.openWebsite("http://www.phyloxml.org", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._aptx_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else {
            int i = 0;
            while (i < this._load_phylogeny_from_webservice_menu_items.length) {
                if (o == this._load_phylogeny_from_webservice_menu_items[i]) {
                    this.readPhylogeniesFromWebservice(i);
                }
                ++i;
            }
        }
        this._contentpane.repaint();
    }

    void activateSaveAllIfNeeded() {
        if (this.getMainPanel().getTabbedPane() != null && this.getMainPanel().getTabbedPane().getTabCount() > 1) {
            this._save_all_item.setEnabled(true);
        } else {
            this._save_all_item.setEnabled(false);
        }
    }

    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_url_item = new JMenuItem("Read tree from URL/webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_url_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu(FONT_SIZE_MENU_LABEL, this.getConfiguration());
        this._super_tiny_fonts_item = new JMenuItem("Super Tiny Fonts");
        this._font_size_menu.add(this._super_tiny_fonts_item);
        this._tiny_fonts_item = new JMenuItem("Tiny Fonts");
        this._font_size_menu.add(this._tiny_fonts_item);
        this._small_fonts_item = new JMenuItem("Small Fonts");
        this._font_size_menu.add(this._small_fonts_item);
        this._medium_fonts_item = new JMenuItem("Medium Fonts");
        this._font_size_menu.add(this._medium_fonts_item);
        this._large_fonts_item = new JMenuItem("Large Fonts");
        this._font_size_menu.add(this._large_fonts_item);
        this.customizeJMenuItem(this._super_tiny_fonts_item);
        this.customizeJMenuItem(this._tiny_fonts_item);
        this.customizeJMenuItem(this._small_fonts_item);
        this.customizeJMenuItem(this._medium_fonts_item);
        this.customizeJMenuItem(this._large_fonts_item);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Help");
        this._help_jmenu.add(this._help_item);
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText(PHYLOXML_REF_TOOL_TIP);
        this._aptx_ref_item.setToolTipText(APTX_REF_TOOL_TIP);
        this._jmenubar.add(this._help_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrame.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._remove_branch_color_item = new JMenuItem("Delete Branch Colors");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To delete branch color values from the current phylogeny.");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._infer_common_sn_names_item = new JMenuItem("Infer Common Parts of Internal Scientific Names");
        this._tools_menu.add(this._infer_common_sn_names_item);
        this.customizeJMenuItem(this._infer_common_sn_names_item);
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._collapse_below_threshold = new JMenuItem("Collapse Branches with Confidence Below Threshold");
        this._tools_menu.add(this._collapse_below_threshold);
        this.customizeJMenuItem(this._collapse_below_threshold);
        this._jmenubar.add(this._tools_menu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu(TYPE_MENU_HEADER, this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem(RECTANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem(EURO_TYPE_CBMI_LABEL);
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem(ROUNDED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem(CURVED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem(TRIANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem(CONVEX_TYPE_CBMI_LABEL);
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem(UNROOTED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem(CIRCULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this._circular_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View as Text", this.getConfiguration());
        this._view_as_XML_item = new JMenuItem("View as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("View as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_NHX_item = new JMenuItem("View as NHX");
        this._view_jmenu.add(this._view_as_NHX_item);
        this._view_as_nexus_item = new JMenuItem("View as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_NHX_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    private void chooseFont() {
        FontChooser fc = new FontChooser();
        fc.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fc.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fc.getFont());
    }

    private void chooseMinimalConfidence() {
        String s = (String)JOptionPane.showInputDialog(this, "Please enter the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(s)) {
            boolean success = true;
            double m = 0.0;
            String m_str = s.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m >= 0.0) {
                this.getOptions().setMinConfidenceValue(m);
            }
        }
    }

    void close() {
        this.removeTextFrame();
        if (this._mainpanel != null) {
            this._mainpanel.terminate();
        }
        if (this._contentpane != null) {
            this._contentpane.removeAll();
        }
        this.setVisible(false);
        this.dispose();
    }

    void confColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().confColor();
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
                item.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    void customizeJMenuItem(JMenuItem jmi) {
        if (jmi != null) {
            jmi.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jmi.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
                jmi.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
            }
            jmi.addActionListener(this);
        }
    }

    void customizeRadioButtonMenuItem(JRadioButtonMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
                item.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    void exceptionOccuredDuringOpenFile(Exception e) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(e.getLocalizedMessage(), 80), "Error during File|Open", 0);
    }

    void exceptionOccuredDuringSaveAs(Exception e) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, "Exception" + e, "Error during File|SaveAs", 0);
    }

    boolean GAndSDoHaveMoreThanOneSpeciesInComman(Phylogeny gene_tree) {
        if (gene_tree == null || gene_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (gene_tree.getNumberOfExternalNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    Options getOptions() {
        return this._options;
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        switch (options.getPhylogenyGraphicsType()) {
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            default: {
                this._rectangular_type_cbmi.setSelected(true);
            }
        }
    }

    void midpointRoot() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().midpointRoot();
        }
    }

    abstract void readPhylogeniesFromURL();

    void readPhylogeniesFromWebservice(int i) {
        UrlTreeReader reader = new UrlTreeReader(this, i);
        new Thread(reader).start();
    }

    /*
     * Exception decompiling
     */
    void readPhylogeniesFromWebserviceOldyButGoody(int i) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            Util.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    void removeTextFrame() {
        if (this._textframe != null) {
            this._textframe.close();
            this._textframe = null;
        }
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE type) {
        this.setTypeMenuToAllUnselected();
        switch (type) {
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case RECTANGULAR: {
                this._rectangular_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
            }
        }
    }

    void setTypeMenuToAllUnselected() {
        this._convex_type_cbmi.setSelected(false);
        this._curved_type_cbmi.setSelected(false);
        this._euro_type_cbmi.setSelected(false);
        this._rounded_type_cbmi.setSelected(false);
        this._triangular_type_cbmi.setSelected(false);
        this._rectangular_type_cbmi.setSelected(false);
        this._unrooted_type_cbmi.setSelected(false);
        this._circular_type_cbmi.setSelected(false);
    }

    void showWhole() {
        this._mainpanel.getControlPanel().showWhole();
    }

    void switchColors() {
        TreeColorSet colorset = this._mainpanel.getTreeColorSet();
        ColorSchemeChooser csc = new ColorSchemeChooser(this.getMainPanel(), colorset);
        csc.setVisible(true);
    }

    void taxColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().taxColor();
        }
    }

    void typeChanged(Object o) {
        this.updateTypeCheckboxes(this.getOptions(), o);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE previous_type = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE new_type = this.getOptions().getPhylogenyGraphicsType();
            if (previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
            if (this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData() != null) {
                if (new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(false);
                } else {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(true);
                }
            }
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowNodeBoxes(this._show_node_boxes_cbmi != null && this._show_node_boxes_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        if (this._show_branch_length_values_cbmi != null && this._show_branch_length_values_cbmi.isEnabled()) {
            options.setShowBranchLengthValues(this._show_branch_length_values_cbmi.isSelected());
        }
        options.setPrintUsingActualSize(this._print_using_actual_size_cbmi != null && this._print_using_actual_size_cbmi.isSelected());
        options.setGraphicsExportUsingActualSize(this._graphics_export_using_actual_size_cbmi != null && this._graphics_export_using_actual_size_cbmi.isSelected());
        options.setAntialiasPrint(this._antialias_print_cbmi != null && this._antialias_print_cbmi.isSelected());
        options.setPrintBlackAndWhite(this._print_black_and_white_cbmi != null && this._print_black_and_white_cbmi.isSelected());
        options.setInternalNumberAreConfidenceForNhParsing(this._internal_number_are_confidence_for_nh_parsing_cbmi != null && this._internal_number_are_confidence_for_nh_parsing_cbmi.isSelected());
        options.setNhParsingIgnoreQuotes(this._ignore_quotes_in_nh_parsing_cbmi != null && this._ignore_quotes_in_nh_parsing_cbmi.isSelected());
        options.setExtractPfamTaxonomyCodesInNhParsing(this._extract_pfam_style_tax_codes_cbmi != null && this._extract_pfam_style_tax_codes_cbmi.isSelected());
        options.setReplaceUnderscoresInNhParsing(this._replace_underscores_cbmi != null && this._replace_underscores_cbmi.isSelected());
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._graphics_export_visible_only_cbmi != null) {
            options.setGraphicsExportVisibleOnly(this._graphics_export_visible_only_cbmi.isSelected());
            if (this._graphics_export_visible_only_cbmi.isSelected() && this._graphics_export_using_actual_size_cbmi != null) {
                this._graphics_export_using_actual_size_cbmi.setSelected(true);
                this._graphics_export_using_actual_size_cbmi.setEnabled(false);
            } else {
                this._graphics_export_using_actual_size_cbmi.setEnabled(true);
            }
        }
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
    }

    void updateTypeCheckboxes(Options options, Object o) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)o).setSelected(true);
    }

    void viewAsNexus() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNexus());
    }

    void viewAsNH() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNewHampshire(false));
    }

    void viewAsNHX() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNewHampshireX());
    }

    void viewAsXML() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty() && this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() <= 10000) {
            this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toPhyloXML(0));
        }
    }

    static void about() {
        StringBuffer about = new StringBuffer("Archaeopteryx\nVersion 0.955 beta x\n");
        about.append("Copyright (C) 2007-2009 Christian M Zmasek\n");
        about.append("Copyright (C) 2007-2009 Ethalinda KS Cannon\n");
        about.append("All Rights Reserved\n");
        about.append("License: GNU Lesser General Public License (LGPL)\n");
        about.append("Last modified: 2010.01.15\n");
        about.append("phyloXML version : 1.10\n");
        about.append("phyloXML location: http://www.phyloxml.org\n");
        if (!ForesterUtil.isEmpty(ForesterUtil.JAVA_VERSION) && !ForesterUtil.isEmpty(ForesterUtil.JAVA_VENDOR)) {
            about.append("[your Java version: " + ForesterUtil.JAVA_VERSION + " " + ForesterUtil.JAVA_VENDOR + "]\n");
        }
        if (!(ForesterUtil.isEmpty(ForesterUtil.OS_NAME) || ForesterUtil.isEmpty(ForesterUtil.OS_ARCH) || ForesterUtil.isEmpty(ForesterUtil.OS_VERSION))) {
            about.append("[your OS: " + ForesterUtil.OS_NAME + " " + ForesterUtil.OS_ARCH + " " + ForesterUtil.OS_VERSION + "]\n");
        }
        Runtime rt = Runtime.getRuntime();
        long free_memory = rt.freeMemory() / 1000000L;
        long total_memory = rt.totalMemory() / 1000000L;
        about.append("[free memory: " + free_memory + "MB, total memory: " + total_memory + "MB]\n");
        about.append("[locale: " + Locale.getDefault() + "]\n");
        about.append("References:\n");
        about.append("Han MV and Zmasek CM (2009), BMC Bioinformatics, 10:356\n");
        about.append("Zmasek CM and Eddy SR (2001), Bioinformatics, 17, 383\n");
        about.append("For more information & download:\n");
        about.append("http://www.phylosoft.org/archaeopteryx/\n");
        about.append("Comments: cmzmasek@yahoo.com");
        JOptionPane.showMessageDialog(null, about, "Archaeopteryx", -1);
    }

    static String createCurrentFontDesc(TreeFontSet tree_font_set) {
        return String.valueOf(tree_font_set.getLargeFont().getFamily()) + " " + tree_font_set.getLargeFont().getSize();
    }

    static JMenu createMenu(String title, Configuration conf) {
        JMenu jmenu = new JMenu(title);
        if (!conf.isUseNativeUI()) {
            jmenu.setFont(menu_font);
            jmenu.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
            jmenu.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
        }
        return jmenu;
    }

    static JMenuItem customizeMenuItemAsLabel(JMenuItem label, Configuration configuration) {
        label.setFont(menu_font.deriveFont(1));
        if (!configuration.isUseNativeUI()) {
            label.setBackground(Constants.MENU_LABEL_BACKGROUND_COLOR_DEFAULT);
            label.setForeground(Constants.MENU_LABEL_TEXT_COLOR_DEFAULT);
            label.setOpaque(true);
        }
        label.setSelected(false);
        label.setEnabled(false);
        return label;
    }

    static void cycleOverview(Options op, TreePanel tree_panel) {
        switch (op.getOvPlacement()) {
            case LOWER_LEFT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                break;
            }
            case LOWER_RIGHT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                break;
            }
            case UPPER_LEFT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                break;
            }
            case UPPER_RIGHT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                break;
            }
            default: {
                throw new IllegalStateException("unknown placement: " + (Object)((Object)op.getOvPlacement()));
            }
        }
        tree_panel.updateOvSettings();
    }

    static void help(Map<String, WebLink> weblinks) {
        StringBuilder sb = new StringBuilder();
        sb.append("Display options\n");
        sb.append("-------------------\n");
        sb.append("Use the checkboxes to select types of information to display on the tree.\n\n");
        sb.append("Clickable tree nodes\n");
        sb.append("--------------------\n");
        sb.append("Tree nodes can be clicked, the action is determined by the 'click on node to' menu\n");
        sb.append("or by right clicking:\n");
        sb.append("o  Display Node Data -- display information for a node\n");
        sb.append("o  Collapse/Uncollapse -- collapse and uncollapse subtree from clicked node\n");
        sb.append("o  Root/Reroot -- change tree root to clicked node\n");
        sb.append("o  Sub/Super Tree -- toggle between subtree from clicked node and whole tree\n");
        sb.append("o  Swap Descendants -- switch descendant on either side of clicked node\n");
        sb.append("o  Colorize Subtree -- color a subtree\n");
        sb.append("o  Open Sequence Web -- launch a web browser to display sequence information\n");
        sb.append("o  Open Taxonomy Web -- launch a web browser to display taxonomy information\n");
        sb.append("-  there may be additional choices depending on this particular setup\n\n");
        sb.append("Right clicking on a node always displays the information of a node.\n\n");
        sb.append("Zooming\n");
        sb.append("---------\n");
        sb.append("The mouse wheel and the plus and minus keys control zooming.\n");
        sb.append("Mouse wheel+Ctrl changes the text size.\n");
        sb.append("Mouse wheel+Shift controls zooming in vertical direction only.\n");
        sb.append("Use the buttons on the control panel to zoom the tree in and out, horizontally or vertically.\n");
        sb.append("The entire tree can be fitted into the window by clicking the \"F\" button, or by pressing F, Delete, or Home.\n");
        sb.append("The up, down, left, and right keys can be used to move the visible part (if zoomed in).\n");
        sb.append("Up, down, left, and right+Shift can be used to control zooming horizontally and vertically.\n");
        sb.append("Plus and minus keys+Ctrl change the text size; F+Ctrl, Delete+Ctrl, or Home+Ctrl resets it.\n\n");
        sb.append("Quick tree manipulation:\n");
        sb.append("------------------------\n");
        sb.append("Order Subtrees -- order the tree by branch length\n");
        sb.append("Uncollapse All -- uncollapse any and all collapsed branches\n\n");
        sb.append("Memory problems (Java heap space error)\n");
        sb.append("---------------------------------------\n");
        sb.append("Since the Java default memory allocation is quite small, it might by necessary (for trees\n");
        sb.append("with more than approximately 5000 external nodes) to increase the memory which Java can use, with\n");
        sb.append("the '-Xmx' Java command line option. For example:\n");
        sb.append("java -Xms32m -Xmx256m -cp path\\to\\forester.jar org.forester.archaeopteryx.Archaeopteryx\n\n");
        if (weblinks != null && weblinks.size() > 0) {
            sb.append("Active web links\n");
            sb.append("--------------------\n");
            for (String key : weblinks.keySet()) {
                sb.append(" " + weblinks.get(key).toString() + "\n");
            }
        }
        sb.append("\n");
        sb.append("phyloXML\n");
        sb.append("-------------------\n");
        sb.append("Reference: Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356\n");
        sb.append("Website: http://www.phyloxml.org\n");
        sb.append("Version: 1.10\n");
        sb.append("\n");
        sb.append("For more information: http://www.phylosoft.org/archaeopteryx/\n");
        sb.append("Email: cmzmasek@yahoo.com\n\n");
        TextFrame.instantiate(sb.toString());
    }

    static void setOvPlacementColorChooseMenuItem(JMenuItem mi, TreePanel tree_panel) {
        if (tree_panel != null && tree_panel.getTreeColorSet() != null) {
            mi.setText("Overview Placement... (current: " + (Object)((Object)tree_panel.getOptions().getOvPlacement()) + ")");
        } else {
            mi.setText("Overview Placement...");
        }
    }

    static void setTextColorChooseMenuItem(JMenuItem mi, TreePanel tree_panel) {
        if (tree_panel != null && tree_panel.getTreeColorSet() != null) {
            mi.setText("Select Colors... (current: " + tree_panel.getTreeColorSet().getCurrentColorSchemeName() + ")");
        } else {
            mi.setText("Select Colors...");
        }
    }

    static void setTextForFontChooserMenuItem(JMenuItem mi, String font_desc) {
        mi.setText("Select Font... (current: " + font_desc + ")");
    }

    static void setTextMinSupportMenuItem(JMenuItem mi, Options options, TreePanel current_tree_panel) {
        if (current_tree_panel == null || current_tree_panel.getPhylogeny() == null) {
            mi.setEnabled(true);
        } else if (ForesterUtil.isHasAtLeastOneBranchWithSupportValues(current_tree_panel.getPhylogeny())) {
            mi.setEnabled(true);
        } else {
            mi.setEnabled(false);
        }
        mi.setText("Enter Min Confidence Value... (current: " + options.getMinConfidenceValue() + ")");
    }

    static void updateOptionsMenuDependingOnPhylogenyType(MainPanel main_panel, JCheckBoxMenuItem scale, JCheckBoxMenuItem branch_lengths, JRadioButtonMenuItem non_lined_up, JRadioButtonMenuItem uniform_clado, JRadioButtonMenuItem nonuniform_clado, JCheckBoxMenuItem label_direction_cbmi) {
        TreePanel tree_panel = main_panel.getCurrentTreePanel();
        ControlPanel control = main_panel.getControlPanel();
        Options options = main_panel.getOptions();
        scale.setSelected(options.isShowScale());
        branch_lengths.setSelected(options.isShowBranchLengthValues());
        if (tree_panel != null && !tree_panel.isPhyHasBranchLengths()) {
            scale.setSelected(false);
            scale.setEnabled(false);
            branch_lengths.setSelected(false);
            branch_lengths.setEnabled(false);
        } else if (tree_panel != null && !control.isDrawPhylogram()) {
            scale.setSelected(false);
            scale.setEnabled(false);
            branch_lengths.setEnabled(true);
        } else {
            scale.setEnabled(true);
            branch_lengths.setEnabled(true);
        }
        if (tree_panel != null && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
            branch_lengths.setSelected(false);
            branch_lengths.setEnabled(false);
        }
        if (tree_panel != null) {
            if (tree_panel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || tree_panel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                non_lined_up.setEnabled(false);
                uniform_clado.setEnabled(false);
                nonuniform_clado.setEnabled(false);
            } else {
                non_lined_up.setEnabled(true);
                uniform_clado.setEnabled(true);
                nonuniform_clado.setEnabled(true);
            }
        } else {
            if (tree_panel != null && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
                branch_lengths.setSelected(false);
                branch_lengths.setEnabled(false);
            }
            if (tree_panel != null && (tree_panel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || tree_panel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                non_lined_up.setEnabled(false);
            } else {
                non_lined_up.setEnabled(true);
            }
        }
        label_direction_cbmi.setEnabled(true);
        if (tree_panel != null) {
            if (tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && tree_panel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                label_direction_cbmi.setEnabled(false);
            }
            if (tree_panel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                scale.setSelected(false);
                scale.setEnabled(false);
            }
        }
    }

    static void updateScreenTextAntialias(List<TreePanel> treepanels) {
        for (TreePanel tree_panel : treepanels) {
            tree_panel.setTextAntialias();
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$forester$archaeopteryx$webservices$WebservicesManager$WsPhylogenyFormat() {
        if ($SWITCH_TABLE$org$forester$archaeopteryx$webservices$WebservicesManager$WsPhylogenyFormat != null) {
            return $SWITCH_TABLE$org$forester$archaeopteryx$webservices$WebservicesManager$WsPhylogenyFormat;
        }
        int[] nArray = new int[WebservicesManager.WsPhylogenyFormat.values().length];
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.NEXUS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.NH.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.NHX.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.NH_EXTRACT_TAXONOMY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.PFAM.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.PHYLOXML.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebservicesManager.WsPhylogenyFormat.TOL_XML_RESPONSE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$forester$archaeopteryx$webservices$WebservicesManager$WsPhylogenyFormat = nArray;
        return nArray;
    }
}

