/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Blast;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.MouseListener;
import org.forester.archaeopteryx.NodeFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.WebLink;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public final class TreePanel
extends JPanel
implements ActionListener,
MouseWheelListener,
Printable {
    private static final float PI = (float)Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    private static final float ONEHALF_PI = 4.712389f;
    private static final float HALF_PI = 1.5707964f;
    private static final float ANGLE_ROTATION_UNIT = 0.09817477f;
    private static final short OV_BORDER = 10;
    static final Cursor CUT_CURSOR = Cursor.getPredefinedCursor(1);
    static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    static final Cursor ARROW_CURSOR = Cursor.getPredefinedCursor(0);
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final long serialVersionUID = -978349745916505029L;
    private static final int EURO_D = 10;
    private static final String NODE_POPMENU_NODE_CLIENT_PROPERTY = "node";
    private static final int MIN_ROOT_LENGTH = 3;
    private static final int BOX_SIZE = 4;
    private static final int HALF_BOX_SIZE = 2;
    private static final int MAX_SUBTREES = 100;
    private static final int MAX_NODE_FRAMES = 10;
    private static final int MOVE = 20;
    private static final NumberFormat FORMATTER_CONFIDENCE;
    private static final NumberFormat FORMATTER_BRANCH_LENGTH;
    private static final int WIGGLE = 2;
    private static final int HALF_BOX_SIZE_PLUS_WIGGLE = 4;
    private static final int LIMIT_FOR_HQ_RENDERING = 1000;
    private final RenderingHints _rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    private File _treefile = null;
    private Configuration _configuration = null;
    private final NodeFrame[] _node_frames = new NodeFrame[10];
    private int _node_frame_index = 0;
    private Phylogeny _phylogeny = null;
    private final Phylogeny[] _phylogenies = new Phylogeny[100];
    private int _subtree_index = 0;
    private MainPanel _main_panel = null;
    private Set<PhylogenyNode> _found_nodes = null;
    private PhylogenyNode _highlight_node = null;
    private JPopupMenu _node_popup_menu = null;
    private JMenuItem[] _node_popup_menu_items = null;
    private int _longest_ext_node_info = 0;
    private float _x_correction_factor = 0.0f;
    private float _ov_x_correction_factor = 0.0f;
    private float _x_distance = 0.0f;
    private float _y_distance = 0.0f;
    private Options.PHYLOGENY_GRAPHICS_TYPE _graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private double _domain_structure_width = 200.0;
    private int _domain_structure_e_value_thr_exp = 0;
    private float _last_drag_point_x = 0.0f;
    private float _last_drag_point_y = 0.0f;
    private ControlPanel _control_panel = null;
    private int _external_node_index = 0;
    private final Polygon _polygon = new Polygon();
    private final StringBuilder _sb = new StringBuilder();
    private JColorChooser _color_chooser = null;
    private double _scale_distance = 0.0;
    private String _scale_label = null;
    private final CubicCurve2D _cubic_curve = new CubicCurve2D.Float();
    private final QuadCurve2D _quad_curve = new QuadCurve2D.Float();
    private final Line2D _line = new Line2D.Float();
    private final Ellipse2D _ellipse = new Ellipse2D.Float();
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private Options _options = null;
    private float _ov_max_width = 0.0f;
    private float _ov_max_height = 0.0f;
    private int _ov_x_position = 0;
    private int _ov_y_position = 0;
    private int _ov_y_start = 0;
    private float _ov_y_distance = 0.0f;
    private float _ov_x_distance = 0.0f;
    private boolean _ov_on = false;
    private double _urt_starting_angle = 1.5707963705062866;
    private float _urt_factor = 1.0f;
    private float _urt_factor_ov = 1.0f;
    private final boolean _phy_has_branch_lengths;
    private final Rectangle2D _ov_rectangle = new Rectangle2D.Float();
    private boolean _in_ov_rect = false;
    private boolean _in_ov = false;
    private final Rectangle _ov_virtual_rectangle = new Rectangle();
    private static final double _180_OVER_PI = 57.29577951308232;
    private static final float ROUNDED_D = 8.0f;
    private int _circ_max_depth;
    private int _circ_num_ext_nodes;
    private PhylogenyNode _root;
    private final Arc2D _arc = new Arc2D.Double();
    private final HashMap<Integer, Double> _urt_nodeid_angle_map = new HashMap();
    private final HashMap<Integer, Integer> _urt_nodeid_index_map = new HashMap();
    HashMap<Integer, Short> _nodeid_dist_to_leaf = new HashMap();
    private AffineTransform _at;
    private double _max_distance_to_root = -1.0;
    private int _dynamic_hiding_factor = 0;
    private boolean _edited = false;
    private Popup _node_desc_popup;
    private JTextArea _rollover_popup;
    private final StringBuffer _popup_buffer = new StringBuffer();
    private static final Font POPUP_FONT;

    static {
        POPUP_FONT = new Font(Configuration.getDefaultFontFamilyName(), 0, 12);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        FORMATTER_CONFIDENCE = new DecimalFormat("#.###", dfs);
        FORMATTER_BRANCH_LENGTH = new DecimalFormat("#.###", dfs);
    }

    TreePanel(Phylogeny t, Configuration configuration, MainPanel tjp) {
        this.requestFocusInWindow();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent key_event) {
                TreePanel.this.keyPressedCalls(key_event);
                TreePanel.this.requestFocusInWindow();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePanel.this.requestFocusInWindow();
            }
        });
        if (t == null || t.isEmpty()) {
            throw new IllegalArgumentException("ill advised attempt to draw phylogeny which is null or empty");
        }
        this._graphics_type = tjp.getOptions().getPhylogenyGraphicsType();
        this._main_panel = tjp;
        this._configuration = configuration;
        this._phylogeny = t;
        this._phy_has_branch_lengths = ForesterUtil.isHasAtLeastOneBranchLengthLargerThanZero(this._phylogeny);
        this.init();
        if (!this._phylogeny.isEmpty()) {
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
        }
        this.setBackground(this.getTreeColorSet().getBackgroundColor());
        MouseListener mouse_listener = new MouseListener(this);
        this.addMouseListener(mouse_listener);
        this.addMouseMotionListener(mouse_listener);
        this.addMouseWheelListener(this);
        this.calculateScaleDistance();
        FORMATTER_CONFIDENCE.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
        FORMATTER_BRANCH_LENGTH.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        boolean done = false;
        JMenuItem node_popup_menu_item = (JMenuItem)e.getSource();
        int index = 0;
        while (index < this._node_popup_menu_items.length && !done) {
            if (node_popup_menu_item == this._node_popup_menu_items[index]) {
                this._main_panel.getControlPanel().setClickToAction(index);
                PhylogenyNode node = (PhylogenyNode)this._node_popup_menu.getClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY);
                this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), node);
                done = true;
            }
            ++index;
        }
        this.repaint();
        this.requestFocusInWindow();
    }

    private final void addEmptyNode(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        String label = this.getASimpleTextRepresentationOfANode(node);
        String msg = "";
        msg = ForesterUtil.isEmpty(label) ? "How to add the new, empty node?" : "How to add the new, empty node to node" + label + "?";
        Object[] options = new Object[]{"As sibling", "As descendant", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, msg, "Addition of Empty New Node", -1, 3, null, options, options[2]);
        boolean add_as_sibling = true;
        if (r == 1) {
            add_as_sibling = false;
        } else if (r != 0) {
            return;
        }
        Phylogeny phy = new Phylogeny();
        phy.setRoot(new PhylogenyNode());
        phy.setRooted(true);
        if (add_as_sibling) {
            if (node.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot add sibling to root", "Attempt to add sibling to root", 0);
                return;
            }
            phy.addAsSibling(node);
        } else {
            phy.addAsChild(node);
        }
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void assignGraphicsForBranchWithColorForParentBranch(PhylogenyNode node, boolean is_vertical, Graphics g, boolean to_pdf, boolean to_graphics_file) {
        ControlPanel.NodeClickAction action = this._control_panel.getActionWhenNodeClicked();
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (!(action != ControlPanel.NodeClickAction.COPY_SUBTREE && action != ControlPanel.NodeClickAction.CUT_SUBTREE && action != ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE && action != ControlPanel.NodeClickAction.PASTE_SUBTREE && action != ControlPanel.NodeClickAction.ADD_NEW_NODE || this.getCutOrCopiedTree() == null || this.getCopiedAndPastedNodes() == null || to_pdf || to_graphics_file || !this.getCopiedAndPastedNodes().contains(node))) {
            g.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(node) != null) {
            g.setColor(PhylogenyMethods.getBranchColorValue(node));
        } else if (to_pdf) {
            g.setColor(this.getTreeColorSet().getBranchColorForPdf());
        } else {
            g.setColor(this.getTreeColorSet().getBranchColor());
        }
    }

    final void assignGraphicsForNodeBoxWithColorForParentBranch(PhylogenyNode node, Graphics g) {
        if (this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(node) != null) {
            g.setColor(PhylogenyMethods.getBranchColorValue(node));
        } else {
            g.setColor(this.getTreeColorSet().getBranchColor());
        }
    }

    private final void blast(PhylogenyNode node) {
        if (!this.isCanBlast(node)) {
            JOptionPane.showMessageDialog(this, "No sequence information present", "Cannot Blast", 2);
            return;
        }
        if (node.getNodeData().isHasSequence()) {
            String name = "";
            if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getName())) {
                name = node.getNodeData().getSequence().getName();
            } else if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getSymbol())) {
                name = node.getNodeData().getSequence().getSymbol();
            } else if (node.getNodeData().getSequence().getAccession() != null) {
                name = node.getNodeData().getSequence().getAccession().getValue();
            }
            if (!ForesterUtil.isEmpty(name)) {
                try {
                    System.out.println("trying: " + name);
                    Blast s = new Blast();
                    s.go(name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    final void calcMaxDepth() {
        if (this._phylogeny != null) {
            this._circ_max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
        }
    }

    private final float calculateBranchLengthToParent(PhylogenyNode node, float factor) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (node.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getXcorrectionFactor() * node.getDistanceToParent());
        }
        if (factor == 0.0f || this.isNonLinedUpCladogram()) {
            return this.getXdistance();
        }
        return this.getXdistance() * factor;
    }

    private final Color calculateColorForAnnotation(PhylogenyData ann) {
        Color c = this.getTreeColorSet().getAnnotationColor();
        if (this.getControlPanel().isColorAccordingToAnnotation() && this.getControlPanel().getAnnotationColors() != null && (c = this.getControlPanel().getAnnotationColors().get(ann.asSimpleText().toString())) == null) {
            c = this.getTreeColorSet().getAnnotationColor();
        }
        return c;
    }

    final void calculateLongestExtNodeInfo() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        int longest = 20;
        for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
            int sum = 0;
            if (node.isCollapse()) continue;
            if (this.getControlPanel().isShowNodeNames()) {
                sum += this.getTreeFontSet()._fm_large.stringWidth(String.valueOf(node.getNodeName()) + " ");
            }
            if (node.getNodeData().isHasSequence()) {
                if (this.getControlPanel().isShowSequenceAcc() && node.getNodeData().getSequence().getAccession() != null) {
                    sum += this.getTreeFontSet()._fm_large.stringWidth(String.valueOf(node.getNodeData().getSequence().getAccession().getValue()) + " ");
                }
                if (this.getControlPanel().isShowGeneNames() && node.getNodeData().getSequence().getName().length() > 0) {
                    sum += this.getTreeFontSet()._fm_large.stringWidth(String.valueOf(node.getNodeData().getSequence().getName()) + " ");
                }
                if (this.getControlPanel().isShowGeneSymbols() && node.getNodeData().getSequence().getSymbol().length() > 0) {
                    sum += this.getTreeFontSet()._fm_large.stringWidth(String.valueOf(node.getNodeData().getSequence().getSymbol()) + " ");
                }
                if (this.getControlPanel().isShowAnnotation() && node.getNodeData().getSequence().getAnnotations() != null && !node.getNodeData().getSequence().getAnnotations().isEmpty()) {
                    sum += this.getTreeFontSet()._fm_large.stringWidth(node.getNodeData().getSequence().getAnnotations().get(0).asSimpleText() + " ");
                }
            }
            if (node.getNodeData().isHasTaxonomy()) {
                Taxonomy tax = node.getNodeData().getTaxonomy();
                if (this.getControlPanel().isShowTaxonomyCode() && !ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                    sum += this.getTreeFontSet()._fm_large_italic.stringWidth(String.valueOf(tax.getTaxonomyCode()) + " ");
                }
                if (this.getControlPanel().isShowTaxonomyNames() && !ForesterUtil.isEmpty(tax.getScientificName())) {
                    sum += this.getTreeFontSet()._fm_large_italic.stringWidth(String.valueOf(tax.getScientificName()) + " ");
                }
                if (this.getControlPanel().isShowTaxonomyNames() && !ForesterUtil.isEmpty(tax.getCommonName())) {
                    sum += this.getTreeFontSet()._fm_large_italic.stringWidth(String.valueOf(tax.getCommonName()) + " ");
                }
            }
            if (this.getControlPanel().isShowBinaryCharacters() && node.getNodeData().isHasBinaryCharacters()) {
                sum += this.getTreeFontSet()._fm_large.stringWidth(node.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString());
            }
            if (this.getControlPanel().isShowDomainArchitectures() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                sum = (int)((double)sum + ((RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture()).getRenderingSize().getWidth());
            }
            if (sum >= 300) {
                this.setLongestExtNodeInfo(300);
                return;
            }
            if (sum <= longest) continue;
            longest = sum;
        }
        if (longest >= 300) {
            this.setLongestExtNodeInfo(300);
        } else {
            this.setLongestExtNodeInfo(longest);
        }
    }

    private final float calculateOvBranchLengthToParent(PhylogenyNode node, int factor) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (node.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getOvXcorrectionFactor() * node.getDistanceToParent());
        }
        if (factor == 0 || this.isNonLinedUpCladogram()) {
            return this.getOvXDistance();
        }
        return this.getOvXDistance() * (float)factor;
    }

    final void calculateScaleDistance() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double height = this.getMaxDistanceToRoot();
        if (height > 0.0) {
            if (height <= 0.5) {
                this.setScaleDistance(0.01);
            } else if (height <= 5.0) {
                this.setScaleDistance(0.1);
            } else if (height <= 50.0) {
                this.setScaleDistance(1.0);
            } else if (height <= 500.0) {
                this.setScaleDistance(10.0);
            } else {
                this.setScaleDistance(100.0);
            }
        } else {
            this.setScaleDistance(0.0);
        }
        String scale_label = String.valueOf(this.getScaleDistance());
        if (!ForesterUtil.isEmpty(this._phylogeny.getDistanceUnit())) {
            scale_label = String.valueOf(scale_label) + " [" + this._phylogeny.getDistanceUnit() + "]";
        }
        this.setScaleLabel(scale_label);
    }

    private final void cannotOpenBrowserWarningMessage(String type_type) {
        JOptionPane.showMessageDialog(this, "Cannot launch web browser for " + type_type + " data of this node", "Cannot launch web browser", 2);
    }

    final void collapse(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot collapse in unrooted display type", "Attempt to collapse in unrooted display", 2);
            return;
        }
        if (!node.isExternal() && !node.isRoot()) {
            boolean collapse = !node.isCollapse();
            Util.collapseSubtree(node, collapse);
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.calculateLongestExtNodeInfo();
            this.resetPreferredSize();
            this.updateOvSizes();
            this._main_panel.adjustJScrollPane();
            this.repaint();
        }
    }

    final void collapseSpeciesSpecificSubtrees() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.collapseSpeciesSpecificSubtrees(this._phylogeny);
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.calculateLongestExtNodeInfo();
        this.resetPreferredSize();
        this._main_panel.adjustJScrollPane();
        this.setArrowCursor();
        this.repaint();
    }

    private final void colorizeSubtree(Color c, PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot colorize subtree in unrooted display type", "Attempt to colorize subtree in unrooted display", 2);
            return;
        }
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        PreorderTreeIterator it = new PreorderTreeIterator(node);
        while (it.hasNext()) {
            it.next().getBranchData().setBranchColor(new BranchColor(c));
        }
        this.repaint();
    }

    private final void colorSubtree(PhylogenyNode node) {
        Color intitial_color = null;
        intitial_color = this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(node) != null && (!node.isRoot() && node.getParent().getNumberOfDescendants() < 3 || node.isRoot()) ? PhylogenyMethods.getBranchColorValue(node) : this.getTreeColorSet().getBranchColor();
        this._color_chooser.setColor(intitial_color);
        this._color_chooser.setPreviewPanel(new JPanel());
        JDialog dialog = JColorChooser.createDialog(this, "Subtree colorization", true, this._color_chooser, new SubtreeColorizationActionListener(this._color_chooser, node), null);
        dialog.setVisible(true);
    }

    final void confColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.colorPhylogenyAccordingToConfidenceValues(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    private final void copySubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        this.setCutOrCopiedTree(this._phylogeny.subTree(node));
        Set<PhylogenyNode> nodes = PhylogenyMethods.getAllDescendants(node);
        nodes.add(node);
        this.setCopiedAndPastedNodes(nodes);
        this.repaint();
    }

    private final void cutSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (node.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot cut entire tree as subtree", "Attempt to cut entire tree", 0);
            return;
        }
        String label = this.getASimpleTextRepresentationOfANode(node);
        int r = JOptionPane.showConfirmDialog(null, "Cut subtree" + label + "?", "Confirm Cutting of Subtree", 0);
        if (r != 0) {
            return;
        }
        this.setCopiedAndPastedNodes(null);
        this.setCutOrCopiedTree(this._phylogeny.subTree(node));
        this._phylogeny.deleteSubtree(node, true);
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void cycleColors() {
        this.getMainPanel().getTreeColorSet().cycleColorScheme();
        for (TreePanel tree_panel : this.getMainPanel().getTreePanels()) {
            tree_panel.setBackground(this.getMainPanel().getTreeColorSet().getBackgroundColor());
        }
    }

    final void decreaseDomainStructureEvalueThreshold() {
        if (this._domain_structure_e_value_thr_exp > -20) {
            --this._domain_structure_e_value_thr_exp;
        }
    }

    private final void decreaseOvSize() {
        if (this.getOvMaxWidth() > 20.0f && this.getOvMaxHeight() > 20.0f) {
            this.setOvMaxWidth(this.getOvMaxWidth() - 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() - 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void deleteNodeOrSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (node.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot delete entire tree", "Attempt to delete entire tree", 0);
            return;
        }
        String label = this.getASimpleTextRepresentationOfANode(node);
        Object[] options = new Object[]{"Node only", "Entire subtree", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, "Delete" + label + "?", "Delete Node/Subtree", -1, 3, null, options, options[2]);
        boolean node_only = true;
        if (r == 1) {
            node_only = false;
        } else if (r != 0) {
            return;
        }
        if (node_only) {
            PhylogenyMethods.removeNode(node, this._phylogeny);
        } else {
            this._phylogeny.deleteSubtree(node, true);
        }
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void displayNodePopupMenu(PhylogenyNode node, int x, int y) {
        this.makePopupMenus(node);
        this._node_popup_menu.putClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY, node);
        this._node_popup_menu.show(this, x, y);
    }

    private final void drawArc(double x, double y, double width, double heigth, double start_angle, double arc_angle, Graphics2D g) {
        this._arc.setArc(x, y, width, heigth, 57.29577951308232 * start_angle, 57.29577951308232 * arc_angle, 0);
        g.draw(this._arc);
    }

    private final void drawLine(double x1, double y1, double x2, double y2, Graphics2D g) {
        if (x1 == x2 && y1 == y2) {
            return;
        }
        this._line.setLine(x1, y1, x2, y2);
        g.draw(this._line);
    }

    private final void drawOval(double x, double y, double width, double heigth, Graphics2D g) {
        this._ellipse.setFrame(x, y, width, heigth);
        g.draw(this._ellipse);
    }

    private final void drawOvalFilled(double x, double y, double width, double heigth, Graphics2D g) {
        this._ellipse.setFrame(x, y, width, heigth);
        g.fill(this._ellipse);
    }

    private final void drawRect(float x, float y, float width, float heigth, Graphics2D g) {
        this._rectangle.setFrame(x, y, width, heigth);
        g.draw(this._rectangle);
    }

    private final void drawRectFilled(double x, double y, double width, double heigth, Graphics2D g) {
        this._rectangle.setFrame(x, y, width, heigth);
        g.fill(this._rectangle);
    }

    private final void errorMessageNoCutCopyPasteInUnrootedDisplay() {
        JOptionPane.showMessageDialog(this, "Cannot cut, copy, paste, add, or delete subtrees/nodes in unrooted display", "Attempt to cut/copy/paste/add/delete in unrooted display", 0);
    }

    final PhylogenyNode findNode(int x, int y) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return null;
        }
        PhylogenyNodeIterator iter = this._phylogeny.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (!this._phylogeny.isRooted() && node.isRoot() && node.getNumberOfDescendants() <= 2 || !(node.getXcoord() - 4.0f <= (float)x) || !(node.getXcoord() + 4.0f >= (float)x) || !(node.getYcoord() - 4.0f <= (float)y) || !(node.getYcoord() + 4.0f >= (float)y)) continue;
            return node;
        }
        return null;
    }

    private final String getASimpleTextRepresentationOfANode(PhylogenyNode node) {
        String tax = PhylogenyMethods.getSpecies(node);
        String label = node.getNodeName();
        label = !ForesterUtil.isEmpty(label) && !ForesterUtil.isEmpty(tax) ? String.valueOf(label) + " " + tax : (!ForesterUtil.isEmpty(tax) ? tax : "");
        if (!ForesterUtil.isEmpty(label)) {
            label = " [" + label + "]";
        }
        return label;
    }

    final Configuration getConfiguration() {
        return this._configuration;
    }

    final ControlPanel getControlPanel() {
        return this._control_panel;
    }

    private final Set<PhylogenyNode> getCopiedAndPastedNodes() {
        return this.getMainPanel().getCopiedAndPastedNodes();
    }

    private final Phylogeny getCutOrCopiedTree() {
        return this.getMainPanel().getCutOrCopiedTree();
    }

    final int getDomainStructureEvalueThreshold() {
        return this._domain_structure_e_value_thr_exp;
    }

    final Set<PhylogenyNode> getFoundNodes() {
        return this._found_nodes;
    }

    private final float getLastDragPointX() {
        return this._last_drag_point_x;
    }

    private final float getLastDragPointY() {
        return this._last_drag_point_y;
    }

    final int getLongestExtNodeInfo() {
        return this._longest_ext_node_info;
    }

    public final MainPanel getMainPanel() {
        return this._main_panel;
    }

    private final short getMaxBranchesToLeaf(PhylogenyNode node) {
        if (!this._nodeid_dist_to_leaf.containsKey(node.getNodeId())) {
            short m = PhylogenyMethods.calculateMaxBranchesToLeaf(node);
            this._nodeid_dist_to_leaf.put(node.getNodeId(), m);
            return m;
        }
        return this._nodeid_dist_to_leaf.get(node.getNodeId());
    }

    private final double getMaxDistanceToRoot() {
        if (this._max_distance_to_root < 0.0) {
            this.recalculateMaxDistanceToRoot();
        }
        return this._max_distance_to_root;
    }

    final Options getOptions() {
        if (this._options == null) {
            this._options = this.getControlPanel().getOptions();
        }
        return this._options;
    }

    private final float getOvMaxHeight() {
        return this._ov_max_height;
    }

    private final float getOvMaxWidth() {
        return this._ov_max_width;
    }

    final Rectangle2D getOvRectangle() {
        return this._ov_rectangle;
    }

    final Rectangle getOvVirtualRectangle() {
        return this._ov_virtual_rectangle;
    }

    private final float getOvXcorrectionFactor() {
        return this._ov_x_correction_factor;
    }

    private final float getOvXDistance() {
        return this._ov_x_distance;
    }

    private final int getOvXPosition() {
        return this._ov_x_position;
    }

    private final float getOvYDistance() {
        return this._ov_y_distance;
    }

    private final int getOvYPosition() {
        return this._ov_y_position;
    }

    private final int getOvYStart() {
        return this._ov_y_start;
    }

    final Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    final Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._graphics_type;
    }

    private final double getScaleDistance() {
        return this._scale_distance;
    }

    private final String getScaleLabel() {
        return this._scale_label;
    }

    final double getStartingAngle() {
        return this._urt_starting_angle;
    }

    final TreeColorSet getTreeColorSet() {
        return this.getMainPanel().getTreeColorSet();
    }

    final File getTreeFile() {
        return this._treefile;
    }

    private final TreeFontSet getTreeFontSet() {
        return this.getMainPanel().getTreeFontSet();
    }

    private final float getUrtFactor() {
        return this._urt_factor;
    }

    private final float getUrtFactorOv() {
        return this._urt_factor_ov;
    }

    final float getXcorrectionFactor() {
        return this._x_correction_factor;
    }

    final float getXdistance() {
        return this._x_distance;
    }

    final float getYdistance() {
        return this._y_distance;
    }

    private final void handleClickToAction(ControlPanel.NodeClickAction action, PhylogenyNode node) {
        switch (action) {
            case SHOW_DATA: {
                this.showNodeFrame(node);
                break;
            }
            case COLLAPSE: {
                this.collapse(node);
                break;
            }
            case REROOT: {
                this.reRoot(node);
                break;
            }
            case SUBTREE: {
                this.subTree(node);
                break;
            }
            case SWAP: {
                this.swap(node);
                break;
            }
            case COLOR_SUBTREE: {
                this.colorSubtree(node);
                break;
            }
            case OPEN_SEQ_WEB: {
                this.openSeqWeb(node);
                break;
            }
            case BLAST: {
                this.blast(node);
                break;
            }
            case OPEN_TAX_WEB: {
                this.openTaxWeb(node);
                break;
            }
            case CUT_SUBTREE: {
                this.cutSubtree(node);
                break;
            }
            case COPY_SUBTREE: {
                this.copySubtree(node);
                break;
            }
            case PASTE_SUBTREE: {
                this.pasteSubtree(node);
                break;
            }
            case DELETE_NODE_OR_SUBTREE: {
                this.deleteNodeOrSubtree(node);
                break;
            }
            case ADD_NEW_NODE: {
                this.addEmptyNode(node);
                break;
            }
            case EDIT_NODE_DATA: {
                this.showNodeEditFrame(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action: " + (Object)((Object)action));
            }
        }
    }

    final void increaseDomainStructureEvalueThreshold() {
        if (this._domain_structure_e_value_thr_exp < 3) {
            ++this._domain_structure_e_value_thr_exp;
        }
    }

    private final void increaseOvSize() {
        if ((double)this.getOvMaxWidth() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getWidth() / 2.0 && (double)this.getOvMaxHeight() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getHeight() / 2.0) {
            this.setOvMaxWidth(this.getOvMaxWidth() + 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() + 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    final void inferCommonPartOfScientificNames() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.inferCommonPartOfScientificNames(this._phylogeny);
        this.setArrowCursor();
        this.repaint();
    }

    private final void init() {
        this._color_chooser = new JColorChooser();
        this._rollover_popup = new JTextArea();
        this._rollover_popup.setFont(POPUP_FONT);
        this.resetNodeIdToDistToLeafMap();
        this.setTextAntialias();
        this.setTreeFile(null);
        this.setEdited(false);
        this.initializeOvSettings();
        this.setStartingAngle(4.71238898038469);
    }

    private final void initializeOvSettings() {
        this.setOvMaxHeight(this.getConfiguration().getOvMaxHeight());
        this.setOvMaxWidth(this.getConfiguration().getOvMaxWidth());
    }

    final void initNodeData() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double max_original_domain_structure_width = 0.0;
        for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
            double dsw;
            if (!node.getNodeData().isHasSequence() || node.getNodeData().getSequence().getDomainArchitecture() == null) continue;
            RenderableDomainArchitecture rds = null;
            if (!(node.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture)) {
                rds = new RenderableDomainArchitecture(node.getNodeData().getSequence().getDomainArchitecture());
                node.getNodeData().getSequence().setDomainArchitecture(rds);
            } else {
                rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
            }
            if (!this.getControlPanel().isShowDomainArchitectures() || !((dsw = rds.getOriginalSize().getWidth()) > max_original_domain_structure_width)) continue;
            max_original_domain_structure_width = dsw;
        }
        if (this.getControlPanel().isShowDomainArchitectures()) {
            double ds_factor_width = this._domain_structure_width / max_original_domain_structure_width;
            for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
                if (!node.getNodeData().isHasSequence() || node.getNodeData().getSequence().getDomainArchitecture() == null) continue;
                RenderableDomainArchitecture rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
                rds.setRenderingFactorWidth(ds_factor_width);
                rds.setParameter(this._domain_structure_e_value_thr_exp);
            }
        }
    }

    final boolean inOv(MouseEvent e) {
        return e.getX() > this.getVisibleRect().x + this.getOvXPosition() + 1 && (float)e.getX() < (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() - 1.0f && e.getY() > this.getVisibleRect().y + this.getOvYPosition() + 1 && (float)e.getY() < (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() - 1.0f;
    }

    final boolean inOvRectangle(MouseEvent e) {
        return (double)e.getX() >= this.getOvRectangle().getX() - 1.0 && (double)e.getX() <= this.getOvRectangle().getX() + this.getOvRectangle().getWidth() + 1.0 && (double)e.getY() >= this.getOvRectangle().getY() - 1.0 && (double)e.getY() <= this.getOvRectangle().getY() + this.getOvRectangle().getHeight() + 1.0;
    }

    private final boolean inOvVirtualRectangle(int x, int y) {
        return x >= this.getOvVirtualRectangle().x - 1 && x <= this.getOvVirtualRectangle().x + this.getOvVirtualRectangle().width + 1 && y >= this.getOvVirtualRectangle().y - 1 && y <= this.getOvVirtualRectangle().y + this.getOvVirtualRectangle().height + 1;
    }

    private final boolean inOvVirtualRectangle(MouseEvent e) {
        return this.inOvVirtualRectangle(e.getX(), e.getY());
    }

    final boolean isApplet() {
        return this.getMainPanel() instanceof MainPanelApplets;
    }

    private final boolean isCanBlast(PhylogenyNode node) {
        return node.getNodeData().isHasSequence() && (node.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getValue()) || !ForesterUtil.isEmpty(node.getNodeData().getSequence().getName()) || !ForesterUtil.isEmpty(node.getNodeData().getSequence().getSymbol()));
    }

    final boolean isCanCollapse() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanColorSubtree() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanCopy() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanCut(PhylogenyNode node) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && !node.isRoot();
    }

    final boolean isCanDelete() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    private final boolean isCanOpenSeqWeb(PhylogenyNode node) {
        return node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getValue()) && this.getConfiguration().isHasWebLink(node.getNodeData().getSequence().getAccession().getSource().toLowerCase());
    }

    private final boolean isCanOpenTaxWeb(PhylogenyNode node) {
        return node.getNodeData().isHasTaxonomy() && (node.getNodeData().getTaxonomy().getIdentifier() != null && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getIdentifier().getProvider()) && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getIdentifier().getValue()) && this.getConfiguration().isHasWebLink(node.getNodeData().getTaxonomy().getIdentifier().getProvider().toLowerCase()) || !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName()) || !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode()) || !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getCommonName()));
    }

    final boolean isCanPaste() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && this.getCutOrCopiedTree() != null && !this.getCutOrCopiedTree().isEmpty();
    }

    final boolean isCanReroot() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanSubtree(PhylogenyNode node) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && !node.isExternal() && (!node.isRoot() || this._subtree_index > 0);
    }

    final boolean isEdited() {
        return this._edited;
    }

    private final boolean isInFoundNodes(PhylogenyNode node) {
        return this.getFoundNodes() != null && this.getFoundNodes().contains(node);
    }

    private final boolean isInOv() {
        return this._in_ov;
    }

    final boolean isInOvRect() {
        return this._in_ov_rect;
    }

    private final boolean isNodeDataInvisible(PhylogenyNode node) {
        return (double)node.getYcoord() < this.getVisibleRect().getMinY() - 40.0 || (double)node.getYcoord() > this.getVisibleRect().getMaxY() + 40.0 || node.getParent() != null && (double)node.getParent().getXcoord() > this.getVisibleRect().getMaxX();
    }

    private final boolean isNodeDataInvisibleUnrootedCirc(PhylogenyNode node) {
        return (double)node.getYcoord() < this.getVisibleRect().getMinY() - 20.0 || (double)node.getYcoord() > this.getVisibleRect().getMaxY() + 20.0 || (double)node.getXcoord() < this.getVisibleRect().getMinX() - 20.0 || (double)node.getXcoord() > this.getVisibleRect().getMaxX() + 20.0;
    }

    private final boolean isNonLinedUpCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP;
    }

    final boolean isOvOn() {
        return this._ov_on;
    }

    final boolean isPhyHasBranchLengths() {
        return this._phy_has_branch_lengths;
    }

    private final boolean isUniformBranchLengthsForCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP;
    }

    private final void keyPressedCalls(KeyEvent e) {
        if (this.isOvOn() && this.getMousePosition() != null && this.getMousePosition().getLocation() != null) {
            if (this.inOvVirtualRectangle(this.getMousePosition().x, this.getMousePosition().y)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
            }
        }
        if (e.getModifiersEx() == 128) {
            if (e.getKeyCode() == 127 || e.getKeyCode() == 36 || e.getKeyCode() == 70) {
                this.getMainPanel().getTreeFontSet().mediumFonts();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (e.getKeyCode() == 109 || e.getKeyCode() == 45) {
                this.getMainPanel().getTreeFontSet().decreaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (TreePanel.plusPressed(e.getKeyCode())) {
                this.getMainPanel().getTreeFontSet().increaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else {
            if (e.getKeyCode() == 127 || e.getKeyCode() == 36 || e.getKeyCode() == 70) {
                this.getControlPanel().showWhole();
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getModifiersEx() == 64) {
                    if (e.getKeyCode() == 38) {
                        this.getMainPanel().getControlPanel().zoomInY(1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 40) {
                        this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 37) {
                        this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 39) {
                        this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    int d = 80;
                    int dx = 0;
                    int dy = -80;
                    if (e.getKeyCode() == 40) {
                        dy = 80;
                    } else if (e.getKeyCode() == 37) {
                        dx = -80;
                        dy = 0;
                    } else if (e.getKeyCode() == 39) {
                        dx = 80;
                        dy = 0;
                    }
                    Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
                    scroll_position.x += dx;
                    scroll_position.y += dy;
                    if (scroll_position.x <= 0) {
                        scroll_position.x = 0;
                    } else {
                        int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
                        if (scroll_position.x >= max_x) {
                            scroll_position.x = max_x;
                        }
                    }
                    if (scroll_position.y <= 0) {
                        scroll_position.y = 0;
                    } else {
                        int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
                        if (scroll_position.y >= max_y) {
                            scroll_position.y = max_y;
                        }
                    }
                    this.repaint();
                    this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
                }
            } else if (e.getKeyCode() == 109 || e.getKeyCode() == 45) {
                this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (TreePanel.plusPressed(e.getKeyCode())) {
                this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                this.getMainPanel().getControlPanel().zoomInY(1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (e.getKeyCode() == 83) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (e.getKeyCode() == 65) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                    if (this.getStartingAngle() < 0.0) {
                        this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                    }
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (e.getKeyCode() == 68) {
                boolean selected = false;
                if (this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.HORIZONTAL) {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                    selected = true;
                } else {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                }
                if (this.getMainPanel().getMainFrame() == null) {
                    ArchaeopteryxE ae = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                    if (ae.getlabelDirectionCbmi() != null) {
                        ae.getlabelDirectionCbmi().setSelected(selected);
                    }
                } else {
                    this.getMainPanel().getMainFrame().getlabelDirectionCbmi().setSelected(selected);
                }
                this.repaint();
            } else if (e.getKeyCode() == 88) {
                this.switchDisplaygetPhylogenyGraphicsType();
                this.repaint();
            } else if (e.getKeyCode() == 67) {
                this.cycleColors();
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 79) {
                MainFrame.cycleOverview(this.getOptions(), this);
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 73) {
                this.increaseOvSize();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 85) {
                this.decreaseOvSize();
            }
            e.consume();
        }
    }

    private final void makePopupMenus(PhylogenyNode node) {
        this._node_popup_menu = new JPopupMenu();
        List<String> clickto_names = this._main_panel.getControlPanel().getSingleClickToNames();
        this._node_popup_menu_items = new JMenuItem[clickto_names.size()];
        int i = 0;
        while (i < clickto_names.size()) {
            block13: {
                block9: {
                    String title;
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block8: {
                                                        title = clickto_names.get(i);
                                                        this._node_popup_menu_items[i] = new JMenuItem(title);
                                                        if (!title.equals(Configuration.clickto_options[6][0])) break block8;
                                                        this._node_popup_menu_items[i].setEnabled(this.isCanOpenSeqWeb(node));
                                                        break block9;
                                                    }
                                                    if (!title.equals(Configuration.clickto_options[7][0])) break block10;
                                                    this._node_popup_menu_items[i].setEnabled(this.isCanOpenTaxWeb(node));
                                                    break block9;
                                                }
                                                if (!title.equals(Configuration.clickto_options[14][0])) break block11;
                                                this._node_popup_menu_items[i].setEnabled(this.isCanBlast(node));
                                                break block9;
                                            }
                                            if (!title.equals(Configuration.clickto_options[11][0])) break block12;
                                            if (!this.getOptions().isEditable()) break block13;
                                            this._node_popup_menu_items[i].setEnabled(this.isCanDelete());
                                            break block9;
                                        }
                                        if (!title.equals(Configuration.clickto_options[8][0])) break block14;
                                        if (!this.getOptions().isEditable()) break block13;
                                        this._node_popup_menu_items[i].setEnabled(this.isCanCut(node));
                                        break block9;
                                    }
                                    if (!title.equals(Configuration.clickto_options[9][0])) break block15;
                                    if (!this.getOptions().isEditable()) break block13;
                                    this._node_popup_menu_items[i].setEnabled(this.isCanCopy());
                                    break block9;
                                }
                                if (!title.equals(Configuration.clickto_options[10][0])) break block16;
                                if (!this.getOptions().isEditable()) break block13;
                                this._node_popup_menu_items[i].setEnabled(this.isCanPaste());
                                break block9;
                            }
                            if (!title.equals(Configuration.clickto_options[13][0])) break block17;
                            if (this.getOptions().isEditable()) break block9;
                            break block13;
                        }
                        if (!title.equals(Configuration.clickto_options[12][0])) break block18;
                        if (this.getOptions().isEditable()) break block9;
                        break block13;
                    }
                    if (title.equals(Configuration.clickto_options[2][0])) {
                        this._node_popup_menu_items[i].setEnabled(this.isCanReroot());
                    } else if (title.equals(Configuration.clickto_options[1][0])) {
                        this._node_popup_menu_items[i].setEnabled(this.isCanCollapse());
                    } else if (title.equals(Configuration.clickto_options[5][0])) {
                        this._node_popup_menu_items[i].setEnabled(this.isCanColorSubtree());
                    } else if (title.equals(Configuration.clickto_options[3][0])) {
                        this._node_popup_menu_items[i].setEnabled(this.isCanSubtree(node));
                    }
                }
                this._node_popup_menu_items[i].addActionListener(this);
                this._node_popup_menu.add(this._node_popup_menu_items[i]);
            }
            ++i;
        }
    }

    final void midpointRoot() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        if (!this._phylogeny.isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        this.setWaitCursor();
        PhylogenyMethods.midpointRoot(this._phylogeny);
        this.resetNodeIdToDistToLeafMap();
        this.setArrowCursor();
        this.repaint();
    }

    final void mouseClicked(MouseEvent e) {
        if (this.getOptions().isShowOverview() && this.isOvOn() && this.isInOv()) {
            double w_ratio = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
            double h_ratio = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
            double x = ((double)(e.getX() - this.getVisibleRect().x - this.getOvXPosition()) - this.getOvRectangle().getWidth() / 2.0) * w_ratio;
            double y = ((double)(e.getY() - this.getVisibleRect().y - this.getOvYPosition()) - this.getOvRectangle().getHeight() / 2.0) * h_ratio;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            double max_x = this.getWidth() - this.getVisibleRect().width;
            double max_y = this.getHeight() - this.getVisibleRect().height;
            if (x > max_x) {
                x = max_x;
            }
            if (y > max_y) {
                y = max_y;
            }
            this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(new Point(ForesterUtil.roundToInt(x), ForesterUtil.roundToInt(y)));
            this.setInOvRect(true);
            this.repaint();
        } else {
            PhylogenyNode node = this.findNode(e.getX(), e.getY());
            if (node != null) {
                if (!node.isRoot() && node.getParent().isCollapse()) {
                    return;
                }
                this._highlight_node = node;
                if ((e.getModifiers() & 1) != 0) {
                    if (this.getFoundNodes() == null) {
                        this.setFoundNodes(new HashSet<PhylogenyNode>());
                    }
                    this.getFoundNodes().add(node);
                } else if ((e.getModifiers() & 2) != 0) {
                    this.displayNodePopupMenu(node, e.getX(), e.getY());
                } else if (e.getModifiers() == 4) {
                    this.displayNodePopupMenu(node, e.getX(), e.getY());
                } else {
                    this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), node);
                }
            } else {
                this._highlight_node = null;
            }
        }
        this.repaint();
    }

    final void mouseDragInBrowserPanel(MouseEvent e) {
        this.setCursor(MOVE_CURSOR);
        Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        scroll_position.x = (int)((float)scroll_position.x - ((float)e.getX() - this.getLastDragPointX()));
        scroll_position.y = (int)((float)scroll_position.y - ((float)e.getY() - this.getLastDragPointY()));
        if (scroll_position.x < 0) {
            scroll_position.x = 0;
        } else {
            int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (scroll_position.x > max_x) {
                scroll_position.x = max_x;
            }
        }
        if (scroll_position.y < 0) {
            scroll_position.y = 0;
        } else {
            int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (scroll_position.y > max_y) {
                scroll_position.y = max_y;
            }
        }
        if (this.isOvOn() || this.getOptions().isShowScale()) {
            this.repaint();
        }
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
    }

    final void mouseDragInOvRectangle(MouseEvent e) {
        this.setCursor(HAND_CURSOR);
        double w_ratio = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
        double h_ratio = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
        Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        double dx = w_ratio * (double)e.getX() - w_ratio * (double)this.getLastDragPointX();
        double dy = h_ratio * (double)e.getY() - h_ratio * (double)this.getLastDragPointY();
        scroll_position.x = ForesterUtil.roundToInt((double)scroll_position.x + dx);
        scroll_position.y = ForesterUtil.roundToInt((double)scroll_position.y + dy);
        if (scroll_position.x <= 0) {
            scroll_position.x = 0;
            dx = 0.0;
        } else {
            int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (scroll_position.x >= max_x) {
                dx = 0.0;
                scroll_position.x = max_x;
            }
        }
        if (scroll_position.y <= 0) {
            dy = 0.0;
            scroll_position.y = 0;
        } else {
            int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (scroll_position.y >= max_y) {
                dy = 0.0;
                scroll_position.y = max_y;
            }
        }
        this.repaint();
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
        this.setLastMouseDragPointX((float)((double)e.getX() + dx));
        this.setLastMouseDragPointY((float)((double)e.getY() + dy));
    }

    final void mouseMoved(MouseEvent e) {
        this.requestFocusInWindow();
        if (this.getControlPanel().isNodeDescPopup() && this._node_desc_popup != null) {
            this._node_desc_popup.hide();
            this._node_desc_popup = null;
        }
        if (this.getOptions().isShowOverview() && this.isOvOn()) {
            if (this.inOvVirtualRectangle(e)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                    this.repaint();
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
                this.repaint();
            }
        }
        if (this.inOv(e) && this.getOptions().isShowOverview() && this.isOvOn()) {
            if (!this.isInOv()) {
                this.setInOv(true);
            }
        } else {
            PhylogenyNode node;
            if (this.isInOv()) {
                this.setInOv(false);
            }
            if ((node = this.findNode(e.getX(), e.getY())) != null && (node.isRoot() || !node.getParent().isCollapse())) {
                if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.CUT_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.COPY_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.PASTE_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.REROOT || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.ADD_NEW_NODE) {
                    this.setCursor(CUT_CURSOR);
                } else {
                    this.setCursor(HAND_CURSOR);
                    if (this.getControlPanel().isNodeDescPopup()) {
                        this.showNodeDataPopup(e, node);
                    }
                }
            } else {
                this.setCursor(ARROW_CURSOR);
            }
        }
    }

    final void mouseReleasedInBrowserPanel(MouseEvent e) {
        this.setCursor(ARROW_CURSOR);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (this.inOvVirtualRectangle(e)) {
            if (!this.isInOvRect()) {
                this.setInOvRect(true);
                this.repaint();
            }
        } else if (this.isInOvRect()) {
            this.setInOvRect(false);
            this.repaint();
        }
        if (e.isControlDown()) {
            if (notches < 0) {
                this.getTreeFontSet().increaseFontSize();
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else {
                this.getTreeFontSet().decreaseFontSize();
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else if (e.isShiftDown()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                if (notches < 0) {
                    int i = 0;
                    while (i < -notches) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < notches) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                        if (this.getStartingAngle() < 0.0) {
                            this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                        }
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                        ++i;
                    }
                }
            } else if (notches < 0) {
                int i = 0;
                while (i < -notches) {
                    this.getControlPanel().zoomInY(1.08f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < notches) {
                    this.getControlPanel().zoomOutY(0.9259259f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    ++i;
                }
            }
        } else if (notches < 0) {
            int i = 0;
            while (i < -notches) {
                this.getControlPanel().zoomInX(1.08f, 1.085f);
                this.getControlPanel().zoomInY(1.08f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < notches) {
                this.getControlPanel().zoomOutY(0.9259259f);
                this.getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                ++i;
            }
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
    }

    final void multiplyUrtFactor(float f) {
        this._urt_factor *= f;
    }

    final JApplet obtainApplet() {
        return ((MainPanelApplets)this.getMainPanel()).getApplet();
    }

    private final void openSeqWeb(PhylogenyNode node) {
        if (!this.isCanOpenSeqWeb(node)) {
            this.cannotOpenBrowserWarningMessage("sequence");
            return;
        }
        String uri_str = null;
        Sequence seq = node.getNodeData().getSequence();
        String source = seq.getAccession().getSource().toLowerCase();
        WebLink weblink = this.getConfiguration().getWebLink(source);
        try {
            uri_str = weblink.getUrl() + URLEncoder.encode(seq.getAccession().getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.showErrorMessage(this, e.toString());
            e.printStackTrace();
        }
        if (!ForesterUtil.isEmpty(uri_str)) {
            try {
                JApplet applet = null;
                if (this.isApplet()) {
                    applet = this.obtainApplet();
                }
                Util.launchWebBrowser(new URI(uri_str), this.isApplet(), applet, "_aptx_seq");
            }
            catch (IOException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("sequence");
        }
    }

    private final void openTaxWeb(PhylogenyNode node) {
        if (!this.isCanOpenTaxWeb(node)) {
            this.cannotOpenBrowserWarningMessage("taxonomic");
            return;
        }
        String uri_str = null;
        Taxonomy tax = node.getNodeData().getTaxonomy();
        if (tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getProvider())) {
            String type = tax.getIdentifier().getProvider().toLowerCase();
            if (this.getConfiguration().isHasWebLink(type)) {
                WebLink weblink = this.getConfiguration().getWebLink(type);
                try {
                    uri_str = weblink.getUrl() + URLEncoder.encode(tax.getIdentifier().getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Util.showErrorMessage(this, e.toString());
                    e.printStackTrace();
                }
            }
        } else if (!ForesterUtil.isEmpty(tax.getScientificName())) {
            try {
                uri_str = "http://www.eol.org/search?q=" + URLEncoder.encode(tax.getScientificName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            try {
                uri_str = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(tax.getTaxonomyCode(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(tax.getCommonName())) {
            try {
                uri_str = "http://www.eol.org/search?q=" + URLEncoder.encode(tax.getCommonName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        }
        if (!ForesterUtil.isEmpty(uri_str)) {
            try {
                JApplet applet = null;
                if (this.isApplet()) {
                    applet = this.obtainApplet();
                }
                Util.launchWebBrowser(new URI(uri_str), this.isApplet(), applet, "_aptx_tax");
            }
            catch (IOException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                Util.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("taxonomic");
        }
    }

    final void paintBranchCircular(PhylogenyNode p, PhylogenyNode c, Graphics2D g, boolean radial_labels, boolean to_pdf, boolean to_graphics_file) {
        double angle = this._urt_nodeid_angle_map.get(c.getNodeId());
        double root_x = this._root.getXcoord();
        double root_y = this._root.getYcoord();
        double dx = root_x - (double)p.getXcoord();
        double dy = root_y - (double)p.getYcoord();
        double parent_radius = Math.sqrt(dx * dx + dy * dy);
        double arc = this._urt_nodeid_angle_map.get(p.getNodeId()) - angle;
        this.assignGraphicsForBranchWithColorForParentBranch(c, false, g, to_pdf, to_graphics_file);
        if ((c.isFirstChildNode() || c.isLastChildNode()) && (Math.abs(parent_radius * arc) > 1.5 || to_pdf || to_graphics_file)) {
            double r2 = 2.0 * parent_radius;
            this.drawArc(root_x - parent_radius, root_y - parent_radius, r2, r2, -angle - arc, arc, g);
        }
        this.drawLine(c.getXcoord(), c.getYcoord(), root_x + Math.cos(angle) * parent_radius, root_y + Math.sin(angle) * parent_radius, g);
        this.paintNodeBox(c.getXcoord(), c.getYcoord(), c, g, to_pdf, to_graphics_file, this.isInFoundNodes(c));
        if (c.isExternal()) {
            boolean is_in_found_nodes = this.isInFoundNodes(c);
            if (this._dynamic_hiding_factor > 1 && !is_in_found_nodes && this._urt_nodeid_index_map.get(c.getNodeId()) % this._dynamic_hiding_factor != 1) {
                return;
            }
            this.paintNodeDataUnrootedCirc(g, c, to_pdf, to_graphics_file, radial_labels, 0.0, is_in_found_nodes);
        }
    }

    final void paintBranchCircularLite(PhylogenyNode p, PhylogenyNode c, Graphics2D g) {
        double angle = this._urt_nodeid_angle_map.get(c.getNodeId());
        double root_x = this._root.getXSecondary();
        double root_y = this._root.getYSecondary();
        double dx = root_x - (double)p.getXSecondary();
        double dy = root_y - (double)p.getYSecondary();
        double arc = this._urt_nodeid_angle_map.get(p.getNodeId()) - angle;
        double parent_radius = Math.sqrt(dx * dx + dy * dy);
        g.setColor(this.getTreeColorSet().getOvColor());
        if ((c.isFirstChildNode() || c.isLastChildNode()) && Math.abs(arc) > 0.02) {
            double r2 = 2.0 * parent_radius;
            this.drawArc(root_x - parent_radius, root_y - parent_radius, r2, r2, -angle - arc, arc, g);
        }
        this.drawLine(c.getXSecondary(), c.getYSecondary(), root_x + Math.cos(angle) * parent_radius, root_y + Math.sin(angle) * parent_radius, g);
        if (this.isInFoundNodes(c)) {
            g.setColor(this.getTreeColorSet().getFoundColor());
            this.drawRectFilled(c.getXSecondary() - 1.0f, c.getYSecondary() - 1.0f, 3.0, 3.0, g);
        }
    }

    private final void paintBranchLength(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        g.setFont(this.getTreeFontSet().getSmallFont());
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        if (!node.isRoot()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), (double)(node.getParent().getXcoord() + 10.0f), (double)(node.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), g);
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), (double)(node.getParent().getXcoord() + 8.0f), (double)(node.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), g);
            } else {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), (double)(node.getParent().getXcoord() + 3.0f), (double)(node.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), g);
            }
        } else {
            TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), 3.0, (double)(node.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), g);
        }
    }

    private final void paintBranchLite(Graphics2D g, float x1, float x2, float y1, float y2, PhylogenyNode node) {
        g.setColor(this.getTreeColorSet().getOvColor());
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(x1, y1, x2, y2, g);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(x1, y1, x1, y2, x2, y2);
            g.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            this._cubic_curve.setCurve(x1, y1, x1 + dx * 0.4f, y1 + dy * 0.2f, x1 + dx * 0.6f, y1 + dy * 0.8f, x2, y2);
            g.draw(this._cubic_curve);
        } else {
            float x2a = x2;
            float x1a = x1;
            if (node.isFirstChildNode() || node.isLastChildNode()) {
                this.drawLine(x1, y1, x1, y2, g);
            }
            this.drawLine(x1a, y2, x2a, y2, g);
        }
    }

    private final void paintBranchRectangular(Graphics2D g, float x1, float x2, float y1, float y2, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        this.assignGraphicsForBranchWithColorForParentBranch(node, false, g, to_pdf, to_graphics_file);
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(x1, y1, x2, y2, g);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(x1, y1, x1, y2, x2, y2);
            g.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            this._cubic_curve.setCurve(x1, y1, x1 + dx * 0.4f, y1 + dy * 0.2f, x1 + dx * 0.6f, y1 + dy * 0.8f, x2, y2);
            g.draw(this._cubic_curve);
        } else {
            float x2a = x2;
            float x1a = x1;
            boolean draw_horizontal = true;
            float y2_r = 0.0f;
            if (node.isFirstChildNode() || node.isLastChildNode() || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                boolean draw_vertical = true;
                PhylogenyNode parent = node.getParent();
                if ((this.getOptions().isShowNodeBoxes() && !to_pdf && !to_graphics_file || this.getControlPanel().isEvents() && parent != null && parent.isHasAssignedEvent()) && (this._phylogeny.isRooted() || parent == null || !parent.isRoot()) && (!to_pdf && !to_graphics_file || !this.getOptions().isPrintBlackAndWhite() || parent.isDuplication())) {
                    if (this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                        if (Math.abs(y2 - y1) <= 2.0f) {
                            draw_vertical = false;
                        } else {
                            y1 = y1 < y2 ? (y1 += 2.0f) : (!to_pdf ? (y1 -= 3.0f) : (y1 -= 2.0f));
                        }
                    }
                    if (x2 - x1 <= 2.0f) {
                        draw_horizontal = false;
                    } else if (!draw_vertical) {
                        x1a += 2.0f;
                    }
                    if (x2 - x1a > 2.0f && (!to_pdf && !to_graphics_file || !this.getOptions().isPrintBlackAndWhite() || node.isDuplication())) {
                        x2a -= 2.0f;
                    }
                }
                if (!(!draw_vertical || !to_graphics_file && !to_pdf && ((double)y2 < this.getVisibleRect().getMinY() - 20.0 && (double)y1 < this.getVisibleRect().getMinY() - 20.0 || (double)y2 > this.getVisibleRect().getMaxY() + 20.0 && (double)y1 > this.getVisibleRect().getMaxY() + 20.0))) {
                    if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                        float x2c = x1 + 10.0f;
                        if (x2c > x2a) {
                            x2c = x2a;
                        }
                        this.drawLine(x1, y1, x2c, y2, g);
                    } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                        if (y2 > y1) {
                            y2_r = y2 - 8.0f;
                            if (y2_r < y1) {
                                y2_r = y1;
                            }
                            this.drawLine(x1, y1, x1, y2_r, g);
                        } else {
                            y2_r = y2 + 8.0f;
                            if (y2_r > y1) {
                                y2_r = y1;
                            }
                            this.drawLine(x1, y1, x1, y2_r, g);
                        }
                    } else {
                        this.drawLine(x1, y1, x1, y2, g);
                    }
                }
            }
            if (!to_graphics_file && !to_pdf && ((double)y2 < this.getVisibleRect().getMinY() - 20.0 || (double)y2 > this.getVisibleRect().getMaxY() + 20.0)) {
                return;
            }
            float x1_r = 0.0f;
            if (draw_horizontal) {
                if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(node) == 1.0) {
                    if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                        x1_r = x1a + 8.0f;
                        if (x1_r < x2a) {
                            this.drawLine(x1_r, y2, x2a, y2, g);
                        }
                    } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                        float x1c = x1a + 10.0f;
                        if (x1c < x2a) {
                            this.drawLine(x1c, y2, x2a, y2, g);
                        }
                    } else {
                        this.drawLine(x1a, y2, x2a, y2, g);
                    }
                } else {
                    double w = PhylogenyMethods.getBranchWidthValue(node);
                    if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                        x1_r = x1a + 8.0f;
                        if (x1_r < x2a) {
                            this.drawRectFilled(x1_r, (double)y2 - w / 2.0, x2a - x1_r, w, g);
                        }
                    } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                        float x1c = x1a + 10.0f;
                        if (x1c < x2a) {
                            this.drawRectFilled(x1c, (double)y2 - w / 2.0, x2a - x1c, w, g);
                        }
                    } else {
                        this.drawRectFilled(x1a, (double)y2 - w / 2.0, x2a - x1a, w, g);
                    }
                }
            }
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                if (x1_r > x2a) {
                    x1_r = x2a;
                }
                if (y2 > y2_r) {
                    double diff = y2 - y2_r;
                    this._arc.setArc(x1, (double)y2_r - diff, 2.0f * (x1_r - x1), 2.0 * diff, 180.0, 90.0, 0);
                } else {
                    this._arc.setArc(x1, y2, 2.0f * (x1_r - x1), 2.0f * (y2_r - y2), 90.0, 90.0, 0);
                }
                g.draw(this._arc);
            }
        }
        this.paintNodeBox(x2, y2, node, g, to_pdf, to_graphics_file, this.isInFoundNodes(node));
    }

    final void paintCircular(Phylogeny phy, double starting_angle, int center_x, int center_y, int radius, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        this._circ_num_ext_nodes = phy.getNumberOfExternalNodes();
        this._root = phy.getRoot();
        this._root.setXcoord(center_x);
        this._root.setYcoord(center_y);
        this.paintNodeBox(this._root.getXcoord(), this._root.getYcoord(), this._root, g, to_pdf, to_graphics_file, this.isInFoundNodes(this._root));
        boolean radial_labels = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
        double current_angle = starting_angle;
        int i = 0;
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            n.setXcoord((float)((double)center_x + (double)radius * Math.cos(current_angle)));
            n.setYcoord((float)((double)center_y + (double)radius * Math.sin(current_angle)));
            this._urt_nodeid_angle_map.put(n.getNodeId(), current_angle);
            this._urt_nodeid_index_map.put(n.getNodeId(), i++);
            current_angle += Math.PI * 2 / (double)this._circ_num_ext_nodes;
        }
        this.paintCirculars(phy.getRoot(), phy, center_x, center_y, radius, radial_labels, g, to_pdf, to_graphics_file);
    }

    final void paintCircularLite(Phylogeny phy, double starting_angle, int center_x, int center_y, int radius, Graphics2D g) {
        this._circ_num_ext_nodes = phy.getNumberOfExternalNodes();
        this._root = phy.getRoot();
        this._root.setXSecondary(center_x);
        this._root.setYSecondary(center_y);
        double current_angle = starting_angle;
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            n.setXSecondary((float)((double)center_x + (double)radius * Math.cos(current_angle)));
            n.setYSecondary((float)((double)center_y + (double)radius * Math.sin(current_angle)));
            this._urt_nodeid_angle_map.put(n.getNodeId(), current_angle);
            current_angle += Math.PI * 2 / (double)this._circ_num_ext_nodes;
        }
        this.paintCircularsLite(phy.getRoot(), phy, center_x, center_y, radius, g);
    }

    private final double paintCirculars(PhylogenyNode n, Phylogeny phy, float center_x, float center_y, double radius, boolean radial_labels, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        if (n.isExternal()) {
            return this._urt_nodeid_angle_map.get(n.getNodeId());
        }
        List<PhylogenyNode> descs = n.getDescendants();
        double sum = 0.0;
        for (PhylogenyNode desc : descs) {
            sum += this.paintCirculars(desc, phy, center_x, center_y, radius, radial_labels, g, to_pdf, to_graphics_file);
        }
        double r = 0.0;
        if (!n.isRoot()) {
            r = 1.0 - ((double)this._circ_max_depth - (double)PhylogenyMethods.calculateDepth(n)) / (double)this._circ_max_depth;
        }
        double theta = sum / (double)descs.size();
        n.setXcoord((float)((double)center_x + r * radius * Math.cos(theta)));
        n.setYcoord((float)((double)center_y + r * radius * Math.sin(theta)));
        this._urt_nodeid_angle_map.put(n.getNodeId(), theta);
        for (PhylogenyNode desc : descs) {
            this.paintBranchCircular(n, desc, g, radial_labels, to_pdf, to_graphics_file);
        }
        return theta;
    }

    private final void paintCircularsLite(PhylogenyNode n, Phylogeny phy, int center_x, int center_y, int radius, Graphics2D g) {
        if (n.isExternal()) {
            return;
        }
        List<PhylogenyNode> descs = n.getDescendants();
        for (PhylogenyNode desc : descs) {
            this.paintCircularsLite(desc, phy, center_x, center_y, radius, g);
        }
        float r = 0.0f;
        if (!n.isRoot()) {
            r = 1.0f - ((float)this._circ_max_depth - (float)PhylogenyMethods.calculateDepth(n)) / (float)this._circ_max_depth;
        }
        double theta = this._urt_nodeid_angle_map.get(n.getNodeId());
        n.setXSecondary((float)((double)center_x + (double)((float)radius * r) * Math.cos(theta)));
        n.setYSecondary((float)((double)center_y + (double)((float)radius * r) * Math.sin(theta)));
        for (PhylogenyNode desc : descs) {
            this.paintBranchCircularLite(n, desc, g);
        }
    }

    private final void paintCollapsedNode(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf, boolean is_in_found_nodes) {
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (is_in_found_nodes) {
            g.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            g.setColor(this.getTaxonomyBasedColor(node));
        } else {
            g.setColor(this.getTreeColorSet().getCollapseFillColor());
        }
        double d = node.getAllExternalDescendants().size();
        d = d > 1000.0 ? (double)(3.0f * this._y_distance / 3.0f) : Math.log10(d) * (double)this._y_distance / 2.5;
        if (d < 4.0) {
            d = 4.0;
        }
        this._polygon.reset();
        this._polygon.addPoint(ForesterUtil.roundToInt(node.getXcoord() - 4.0f), ForesterUtil.roundToInt(node.getYcoord()));
        this._polygon.addPoint(ForesterUtil.roundToInt(node.getXcoord() + 4.0f), ForesterUtil.roundToInt((double)node.getYcoord() - d));
        this._polygon.addPoint(ForesterUtil.roundToInt(node.getXcoord() + 4.0f), ForesterUtil.roundToInt((double)node.getYcoord() + d));
        g.fillPolygon(this._polygon);
        this.paintNodeData(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
    }

    @Override
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this._rendering_hints);
        this.paintPhylogeny(g2d, false, false, 0, 0, 0, 0);
    }

    private final void paintConfidenceValues(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        String conf_str = "";
        List<Confidence> confidences = node.getBranchData().getConfidences();
        if (confidences.size() == 1) {
            double value = node.getBranchData().getConfidence(0).getValue();
            if (value == -9999.0 || value < this.getOptions().getMinConfidenceValue()) {
                return;
            }
            conf_str = FORMATTER_CONFIDENCE.format(value);
        } else if (confidences.size() > 1) {
            boolean one_ok = false;
            boolean not_first = false;
            Collections.sort(confidences);
            StringBuilder sb = new StringBuilder();
            for (Confidence confidence : confidences) {
                double value = confidence.getValue();
                if (value == -9999.0) continue;
                if (value >= this.getOptions().getMinConfidenceValue()) {
                    one_ok = true;
                }
                if (not_first) {
                    sb.append("/");
                } else {
                    not_first = true;
                }
                sb.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(value, this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            }
            if (one_ok) {
                conf_str = sb.toString();
            }
        }
        if (conf_str.length() > 0) {
            double parent_x = node.getParent().getXcoord();
            double x = node.getXcoord();
            g.setFont(this.getTreeFontSet().getSmallFont());
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                x += 10.0;
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                x += 8.0;
            }
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getTreeColorSet().getConfidenceColor());
            }
            TreePanel.drawString(conf_str, parent_x + (x - parent_x - (double)this.getTreeFontSet()._fm_small.stringWidth(conf_str)) / 2.0, (double)(node.getYcoord() + (float)this.getTreeFontSet()._small_max_ascent - 1.0f), g);
        }
    }

    private final void paintFoundNode(int x, int y, Graphics2D g) {
        g.setColor(this.getTreeColorSet().getFoundColor());
        g.fillRect(x - 2, y - 2, 4, 4);
    }

    private final void paintGainedAndLostCharacters(Graphics2D g, PhylogenyNode node, String gained, String lost) {
        if (node.getParent() != null) {
            double parent_x = node.getParent().getXcoord();
            double x = node.getXcoord();
            g.setFont(this.getTreeFontSet().getLargeFont());
            g.setColor(this.getTreeColorSet().getGainedCharactersColor());
            TreePanel.drawString(gained, parent_x + (x - parent_x - (double)this.getTreeFontSet()._fm_large.stringWidth(gained)) / 2.0, (double)(node.getYcoord() - (float)this.getTreeFontSet()._fm_large.getMaxDescent() - 1.0f), g);
            g.setColor(this.getTreeColorSet().getLostCharactersColor());
            TreePanel.drawString(lost, parent_x + (x - parent_x - (double)this.getTreeFontSet()._fm_large.stringWidth(lost)) / 2.0, (double)(node.getYcoord() + (float)this.getTreeFontSet()._fm_large.getMaxAscent() + 1.0f), g);
        }
    }

    private final void paintNodeBox(double x, double y, PhylogenyNode node, Graphics2D g, boolean to_pdf, boolean to_graphics_file, boolean is_in_found_nodes) {
        if (node.isCollapse()) {
            return;
        }
        if (this._highlight_node == node && !to_pdf && !to_graphics_file) {
            g.setColor(this.getTreeColorSet().getFoundColor());
            this.drawOval(x - 8.0, y - 8.0, 16.0, 16.0, g);
            this.drawOval(x - 9.0, y - 8.0, 17.0, 17.0, g);
            this.drawOval(x - 9.0, y - 9.0, 18.0, 18.0, g);
        }
        if (is_in_found_nodes) {
            this.paintFoundNode(ForesterUtil.roundToInt(x), ForesterUtil.roundToInt(y), g);
        } else {
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else if (this.getControlPanel().isEvents() && Util.isHasAssignedEvent(node)) {
                Event event = node.getNodeData().getEvent();
                if (event.isDuplication()) {
                    g.setColor(this.getTreeColorSet().getDuplicationBoxColor());
                } else if (event.isSpeciation()) {
                    g.setColor(this.getTreeColorSet().getSpecBoxColor());
                } else if (event.isSpeciationOrDuplication()) {
                    g.setColor(this.getTreeColorSet().getDuplicationOrSpeciationColor());
                }
            } else {
                this.assignGraphicsForNodeBoxWithColorForParentBranch(node, g);
            }
            if (this.getOptions().isShowNodeBoxes() && !to_pdf && !to_graphics_file || this.getControlPanel().isEvents() && node.isHasAssignedEvent()) {
                if (to_pdf || to_graphics_file) {
                    if (node.isDuplication() || !this.getOptions().isPrintBlackAndWhite()) {
                        this.drawOvalFilled(x - 2.0, y - 2.0, 4.0, 4.0, g);
                    }
                } else {
                    this.drawRectFilled(x - 2.0, y - 2.0, 4.0, 4.0, g);
                }
            }
        }
    }

    private final void paintNodeData(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf, boolean is_in_found_nodes) {
        if (this.isNodeDataInvisible(node) && !to_graphics_file && !to_pdf) {
            return;
        }
        if (this.getOptions().isShowBranchLengthValues() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && !node.isRoot() && node.getDistanceToParent() != -1024.0) {
            this.paintBranchLength(g, node, to_pdf, to_graphics_file);
        }
        if (!(this.getControlPanel().isShowInternalData() || node.isExternal() || node.isCollapse())) {
            return;
        }
        int x = 0;
        if (node.getNodeData().isHasTaxonomy() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyNames())) {
            x = this.paintTaxonomy(g, node, is_in_found_nodes, to_pdf, to_graphics_file);
        }
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (is_in_found_nodes) {
            g.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            g.setColor(this.getTaxonomyBasedColor(node));
        } else {
            g.setColor(this.getTreeColorSet().getSequenceColor());
        }
        this._sb.setLength(0);
        if (node.isCollapse() && (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot())) {
            this._sb.append(" [");
            this._sb.append(node.getAllExternalDescendants().size());
            this._sb.append("]");
        }
        if (this.getControlPanel().isShowNodeNames() && node.getNodeName().length() > 0) {
            if (this._sb.length() > 0) {
                this._sb.append(" ");
            }
            this._sb.append(node.getNodeName());
        }
        if (node.getNodeData().isHasSequence()) {
            if (this.getControlPanel().isShowGeneSymbols() && node.getNodeData().getSequence().getSymbol().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(node.getNodeData().getSequence().getSymbol());
            }
            if (this.getControlPanel().isShowGeneNames() && node.getNodeData().getSequence().getName().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(node.getNodeData().getSequence().getName());
            }
            if (this.getControlPanel().isShowSequenceAcc() && node.getNodeData().getSequence().getAccession() != null) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getSource())) {
                    this._sb.append(node.getNodeData().getSequence().getAccession().getSource());
                    this._sb.append(":");
                }
                this._sb.append(node.getNodeData().getSequence().getAccession().getValue());
            }
        }
        g.setFont(this.getTreeFontSet().getLargeFont());
        if (is_in_found_nodes) {
            g.setFont(this.getTreeFontSet().getLargeFont().deriveFont(1));
        }
        double down_shift_factor = 3.0;
        if (!node.isExternal() && node.getNumberOfDescendants() == 1) {
            down_shift_factor = 1.0;
        }
        if (this._sb.length() > 0) {
            TreePanel.drawString(this._sb.toString(), (double)(node.getXcoord() + (float)x + 2.0f + 2.0f), (double)node.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / down_shift_factor, g);
        }
        if (this.getControlPanel().isShowAnnotation() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAnnotations() != null && !node.getNodeData().getSequence().getAnnotations().isEmpty()) {
            if (this._sb.length() > 0) {
                x += this.getTreeFontSet()._fm_large.stringWidth(this._sb.toString()) + 5;
            }
            Annotation ann = (Annotation)node.getNodeData().getSequence().getAnnotations().get(0);
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.calculateColorForAnnotation(ann));
            }
            String ann_str = ann.asSimpleText().toString();
            TreePanel.drawString(ann_str, (double)(node.getXcoord() + (float)x + 3.0f + 2.0f), (double)node.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / down_shift_factor, g);
            this._sb.setLength(0);
            this._sb.append(ann_str);
        }
        if ((this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) && (this.getControlPanel().isShowBinaryCharacters() || this.getControlPanel().isShowBinaryCharacterCounts()) && node.getNodeData().isHasBinaryCharacters()) {
            if (this._sb.length() > 0) {
                x += this.getTreeFontSet()._fm_large.stringWidth(this._sb.toString()) + 5;
            }
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getTreeColorSet().getBinaryDomainCombinationsColor());
            }
            if (this.getControlPanel().isShowBinaryCharacters()) {
                TreePanel.drawString(node.getNodeData().getBinaryCharacters().getPresentCharactersAsStringBuffer().toString(), (double)(node.getXcoord() + (float)x + 1.0f + 2.0f), (double)node.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / down_shift_factor, g);
                this.paintGainedAndLostCharacters(g, node, node.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString(), node.getNodeData().getBinaryCharacters().getLostCharactersAsStringBuffer().toString());
            } else {
                TreePanel.drawString(node.getNodeData().getBinaryCharacters().getPresentCount(), (double)(node.getXcoord() + (float)x + 2.0f + 2.0f), (double)node.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / down_shift_factor, g);
                this.paintGainedAndLostCharacters(g, node, "+" + node.getNodeData().getBinaryCharacters().getGainedCount(), "-" + node.getNodeData().getBinaryCharacters().getLostCount());
            }
        }
    }

    private final void paintNodeDataUnrootedCirc(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file, boolean radial_labels, double ur_angle, boolean is_in_found_nodes) {
        if (this.isNodeDataInvisibleUnrootedCirc(node) && !to_graphics_file && !to_pdf) {
            return;
        }
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (is_in_found_nodes) {
            g.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            g.setColor(this.getTaxonomyBasedColor(node));
        } else {
            g.setColor(this.getTreeColorSet().getSequenceColor());
        }
        this._sb.setLength(0);
        this._sb.append(" ");
        if (node.getNodeData().isHasTaxonomy() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyNames())) {
            Taxonomy taxonomy = node.getNodeData().getTaxonomy();
            if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                this._sb.append(taxonomy.getTaxonomyCode());
                this._sb.append(" ");
            }
            if (this._control_panel.isShowTaxonomyNames()) {
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" (");
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(") ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(" ");
                }
            }
        }
        if (node.isCollapse() && (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot())) {
            this._sb.append(" [");
            this._sb.append(node.getAllExternalDescendants().size());
            this._sb.append("]");
        }
        if (this.getControlPanel().isShowNodeNames() && node.getNodeName().length() > 0) {
            if (this._sb.length() > 0) {
                this._sb.append(" ");
            }
            this._sb.append(node.getNodeName());
        }
        if (node.getNodeData().isHasSequence()) {
            if (this.getControlPanel().isShowSequenceAcc() && node.getNodeData().getSequence().getAccession() != null) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getSource())) {
                    this._sb.append(node.getNodeData().getSequence().getAccession().getSource());
                    this._sb.append(":");
                }
                this._sb.append(node.getNodeData().getSequence().getAccession().getValue());
            }
            if (this.getControlPanel().isShowGeneNames() && node.getNodeData().getSequence().getName().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(node.getNodeData().getSequence().getName());
            }
        }
        g.setFont(this.getTreeFontSet().getLargeFont());
        if (is_in_found_nodes) {
            g.setFont(this.getTreeFontSet().getLargeFont().deriveFont(1));
        }
        if (this._sb.length() > 1) {
            String sb_str = this._sb.toString();
            double m = 0.0;
            m = this._graphics_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR ? this._urt_nodeid_angle_map.get(node.getNodeId()) % (Math.PI * 2) : (double)((float)(ur_angle % (Math.PI * 2)));
            this._at = g.getTransform();
            boolean need_to_reset = false;
            float x_coord = node.getXcoord();
            float y_coord = node.getYcoord() + (float)this.getTreeFontSet()._fm_large.getAscent() / 3.0f;
            if (radial_labels) {
                need_to_reset = true;
                boolean left = false;
                if (m > 1.5707963705062866 && m < 4.71238899230957) {
                    m -= 3.1415927410125732;
                    left = true;
                }
                g.rotate(m, x_coord, node.getYcoord());
                if (left) {
                    g.translate(-this.getTreeFontSet()._fm_large.getStringBounds(sb_str, g).getWidth(), 0.0);
                }
            } else if (m > 1.5707963705062866 && m < 4.71238899230957) {
                need_to_reset = true;
                g.translate(-this.getTreeFontSet()._fm_large.getStringBounds(sb_str, g).getWidth(), 0.0);
            }
            TreePanel.drawString(sb_str, (double)x_coord, (double)y_coord, g);
            if (need_to_reset) {
                g.setTransform(this._at);
            }
        }
    }

    private final void paintNodeLite(Graphics2D g, PhylogenyNode node) {
        if (node.isCollapse()) {
            if (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot()) {
                this.paintCollapsedNode(g, node, false, false, false);
            }
            return;
        }
        if (this.isInFoundNodes(node)) {
            g.setColor(this.getTreeColorSet().getFoundColor());
            this.drawRectFilled(node.getXSecondary() - 1.0f, node.getYSecondary() - 1.0f, 3.0, 3.0, g);
        }
        float new_x = 0.0f;
        if (!node.isExternal() && !node.isCollapse()) {
            boolean first_child = true;
            float y2 = 0.0f;
            short parent_max_branch_to_leaf = this.getMaxBranchesToLeaf(node);
            int i = 0;
            while (i < node.getNumberOfDescendants()) {
                PhylogenyNode child_node = node.getChildNode(i);
                int factor_x = !this.isUniformBranchLengthsForCladogram() ? node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes() : parent_max_branch_to_leaf - this.getMaxBranchesToLeaf(child_node);
                if (first_child) {
                    first_child = false;
                    y2 = node.getYSecondary() - this.getOvYDistance() * (float)(node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes());
                } else {
                    y2 += this.getOvYDistance() * (float)child_node.getNumberOfExternalNodes();
                }
                float x2 = this.calculateOvBranchLengthToParent(child_node, factor_x);
                new_x = x2 + node.getXSecondary();
                float diff_y = node.getYSecondary() - y2;
                float diff_x = node.getXSecondary() - new_x;
                if (diff_y > 2.0f || diff_y < -2.0f || diff_x > 2.0f || diff_x < -2.0f) {
                    this.paintBranchLite(g, node.getXSecondary(), new_x, node.getYSecondary(), y2, child_node);
                }
                child_node.setXSecondary(new_x);
                child_node.setYSecondary(y2);
                y2 += this.getOvYDistance() * (float)child_node.getNumberOfExternalNodes();
                ++i;
            }
        }
    }

    private final void paintNodeRectangular(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean dynamically_hide, int dynamic_hiding_factor, boolean to_graphics_file) {
        boolean is_in_found_nodes = this.isInFoundNodes(node);
        if (node.isCollapse()) {
            if (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot()) {
                this.paintCollapsedNode(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
            }
            return;
        }
        if (node.isExternal()) {
            ++this._external_node_index;
        }
        if (this.getControlPanel().isShowBootstrapValues() && !node.isExternal() && !node.isRoot() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && node.getBranchData().isHasConfidences()) {
            this.paintConfidenceValues(g, node, to_pdf, to_graphics_file);
        }
        if (node.isRoot() && this._phylogeny.isRooted()) {
            this.paintRootBranch(g, node.getXcoord(), node.getYcoord(), node, to_pdf, to_graphics_file);
        }
        float new_x = 0.0f;
        float new_x_min = Float.MAX_VALUE;
        boolean disallow_shortcutting = dynamic_hiding_factor < 40;
        float min_dist = 1.5f;
        if (!disallow_shortcutting) {
            if (dynamic_hiding_factor > 4000) {
                min_dist = 4.0f;
            } else if (dynamic_hiding_factor > 1000) {
                min_dist = 3.0f;
            } else if (dynamic_hiding_factor > 100) {
                min_dist = 2.0f;
            }
        }
        if (!node.isExternal() && !node.isCollapse()) {
            boolean first_child = true;
            float y2 = 0.0f;
            short parent_max_branch_to_leaf = this.getMaxBranchesToLeaf(node);
            int i = 0;
            while (i < node.getNumberOfDescendants()) {
                PhylogenyNode child_node = node.getChildNode(i);
                int factor_x = !this.isUniformBranchLengthsForCladogram() ? node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes() : parent_max_branch_to_leaf - this.getMaxBranchesToLeaf(child_node);
                if (first_child) {
                    first_child = false;
                    y2 = node.getYcoord() - this._y_distance * (float)(node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes());
                } else {
                    y2 += this._y_distance * (float)child_node.getNumberOfExternalNodes();
                }
                float x2 = this.calculateBranchLengthToParent(child_node, factor_x);
                new_x = x2 + node.getXcoord();
                if (dynamically_hide && x2 < new_x_min) {
                    new_x_min = x2;
                }
                float diff_y = node.getYcoord() - y2;
                float diff_x = node.getXcoord() - new_x;
                if (disallow_shortcutting || diff_y > min_dist || diff_y < -min_dist || diff_x > min_dist || diff_x < -min_dist || to_graphics_file || to_pdf) {
                    this.paintBranchRectangular(g, node.getXcoord(), new_x, node.getYcoord(), y2, child_node, to_pdf, to_graphics_file);
                }
                child_node.setXcoord(new_x);
                child_node.setYcoord(y2);
                y2 += this._y_distance * (float)child_node.getNumberOfExternalNodes();
                ++i;
            }
        }
        if (dynamically_hide && !is_in_found_nodes && (node.isExternal() && this._external_node_index % dynamic_hiding_factor != 1 || !node.isExternal() && (new_x_min < 20.0f || this._y_distance * (float)node.getNumberOfExternalNodes() < (float)this.getTreeFontSet()._fm_large.getHeight()))) {
            return;
        }
        this.paintNodeData(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
        this.paintNodeWithRenderableData(g, node, to_graphics_file, to_pdf);
    }

    private final void paintNodeWithRenderableData(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf) {
        if (this.isNodeDataInvisible(node) && !to_graphics_file) {
            return;
        }
        if (!this.getControlPanel().isShowInternalData() && !node.isExternal()) {
            return;
        }
        if (this.getControlPanel().isShowDomainArchitectures() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
            RenderableDomainArchitecture rds = null;
            try {
                rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
            }
            catch (ClassCastException cce) {
                return;
            }
            rds.setRenderingHeight(6.0);
            int x = 0;
            if (this.getControlPanel().isShowTaxonomyCode() && PhylogenyMethods.getSpecies(node).length() > 0) {
                x += this.getTreeFontSet()._fm_large_italic.stringWidth(String.valueOf(PhylogenyMethods.getSpecies(node)) + " ");
            }
            if (this.getControlPanel().isShowNodeNames() && node.getNodeName().length() > 0) {
                x += this.getTreeFontSet()._fm_large.stringWidth(String.valueOf(node.getNodeName()) + " ");
            }
            rds.render(node.getXcoord() + (float)x, node.getYcoord() - 3.0f, g, this, to_pdf);
        }
    }

    private final void paintOvRectangle(Graphics2D g) {
        float w_ratio = (float)this.getWidth() / (float)this.getVisibleRect().width;
        float h_ratio = (float)this.getHeight() / (float)this.getVisibleRect().height;
        float x_ratio = (float)this.getWidth() / (float)this.getVisibleRect().x;
        float y_ratio = (float)this.getHeight() / (float)this.getVisibleRect().y;
        float width = this.getOvMaxWidth() / w_ratio;
        float height = this.getOvMaxHeight() / h_ratio;
        float x = (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / x_ratio;
        float y = (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / y_ratio;
        g.setColor(this.getTreeColorSet().getFoundColor());
        this.getOvRectangle().setRect(x, y, width, height);
        if (width < 6.0f && height < 6.0f) {
            this.drawRectFilled(x, y, 6.0, 6.0, g);
            this.getOvVirtualRectangle().setRect(x, y, 6.0, 6.0);
        } else if (width < 6.0f) {
            this.drawRectFilled(x, y, 6.0, height, g);
            this.getOvVirtualRectangle().setRect(x, y, 6.0, height);
        } else if (height < 6.0f) {
            this.drawRectFilled(x, y, width, 6.0, g);
            this.getOvVirtualRectangle().setRect(x, y, width, 6.0);
        } else {
            this.drawRect(x, y, width, height, g);
            if (this.isInOvRect()) {
                this.drawRect(x + 1.0f, y + 1.0f, width - 2.0f, height - 2.0f, g);
            }
            this.getOvVirtualRectangle().setRect(x, y, width, height);
        }
    }

    final void paintPhylogeny(Graphics2D g, boolean to_pdf, boolean to_graphics_file, int graphics_file_width, int graphics_file_height, int graphics_file_x, int graphics_file_y) {
        if (!to_pdf) {
            Rectangle r = this.getVisibleRect();
            if (!this.getOptions().isBackgroundColorGradient() || this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(this.getTreeColorSet().getBackgroundColor());
                if (!to_graphics_file) {
                    g.fill(r);
                } else {
                    if (this.getOptions().isPrintBlackAndWhite()) {
                        g.setColor(Color.WHITE);
                    }
                    g.fillRect(graphics_file_x, graphics_file_y, graphics_file_width, graphics_file_height);
                }
            } else if (!to_graphics_file) {
                g.setPaint(new GradientPaint(r.x, r.y, this.getTreeColorSet().getBackgroundColor(), r.x, r.y + r.height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                g.fill(r);
            } else {
                g.setPaint(new GradientPaint(graphics_file_x, graphics_file_y, this.getTreeColorSet().getBackgroundColor(), graphics_file_x, graphics_file_y + graphics_file_height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                g.fillRect(graphics_file_x, graphics_file_y, graphics_file_width, graphics_file_height);
            }
            g.setStroke(new BasicStroke(1.0f));
        } else {
            g.setStroke(new BasicStroke(this.getOptions().getPrintLineWidth()));
        }
        if (this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this._external_node_index = 0;
            if (!this._phylogeny.isRooted()) {
                this._phylogeny.getRoot().setXcoord(20.0f);
            } else if (this._phylogeny.getRoot().getDistanceToParent() > 0.0 && this.getControlPanel().isDrawPhylogram()) {
                this._phylogeny.getRoot().setXcoord((float)(20.0 + this._phylogeny.getRoot().getDistanceToParent() * (double)this.getXcorrectionFactor()));
            } else {
                this._phylogeny.getRoot().setXcoord(20.0f + this.getXdistance());
            }
            this._phylogeny.getRoot().setYcoord(this.getYdistance() * (float)this._phylogeny.getRoot().getNumberOfExternalNodes() + 10.0f);
            int dynamic_hiding_factor = (int)((double)this.getTreeFontSet()._fm_large.getHeight() / (1.5 * (double)this.getYdistance()));
            if (this.getControlPanel().isDynamicallyHideData()) {
                if (dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            PhylogenyNodeIterator it = this._phylogeny.iteratorPreorder();
            while (it.hasNext()) {
                this.paintNodeRectangular(g, it.next(), to_pdf, this.getControlPanel().isDynamicallyHideData() && dynamic_hiding_factor > 1, dynamic_hiding_factor, to_graphics_file);
            }
            if (this.getOptions().isShowScale()) {
                if (!to_graphics_file && !to_pdf) {
                    this.paintScale(g, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, to_pdf, to_graphics_file);
                } else {
                    this.paintScale(g, graphics_file_x, graphics_file_y + graphics_file_height, to_pdf, to_graphics_file);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                this.paintPhylogenyLite(g);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                this.getControlPanel().setDynamicHidingIsOn(false);
            }
            double angle = this.getStartingAngle();
            boolean radial_labels = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData()) {
                this._dynamic_hiding_factor = (int)((double)this.getTreeFontSet()._fm_large.getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / 62.83185307179586);
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintUnrooted(this._phylogeny.getRoot(), angle, (float)(angle + Math.PI * 2), radial_labels, g, to_pdf, to_graphics_file);
            if (this.getOptions().isShowScale()) {
                if (!to_graphics_file && !to_pdf) {
                    this.paintScale(g, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, to_pdf, to_graphics_file);
                } else {
                    this.paintScale(g, graphics_file_x, graphics_file_y + graphics_file_height, to_pdf, to_graphics_file);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                g.setColor(this.getTreeColorSet().getOvColor());
                this.paintUnrootedLite(this._phylogeny.getRoot(), angle, angle + Math.PI * 2, g, this.getUrtFactorOv() / ((float)this.getVisibleRect().width / this.getOvMaxWidth()));
                this.paintOvRectangle(g);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            int radius = (int)(Math.min(this.getPreferredSize().getWidth(), this.getPreferredSize().getHeight()) / 2.0 - (double)(20 + this.getLongestExtNodeInfo()));
            int d = radius + 20 + this.getLongestExtNodeInfo();
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData() && radius > 0) {
                this._dynamic_hiding_factor = (int)((double)this.getTreeFontSet()._fm_large.getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / (Math.PI * 2 * (double)radius));
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintCircular(this._phylogeny, this.getStartingAngle(), d, d, radius > 0 ? radius : 0, g, to_pdf, to_graphics_file);
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                int radius_ov = (int)(this.getOvMaxHeight() < this.getOvMaxWidth() ? this.getOvMaxHeight() / 2.0f : this.getOvMaxWidth() / 2.0f);
                double x_scale = 1.0;
                double y_scale = 1.0;
                int x_pos = this.getVisibleRect().x + this.getOvXPosition();
                int y_pos = this.getVisibleRect().y + this.getOvYPosition();
                if (this.getWidth() > this.getHeight()) {
                    x_scale = (double)this.getHeight() / (double)this.getWidth();
                    x_pos = ForesterUtil.roundToInt((double)x_pos / x_scale);
                } else {
                    y_scale = (double)this.getWidth() / (double)this.getHeight();
                    y_pos = ForesterUtil.roundToInt((double)y_pos / y_scale);
                }
                this._at = g.getTransform();
                g.scale(x_scale, y_scale);
                this.paintCircularLite(this._phylogeny, this.getStartingAngle(), x_pos + radius_ov, y_pos + radius_ov, (int)((double)radius_ov - (double)this.getLongestExtNodeInfo() / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())), g);
                g.setTransform(this._at);
                this.paintOvRectangle(g);
            }
        }
    }

    private final void paintPhylogenyLite(Graphics2D g) {
        this._phylogeny.getRoot().setXSecondary((float)((double)(this.getVisibleRect().x + this.getOvXPosition()) + 20.0 / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())));
        this._phylogeny.getRoot().setYSecondary(this.getVisibleRect().y + this.getOvYStart());
        PhylogenyNodeIterator it = this._phylogeny.iteratorPreorder();
        while (it.hasNext()) {
            this.paintNodeLite(g, it.next());
        }
        this.paintOvRectangle(g);
    }

    private final void paintRootBranch(Graphics2D g, float x1, float y1, PhylogenyNode root, boolean to_pdf, boolean to_graphics_file) {
        this.assignGraphicsForBranchWithColorForParentBranch(root, false, g, to_pdf, to_graphics_file);
        float d = this.getXdistance();
        if (this.getControlPanel().isDrawPhylogram() && root.getDistanceToParent() > 0.0) {
            d = (float)((double)this.getXcorrectionFactor() * root.getDistanceToParent());
        }
        if (d < 3.0f) {
            d = 3.0f;
        }
        if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(root) == 1.0) {
            this.drawLine(x1 - d, root.getYcoord(), x1, root.getYcoord(), g);
        } else {
            double w = PhylogenyMethods.getBranchWidthValue(root);
            this.drawRectFilled(x1 - d, (double)root.getYcoord() - w / 2.0, d, w, g);
        }
        this.paintNodeBox(x1, root.getYcoord(), root, g, to_pdf, to_graphics_file, this.isInFoundNodes(root));
    }

    private final void paintScale(Graphics2D g, int x1, int y1, boolean to_pdf, boolean to_graphics_file) {
        if (!this.getControlPanel().isDrawPhylogram() || this.getScaleDistance() <= 0.0) {
            return;
        }
        double x2 = (double)(x1 += 20) + this.getScaleDistance() * (double)this.getXcorrectionFactor();
        int y2 = (y1 -= 12) - 8;
        int y3 = y1 - 4;
        g.setFont(this.getTreeFontSet().getSmallFont());
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        this.drawLine(x1, y1, x1, y2, g);
        this.drawLine(x2, y1, x2, y2, g);
        this.drawLine(x1, y3, x2, y3, g);
        if (this.getScaleLabel() != null) {
            g.drawString(this.getScaleLabel(), x1 + 2, y3 - 2);
        }
    }

    private final int paintTaxonomy(Graphics2D g, PhylogenyNode node, boolean is_in_found_nodes, boolean to_pdf, boolean to_graphics_file) {
        Taxonomy taxonomy = node.getNodeData().getTaxonomy();
        g.setFont(this.getTreeFontSet().getLargeItalicFont());
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (is_in_found_nodes) {
            g.setFont(this.getTreeFontSet().getLargeItalicFont().deriveFont(3));
            g.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            g.setColor(this.getTaxonomyBasedColor(node));
        } else {
            g.setColor(this.getTreeColorSet().getTaxonomyColor());
        }
        double start_x = node.getXcoord() + 3.0f + 2.0f;
        double start_y = (double)node.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / (node.getNumberOfDescendants() == 1 ? 1.0 : 3.0);
        this._sb.setLength(0);
        if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            this._sb.append(taxonomy.getTaxonomyCode());
            this._sb.append(" ");
        }
        if (this._control_panel.isShowTaxonomyNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                this._sb.append(taxonomy.getScientificName());
                this._sb.append(" (");
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(") ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                this._sb.append(taxonomy.getScientificName());
                this._sb.append(" ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(" ");
            }
        }
        String label = this._sb.toString();
        TreePanel.drawString(label, start_x, start_y, g);
        if (is_in_found_nodes) {
            return this.getTreeFontSet()._fm_large_italic_bold.stringWidth(label);
        }
        return this.getTreeFontSet()._fm_large_italic.stringWidth(label);
    }

    private final void paintUnrooted(PhylogenyNode n, double low_angle, double high_angle, boolean radial_labels, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        if (n.isRoot()) {
            n.setXcoord(this.getWidth() / 2);
            n.setYcoord(this.getHeight() / 2);
            this.paintNodeBox(n.getXcoord(), n.getYcoord(), n, g, to_pdf, to_graphics_file, this.isInFoundNodes(n));
        }
        if (n.isExternal()) {
            this.paintNodeDataUnrootedCirc(g, n, to_pdf, to_graphics_file, radial_labels, (high_angle + low_angle) / 2.0, this.isInFoundNodes(n));
            return;
        }
        float num_enclosed = n.getNumberOfExternalNodes();
        float x = n.getXcoord();
        float y = n.getYcoord();
        double current_angle = low_angle;
        int i = 0;
        while (i < n.getNumberOfDescendants()) {
            PhylogenyNode desc = n.getChildNode(i);
            int desc_num_enclosed = desc.getNumberOfExternalNodes();
            double arc_size = (double)((float)desc_num_enclosed / num_enclosed) * (high_angle - low_angle);
            float length = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (desc.getDistanceToParent() < 0.0 ? 0.0f : (float)(desc.getDistanceToParent() * (double)this.getUrtFactor())) : this.getUrtFactor();
            double mid_angle = current_angle + arc_size / 2.0;
            float new_x = (float)((double)x + Math.cos(mid_angle) * (double)length);
            float new_y = (float)((double)y + Math.sin(mid_angle) * (double)length);
            desc.setXcoord(new_x);
            desc.setYcoord(new_y);
            this.paintNodeBox(new_x, new_y, desc, g, to_pdf, to_graphics_file, this.isInFoundNodes(desc));
            this.paintUnrooted(desc, current_angle, current_angle + arc_size, radial_labels, g, to_pdf, to_graphics_file);
            current_angle += arc_size;
            this.assignGraphicsForBranchWithColorForParentBranch(desc, false, g, to_pdf, to_graphics_file);
            this.drawLine(x, y, new_x, new_y, g);
            ++i;
        }
    }

    private final void paintUnrootedLite(PhylogenyNode n, double low_angle, double high_angle, Graphics2D g, float urt_ov_factor) {
        if (n.isRoot()) {
            int x_pos = (int)((float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / 2.0f);
            int y_pos = (int)((float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / 2.0f);
            n.setXSecondary(x_pos);
            n.setYSecondary(y_pos);
        }
        if (n.isExternal()) {
            return;
        }
        float num_enclosed = n.getNumberOfExternalNodes();
        float x = n.getXSecondary();
        float y = n.getYSecondary();
        double current_angle = low_angle;
        int i = 0;
        while (i < n.getNumberOfDescendants()) {
            PhylogenyNode desc = n.getChildNode(i);
            int desc_num_enclosed = desc.getNumberOfExternalNodes();
            double arc_size = (double)((float)desc_num_enclosed / num_enclosed) * (high_angle - low_angle);
            float length = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (desc.getDistanceToParent() < 0.0 ? 0.0f : (float)(desc.getDistanceToParent() * (double)urt_ov_factor)) : urt_ov_factor;
            double mid_angle = current_angle + arc_size / 2.0;
            float new_x = (float)((double)x + Math.cos(mid_angle) * (double)length);
            float new_y = (float)((double)y + Math.sin(mid_angle) * (double)length);
            desc.setXSecondary(new_x);
            desc.setYSecondary(new_y);
            if (this.isInFoundNodes(desc)) {
                g.setColor(this.getTreeColorSet().getFoundColor());
                this.drawRectFilled(desc.getXSecondary() - 1.0f, desc.getYSecondary() - 1.0f, 3.0, 3.0, g);
                g.setColor(this.getTreeColorSet().getOvColor());
            }
            this.paintUnrootedLite(desc, current_angle, current_angle + arc_size, g, urt_ov_factor);
            current_angle += arc_size;
            this.drawLine(x, y, new_x, new_y, g);
            ++i;
        }
    }

    private final void pasteSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (this.getCutOrCopiedTree() == null || this.getCutOrCopiedTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No tree in buffer (need to copy or cut a subtree first)", "Attempt to paste with empty buffer", 0);
            return;
        }
        String label = this.getASimpleTextRepresentationOfANode(this.getCutOrCopiedTree().getRoot());
        Object[] options = new Object[]{"As sibling", "As descendant", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, "How to paste subtree" + label + "?", "Paste Subtree", -1, 3, null, options, options[2]);
        boolean paste_as_sibling = true;
        if (r == 1) {
            paste_as_sibling = false;
        } else if (r != 0) {
            return;
        }
        Phylogeny buffer_phy = this.getCutOrCopiedTree().copy();
        buffer_phy.setAllNodesToNotCollapse();
        buffer_phy.preOrderReId();
        if (paste_as_sibling) {
            if (node.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot paste sibling to root", "Attempt to paste sibling to root", 0);
                return;
            }
            buffer_phy.addAsSibling(node);
        } else {
            buffer_phy.addAsChild(node);
        }
        if (this.getCopiedAndPastedNodes() == null) {
            this.setCopiedAndPastedNodes(new HashSet<PhylogenyNode>());
        }
        this.getCopiedAndPastedNodes().addAll(PhylogenyMethods.obtainAllNodesAsSet(buffer_phy));
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    @Override
    public final int print(Graphics g, PageFormat page_format, int page_index) throws PrinterException {
        if (page_index > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(page_format.getImageableX(), page_format.getImageableY());
        this.paintPhylogeny(g2d, true, false, 0, 0, 0, 0);
        return 0;
    }

    final void recalculateMaxDistanceToRoot() {
        this._max_distance_to_root = PhylogenyMethods.calculateMaxDistanceToRoot(this.getPhylogeny());
    }

    final void removeAllEditNodeJFrames() {
        int i = 0;
        while (i <= 9) {
            if (this._node_frames[i] != null) {
                this._node_frames[i].dispose();
                this._node_frames[i] = null;
            }
            ++i;
        }
        this._node_frame_index = 0;
    }

    final void removeEditNodeFrame(int i) {
        --this._node_frame_index;
        this._node_frames[i] = null;
        if (i < this._node_frame_index) {
            int j = 0;
            while (j < this._node_frame_index - 1) {
                this._node_frames[j] = this._node_frames[j + 1];
                ++j;
            }
            this._node_frames[this._node_frame_index] = null;
        }
    }

    final void reRoot(PhylogenyNode node) {
        if (!this.getPhylogeny().isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot reroot in unrooted display type", "Attempt to reroot tree in unrooted display", 2);
            return;
        }
        this.getPhylogeny().reRoot(node);
        this.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.resetPreferredSize();
        this.getMainPanel().adjustJScrollPane();
        this.repaint();
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().showWhole();
        }
    }

    final void resetNodeIdToDistToLeafMap() {
        this._nodeid_dist_to_leaf = new HashMap();
    }

    final void resetPreferredSize() {
        if (this.getPhylogeny() == null || this.getPhylogeny().isEmpty()) {
            return;
        }
        int x = 0;
        int y = 0;
        y = 20 + ForesterUtil.roundToInt(this.getYdistance() * (float)this.getPhylogeny().getRoot().getNumberOfExternalNodes() * 2.0f);
        x = this.getControlPanel().isDrawPhylogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt((double)this.getXcorrectionFactor() * this.getPhylogeny().getHeight() + (double)this.getXdistance()) : (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(this.getPhylogeny().getRoot().getNumberOfExternalNodes() + 2)) : 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(PhylogenyMethods.calculateMaxDepth(this.getPhylogeny()) + 1)));
        this.setPreferredSize(new Dimension(x, y));
    }

    final void setArrowCursor() {
        this.setCursor(ARROW_CURSOR);
        this.repaint();
    }

    final void setControlPanel(ControlPanel atv_control) {
        this._control_panel = atv_control;
    }

    private final void setCopiedAndPastedNodes(Set<PhylogenyNode> copied_and_pasted_nodes) {
        this.getMainPanel().setCopiedAndPastedNodes(copied_and_pasted_nodes);
    }

    private final void setCutOrCopiedTree(Phylogeny cut_or_copied_tree) {
        this.getMainPanel().setCutOrCopiedTree(cut_or_copied_tree);
    }

    final void setEdited(boolean edited) {
        this._edited = edited;
    }

    final void setFoundNodes(Set<PhylogenyNode> found_nodes) {
        this._found_nodes = found_nodes;
    }

    private final void setInOv(boolean in_ov) {
        this._in_ov = in_ov;
    }

    final void setInOvRect(boolean in_ov_rect) {
        this._in_ov_rect = in_ov_rect;
    }

    final void setLargeFonts() {
        this.getTreeFontSet().largeFonts();
    }

    final void setLastMouseDragPointX(float x) {
        this._last_drag_point_x = x;
    }

    final void setLastMouseDragPointY(float y) {
        this._last_drag_point_y = y;
    }

    final void setLongestExtNodeInfo(int i) {
        this._longest_ext_node_info = i;
    }

    final void setMediumFonts() {
        this.getTreeFontSet().mediumFonts();
    }

    private final void setOvMaxHeight(float ov_max_height) {
        this._ov_max_height = ov_max_height;
    }

    private final void setOvMaxWidth(float ov_max_width) {
        this._ov_max_width = ov_max_width;
    }

    final void setOvOn(boolean ov_on) {
        this._ov_on = ov_on;
    }

    private final void setOvXcorrectionFactor(float f) {
        this._ov_x_correction_factor = f;
    }

    private final void setOvXDistance(float ov_x_distance) {
        this._ov_x_distance = ov_x_distance;
    }

    private final void setOvXPosition(int ov_x_position) {
        this._ov_x_position = ov_x_position;
    }

    private final void setOvYDistance(float ov_y_distance) {
        this._ov_y_distance = ov_y_distance;
    }

    private final void setOvYPosition(int ov_y_position) {
        this._ov_y_position = ov_y_position;
    }

    private final void setOvYStart(int ov_y_start) {
        this._ov_y_start = ov_y_start;
    }

    final void setParametersForPainting(int x, int y, boolean recalc_longest_ext_node_info) {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            this.initNodeData();
            if (recalc_longest_ext_node_info) {
                this.calculateLongestExtNodeInfo();
            }
            int ext_nodes = this._phylogeny.getRoot().getNumberOfExternalNodes();
            int max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            if (ext_nodes == 1 && (ext_nodes = max_depth) < 1) {
                ext_nodes = 1;
            }
            this.updateOvSizes();
            float xdist = 0.0f;
            float ov_xdist = 0.0f;
            if (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram()) {
                xdist = (float)((double)(x - this.getLongestExtNodeInfo() - 20) / ((double)ext_nodes + 3.0));
                ov_xdist = (float)((double)this.getOvMaxWidth() / ((double)ext_nodes + 3.0));
            } else {
                xdist = (x - this.getLongestExtNodeInfo() - 20) / (max_depth + 1);
                ov_xdist = this.getOvMaxWidth() / (float)(max_depth + 1);
            }
            float ydist = (float)((double)(y - 20) / ((double)ext_nodes * 2.0));
            if ((double)xdist < 0.0) {
                xdist = 0.0f;
            }
            if ((double)ov_xdist < 0.0) {
                ov_xdist = 0.0f;
            }
            if ((double)ydist < 0.0) {
                ydist = 0.0f;
            }
            this.setXdistance(xdist);
            this.setYdistance(ydist);
            this.setOvXDistance(ov_xdist);
            double height = this._phylogeny.getHeight();
            if (height > 0.0) {
                float corr = (float)((double)((float)(x - 20 - this.getLongestExtNodeInfo()) - this.getXdistance()) / height);
                this.setXcorrectionFactor(corr > 0.0f ? corr : 0.0f);
                float ov_corr = (float)((double)(this.getOvMaxWidth() - this.getOvXDistance()) / height);
                this.setOvXcorrectionFactor(ov_corr > 0.0f ? ov_corr : 0.0f);
            } else {
                this.setXcorrectionFactor(0.0f);
                this.setOvXcorrectionFactor(0.0f);
            }
            this._circ_max_depth = max_depth;
            this.setUpUrtFactor();
        }
    }

    final void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE graphics_type) {
        this._graphics_type = graphics_type;
        this.setTextAntialias();
    }

    private final void setScaleDistance(double scale_distance) {
        this._scale_distance = scale_distance;
    }

    private final void setScaleLabel(String scale_label) {
        this._scale_label = scale_label;
    }

    final void setSmallFonts() {
        this.getTreeFontSet().smallFonts();
    }

    final void setStartingAngle(double starting_angle) {
        this._urt_starting_angle = starting_angle;
    }

    final void setSuperTinyFonts() {
        this.getTreeFontSet().superTinyFonts();
    }

    final void setTextAntialias() {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            if (this._phylogeny.getNumberOfExternalNodes() <= 1000) {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        if (this.getMainPanel().getOptions().isAntialiasScreen()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
                this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            try {
                this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            catch (Throwable e) {
                this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    final void setTinyFonts() {
        this.getTreeFontSet().tinyFonts();
    }

    final void setTree(Phylogeny t) {
        this._phylogeny = t;
    }

    final void setTreeFile(File treefile) {
        this._treefile = treefile;
    }

    private final void setUpUrtFactor() {
        int d;
        int n = d = this.getVisibleRect().width < this.getVisibleRect().height ? this.getVisibleRect().width : this.getVisibleRect().height;
        if (this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram()) {
            this.setUrtFactor((float)((double)d / (2.0 * this.getMaxDistanceToRoot())));
        } else {
            int max_depth = this._circ_max_depth;
            if (max_depth > 0) {
                this.setUrtFactor(d / (2 * max_depth));
            } else {
                this.setUrtFactor(d / 2);
            }
        }
        this.setUrtFactorOv(this.getUrtFactor());
    }

    private final void setUrtFactor(float urt_factor) {
        this._urt_factor = urt_factor;
    }

    private final void setUrtFactorOv(float urt_factor_ov) {
        this._urt_factor_ov = urt_factor_ov;
    }

    final void setWaitCursor() {
        this.setCursor(WAIT_CURSOR);
        this.repaint();
    }

    final void setXcorrectionFactor(float f) {
        this._x_correction_factor = f;
    }

    final void setXdistance(float x) {
        this._x_distance = x;
    }

    final void setYdistance(float y) {
        this._y_distance = y;
    }

    private final void showNodeDataPopup(MouseEvent e, PhylogenyNode node) {
        try {
            if (node.getNodeName().length() > 0 || node.getNodeData().isHasTaxonomy() && !TreePanel.isTaxonomyEmpty(node.getNodeData().getTaxonomy()) || node.getNodeData().isHasSequence() && !TreePanel.isSequenceEmpty(node.getNodeData().getSequence()) || node.getNodeData().isHasDate() || node.getNodeData().isHasDistribution() || node.getBranchData().isHasConfidences()) {
                boolean enc_data;
                this._popup_buffer.setLength(0);
                int lines = 0;
                if (node.getNodeName().length() > 0) {
                    lines = (short)(lines + 1);
                    this._popup_buffer.append(node.getNodeName());
                }
                if (node.getNodeData().isHasTaxonomy() && !TreePanel.isTaxonomyEmpty(node.getNodeData().getTaxonomy())) {
                    lines = (short)(lines + 1);
                    enc_data = false;
                    Taxonomy tax = node.getNodeData().getTaxonomy();
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                        this._popup_buffer.append("[");
                        this._popup_buffer.append(tax.getTaxonomyCode());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getScientificName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(tax.getScientificName());
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getCommonName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(tax.getCommonName());
                        this._popup_buffer.append(")");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getAuthority())) {
                        if (enc_data) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(tax.getAuthority());
                        this._popup_buffer.append(")");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getRank())) {
                        if (enc_data) {
                            this._popup_buffer.append(" {");
                        } else {
                            this._popup_buffer.append("{");
                        }
                        this._popup_buffer.append(tax.getRank());
                        this._popup_buffer.append("}");
                        enc_data = true;
                    }
                    if (tax.getSynonyms().size() > 0) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append("[");
                        int counter = 1;
                        for (String syn : tax.getSynonyms()) {
                            if (!ForesterUtil.isEmpty(syn)) {
                                this._popup_buffer.append(syn);
                                if (counter < tax.getSynonyms().size()) {
                                    this._popup_buffer.append(", ");
                                }
                            }
                            ++counter;
                        }
                        this._popup_buffer.append("]");
                    }
                }
                if (node.getNodeData().isHasSequence() && !TreePanel.isSequenceEmpty(node.getNodeData().getSequence())) {
                    Sequence seq;
                    lines = (short)(lines + 1);
                    enc_data = false;
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if ((seq = node.getNodeData().getSequence()).getAccession() != null) {
                        this._popup_buffer.append("[");
                        if (!ForesterUtil.isEmpty(seq.getAccession().getSource())) {
                            this._popup_buffer.append(seq.getAccession().getSource());
                            this._popup_buffer.append("=");
                        }
                        this._popup_buffer.append(seq.getAccession().getValue());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(seq.getSymbol())) {
                        if (enc_data) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(seq.getSymbol());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(seq.getName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(seq.getName());
                    }
                }
                if (node.getNodeData().isHasDate()) {
                    lines = (short)(lines + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(node.getNodeData().getDate().asSimpleText());
                }
                if (node.getNodeData().isHasDistribution()) {
                    lines = (short)(lines + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(node.getNodeData().getDistribution().asSimpleText());
                }
                if (node.getBranchData().isHasConfidences()) {
                    List<Confidence> confs = node.getBranchData().getConfidences();
                    for (Confidence confidence : confs) {
                        lines = (short)(lines + 1);
                        if (this._popup_buffer.length() > 0) {
                            this._popup_buffer.append("\n");
                        }
                        if (!ForesterUtil.isEmpty(confidence.getType())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(confidence.getType());
                            this._popup_buffer.append("] ");
                        } else {
                            this._popup_buffer.append("[?] ");
                        }
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getValue(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                    }
                }
                if (this._popup_buffer.length() > 0) {
                    if (!this.getConfiguration().isUseNativeUI()) {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(this.getTreeColorSet().getBranchColor()));
                        this._rollover_popup.setBackground(this.getTreeColorSet().getBackgroundColor());
                        if (this.isInFoundNodes(node)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor());
                        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
                            this._rollover_popup.setForeground(this.getTaxonomyBasedColor(node));
                        } else {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getSequenceColor());
                        }
                    } else {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    }
                    this._rollover_popup.setText(this._popup_buffer.toString());
                    this._node_desc_popup = PopupFactory.getSharedInstance().getPopup(null, this._rollover_popup, e.getLocationOnScreen().x + 10, e.getLocationOnScreen().y - lines * 20);
                    this._node_desc_popup.show();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void showNodeEditFrame(PhylogenyNode n) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(n, this._phylogeny, this, this._node_frame_index, "");
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void showNodeFrame(PhylogenyNode n) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(n, this._phylogeny, this, this._node_frame_index);
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    final Color getTaxonomyBasedColor(PhylogenyNode node) {
        if (node.getNodeData().getTaxonomy() == null) {
            return this.getTreeColorSet().getTaxonomyColor();
        }
        return this.calculateTaxonomyBasedColor(node.getNodeData().getTaxonomy());
    }

    final Color calculateTaxonomyBasedColor(Taxonomy tax) {
        String species = tax.getTaxonomyCode();
        if (ForesterUtil.isEmpty(species) && ForesterUtil.isEmpty(species = tax.getScientificName())) {
            species = tax.getCommonName();
        }
        if (ForesterUtil.isEmpty(species)) {
            return this.getTreeColorSet().getTaxonomyColor();
        }
        Color c = this.getControlPanel().getSpeciesColors().get(species);
        if (c == null) {
            c = Util.calculateColorFromString(species);
            this.getControlPanel().getSpeciesColors().put(species, c);
        }
        return c;
    }

    final void subTree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot get a sub/super tree in unrooted display", "Attempt to get sub/super tree in unrooted display", 2);
            return;
        }
        if (node.isExternal()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of a external node", "Attempt to get subtree of external node", 2);
            return;
        }
        if (node.isRoot() && this._subtree_index < 1) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of the root node", "Attempt to get subtree of root node", 2);
            return;
        }
        if (!node.isExternal() && !node.isRoot() && this._subtree_index <= 99) {
            this._phylogenies[this._subtree_index++] = this._phylogeny;
            this._phylogeny = this._phylogeny.subTree(node);
            this.updateSubSuperTreeButton();
        } else if (node.isRoot() && this._subtree_index >= 1) {
            this.superTree();
        }
        this._main_panel.getControlPanel().showWhole();
        this.repaint();
    }

    final void superTree() {
        this._phylogenies[this._subtree_index] = null;
        this._phylogeny = this._phylogenies[--this._subtree_index];
        this.updateSubSuperTreeButton();
    }

    final void swap(PhylogenyNode node) {
        if (!node.isExternal()) {
            this._phylogeny.swapChildren(node);
        }
        this.repaint();
    }

    private final void switchDisplaygetPhylogenyGraphicsType() {
        switch (this.getPhylogenyGraphicsType()) {
            case RECTANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                break;
            }
            case EURO_STYLE: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                break;
            }
            case ROUNDED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                break;
            }
            case CURVED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                break;
            }
            case TRIANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                break;
            }
            case CONVEX: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                break;
            }
            case UNROOTED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                break;
            }
            case CIRCULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                break;
            }
            default: {
                throw new IllegalStateException("unkwnown display type: " + (Object)((Object)this.getPhylogenyGraphicsType()));
            }
        }
        if (this.getControlPanel().getDynamicallyHideData() != null) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                this.getControlPanel().getDynamicallyHideData().setEnabled(false);
            } else {
                this.getControlPanel().getDynamicallyHideData().setEnabled(true);
            }
        }
        if (this.isPhyHasBranchLengths() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().setDrawPhylogramEnabled(true);
        } else {
            this.getControlPanel().setDrawPhylogramEnabled(false);
        }
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        }
    }

    final void taxColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.colorPhylogenyAccordingToExternalTaxonomy(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    final void updateOvSettings() {
        switch (this.getOptions().getOvPlacement()) {
            case LOWER_LEFT: {
                this.setOvXPosition(10);
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case LOWER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case UPPER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
                break;
            }
            default: {
                this.setOvXPosition(10);
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
            }
        }
    }

    final void updateOvSizes() {
        if ((double)this.getWidth() > 1.05 * (double)this.getVisibleRect().width || (double)this.getHeight() > 1.05 * (double)this.getVisibleRect().height) {
            this.setOvOn(true);
            float l = this.getLongestExtNodeInfo();
            float w_ratio = this.getOvMaxWidth() / (float)this.getWidth();
            int ext_nodes = this._phylogeny.getRoot().getNumberOfExternalNodes();
            this.setOvYDistance(this.getOvMaxHeight() / (float)(2 * ext_nodes));
            float ov_xdist = 0.0f;
            ov_xdist = !this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? (this.getOvMaxWidth() - l) / (float)ext_nodes : (this.getOvMaxWidth() - (l *= w_ratio)) / (float)PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            float ydist = (float)((double)this.getOvMaxWidth() / ((double)ext_nodes * 2.0));
            if ((double)ov_xdist < 0.0) {
                ov_xdist = 0.0f;
            }
            if ((double)ydist < 0.0) {
                ydist = 0.0f;
            }
            this.setOvXDistance(ov_xdist);
            double height = this._phylogeny.getHeight();
            if (height > 0.0) {
                float ov_corr = (float)((double)(this.getOvMaxWidth() - l - this.getOvXDistance()) / height);
                this.setOvXcorrectionFactor(ov_corr > 0.0f ? ov_corr : 0.0f);
            } else {
                this.setOvXcorrectionFactor(0.0f);
            }
        } else {
            this.setOvOn(false);
        }
    }

    final void updateSubSuperTreeButton() {
        if (this._subtree_index < 1) {
            this.getControlPanel().deactivateButtonToReturnToSuperTree();
        } else {
            this.getControlPanel().activateButtonToReturnToSuperTree(this._subtree_index);
        }
    }

    final void zoomInDomainStructure() {
        if (this._domain_structure_width < 2000.0) {
            this._domain_structure_width *= 1.2;
        }
    }

    final void zoomOutDomainStructure() {
        if (this._domain_structure_width > 20.0) {
            this._domain_structure_width *= 0.8;
        }
    }

    private static final void drawString(int i, double x, double y, Graphics2D g) {
        g.drawString(String.valueOf(i), (int)(x + 0.5), (int)(y + 0.5));
    }

    private static final void drawString(String str, double x, double y, Graphics2D g) {
        g.drawString(str, (int)(x + 0.5), (int)(y + 0.5));
    }

    private static final boolean isSequenceEmpty(Sequence seq) {
        return seq.getAccession() == null && ForesterUtil.isEmpty(seq.getName()) && ForesterUtil.isEmpty(seq.getSymbol());
    }

    private static final boolean isTaxonomyEmpty(Taxonomy tax) {
        return tax.getIdentifier() == null && ForesterUtil.isEmpty(tax.getTaxonomyCode()) && ForesterUtil.isEmpty(tax.getCommonName()) && ForesterUtil.isEmpty(tax.getScientificName()) && tax.getSynonyms().isEmpty();
    }

    private static final boolean plusPressed(int key_code) {
        return key_code == 107 || key_code == 521 || key_code == 61 || key_code == 59 || key_code == 49;
    }

    private final class SubtreeColorizationActionListener
    implements ActionListener {
        JColorChooser _chooser;
        PhylogenyNode _node;

        SubtreeColorizationActionListener(JColorChooser chooser, PhylogenyNode node) {
            this._chooser = chooser;
            this._node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = this._chooser.getColor();
            if (c != null) {
                TreePanel.this.colorizeSubtree(c, this._node);
            }
        }
    }
}

