/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.ArrayList;
import java.util.Arrays;
import org.forester.development.Msa;
import org.forester.development.Sequence;

public class BasicMsa
implements Msa {
    private final ArrayList<Sequence> _sequences = new ArrayList();

    public void addSequence(Sequence sequence, boolean check_for_equal_length) {
        if (check_for_equal_length && this.getNumberOfSequences() > 0 && this.getLength() != sequence.getLength()) {
            String msg = "Attempt to a sequence of length " + sequence.getLength() + " to alignment of length " + this.getLength();
            throw new IllegalArgumentException(msg);
        }
        this.getSequences().add(sequence);
    }

    public Msa copy() {
        return this.createSubAlignment(null, null);
    }

    public Msa createSubAlignment(int[] sequences, int[] positions) {
        BasicMsa msa = new BasicMsa();
        boolean return_all_seqs = false;
        boolean return_all_pos = false;
        if (sequences == null || sequences.length < 1) {
            return_all_seqs = true;
        } else {
            Arrays.sort(sequences);
        }
        if (positions == null || positions.length < 1) {
            return_all_pos = true;
        } else {
            Arrays.sort(positions);
        }
        int s = 0;
        while (s < this.getNumberOfSequences()) {
            if (return_all_seqs || Arrays.binarySearch(sequences, s) >= 0) {
                int p = 0;
                while (p < this.getLength()) {
                    if (!return_all_pos) {
                        Arrays.binarySearch(positions, p);
                    }
                    ++p;
                }
            }
            ++s;
        }
        return msa;
    }

    public int[] findSequence(String name, boolean case_sensitive, boolean partial_match) {
        return null;
    }

    @Override
    public int getLength() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getSequence(0).getLength();
    }

    @Override
    public int getNumberOfSequences() {
        return this.getSequences().size();
    }

    @Override
    public char getResidueAt(int col, int row) {
        return '\u0000';
    }

    @Override
    public Sequence getSequence(int i) {
        return this.getSequences().get(i);
    }

    private ArrayList<Sequence> getSequences() {
        return this._sequences;
    }

    public boolean isAppearsAligned() {
        if (!this.isEmpty()) {
            int l = this.getSequence(0).getLength();
            int i = 0;
            while (i < this.getNumberOfSequences()) {
                if (l != this.getSequence(i).getLength()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getNumberOfSequences() < 1;
    }

    public void removeSequence(int i) {
        this.getSequences().remove(i);
    }
}

