/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.Date;
import org.forester.development.AminoAcidSequence;
import org.forester.development.DevelopmentTools;
import org.forester.phylogeny.Phylogeny;

public class Test {
    public static void main(String[] args) {
        int failed = 0;
        int succeeded = 0;
        long start_time = new Date().getTime();
        System.out.print("Amino acid sequence: ");
        if (Test.testAminoAcidSequence()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.println("Creation of balanced phylogeny: ");
        if (Test.testCreateBalancedPhylogeny()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.println("\nTime requirement:  " + (new Date().getTime() - start_time) + "ms.");
        System.out.println();
        System.out.println("Successful tests: " + succeeded);
        System.out.println("Failed     tests: " + failed);
        System.out.println();
        if (failed < 1) {
            System.out.println("OK.");
        } else {
            System.out.println("Not OK.");
        }
    }

    private static boolean testAminoAcidSequence() {
        AminoAcidSequence aa1;
        block25: {
            AminoAcidSequence aa2;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        try {
                                                            AminoAcidSequence aa0 = new AminoAcidSequence(12);
                                                            if (aa0.getLength() == 12) break block14;
                                                            return false;
                                                        }
                                                        catch (Exception e) {
                                                            e.printStackTrace();
                                                            return false;
                                                        }
                                                    }
                                                    aa1 = new AminoAcidSequence("aa1", " aAklm-?xX*z$#");
                                                    aa2 = aa1.copy();
                                                    aa1.setStateAt(0, (byte)1);
                                                    aa1.setResidueAt(1, 'r');
                                                    if (aa1.getLength() == 14) break block15;
                                                    return false;
                                                }
                                                if (aa1.getResidueAt(0) == 'R') break block16;
                                                return false;
                                            }
                                            if (aa1.getResidueAt(1) == 'R') break block17;
                                            return false;
                                        }
                                        if (aa2.getResidueAt(0) == '?') break block18;
                                        return false;
                                    }
                                    if (aa2.getResidueAt(1) == 'A') break block19;
                                    return false;
                                }
                                if (aa2.getResidueAt(6) == '-') break block20;
                                return false;
                            }
                            if (aa2.getResidueAt(7) == '?') break block21;
                            return false;
                        }
                        if (aa2.getResidueAt(8) == '?') break block22;
                        return false;
                    }
                    if (aa2.getResidueAt(9) == '?') break block23;
                    return false;
                }
                if (aa2.getResidueAt(10) == '*') break block24;
                return false;
            }
            if (aa2.getSequenceAsString().equals("?AAKLM-???*???")) break block25;
            return false;
        }
        return aa1.getSequenceAsString().equals("RRAKLM-???*???");
    }

    private static boolean testCreateBalancedPhylogeny() {
        Phylogeny p1;
        block7: {
            block6: {
                Phylogeny p0;
                block5: {
                    try {
                        p0 = DevelopmentTools.createBalancedPhylogeny(6, 5);
                        if (p0.getRoot().getNumberOfDescendants() == 5) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (p0.getNumberOfExternalNodes() == 15625) break block6;
                return false;
            }
            p1 = DevelopmentTools.createBalancedPhylogeny(2, 10);
            if (p1.getRoot().getNumberOfDescendants() == 10) break block7;
            return false;
        }
        return p1.getNumberOfExternalNodes() == 100;
    }
}

