/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoXRef;

public class BasicGoXRef
implements GoXRef {
    private final String _xref;
    private final GoXRef.Type _type;

    public BasicGoXRef(String s) {
        String[] sa = s.split(":");
        if (sa.length < 2) {
            throw new IllegalArgumentException("unexpected format for GO xref: " + s);
        }
        String type = sa[0].trim();
        if (type.equals("EC")) {
            this._type = GoXRef.Type.EC;
        } else if (type.equals("MetaCyc")) {
            this._type = GoXRef.Type.META_CYC;
        } else if (type.equals("Reactome")) {
            this._type = GoXRef.Type.REACTOME;
        } else if (type.equals("RESID")) {
            this._type = GoXRef.Type.RESID;
        } else if (type.equals("UM-BBD_enzymeID")) {
            this._type = GoXRef.Type.UM_BBD_ENZYME_ID;
        } else if (type.equals("UM-BBD_pathwayID")) {
            this._type = GoXRef.Type.UM_BBD_PATHWAY_ID;
        } else if (type.equals("UM-BBD_reactionID")) {
            this._type = GoXRef.Type.UM_BBD_REACTIONID;
        } else if (type.equals("TC")) {
            this._type = GoXRef.Type.TC;
        } else if (type.equals("AraCyc")) {
            this._type = GoXRef.Type.ARACYC;
        } else if (type.equals("XX")) {
            this._type = GoXRef.Type.XX;
        } else if (type.equals("PMID")) {
            this._type = GoXRef.Type.PMID;
        } else if (type.equals("IMG")) {
            this._type = GoXRef.Type.IMG;
        } else if (type.equals("GOC")) {
            this._type = GoXRef.Type.GOC;
        } else if (type.equals("KEGG")) {
            this._type = GoXRef.Type.KEGG;
        } else if (type.equals("Wikipedia")) {
            this._type = GoXRef.Type.WIKIPEDIA;
        } else {
            throw new IllegalArgumentException("unknown GO xref type: " + type);
        }
        this._xref = sa[1].trim();
    }

    public BasicGoXRef(GoXRef.Type type, String xref) {
        this._type = type;
        this._xref = xref;
    }

    @Override
    public int compareTo(GoXRef xref) {
        return this.getXRef().compareTo(xref.getXRef());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go xref equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go xref equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getXRef().equals(((GoXRef)o).getXRef()) && this.getType().equals((Object)((GoXRef)o).getType());
    }

    @Override
    public GoXRef.Type getType() {
        return this._type;
    }

    @Override
    public String getXRef() {
        return this._xref;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.getType()) {
            case EC: {
                sb.append("EC");
                break;
            }
            case META_CYC: {
                sb.append("MetaCyc");
                break;
            }
            case REACTOME: {
                sb.append("Reactome");
                break;
            }
            case RESID: {
                sb.append("RESID");
                break;
            }
            case UM_BBD_ENZYME_ID: {
                sb.append("UM-BBD_enzymeID");
                break;
            }
            case UM_BBD_PATHWAY_ID: {
                sb.append("UM-BBD_pathwayID");
                break;
            }
            case UM_BBD_REACTIONID: {
                sb.append("UM-BBD_reactionID");
                break;
            }
            case TC: {
                sb.append("TC");
                break;
            }
            case ARACYC: {
                sb.append("AraCyc");
                break;
            }
            case XX: {
                sb.append("XX");
                break;
            }
            case GOC: {
                sb.append("GOC");
                break;
            }
            case IMG: {
                sb.append("IMG");
                break;
            }
            case PMID: {
                sb.append("PMID");
                break;
            }
            case WIKIPEDIA: {
                sb.append("Wikipedia");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        sb.append(":");
        sb.append(this.getXRef());
        return sb.toString();
    }
}

