/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

public class GoNameSpace {
    public final String MOLECULAR_FUNCTION_STR = "molecular_function";
    public final String BIOLOGICAL_PROCESS_STR = "biological_process";
    public final String CELLULAR_COMPONENT_STR = "cellular_component";
    public final String UNASSIGNED_STR = "unassigned";
    private final GoNamespaceType _type;

    public GoNameSpace(GoNamespaceType type) {
        this._type = type;
    }

    public GoNameSpace(String type) {
        if (type.toLowerCase().equals("molecular_function")) {
            this._type = GoNamespaceType.MOLECULAR_FUNCTION;
        } else if (type.toLowerCase().equals("biological_process")) {
            this._type = GoNamespaceType.BIOLOGICAL_PROCESS;
        } else if (type.toLowerCase().equals("cellular_component")) {
            this._type = GoNamespaceType.CELLULAR_COMPONENT;
        } else if (type.toLowerCase().equals("unassigned")) {
            this._type = GoNamespaceType.UNASSIGNED;
        } else {
            throw new IllegalArgumentException("unknown GO namespace: " + type);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.getType() == ((GoNameSpace)o).getType();
    }

    public GoNamespaceType getType() {
        return this._type;
    }

    public boolean isBiologicalProcess() {
        return this.getType() == GoNamespaceType.BIOLOGICAL_PROCESS;
    }

    public boolean isCellularComponent() {
        return this.getType() == GoNamespaceType.CELLULAR_COMPONENT;
    }

    public boolean isMolecularFunction() {
        return this.getType() == GoNamespaceType.MOLECULAR_FUNCTION;
    }

    public boolean isUnassigned() {
        return this.getType() == GoNamespaceType.UNASSIGNED;
    }

    public String toShortString() {
        switch (this._type) {
            case BIOLOGICAL_PROCESS: {
                return "B";
            }
            case CELLULAR_COMPONENT: {
                return "C";
            }
            case MOLECULAR_FUNCTION: {
                return "M";
            }
            case UNASSIGNED: {
                return "?";
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        switch (this._type) {
            case BIOLOGICAL_PROCESS: {
                return "biological_process";
            }
            case CELLULAR_COMPONENT: {
                return "cellular_component";
            }
            case MOLECULAR_FUNCTION: {
                return "molecular_function";
            }
            case UNASSIGNED: {
                return "unassigned";
            }
        }
        throw new IllegalStateException();
    }

    public static GoNameSpace createBiologicalProcess() {
        return new GoNameSpace(GoNamespaceType.BIOLOGICAL_PROCESS);
    }

    public static GoNameSpace createCellularComponent() {
        return new GoNameSpace(GoNamespaceType.CELLULAR_COMPONENT);
    }

    public static GoNameSpace createMolecularFunction() {
        return new GoNameSpace(GoNamespaceType.MOLECULAR_FUNCTION);
    }

    public static GoNameSpace createUnassigned() {
        return new GoNameSpace(GoNamespaceType.UNASSIGNED);
    }

    public static enum GoNamespaceType {
        MOLECULAR_FUNCTION,
        BIOLOGICAL_PROCESS,
        CELLULAR_COMPONENT,
        UNASSIGNED;

    }
}

