/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public final class ParserUtils {
    public static BufferedReader createReader(Object source) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        if (source instanceof File || source instanceof String) {
            File f = null;
            f = source instanceof File ? (File)source : new File((String)source);
            if (!f.exists()) {
                throw new IOException("[" + f.getAbsolutePath() + "] does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof StringBuffer || source instanceof StringBuilder) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + source.getClass() + "] (can only parse objects of type File/String, InputStream, StringBuffer, or StringBuilder)");
        }
        return reader;
    }
}

