/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.ConfidenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PropertyParser;
import org.forester.io.parsers.phyloxml.phylogenydata.UriParser;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Uri;

public class AnnotationParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new AnnotationParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private AnnotationParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhylogenyParserException {
        Annotation annotation = new Annotation();
        if (element.isHasAttribute("type")) {
            annotation.setType(element.getAttribute("type"));
        }
        if (element.isHasAttribute("evidence")) {
            annotation.setEvidence(element.getAttribute("evidence"));
        }
        if (element.isHasAttribute("ref")) {
            annotation.setRef(element.getAttribute("ref"));
        }
        if (element.isHasAttribute("source")) {
            annotation.setSource(element.getAttribute("source"));
        }
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("desc")) {
                annotation.setDesc(child_element.getValueAsString());
            } else if (child_element.getQualifiedName().equals("confidence")) {
                annotation.setConfidence((Confidence)ConfidenceParser.getInstance().parse(child_element));
            } else if (child_element.getQualifiedName().equals("uri")) {
                annotation.setUri((Uri)UriParser.getInstance().parse(child_element));
            } else if (child_element.getQualifiedName().equals("property")) {
                if (annotation.getProperties() == null) {
                    annotation.setProperties(new PropertiesMap());
                }
                annotation.getProperties().addProperty((Property)PropertyParser.getInstance().parse(child_element));
            }
            ++i;
        }
        return annotation;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

