/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.PhylogenyData;

public class BinaryCharactersParser
implements PhylogenyDataPhyloXmlParser {
    private static final BinaryCharactersParser _instance;

    static {
        try {
            _instance = new BinaryCharactersParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private BinaryCharactersParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhylogenyParserException {
        TreeSet<String> present = new TreeSet<String>();
        TreeSet<String> gained = new TreeSet<String>();
        TreeSet<String> lost = new TreeSet<String>();
        String type = "";
        int present_count = -1;
        int gained_count = -1;
        int lost_count = -1;
        if (element.isHasAttribute("type")) {
            type = element.getAttribute("type");
        }
        try {
            if (element.isHasAttribute("present_count")) {
                present_count = Integer.parseInt(element.getAttribute("present_count"));
            }
            if (element.isHasAttribute("gained_count")) {
                gained_count = Integer.parseInt(element.getAttribute("gained_count"));
            }
            if (element.isHasAttribute("lost_count")) {
                lost_count = Integer.parseInt(element.getAttribute("lost_count"));
            }
        }
        catch (NumberFormatException e) {
            throw new PhylogenyParserException("failed to parse integer from element " + element.getQualifiedName());
        }
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("present")) {
                this.parseCharacters(present, child_element);
            } else if (child_element.getQualifiedName().equals("gained")) {
                this.parseCharacters(gained, child_element);
            } else if (child_element.getQualifiedName().equals("lost")) {
                this.parseCharacters(lost, child_element);
            }
            ++i;
        }
        BinaryCharacters bc = null;
        bc = present_count != -1 ? new BinaryCharacters(present, gained, lost, type, present_count, gained_count, lost_count) : new BinaryCharacters(present, gained, lost, type);
        return bc;
    }

    private void parseCharacters(SortedSet<String> present, XmlElement child_element) {
        int j = 0;
        while (j < child_element.getNumberOfChildElements()) {
            XmlElement child_child_element = child_element.getChildElement(j);
            if (child_child_element.getQualifiedName().equals("bc")) {
                present.add(child_child_element.getValueAsString());
            }
            ++j;
        }
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

