/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import java.awt.Color;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.PhylogenyData;

public class ColorParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new ColorParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private ColorParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhylogenyParserException {
        int red = 0;
        int green = 0;
        int blue = 0;
        int j = 0;
        while (j < element.getNumberOfChildElements()) {
            XmlElement c = element.getChildElement(j);
            if (c.getQualifiedName().equals("red")) {
                red = c.getValueAsInt();
            } else if (c.getQualifiedName().equals("green")) {
                green = c.getValueAsInt();
            } else if (c.getQualifiedName().equals("blue")) {
                blue = c.getValueAsInt();
            }
            ++j;
        }
        BranchColor color = new BranchColor();
        color.setValue(new Color(red, green, blue));
        return color;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

