/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ProteinDomainParser;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.ProteinDomain;

public class DomainArchitectureParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new DomainArchitectureParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private DomainArchitectureParser() {
    }

    @Override
    public DomainArchitecture parse(XmlElement element) throws PhylogenyParserException {
        DomainArchitecture architecure = new DomainArchitecture();
        if (!element.isHasAttribute("length")) {
            throw new PhylogenyParserException("length attribute is required for domain architecture");
        }
        String lenght_str = element.getAttribute("length");
        try {
            architecure.setTotalLength(Integer.parseInt(lenght_str));
        }
        catch (NumberFormatException e) {
            throw new PhylogenyParserException("could not extract domain architecture length from [" + lenght_str + "]: " + e.getMessage());
        }
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("domain")) {
                architecure.addDomain((ProteinDomain)ProteinDomainParser.getInstance().parse(child_element));
            }
            ++i;
        }
        return architecure;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

