/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.tol;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.tol.TolXmlHandler;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TolParser
implements PhylogenyParser {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA_FULL = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private Object _source;
    private boolean _valid;
    private boolean _zipped_inputstream;
    private int _error_count;
    private int _warning_count;
    private String _schema_location;
    private StringBuffer _error_messages;
    private StringBuffer _warning_messages;

    public TolParser() {
        this.init();
        this.reset();
    }

    public int getErrorCount() {
        return this._error_count;
    }

    public StringBuffer getErrorMessages() {
        return this._error_messages;
    }

    private Reader getReaderFromZipFile() throws IOException {
        InputStreamReader reader = null;
        ZipFile zip_file = new ZipFile(this.getSource().toString());
        Enumeration<? extends ZipEntry> zip_file_entries = zip_file.entries();
        while (zip_file_entries.hasMoreElements()) {
            ZipEntry zip_file_entry = zip_file_entries.nextElement();
            if (zip_file_entry.isDirectory() || zip_file_entry.getSize() <= 0L) continue;
            InputStream is = zip_file.getInputStream(zip_file_entry);
            reader = new InputStreamReader(is);
            break;
        }
        return reader;
    }

    private String getSchemaLocation() {
        return this._schema_location;
    }

    private Object getSource() {
        return this._source;
    }

    public int getWarningCount() {
        return this._warning_count;
    }

    public StringBuffer getWarningMessages() {
        return this._warning_messages;
    }

    private void init() {
        this.setZippedInputstream(false);
    }

    public boolean isValid() {
        return this._valid;
    }

    private boolean isZippedInputstream() {
        return this._zipped_inputstream;
    }

    @Override
    public Phylogeny[] parse() throws IOException, PhylogenyParserException {
        TolXmlHandler handler;
        block25: {
            this.reset();
            handler = new TolXmlHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    factory.setFeature(SAX_FEATURES_VALIDATION, true);
                    factory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA, true);
                    factory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA_FULL, true);
                }
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
                throw new PhylogenyParserException("sax not recognized exception: " + e.getMessage());
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
                throw new PhylogenyParserException("sax not supported exception: " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new PhylogenyParserException("parser _configuration exception: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PhylogenyParserException("error while configuring sax parser: " + e.getMessage());
            }
            try {
                InputStreamReader reader;
                SAXParser parser = factory.newSAXParser();
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    parser.setProperty(JAXP_SCHEMA_SOURCE, this.getSchemaLocation());
                    parser.setProperty(APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION, this.getSchemaLocation());
                }
                XMLReader xml_reader = parser.getXMLReader();
                xml_reader.setContentHandler(handler);
                xml_reader.setErrorHandler(new TolParserErrorHandler());
                if (this.getSource() instanceof File) {
                    if (!this.getSource().toString().toLowerCase().endsWith(".zip")) {
                        xml_reader.parse(new InputSource(new FileReader((File)this.getSource())));
                    } else {
                        Reader reader2 = this.getReaderFromZipFile();
                        if (reader2 == null) {
                            throw new PhylogenyParserException("Zip file \"" + this.getSource() + "\" appears not to contain any entries");
                        }
                        xml_reader.parse(new InputSource(reader2));
                    }
                    break block25;
                }
                if (this.getSource() instanceof InputSource) {
                    xml_reader.parse((InputSource)this.getSource());
                    break block25;
                }
                if (this.getSource() instanceof InputStream) {
                    if (!this.isZippedInputstream()) {
                        InputStream is = (InputStream)this.getSource();
                        reader = new InputStreamReader(is);
                        xml_reader.parse(new InputSource(reader));
                    } else {
                        ZipInputStream zip_is = new ZipInputStream((InputStream)this.getSource());
                        zip_is.getNextEntry();
                        reader = new InputStreamReader(zip_is);
                        if (reader == null) {
                            throw new PhylogenyParserException("Zip input stream \"" + this.getSource() + "\" appears not to contain any data");
                        }
                        xml_reader.parse(new InputSource(reader));
                    }
                    break block25;
                }
                if (this.getSource() instanceof String) {
                    File file = new File(this.getSource().toString());
                    reader = new FileReader(file);
                    xml_reader.parse(new InputSource(reader));
                    break block25;
                }
                if (this.getSource() instanceof StringBuffer) {
                    StringReader string_reader = new StringReader(this.getSource().toString());
                    xml_reader.parse(new InputSource(string_reader));
                    break block25;
                }
                throw new PhylogenyParserException("attempt to parse object of unsupported type: \"" + this.getSource().getClass() + "\"");
            }
            catch (SAXException sax_exception) {
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "]: " + sax_exception.getMessage());
            }
            catch (ParserConfigurationException parser_config_exception) {
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "] Problem with xml parser _configuration: " + parser_config_exception.getMessage());
            }
            catch (IOException e) {
                throw new PhylogenyParserException("Problem with input source [" + this.getSource() + "]: \n" + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "]: " + e.getMessage());
            }
            catch (Error err) {
                err.printStackTrace();
                throw new PhylogenyParserException("Severe error: " + err.getMessage());
            }
        }
        Phylogeny[] ps = new Phylogeny[handler.getPhylogenies().size()];
        int i = 0;
        for (Phylogeny phylogeny : handler.getPhylogenies()) {
            ps[i++] = phylogeny;
        }
        return ps;
    }

    private void reset() {
        this._valid = true;
        this._error_count = 0;
        this._warning_count = 0;
        this._error_messages = new StringBuffer();
        this._warning_messages = new StringBuffer();
    }

    @Override
    public void setSource(Object source) {
        this._source = source;
    }

    public void setValidateAgainstSchema(String schema_location) {
        this._schema_location = schema_location;
    }

    public void setZippedInputstream(boolean zipped_inputstream) {
        this._zipped_inputstream = zipped_inputstream;
    }

    private class TolParserErrorHandler
    extends DefaultHandler {
        private TolParserErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            TolParser tolParser = TolParser.this;
            tolParser._error_count = tolParser._error_count + 1;
            TolParser.this._valid = false;
            throw new RuntimeException("XML error at line " + e.getLineNumber() + ": \n" + e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) {
            TolParser tolParser = TolParser.this;
            tolParser._error_count = tolParser._error_count + 1;
            TolParser.this._valid = false;
            throw new RuntimeException("Fatal XML error at line " + e.getLineNumber() + ": \n" + e.getMessage());
        }

        @Override
        public void warning(SAXParseException e) {
            TolParser tolParser = TolParser.this;
            tolParser._warning_count = tolParser._warning_count + 1;
            if (TolParser.this._error_messages.length() > 1) {
                TolParser.this._error_messages.append(ForesterUtil.LINE_SEPARATOR);
            }
            TolParser.this._warning_messages.append("[line: " + e.getLineNumber() + "] " + e.getMessage());
        }
    }
}

