/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.iterators.ExternalForwardIterator;
import org.forester.phylogeny.iterators.LevelOrderTreeIterator;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostorderTreeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public class Phylogeny {
    public static final boolean ALLOW_MULTIPLE_PARENTS_DEFAULT = false;
    private PhylogenyNode _root;
    private boolean _rooted;
    private boolean _allow_multiple_parents;
    private String _name;
    private String _type;
    private String _description;
    private String _distance_unit;
    private Confidence _confidence;
    private Identifier _identifier;
    private boolean _rerootable;
    private HashMap<Integer, PhylogenyNode> _idhash;
    private Set<PhylogenyNode> _external_nodes_set;

    public Phylogeny() {
        this.init();
    }

    public void addAsChild(PhylogenyNode parent) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an empty tree.");
        }
        if (!this.isRooted()) {
            throw new IllegalArgumentException("Attempt to add an unrooted tree.");
        }
        parent.addAsChild(this.getRoot());
        this.externalNodesHaveChanged();
    }

    public void addAsSibling(PhylogenyNode sibling) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an empty tree.");
        }
        if (!this.isRooted()) {
            throw new IllegalArgumentException("Attempt to add an unrooted tree.");
        }
        int sibling_index = sibling.getChildNodeIndex();
        PhylogenyNode new_node = new PhylogenyNode();
        PhylogenyNode sibling_parent = sibling.getParent();
        new_node.setChild1(sibling);
        new_node.setChild2(this.getRoot());
        new_node.setParent(sibling_parent);
        sibling.setParent(new_node);
        sibling_parent.setChildNode(sibling_index, new_node);
        double new_dist = sibling.getDistanceToParent() == -1024.0 ? -1024.0 : sibling.getDistanceToParent() / 2.0;
        new_node.setDistanceToParent(new_dist);
        sibling.setDistanceToParent(new_dist);
        this.externalNodesHaveChanged();
    }

    public double calculateSubtreeHeight(PhylogenyNode n) {
        if (n.isExternal() || n.isCollapse()) {
            return ForesterUtil.isLargerOrEqualToZero(n.getDistanceToParent());
        }
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < n.getNumberOfDescendants()) {
            double l = this.calculateSubtreeHeight(n.getChildNode(i));
            if (l > max) {
                max = l;
            }
            ++i;
        }
        return max + ForesterUtil.isLargerOrEqualToZero(n.getDistanceToParent());
    }

    public Phylogeny copy() {
        Phylogeny tree = new Phylogeny();
        if (this.isEmpty()) {
            tree.init();
            return tree;
        }
        tree._rooted = this._rooted;
        tree._name = new String(this._name);
        tree._description = new String(this._description);
        tree._type = new String(this._type);
        tree._rerootable = this._rerootable;
        tree._distance_unit = new String(this._distance_unit);
        if (this._confidence != null) {
            tree._confidence = (Confidence)this._confidence.copy();
        }
        if (this._identifier != null) {
            tree._identifier = (Identifier)this._identifier.copy();
        }
        tree.setAllowMultipleParents(this.isAllowMultipleParents());
        tree._root = PhylogenyMethods.copySubTree(this._root);
        return tree;
    }

    public void deleteSubtree(PhylogenyNode remove_us, boolean collapse_resulting_node_with_one_desc) {
        if (this.isEmpty()) {
            return;
        }
        if (remove_us.isRoot()) {
            this.init();
            return;
        }
        if (!collapse_resulting_node_with_one_desc) {
            remove_us.getParent().removeChildNode(remove_us);
        } else {
            PhylogenyNode removed_node = remove_us;
            PhylogenyNode p = remove_us.getParent();
            if (p.isRoot()) {
                if (p.getNumberOfDescendants() == 2) {
                    if (removed_node.isFirstChildNode()) {
                        this.setRoot(this.getRoot().getChildNode(1));
                        this.getRoot().setParent(null);
                    } else {
                        this.setRoot(this.getRoot().getChildNode(0));
                        this.getRoot().setParent(null);
                    }
                } else {
                    p.removeChildNode(removed_node.getChildNodeIndex());
                }
            } else {
                PhylogenyNode pp = removed_node.getParent().getParent();
                if (p.getNumberOfDescendants() == 2) {
                    int pi = p.getChildNodeIndex();
                    if (removed_node.isFirstChildNode()) {
                        p.getChildNode(1).setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(p.getDistanceToParent(), p.getChildNode(1).getDistanceToParent()));
                        pp.setChildNode(pi, p.getChildNode(1));
                    } else {
                        p.getChildNode(0).setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(p.getDistanceToParent(), p.getChildNode(0).getDistanceToParent()));
                        pp.setChildNode(pi, p.getChildNode(0));
                    }
                } else {
                    p.removeChildNode(removed_node.getChildNodeIndex());
                }
            }
        }
        remove_us.setParent(null);
        this.setIdHash(null);
        this.externalNodesHaveChanged();
    }

    public void externalNodesHaveChanged() {
        this._external_nodes_set = null;
    }

    public String[] getAllExternalNodeNames() {
        int i = 0;
        if (this.isEmpty()) {
            return null;
        }
        String[] names = new String[this.getNumberOfExternalNodes()];
        PhylogenyNodeIterator iter = this.iteratorExternalForward();
        while (iter.hasNext()) {
            names[i++] = new String(iter.next().getNodeName());
        }
        return names;
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDistanceUnit() {
        return this._distance_unit;
    }

    public Set<PhylogenyNode> getExternalNodes() {
        if (this._external_nodes_set == null) {
            this._external_nodes_set = new HashSet<PhylogenyNode>();
            PhylogenyNodeIterator it = this.iteratorPostorder();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                if (!n.isExternal()) continue;
                this._external_nodes_set.add(n);
            }
        }
        return this._external_nodes_set;
    }

    public PhylogenyNode getFirstExternalNode() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Attempt to obtain first external node of empty Phylogeney.");
        }
        PhylogenyNode node = this.getRoot();
        while (node.isInternal()) {
            node = node.getFirstChildNode();
        }
        return node;
    }

    public double getHeight() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.calculateSubtreeHeight(this.getRoot());
    }

    public Identifier getIdentifier() {
        return this._identifier;
    }

    private HashMap<Integer, PhylogenyNode> getIdHash() {
        return this._idhash;
    }

    public String getName() {
        return this._name;
    }

    public PhylogenyNode getNode(int id) throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException("attempt to get node in an empty phylogeny");
        }
        if (this._idhash != null) {
            return this._idhash.get(id);
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.getNodeId() != id) continue;
            return node;
        }
        return null;
    }

    public PhylogenyNode getNode(String name) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> nodes = this.getNodes(name);
        if (nodes == null || nodes.size() < 1) {
            throw new IllegalArgumentException("node named [" + name + "] not found");
        }
        if (nodes.size() > 1) {
            throw new IllegalArgumentException("node named [" + name + "] not unique");
        }
        return nodes.get(0);
    }

    private List<PhylogenyNode> getNodeByTaxonomyID(String taxonomyID, List<PhylogenyNode> nodes) {
        ArrayList<PhylogenyNode> retour = new ArrayList<PhylogenyNode>();
        for (PhylogenyNode node : nodes) {
            if (!taxonomyID.equals(PhylogenyMethods.getTaxonomyIdentifier(node))) continue;
            retour.add(node);
        }
        return retour;
    }

    public List<PhylogenyNode> getNodes(String name) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getNodeName().equals(name)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public List<PhylogenyNode> getNodesViaSequenceName(String seq_name) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getNodeData().isHasSequence() || !n.getNodeData().getSequence().getName().equals(seq_name)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public List<PhylogenyNode> getNodesViaTaxonomyCode(String taxonomy_code) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getNodeData().isHasTaxonomy() || !n.getNodeData().getTaxonomy().getTaxonomyCode().equals(taxonomy_code)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public List<PhylogenyNode> getNodesWithMatchingSpecies(String specname) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!PhylogenyMethods.getSpecies(n).equals(specname)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public PhylogenyNode getNodeViaSequenceName(String seq_name) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> nodes = this.getNodesViaSequenceName(seq_name);
        if (nodes == null || nodes.size() < 1) {
            throw new IllegalArgumentException("node with sequence named [" + seq_name + "] not found");
        }
        if (nodes.size() > 1) {
            throw new IllegalArgumentException("node with sequence named [" + seq_name + "] not unique");
        }
        return nodes.get(0);
    }

    public PhylogenyNode getNodeViaTaxonomyCode(String taxonomy_code) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> nodes = this.getNodesViaTaxonomyCode(taxonomy_code);
        if (nodes == null || nodes.size() < 1) {
            throw new IllegalArgumentException("node with taxonomy code \"" + taxonomy_code + "\" not found");
        }
        if (nodes.size() > 1) {
            throw new IllegalArgumentException("node with taxonomy code \"" + taxonomy_code + "\" not unique");
        }
        return nodes.get(0);
    }

    public int getNumberOfBranches() {
        if (this.isEmpty()) {
            return 0;
        }
        int c = 0;
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            ++c;
            iter.next();
        }
        if (!this.isRooted()) {
            --c;
        }
        return c;
    }

    public int getNumberOfExternalNodes() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getExternalNodes().size();
    }

    public List<PhylogenyNode> getParalogousNodes(PhylogenyNode n, String[] taxonomyCodeRange) {
        PhylogenyNode node = n;
        PhylogenyNode prev = null;
        ArrayList<PhylogenyNode> v = new ArrayList<PhylogenyNode>();
        HashMap<PhylogenyNode, List<String>> map = new HashMap<PhylogenyNode, List<String>>();
        this.getTaxonomyMap(this.getRoot(), map);
        if (!node.isExternal() || this.isEmpty()) {
            return null;
        }
        String searchNodeSpeciesId = PhylogenyMethods.getTaxonomyIdentifier(n);
        if (!node.isExternal() || this.isEmpty()) {
            return null;
        }
        List taxIdList = null;
        List<String> taxonomyCodeRangeList = Arrays.asList(taxonomyCodeRange);
        while (!node.isRoot()) {
            prev = node;
            node = node.getParent();
            taxIdList = (List)map.get(node);
            if (!node.isDuplication() || !this.isContains(taxIdList, taxonomyCodeRangeList)) continue;
            if (node.getChildNode1() == prev) {
                v.addAll(this.getNodeByTaxonomyID(searchNodeSpeciesId, node.getChildNode2().getAllExternalDescendants()));
                continue;
            }
            v.addAll(this.getNodeByTaxonomyID(searchNodeSpeciesId, node.getChildNode1().getAllExternalDescendants()));
        }
        return v;
    }

    public PhylogenyNode getRoot() {
        return this._root;
    }

    private List<String> getSubNodeTaxonomy(PhylogenyNode node) {
        ArrayList<String> taxonomyList = new ArrayList<String>();
        List<PhylogenyNode> childs = node.getAllExternalDescendants();
        String speciesId = null;
        for (PhylogenyNode phylogenyNode : childs) {
            speciesId = PhylogenyMethods.getTaxonomyIdentifier(phylogenyNode);
            if (taxonomyList.contains(speciesId)) continue;
            taxonomyList.add(speciesId);
        }
        return taxonomyList;
    }

    private void getTaxonomyMap(PhylogenyNode node, Map<PhylogenyNode, List<String>> map) {
        if (node.isExternal()) {
            return;
        }
        map.put(node, this.getSubNodeTaxonomy(node));
        this.getTaxonomyMap(node.getChildNode1(), map);
        this.getTaxonomyMap(node.getChildNode2(), map);
    }

    public String getType() {
        return this._type;
    }

    public void hashIDs() {
        if (this.isEmpty()) {
            return;
        }
        this.setIdHash(new HashMap<Integer, PhylogenyNode>());
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            this.getIdHash().put(node.getNodeId(), node);
        }
    }

    public void init() {
        this._root = null;
        this._rooted = false;
        this._name = "";
        this._description = "";
        this._type = "";
        this._distance_unit = "";
        this._idhash = null;
        this._confidence = null;
        this._identifier = null;
        this._rerootable = true;
        this.setAllowMultipleParents(false);
    }

    private boolean isAllowMultipleParents() {
        return this._allow_multiple_parents;
    }

    public boolean isCompletelyBinary() {
        if (this.isEmpty()) {
            return false;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (!node.isInternal() || node.getNumberOfDescendants() == 2) continue;
            return false;
        }
        return true;
    }

    private boolean isContains(List<String> list, List<String> rangeList) {
        if (list.size() > rangeList.size()) {
            return false;
        }
        String l2 = null;
        for (String l2 : list) {
            if (rangeList.contains(l2)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    public boolean isRerootable() {
        return this._rerootable;
    }

    public boolean isRooted() {
        return this._rooted;
    }

    public boolean isTree() {
        return true;
    }

    public PhylogenyNodeIterator iteratorExternalForward() {
        return new ExternalForwardIterator(this);
    }

    public PhylogenyNodeIterator iteratorLevelOrder() {
        return new LevelOrderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorPostorder() {
        return new PostorderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorPreorder() {
        return new PreorderTreeIterator(this);
    }

    public int levelOrderReID(int start_label) {
        if (this.isEmpty()) {
            return start_label;
        }
        this._idhash = null;
        int max = Integer.MIN_VALUE;
        PhylogenyNodeIterator it = this.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (node.isRoot()) {
                node.setNodeId(start_label);
                continue;
            }
            node.setNodeId(node.getParent().getNodeId() + 1);
            if (node.getNodeId() <= max) continue;
            max = node.getNodeId();
        }
        return max;
    }

    public void orderAppearance(boolean order) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to order appearance on phylogeny which is not tree-like.");
        }
        if (this.isEmpty()) {
            return;
        }
        this.orderAppearanceHelper(this.getRoot(), order);
    }

    private void orderAppearanceHelper(PhylogenyNode n, boolean order) {
        if (n.isExternal()) {
            return;
        }
        PhylogenyNode temp = null;
        if (n.getNumberOfDescendants() == 2 && n.getChildNode1().getNumberOfExternalNodes() != n.getChildNode2().getNumberOfExternalNodes() && n.getChildNode1().getNumberOfExternalNodes() < n.getChildNode2().getNumberOfExternalNodes() == order) {
            temp = n.getChildNode1();
            n.setChild1(n.getChildNode2());
            n.setChild2(temp);
        }
        int i = 0;
        while (i < n.getNumberOfDescendants()) {
            this.orderAppearanceHelper(n.getChildNode(i), order);
            ++i;
        }
    }

    public void preOrderReId() {
        if (this.isEmpty()) {
            return;
        }
        this.setIdHash(null);
        int i = PhylogenyNode.getNodeCount() + 1;
        PhylogenyNodeIterator it = this.iteratorPreorder();
        while (it.hasNext()) {
            it.next().setNodeId(i++);
        }
        PhylogenyNode.setNodeCount(i);
    }

    public int preOrderReId(int start_label) {
        if (this.isEmpty()) {
            return start_label;
        }
        this.setIdHash(null);
        PhylogenyNodeIterator it = this.iteratorPreorder();
        while (it.hasNext()) {
            it.next().setNodeId(start_label++);
        }
        return start_label;
    }

    public void printExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorExternalForward();
        while (iter.hasNext()) {
            System.out.println(iter.next() + "\n");
        }
    }

    public void recalculateNumberOfExternalDescendants(boolean consider_collapsed_nodes) {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isExternal() || consider_collapsed_nodes && node.isCollapse()) {
                node.setSumExtNodes(1);
                continue;
            }
            int sum = 0;
            int i = 0;
            while (i < node.getNumberOfDescendants()) {
                sum += node.getChildNode(i).getNumberOfExternalNodes();
                ++i;
            }
            node.setSumExtNodes(sum);
        }
    }

    public void reRoot(int id) {
        this.reRoot(this.getNode(id));
    }

    public void reRoot(PhylogenyBranch b) {
        PhylogenyNode n1 = b.getFirstNode();
        PhylogenyNode n2 = b.getSecondNode();
        if (n1.isExternal()) {
            this.reRoot(n1);
        } else if (n2.isExternal()) {
            this.reRoot(n2);
        } else if (n2 == n1.getChildNode1() || n2 == n1.getChildNode2()) {
            this.reRoot(n2);
        } else if (n1 == n2.getChildNode1() || n1 == n2.getChildNode2()) {
            this.reRoot(n1);
        } else if (n1.getParent() != null && n1.getParent().isRoot() && (n1.getParent().getChildNode1() == n2 || n1.getParent().getChildNode2() == n2)) {
            this.reRoot(n1);
        } else {
            throw new IllegalArgumentException("reRoot( Branch b ): b is not a branch.");
        }
    }

    public void reRoot(PhylogenyNode n) {
        this.reRoot(n, -1.0);
    }

    public void reRoot(PhylogenyNode n, double distance_n_to_parent) {
        if (this.isEmpty() || this.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setRooted(true);
        if (n.isRoot()) {
            return;
        }
        if (n.getParent().isRoot()) {
            if (n.getParent().getNumberOfDescendants() == 2 && distance_n_to_parent >= 0.0) {
                double d = n.getParent().getChildNode1().getDistanceToParent() + n.getParent().getChildNode2().getDistanceToParent();
                PhylogenyNode other = n.getChildNodeIndex() == 0 ? n.getParent().getChildNode2() : n.getParent().getChildNode1();
                n.setDistanceToParent(distance_n_to_parent);
                double dm = d - distance_n_to_parent;
                if (dm >= 0.0) {
                    other.setDistanceToParent(dm);
                } else {
                    other.setDistanceToParent(0.0);
                }
            }
            if (n.getParent().getNumberOfDescendants() > 2) {
                int index = n.getChildNodeIndex();
                double dn = n.getDistanceToParent();
                PhylogenyNode prev_root = this.getRoot();
                prev_root.getDescendants().remove(index);
                PhylogenyNode new_root = new PhylogenyNode();
                new_root.setChildNode(0, n);
                new_root.setChildNode(1, prev_root);
                if (n.getBranchDataDirectly() != null) {
                    prev_root.setBranchData((BranchData)n.getBranchDataDirectly().copy());
                }
                this.setRoot(new_root);
                if (distance_n_to_parent >= 0.0) {
                    n.setDistanceToParent(distance_n_to_parent);
                    double d = dn - distance_n_to_parent;
                    if (d >= 0.0) {
                        prev_root.setDistanceToParent(d);
                    } else {
                        prev_root.setDistanceToParent(0.0);
                    }
                } else if (dn >= 0.0) {
                    double d = dn / 2.0;
                    n.setDistanceToParent(d);
                    prev_root.setDistanceToParent(d);
                }
            }
        } else {
            PhylogenyNode a = n;
            PhylogenyNode b = null;
            PhylogenyNode c = null;
            PhylogenyNode new_root = new PhylogenyNode();
            double distance1 = 0.0;
            double distance2 = 0.0;
            BranchData branch_data_1 = null;
            BranchData branch_data_2 = null;
            b = a.getParent();
            c = b.getParent();
            new_root.setChildNode(0, a);
            new_root.setChildNode(1, b);
            distance1 = c.getDistanceToParent();
            if (c.getBranchDataDirectly() != null) {
                branch_data_1 = (BranchData)c.getBranchDataDirectly().copy();
            }
            c.setDistanceToParent(b.getDistanceToParent());
            if (b.getBranchDataDirectly() != null) {
                c.setBranchData((BranchData)b.getBranchDataDirectly().copy());
            }
            if (a.getBranchDataDirectly() != null) {
                b.setBranchData((BranchData)a.getBranchDataDirectly().copy());
            }
            if (a.getDistanceToParent() == -1024.0) {
                b.setDistanceToParent(-1024.0);
            } else if (distance_n_to_parent >= 0.0) {
                double diff = a.getDistanceToParent() - distance_n_to_parent;
                a.setDistanceToParent(distance_n_to_parent);
                b.setDistanceToParent(diff >= 0.0 ? diff : 0.0);
            } else {
                double d = a.getDistanceToParent() / 2.0;
                a.setDistanceToParent(d);
                b.setDistanceToParent(d);
            }
            b.setChildNodeOnly(a.getChildNodeIndex(b), c);
            while (!c.isRoot()) {
                a = b;
                b = c;
                c = c.getParent();
                b.setChildNodeOnly(a.getChildNodeIndex(b), c);
                b.setParent(a);
                distance2 = c.getDistanceToParent();
                branch_data_2 = c.getBranchDataDirectly();
                c.setDistanceToParent(distance1);
                c.setBranchData(branch_data_1);
                distance1 = distance2;
                branch_data_1 = branch_data_2;
            }
            if (c.getNumberOfDescendants() == 2) {
                PhylogenyNode node = c.getChildNode(1 - b.getChildNodeIndex(c));
                node.setParent(b);
                if (c.getDistanceToParent() == -1024.0 && node.getDistanceToParent() == -1024.0) {
                    node.setDistanceToParent(-1024.0);
                } else {
                    node.setDistanceToParent((c.getDistanceToParent() >= 0.0 ? c.getDistanceToParent() : 0.0) + (node.getDistanceToParent() >= 0.0 ? node.getDistanceToParent() : 0.0));
                }
                if (c.getBranchDataDirectly() != null) {
                    node.setBranchData((BranchData)c.getBranchDataDirectly().copy());
                }
                int i = 0;
                while (i < b.getNumberOfDescendants()) {
                    if (b.getChildNode(i) == c) {
                        b.setChildNodeOnly(i, node);
                        break;
                    }
                    ++i;
                }
            } else {
                c.setParent(b);
                c.removeChildNode(b.getChildNodeIndex(c));
            }
            this.setRoot(new_root);
        }
    }

    public void setAllNodesToNotCollapse() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            node.setCollapse(false);
        }
    }

    private void setAllowMultipleParents(boolean allow_multiple_parents) {
        this._allow_multiple_parents = allow_multiple_parents;
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDistanceUnit(String _distance_unit) {
        this._distance_unit = _distance_unit;
    }

    public void setIdentifier(Identifier identifier) {
        this._identifier = identifier;
    }

    void setIdHash(HashMap<Integer, PhylogenyNode> idhash) {
        this._idhash = idhash;
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            iter.next().setIndicator((byte)0);
        }
    }

    public void setName(String s) {
        this._name = s;
    }

    public void setRerootable(boolean rerootable) {
        this._rerootable = rerootable;
    }

    public void setRoot(PhylogenyNode n) {
        this._root = n;
    }

    public void setRooted(boolean b) {
        this._rooted = b;
    }

    public void setType(String type) {
        this._type = type;
    }

    public Phylogeny subTree(PhylogenyNode node) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("attempt to get sub tree on phylogeny which is not tree-like.");
        }
        if (node == null || this.isEmpty()) {
            return null;
        }
        Phylogeny sub_tree = null;
        sub_tree = this.copy();
        PhylogenyNode new_root = sub_tree.getNode(node.getNodeId());
        new_root.setParent(null);
        sub_tree.setName("");
        sub_tree.setDescription("");
        sub_tree.setIdHash(null);
        sub_tree.setConfidence(null);
        sub_tree.setIdentifier(null);
        sub_tree.setRooted(true);
        sub_tree.setRoot(new_root);
        sub_tree.recalculateNumberOfExternalDescendants(true);
        return sub_tree;
    }

    public void swapChildren(PhylogenyNode node) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to swap children on phylogeny which is not tree-like.");
        }
        if (this.isEmpty() || node.isExternal() || node.getNumberOfDescendants() < 2) {
            return;
        }
        PhylogenyNode first = node.getFirstChildNode();
        int i = 1;
        while (i < node.getNumberOfDescendants()) {
            node.setChildNode(i - 1, node.getChildNode(i));
            ++i;
        }
        node.setChildNode(node.getNumberOfDescendants() - 1, first);
    }

    public String toNewHampshire(boolean simple_nh) {
        try {
            return new PhylogenyWriter().toNewHampshire(this, simple_nh, true).toString();
        }
        catch (IOException e) {
            throw new Error("this should not have happend: " + e.getMessage());
        }
    }

    public String toNewHampshireX() {
        try {
            return new PhylogenyWriter().toNewHampshireX(this).toString();
        }
        catch (IOException e) {
            throw new Error("this should not have happend: " + e.getMessage());
        }
    }

    public String toNexus() {
        try {
            return new PhylogenyWriter().toNexus(this).toString();
        }
        catch (IOException e) {
            throw new Error("this should not have happend: " + e.getMessage());
        }
    }

    public String toPhyloXML(int phyloxml_level) {
        try {
            return new PhylogenyWriter().toPhyloXML(this, phyloxml_level).toString();
        }
        catch (IOException e) {
            throw new Error("this should not have happend: " + e.getMessage());
        }
    }

    public String toString() {
        return this.toNewHampshireX();
    }

    public void unRoot() throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to unroot a phylogeny which is not tree-like.");
        }
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExternalNodes() <= 1) {
            return;
        }
        this.setRooted(false);
    }
}

