/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.Species;
import org.forester.util.DescriptiveStatistics;

public class BasicCombinableDomains
implements CombinableDomains {
    private final DomainId _key_domain;
    private int _key_domain_count;
    private int _key_domain_proteins_count;
    private final Species _species;
    private final TreeMap<DomainId, Integer> _combining_domains;
    private DescriptiveStatistics _key_domain_confidence_statistics;

    public BasicCombinableDomains(DomainId key_domain, Species species) {
        this._key_domain = key_domain;
        this._species = species;
        this._combining_domains = new TreeMap();
        this.init();
    }

    @Override
    public void addCombinableDomain(DomainId protein_domain) {
        if (this.getCombiningDomains().containsKey(protein_domain)) {
            this.getCombiningDomains().put(protein_domain, this.getCombiningDomains().get(protein_domain) + 1);
        } else {
            this.getCombiningDomains().put(protein_domain, 1);
        }
    }

    @Override
    public List<DomainId> getAllDomains() {
        List<DomainId> domains = this.getCombinableDomains();
        if (!domains.contains(this.getKeyDomain())) {
            domains.add(this.getKeyDomain());
        }
        return domains;
    }

    @Override
    public List<DomainId> getCombinableDomains() {
        ArrayList<DomainId> domains = new ArrayList<DomainId>(this.getNumberOfCombinableDomains());
        for (DomainId domain : this.getCombiningDomains().keySet()) {
            domains.add(domain);
        }
        return domains;
    }

    @Override
    public SortedMap<DomainId, Integer> getCombinableDomainsIds() {
        TreeMap<DomainId, Integer> ids = new TreeMap<DomainId, Integer>();
        Iterator<DomainId> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            DomainId domain;
            DomainId pd = domain = iterator.next();
            ids.put(pd, this.getCombiningDomains().get(pd));
        }
        return ids;
    }

    @Override
    public StringBuilder getCombiningDomainIdsAsStringBuilder() {
        StringBuilder sb = new StringBuilder();
        Iterator<DomainId> iter = this.getCombiningDomains().keySet().iterator();
        while (iter.hasNext()) {
            DomainId key = iter.next();
            sb.append(key.toString());
            sb.append(" [");
            int count = this.getCombiningDomains().get(key);
            sb.append(count);
            sb.append("]");
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }

    protected TreeMap<DomainId, Integer> getCombiningDomains() {
        return this._combining_domains;
    }

    @Override
    public DomainId getKeyDomain() {
        return this._key_domain;
    }

    @Override
    public DescriptiveStatistics getKeyDomainConfidenceDescriptiveStatistics() {
        return this._key_domain_confidence_statistics;
    }

    @Override
    public int getKeyDomainCount() {
        return this._key_domain_count;
    }

    @Override
    public int getKeyDomainProteinsCount() {
        return this._key_domain_proteins_count;
    }

    @Override
    public int getNumberOfCombinableDomains() {
        return this._combining_domains.size();
    }

    @Override
    public int getNumberOfProteinsExhibitingCombination(DomainId protein_domain) {
        if (this.getCombiningDomains().containsKey(protein_domain)) {
            return this.getCombiningDomains().get(protein_domain);
        }
        return 0;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    private void init() {
        this._key_domain_count = 0;
        this._key_domain_proteins_count = 0;
        this._key_domain_confidence_statistics = null;
    }

    @Override
    public boolean isCombinable(DomainId protein_domain) {
        return this.getCombiningDomains().containsKey(protein_domain);
    }

    @Override
    public void setKeyDomainConfidenceDescriptiveStatistics(DescriptiveStatistics key_domain_confidence_statistics) {
        this._key_domain_confidence_statistics = key_domain_confidence_statistics;
    }

    @Override
    public void setKeyDomainCount(int key_domain_count) {
        this._key_domain_count = key_domain_count;
    }

    @Override
    public void setKeyDomainProteinsCount(int key_domain_proteins_count) {
        this._key_domain_proteins_count = key_domain_proteins_count;
    }

    @Override
    public List<BinaryDomainCombination> toBinaryDomainCombinations() {
        ArrayList<BinaryDomainCombination> binary_combinations = new ArrayList<BinaryDomainCombination>(this.getNumberOfCombinableDomains());
        for (DomainId domain : this.getCombiningDomains().keySet()) {
            binary_combinations.add(new BasicBinaryDomainCombination(this.getKeyDomain(), domain));
        }
        return binary_combinations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKeyDomain());
        sb.append(" [");
        sb.append(this.getKeyDomainCount());
        sb.append(", ");
        sb.append(this.getKeyDomainProteinsCount());
        sb.append(", ");
        sb.append(this.getNumberOfCombinableDomains());
        sb.append("]: ");
        sb.append((CharSequence)this.getCombiningDomainIdsAsStringBuilder());
        return sb.toString();
    }
}

